% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sandbag.R
\name{sandbag}
\alias{sandbag}
\alias{sandbag,ANY-method}
\alias{sandbag,SummarizedExperiment-method}
\title{Cell cycle phase training}
\usage{
sandbag(x, ...)

\S4method{sandbag}{ANY}(x, phases, gene.names = rownames(x), fraction = 0.5, subset.row = NULL)

\S4method{sandbag}{SummarizedExperiment}(x, ..., assay.type = "counts")
}
\arguments{
\item{x}{A numeric matrix of gene expression values where rows are genes and columns are cells.

Alternatively, a \linkS4class{SummarizedExperiment} object containing such a matrix.}

\item{...}{For the generic, additional arguments to pass to specific methods.

For the SummarizedExperiment method, additional arguments to pass to the ANY method.}

\item{phases}{A list of subsetting vectors specifying which cells are in each phase of the cell cycle.
This should typically be of length 3, with elements named as \code{"G1"}, \code{"S"} and \code{"G2M"}.}

\item{gene.names}{A character vector of gene names.}

\item{fraction}{A numeric scalar specifying the minimum fraction to define a marker gene pair.}

\item{subset.row}{See \code{?"\link{scran-gene-selection}"}.}

\item{assay.type}{A string specifying which assay values to use, e.g., \code{"counts"} or \code{"logcounts"}.}
}
\value{
A named list of data.frames, where each data frame corresponds to a cell cycle phase and contains the names of the genes in each marker pair.
}
\description{
Use gene expression data to train a classifier for cell cycle phase.
}
\details{
This function implements the training step of the pair-based prediction method described by Scialdone et al. (2015).
Pairs of genes (A, B) are identified from a training data set where in each pair,
    the fraction of cells in phase G1 with expression of A > B (based on expression values in \code{training.data}) 
    and the fraction with B > A in each other phase exceeds \code{fraction}.
These pairs are defined as the marker pairs for G1.
This is repeated for each phase to obtain a separate marker pair set.

Pre-defined sets of marker pairs are provided for mouse and human (see Examples).
The mouse set was generated as described by Scialdone et al. (2015), while the human training set was generated with data from Leng et al. (2015).
Classification from test data can be performed using the \code{\link{cyclone}} function.
For each cell, this involves comparing expression values between genes in each marker pair. 
The cell is then assigned to the phase that is consistent with the direction of the difference in expression in the majority of pairs.
}
\examples{
library(scuttle)
sce <- mockSCE(ncells=50, ngenes=200)

is.G1 <- 1:20
is.S <- 21:30
is.G2M <- 31:50
out <- sandbag(sce, list(G1=is.G1, S=is.S, G2M=is.G2M))
str(out)

# Getting pre-trained marker sets
mm.pairs <- readRDS(system.file("exdata", "mouse_cycle_markers.rds", package="scran"))
hs.pairs <- readRDS(system.file("exdata", "human_cycle_markers.rds", package="scran"))

}
\references{
Scialdone A, Natarajana KN, Saraiva LR et al. (2015). 
Computational assignment of cell-cycle stage from single-cell transcriptome data.
\emph{Methods} 85:54--61

Leng N, Chu LF, Barry C et al. (2015).
Oscope identifies oscillatory genes in unsynchronized single-cell RNA-seq experiments.
\emph{Nat. Methods} 12:947--50
}
\seealso{
\code{\link{cyclone}}, to perform the classification on a test dataset.
}
\author{
Antonio Scialdone,
with modifications by Aaron Lun
}
