% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/saveVersion.R
\name{saveVersion}
\alias{saveVersion}
\title{Save all files for a version of a project asset}
\usage{
saveVersion(
  project,
  asset,
  version,
  cache = cacheDirectory(),
  overwrite = FALSE,
  relink = TRUE,
  concurrent = 1,
  url = restUrl(),
  config = NULL
)
}
\arguments{
\item{project}{String containing the project name.}

\item{asset}{String containing the asset name.}

\item{version}{String containing the version name.}

\item{cache}{String containing the path to the cache directory.}

\item{overwrite}{Logical scalar indicating whether to overwrite existing files in the cache.
If \code{FALSE} and the files already exist in \code{cache}, the download is skipped.}

\item{relink}{Logical scalar indicating whether links should be resolved, see \code{\link{resolveLinks}}.}

\item{concurrent}{Integer specifying the number of concurrent downloads.}

\item{url}{String containing the URL of the gypsum REST API.}

\item{config}{Deprecated and ignored.}
}
\value{
The version's files are downloaded to the local file system, and the path to the local subdirectory is returned.
}
\description{
Download all files associated with a version of an asset of a project from the gypsum bucket.
}
\examples{
out <- saveVersion("test-R", "basic", "v1")
list.files(out, recursive=TRUE, all.files=TRUE)

}
\seealso{
\code{\link{saveFile}}, to save a single file.

\code{\link{cacheDirectory}}, for file caching.
}
\author{
Aaron Lun
}
