/**********************************************************************
 *
 * PostGIS - Spatial Types for PostgreSQL
 * http://postgis.net
 *
 * This is free software; you can redistribute and/or modify it under
 * the terms of the GNU General Public Licence. See the COPYING file.
 *
 **********************************************************************/

#ifndef _CU_RASTER_TESTER_H
#define _CU_RASTER_TESTER_H 1

#include "librtcore.h"

#include "../../../postgis_config.h"
#include "../../raster_config.h"

#define MAX_CUNIT_MSG_LENGTH 512

#define PG_ADD_TEST(suite, testfunc) CU_add_test(suite, #testfunc, testfunc)

/* Contains the most recent error message generated by rterror. */
extern char cu_error_msg[];

/* Resets cu_error_msg back to blank. */
void cu_error_msg_reset(void);

/* free raster object */
void cu_free_raster(rt_raster raster);

/* helper to add bands to raster */
rt_band cu_add_band(
	rt_raster raster,
	rt_pixtype pixtype,
	int hasnodata, double nodataval
);

/* Our internal callback to register Suites with the main tester */
typedef void (*PG_SuiteSetup)(void);

#endif /* _CU_RASTER_TESTER_H */
