---
id: fast-foundation.anchoredregion
title: AnchoredRegion class
hide_title: true
---
<!-- Do not edit this file. It is automatically generated by API Documenter. -->

[@microsoft/fast-foundation](./fast-foundation.md) &gt; [AnchoredRegion](./fast-foundation.anchoredregion.md)

## AnchoredRegion class

An anchored region Custom HTML Element.


- The default slot for the content


loaded - Fires a custom 'loaded' event when the region is loaded and visible


positionchange - Fires a custom 'positionchange' event when the position has changed

<b>Signature:</b>

```typescript
export declare class AnchoredRegion extends FoundationElement 
```

## Properties

|  Property | Modifiers | Type | Description |
|  --- | --- | --- | --- |
|  [anchor](./fast-foundation.anchoredregion.anchor.md) |  | string | The HTML ID of the anchor element this region is positioned relative to |
|  [anchorElement](./fast-foundation.anchoredregion.anchorelement.md) |  | HTMLElement \| null | The HTML element being used as the anchor |
|  [autoUpdateMode](./fast-foundation.anchoredregion.autoupdatemode.md) |  | [AutoUpdateMode](./fast-foundation.autoupdatemode.md) | Defines what triggers the anchored region to revaluate positioning |
|  [fixedPlacement](./fast-foundation.anchoredregion.fixedplacement.md) |  | boolean | Whether the region is positioned using css "position: fixed". Otherwise the region uses "position: absolute". Fixed placement allows the region to break out of parent containers, |
|  [horizontalDefaultPosition](./fast-foundation.anchoredregion.horizontaldefaultposition.md) |  | [HorizontalPosition](./fast-foundation.horizontalposition.md) | The default horizontal position of the region relative to the anchor element |
|  [horizontalInset](./fast-foundation.anchoredregion.horizontalinset.md) |  | boolean | Whether the region overlaps the anchor on the horizontal axis |
|  [horizontalPosition](./fast-foundation.anchoredregion.horizontalposition.md) |  | [AnchoredRegionPositionLabel](./fast-foundation.anchoredregionpositionlabel.md) \| undefined | indicates the current vertical position of the region |
|  [horizontalPositioningMode](./fast-foundation.anchoredregion.horizontalpositioningmode.md) |  | [AxisPositioningMode](./fast-foundation.axispositioningmode.md) | Sets what logic the component uses to determine horizontal placement. 'locktodefault' forces the default position 'dynamic' decides placement based on available space 'uncontrolled' does not control placement on the horizontal axis |
|  [horizontalScaling](./fast-foundation.anchoredregion.horizontalscaling.md) |  | [AxisScalingMode](./fast-foundation.axisscalingmode.md) | Defines how the width of the region is calculated |
|  [horizontalThreshold](./fast-foundation.anchoredregion.horizontalthreshold.md) |  | number | How narrow the space allocated to the default position has to be before the widest area is selected for layout |
|  [horizontalViewportLock](./fast-foundation.anchoredregion.horizontalviewportlock.md) |  | boolean | Whether the region remains in the viewport (ie. detaches from the anchor) on the horizontal axis |
|  [update](./fast-foundation.anchoredregion.update.md) |  | () =&gt; void | update position |
|  [verticalDefaultPosition](./fast-foundation.anchoredregion.verticaldefaultposition.md) |  | [VerticalPosition](./fast-foundation.verticalposition.md) | The default vertical position of the region relative to the anchor element |
|  [verticalInset](./fast-foundation.anchoredregion.verticalinset.md) |  | boolean | Whether the region overlaps the anchor on the vertical axis |
|  [verticalPosition](./fast-foundation.anchoredregion.verticalposition.md) |  | [AnchoredRegionPositionLabel](./fast-foundation.anchoredregionpositionlabel.md) \| undefined | indicates the current horizontal position of the region |
|  [verticalPositioningMode](./fast-foundation.anchoredregion.verticalpositioningmode.md) |  | [AxisPositioningMode](./fast-foundation.axispositioningmode.md) | Sets what logic the component uses to determine vertical placement. 'locktodefault' forces the default position 'dynamic' decides placement based on available space 'uncontrolled' does not control placement on the vertical axis |
|  [verticalScaling](./fast-foundation.anchoredregion.verticalscaling.md) |  | [AxisScalingMode](./fast-foundation.axisscalingmode.md) | Defines how the height of the region is calculated |
|  [verticalThreshold](./fast-foundation.anchoredregion.verticalthreshold.md) |  | number | How short the space allocated to the default position has to be before the tallest area is selected for layout |
|  [verticalViewportLock](./fast-foundation.anchoredregion.verticalviewportlock.md) |  | boolean | Whether the region remains in the viewport (ie. detaches from the anchor) on the vertical axis |
|  [viewport](./fast-foundation.anchoredregion.viewport.md) |  | string | The HTML ID of the viewport element this region is positioned relative to |
|  [viewportElement](./fast-foundation.anchoredregion.viewportelement.md) |  | HTMLElement \| null | The HTML element being used as the viewport |
