# Filing Issues

Before filing an issue, please be sure to read the guidelines for what you're
reporting:

## Reporting Bugs

If you think you’ve found a bug in the eslint-plugin-requirejs code, please [file an issue](https://github.com/cvisco/eslint-plugin-requirejs/issues) on GitHub. Be sure to include the following information:

* The version of ESLint you are using
* The version of the plugin you are using
* The actual source code that is causing the issue
* In the case of an exception, the _complete_ output from ESLint

You can never have too much detail in your bug report, so please include as much detail as possible to help us properly address your issue.

## Requesting a New Rule

All rules in this plugin focus on specific [RequireJS](http://requirejs.org) features, patterns or potential issues. Any proposed new rule should do the same. Rules must be as atomic as possible, and not overlap with other rules. If you would like to propose a new rule, please [file an issue](https://github.com/cvisco/eslint-plugin-requirejs/issues) on GitHub. Be sure to include the following information:

* When the rule will warn. Include a description as well as sample code.
* Whether the rule prevents an error or is stylistic.
* If you are interested or willing to create the rule yourself

## Changes to Existing Rules

In the event that a rule is found to be incomplete or inflexible, it may need an enhancement. If you would like to propose an enhancement to an existing rule, please [file an issue](https://github.com/cvisco/eslint-plugin-requirejs/issues) on GitHub. Be sure to include the following information:

* The version of ESLint you are using
* The version of the plugin you are using
* The rule you want to change
* The source code you want to be flagged as incorrect
* What happens when the rule is applied to the code without your change
