/*
 * Decompiled with CFR 0.152.
 */
package cx.fbn.encrypt;

import cx.fbn.encrypt.Base64;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.zip.CRC32;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.RC2ParameterSpec;
import javax.crypto.spec.SecretKeySpec;

public class EnCrypt {
    public static String asHex(byte[] buf) {
        StringBuffer strbuf = new StringBuffer(buf.length * 2);
        int i = 0;
        while (i < buf.length) {
            if ((buf[i] & 0xFF) < 16) {
                strbuf.append("0");
            }
            strbuf.append(Long.toString(buf[i] & 0xFF, 16));
            ++i;
        }
        return strbuf.toString();
    }

    private Charset getCharset() {
        boolean useUtf8 = true;
        Charset charSet = useUtf8 ? Charset.forName("UTF-8") : Charset.defaultCharset();
        return charSet;
    }

    private byte[] encodeString(String text, int length) {
        int align;
        int paddingNeeded;
        Charset charSet = this.getCharset();
        byte[] bytes = text.getBytes(charSet);
        byte[] paddedBytes = Arrays.copyOf(bytes, bytes.length + (paddingNeeded = length - (align = (bytes.length + 4) % length)));
        String crc = this.crcHeader(paddedBytes);
        byte[] crcBytes = crc.getBytes(charSet);
        if (crcBytes.length != 4) {
            System.err.println("CRC Bytes really should be 4 in length!");
            return null;
        }
        byte[] total = new byte[paddedBytes.length + crcBytes.length];
        System.arraycopy(crcBytes, 0, total, 0, crcBytes.length);
        System.arraycopy(paddedBytes, 0, total, crcBytes.length, paddedBytes.length);
        return total;
    }

    private String decodeBytes(byte[] bytes) {
        Charset charSet = this.getCharset();
        byte[] crcBytes = Arrays.copyOfRange(bytes, 0, 4);
        byte[] textBytes = Arrays.copyOfRange(bytes, 4, bytes.length);
        CharBuffer crcChar = charSet.decode(ByteBuffer.wrap(crcBytes));
        CharBuffer textChar = charSet.decode(ByteBuffer.wrap(textBytes));
        String cryptCRC = crcChar.toString();
        String realCRC = this.crcHeader(textBytes);
        if (realCRC.equals(cryptCRC)) {
            while (textChar.get(textChar.limit() - 1) == '\u0000' && textChar.limit() != 0) {
                textChar.limit(textChar.limit() - 1);
            }
            String str = textChar.toString();
            return str;
        }
        return "";
    }

    public String encryptRC2(String text, String passphrase, int keylen) {
        RC2ParameterSpec parm = new RC2ParameterSpec(keylen);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(passphrase.getBytes(this.getCharset()));
            SecretKeySpec skeySpec = new SecretKeySpec(md.digest(), "RC2");
            Cipher cipher = Cipher.getInstance("RC2/ECB/NoPadding");
            cipher.init(1, (Key)skeySpec, parm);
            byte[] newBytes = this.encodeString(text, 8);
            byte[] d = cipher.doFinal(newBytes);
            return Base64.encodeBytes(d);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String decryptRC2(String text, String passphrase, int keylen) {
        RC2ParameterSpec parm = new RC2ParameterSpec(keylen);
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(passphrase.getBytes(this.getCharset()));
            SecretKeySpec skeySpec = new SecretKeySpec(md.digest(), "RC2");
            Cipher cipher = Cipher.getInstance("RC2/ECB/NOPADDING");
            cipher.init(2, (Key)skeySpec, parm);
            byte[] dString = Base64.decode(text);
            byte[] d = cipher.doFinal(dString);
            String clearTextNew = this.decodeBytes(d);
            return clearTextNew;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (InvalidAlgorithmParameterException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String encryptAES(String text, String passphrase, int keylen) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(passphrase.getBytes(this.getCharset()));
            SecretKeySpec skeySpec = new SecretKeySpec(md.digest(), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5PADDING");
            cipher.init(1, skeySpec);
            byte[] newBytes = this.encodeString(text, 16);
            byte[] d = cipher.doFinal(newBytes);
            return Base64.encodeBytes(d);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return "";
    }

    public String decryptAES(String text, String passphrase, int keylen) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update(passphrase.getBytes(this.getCharset()));
            byte[] digest = md.digest();
            SecretKeySpec skeySpec = new SecretKeySpec(digest, "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            byte[] dString = Base64.decode(text);
            byte[] d = cipher.doFinal(dString);
            String clearTextNew = this.decodeBytes(d);
            return clearTextNew;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return "";
    }

    private String crcHeader(byte[] bytes) {
        CRC32 crc = new CRC32();
        crc.update(bytes);
        int realCRC = (int)crc.getValue();
        realCRC ^= 0xFFFFFFFF;
        String hexCRC = Integer.toHexString(realCRC >>>= 0).substring(0, 4);
        return hexCRC.toString().toUpperCase();
    }
}

