/*
 * Decompiled with CFR 0.152.
 */
package com.jcoverage.coverage.reporting.collation;

import com.jcoverage.coverage.reporting.collation.FieldHelper;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPackageLine;
import com.jcoverage.coverage.reporting.collation.ReportSummaryPage;
import com.jcoverage.reporting.AbstractLine;
import com.jcoverage.reporting.Column;
import com.jcoverage.reporting.Line;
import com.jcoverage.reporting.Page;
import java.util.Iterator;
import org.apache.log4j.Logger;

public class OverallSummaryLine
extends AbstractLine
implements Line {
    static Logger logger = Logger.getLogger((Class)(class$com$jcoverage$coverage$reporting$collation$OverallSummaryLine == null ? (class$com$jcoverage$coverage$reporting$collation$OverallSummaryLine = OverallSummaryLine.class$("com.jcoverage.coverage.reporting.collation.OverallSummaryLine")) : class$com$jcoverage$coverage$reporting$collation$OverallSummaryLine));
    public static Column COLUMN_TOTAL_JAVAFILES = new Column("files", class$java$lang$Integer == null ? (class$java$lang$Integer = OverallSummaryLine.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static Column COLUMN_TOTAL_LINES = new Column("lines", class$java$lang$Integer == null ? (class$java$lang$Integer = OverallSummaryLine.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static Column COLUMN_AVERAGE_COVERAGE = new Column("", class$java$lang$Double == null ? (class$java$lang$Double = OverallSummaryLine.class$("java.lang.Double")) : class$java$lang$Double);
    public static Column COLUMN_AVERAGE_COVERAGE_PERCENT = new Column("%line", class$java$lang$Integer == null ? (class$java$lang$Integer = OverallSummaryLine.class$("java.lang.Integer")) : class$java$lang$Integer);
    public static Column COLUMN_BRANCH_AVERAGE_COVERAGE = new Column("", class$java$lang$Double == null ? (class$java$lang$Double = OverallSummaryLine.class$("java.lang.Double")) : class$java$lang$Double);
    public static Column COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT = new Column("%branch", class$java$lang$Integer == null ? (class$java$lang$Integer = OverallSummaryLine.class$("java.lang.Integer")) : class$java$lang$Integer);
    static /* synthetic */ Class class$com$jcoverage$coverage$reporting$collation$OverallSummaryLine;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;

    public Page instantiateDetailPage() {
        return new ReportSummaryPage();
    }

    public Object getField(Column column) {
        Object o = super.getField(column);
        if (column.equals(COLUMN_TOTAL_LINES)) {
            return new Integer(this.getTotalLines());
        }
        if (column.equals(COLUMN_AVERAGE_COVERAGE)) {
            return new Double(this.getAverageLineCoverageRate());
        }
        if (column.equals(COLUMN_AVERAGE_COVERAGE_PERCENT)) {
            return new Integer(FieldHelper.toPercent(this.getAverageLineCoverageRate()));
        }
        if (column.equals(COLUMN_BRANCH_AVERAGE_COVERAGE)) {
            return new Double(this.getAverageBranchCoverageRate());
        }
        if (column.equals(COLUMN_BRANCH_AVERAGE_COVERAGE_PERCENT)) {
            return new Integer(FieldHelper.toPercent(this.getAverageBranchCoverageRate()));
        }
        if (column.equals(COLUMN_TOTAL_JAVAFILES)) {
            return new Integer(this.getTotalJavaFiles());
        }
        return o;
    }

    double getAverageLineCoverageRate() {
        int totalLines = 0;
        int coveredLines = 0;
        Iterator it = this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            int sourceLineCount = (Integer)line.getField(ReportSummaryPackageLine.COLUMN_TOTAL_LINES);
            totalLines += sourceLineCount;
            double rate = (Double)line.getField(ReportSummaryPackageLine.COLUMN_AVERAGE_COVERAGE);
            coveredLines += (int)((double)sourceLineCount * rate);
        }
        if (totalLines == 0) {
            return 1.0;
        }
        return (double)coveredLines / (double)totalLines;
    }

    double getAverageBranchCoverageRate() {
        if (this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).size() == 0) {
            return 0.0;
        }
        double total = 0.0;
        Iterator it = this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            total += ((Double)line.getField(ReportSummaryPackageLine.COLUMN_BRANCH_AVERAGE_COVERAGE)).doubleValue();
        }
        return total / (double)this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).size();
    }

    int getTotalLines() {
        int totalLines = 0;
        Iterator it = this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            totalLines += ((Integer)line.getField(ReportSummaryPackageLine.COLUMN_TOTAL_LINES)).intValue();
        }
        return totalLines;
    }

    int getTotalJavaFiles() {
        int totalFiles = 0;
        Iterator it = this.getDetailPage().getLines(ReportSummaryPage.CATEGORY_PACKAGE_SUMMARY).iterator();
        while (it.hasNext()) {
            Line line = (Line)it.next();
            totalFiles += ((Integer)line.getField(ReportSummaryPackageLine.COLUMN_TOTAL_JAVAFILES)).intValue();
        }
        return totalFiles;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

