// SPDX-License-Identifier: GPL-2.0
#include <linux/kernel.h>
#include <cpu/sh7722.h>

#include "sh_pfc.h"

enum {
	PINMUX_RESERVED = 0,

	PINMUX_DATA_BEGIN,
	PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
	PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA,
	PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
	PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA,
	PTC7_DATA, PTC5_DATA, PTC4_DATA, PTC3_DATA, PTC2_DATA, PTC0_DATA,
	PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
	PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA,
	PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA, PTE1_DATA, PTE0_DATA,
	PTF6_DATA, PTF5_DATA, PTF4_DATA,
	PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA,
	PTG4_DATA, PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA,
	PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
	PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA,
	PTJ7_DATA, PTJ6_DATA, PTJ5_DATA, PTJ1_DATA, PTJ0_DATA,
	PTK6_DATA, PTK5_DATA, PTK4_DATA,
	PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA,
	PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
	PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA,
	PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
	PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA,
	PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
	PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA,
	PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
	PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA,
	PTR4_DATA, PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA,
	PTS4_DATA, PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA,
	PTT4_DATA, PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA,
	PTU4_DATA, PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA,
	PTV4_DATA, PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA,
	PTW6_DATA, PTW5_DATA, PTW4_DATA,
	PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA,
	PTX6_DATA, PTX5_DATA, PTX4_DATA,
	PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA,
	PTY6_DATA, PTY5_DATA, PTY4_DATA,
	PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA,
	PTZ5_DATA, PTZ4_DATA, PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA,
	PINMUX_DATA_END,

	PINMUX_INPUT_BEGIN,
	PTA7_IN, PTA6_IN, PTA5_IN, PTA4_IN,
	PTA3_IN, PTA2_IN, PTA1_IN, PTA0_IN,
	PTB7_IN, PTB6_IN, PTB5_IN, PTB4_IN,
	PTB3_IN, PTB2_IN, PTB1_IN, PTB0_IN,
	PTC7_IN, PTC5_IN, PTC4_IN, PTC3_IN, PTC2_IN, PTC0_IN,
	PTD7_IN, PTD6_IN, PTD5_IN, PTD4_IN, PTD3_IN, PTD2_IN, PTD1_IN,
	PTE7_IN, PTE6_IN, PTE5_IN, PTE4_IN, PTE1_IN, PTE0_IN,
	PTF6_IN, PTF5_IN, PTF4_IN, PTF3_IN, PTF2_IN, PTF1_IN,
	PTH6_IN, PTH5_IN, PTH1_IN, PTH0_IN,
	PTJ1_IN, PTJ0_IN,
	PTK6_IN, PTK5_IN, PTK4_IN, PTK3_IN, PTK2_IN, PTK0_IN,
	PTL7_IN, PTL6_IN, PTL5_IN, PTL4_IN,
	PTL3_IN, PTL2_IN, PTL1_IN, PTL0_IN,
	PTM7_IN, PTM6_IN, PTM5_IN, PTM4_IN,
	PTM3_IN, PTM2_IN, PTM1_IN, PTM0_IN,
	PTN7_IN, PTN6_IN, PTN5_IN, PTN4_IN,
	PTN3_IN, PTN2_IN, PTN1_IN, PTN0_IN,
	PTQ5_IN, PTQ4_IN, PTQ3_IN, PTQ2_IN, PTQ0_IN,
	PTR2_IN,
	PTS4_IN, PTS2_IN, PTS1_IN,
	PTT4_IN, PTT3_IN, PTT2_IN, PTT1_IN,
	PTU4_IN, PTU3_IN, PTU2_IN, PTU1_IN, PTU0_IN,
	PTV4_IN, PTV3_IN, PTV2_IN, PTV1_IN, PTV0_IN,
	PTW6_IN, PTW4_IN, PTW3_IN, PTW2_IN, PTW1_IN, PTW0_IN,
	PTX6_IN, PTX5_IN, PTX4_IN, PTX3_IN, PTX2_IN, PTX1_IN, PTX0_IN,
	PTY5_IN, PTY4_IN, PTY3_IN, PTY2_IN, PTY0_IN,
	PTZ5_IN, PTZ4_IN, PTZ3_IN, PTZ2_IN, PTZ1_IN,
	PINMUX_INPUT_END,

	PINMUX_OUTPUT_BEGIN,
	PTA7_OUT, PTA5_OUT,
	PTB7_OUT, PTB6_OUT, PTB5_OUT, PTB4_OUT,
	PTB3_OUT, PTB2_OUT, PTB1_OUT, PTB0_OUT,
	PTC4_OUT, PTC3_OUT, PTC2_OUT, PTC0_OUT,
	PTD6_OUT, PTD5_OUT, PTD4_OUT,
	PTD3_OUT, PTD2_OUT, PTD1_OUT, PTD0_OUT,
	PTE7_OUT, PTE6_OUT, PTE5_OUT, PTE4_OUT, PTE1_OUT, PTE0_OUT,
	PTF6_OUT, PTF5_OUT, PTF4_OUT, PTF3_OUT, PTF2_OUT, PTF0_OUT,
	PTG4_OUT, PTG3_OUT, PTG2_OUT, PTG1_OUT, PTG0_OUT,
	PTH7_OUT, PTH6_OUT, PTH5_OUT, PTH4_OUT,
	PTH3_OUT, PTH2_OUT, PTH1_OUT, PTH0_OUT,
	PTJ7_OUT, PTJ6_OUT, PTJ5_OUT, PTJ1_OUT, PTJ0_OUT,
	PTK6_OUT, PTK5_OUT, PTK4_OUT, PTK3_OUT, PTK1_OUT, PTK0_OUT,
	PTL7_OUT, PTL6_OUT, PTL5_OUT, PTL4_OUT,
	PTL3_OUT, PTL2_OUT, PTL1_OUT, PTL0_OUT,
	PTM7_OUT, PTM6_OUT, PTM5_OUT, PTM4_OUT,
	PTM3_OUT, PTM2_OUT, PTM1_OUT, PTM0_OUT,
	PTN7_OUT, PTN6_OUT, PTN5_OUT, PTN4_OUT,
	PTN3_OUT, PTN2_OUT, PTN1_OUT, PTN0_OUT,	PTQ6_OUT, PTQ5_OUT, PTQ4_OUT,
	PTQ3_OUT, PTQ2_OUT, PTQ1_OUT, PTQ0_OUT,
	PTR4_OUT, PTR3_OUT, PTR1_OUT, PTR0_OUT,
	PTS3_OUT, PTS2_OUT, PTS0_OUT,
	PTT4_OUT, PTT3_OUT, PTT2_OUT, PTT0_OUT,
	PTU4_OUT, PTU3_OUT, PTU2_OUT, PTU0_OUT,
	PTV4_OUT, PTV3_OUT, PTV2_OUT, PTV1_OUT, PTV0_OUT,
	PTW5_OUT, PTW4_OUT, PTW3_OUT, PTW2_OUT, PTW1_OUT, PTW0_OUT,
	PTX6_OUT, PTX5_OUT, PTX4_OUT, PTX3_OUT, PTX2_OUT, PTX1_OUT, PTX0_OUT,
	PTY5_OUT, PTY4_OUT, PTY3_OUT, PTY2_OUT, PTY1_OUT, PTY0_OUT,
	PINMUX_OUTPUT_END,

	PINMUX_MARK_BEGIN,
	SCIF0_TXD_MARK, SCIF0_RXD_MARK,
	SCIF0_RTS_MARK, SCIF0_CTS_MARK, SCIF0_SCK_MARK,
	SCIF1_TXD_MARK, SCIF1_RXD_MARK,
	SCIF1_RTS_MARK, SCIF1_CTS_MARK, SCIF1_SCK_MARK,
	SCIF2_TXD_MARK, SCIF2_RXD_MARK,
	SCIF2_RTS_MARK, SCIF2_CTS_MARK, SCIF2_SCK_MARK,
	SIOTXD_MARK, SIORXD_MARK,
	SIOD_MARK, SIOSTRB0_MARK, SIOSTRB1_MARK,
	SIOSCK_MARK, SIOMCK_MARK,
	VIO_D15_MARK, VIO_D14_MARK, VIO_D13_MARK, VIO_D12_MARK,
	VIO_D11_MARK, VIO_D10_MARK, VIO_D9_MARK, VIO_D8_MARK,
	VIO_D7_MARK, VIO_D6_MARK, VIO_D5_MARK, VIO_D4_MARK,
	VIO_D3_MARK, VIO_D2_MARK, VIO_D1_MARK, VIO_D0_MARK,
	VIO_CLK_MARK, VIO_VD_MARK, VIO_HD_MARK, VIO_FLD_MARK,
	VIO_CKO_MARK, VIO_STEX_MARK, VIO_STEM_MARK, VIO_VD2_MARK,
	VIO_HD2_MARK, VIO_CLK2_MARK,
	LCDD23_MARK, LCDD22_MARK, LCDD21_MARK, LCDD20_MARK,
	LCDD19_MARK, LCDD18_MARK, LCDD17_MARK, LCDD16_MARK,
	LCDD15_MARK, LCDD14_MARK, LCDD13_MARK, LCDD12_MARK,
	LCDD11_MARK, LCDD10_MARK, LCDD9_MARK, LCDD8_MARK,
	LCDD7_MARK, LCDD6_MARK, LCDD5_MARK, LCDD4_MARK,
	LCDD3_MARK, LCDD2_MARK, LCDD1_MARK, LCDD0_MARK,
	LCDLCLK_MARK, LCDDON_MARK, LCDVCPWC_MARK, LCDVEPWC_MARK,
	LCDVSYN_MARK, LCDDCK_MARK, LCDHSYN_MARK, LCDDISP_MARK,
	LCDRS_MARK, LCDCS_MARK, LCDWR_MARK, LCDRD_MARK,
	LCDDON2_MARK, LCDVCPWC2_MARK, LCDVEPWC2_MARK, LCDVSYN2_MARK,
	LCDCS2_MARK,
	IOIS16_MARK, A25_MARK, A24_MARK, A23_MARK, A22_MARK,
	BS_MARK, CS6B_CE1B_MARK, WAIT_MARK, CS6A_CE2B_MARK,
	HPD63_MARK, HPD62_MARK, HPD61_MARK, HPD60_MARK,
	HPD59_MARK, HPD58_MARK, HPD57_MARK, HPD56_MARK,
	HPD55_MARK, HPD54_MARK, HPD53_MARK, HPD52_MARK,
	HPD51_MARK, HPD50_MARK, HPD49_MARK, HPD48_MARK,
	HPDQM7_MARK, HPDQM6_MARK, HPDQM5_MARK, HPDQM4_MARK,
	IRQ0_MARK, IRQ1_MARK, IRQ2_MARK, IRQ3_MARK,
	IRQ4_MARK, IRQ5_MARK, IRQ6_MARK, IRQ7_MARK,
	SDHICD_MARK, SDHIWP_MARK, SDHID3_MARK, SDHID2_MARK,
	SDHID1_MARK, SDHID0_MARK, SDHICMD_MARK, SDHICLK_MARK,
	SIUAOLR_MARK, SIUAOBT_MARK, SIUAISLD_MARK, SIUAILR_MARK,
	SIUAIBT_MARK, SIUAOSLD_MARK, SIUMCKA_MARK, SIUFCKA_MARK,
	SIUBOLR_MARK, SIUBOBT_MARK, SIUBISLD_MARK, SIUBILR_MARK,
	SIUBIBT_MARK, SIUBOSLD_MARK, SIUMCKB_MARK, SIUFCKB_MARK,
	AUDSYNC_MARK, AUDATA3_MARK, AUDATA2_MARK, AUDATA1_MARK,	AUDATA0_MARK,
	DACK_MARK, DREQ0_MARK,
	DV_CLKI_MARK, DV_CLK_MARK, DV_HSYNC_MARK, DV_VSYNC_MARK,
	DV_D15_MARK, DV_D14_MARK, DV_D13_MARK, DV_D12_MARK,
	DV_D11_MARK, DV_D10_MARK, DV_D9_MARK, DV_D8_MARK,
	DV_D7_MARK, DV_D6_MARK, DV_D5_MARK, DV_D4_MARK,
	DV_D3_MARK, DV_D2_MARK, DV_D1_MARK, DV_D0_MARK,
	STATUS0_MARK, PDSTATUS_MARK,
	SIOF0_MCK_MARK, SIOF0_SCK_MARK,
	SIOF0_SYNC_MARK, SIOF0_SS1_MARK, SIOF0_SS2_MARK,
	SIOF0_TXD_MARK,	SIOF0_RXD_MARK,
	SIOF1_MCK_MARK, SIOF1_SCK_MARK,
	SIOF1_SYNC_MARK, SIOF1_SS1_MARK, SIOF1_SS2_MARK,
	SIOF1_TXD_MARK, SIOF1_RXD_MARK,
	SIM_D_MARK, SIM_CLK_MARK, SIM_RST_MARK,
	TS_SDAT_MARK, TS_SCK_MARK, TS_SDEN_MARK, TS_SPSYNC_MARK,
	IRDA_IN_MARK, IRDA_OUT_MARK,
	TPUTO_MARK,
	FCE_MARK, NAF7_MARK, NAF6_MARK, NAF5_MARK, NAF4_MARK,
	NAF3_MARK, NAF2_MARK, NAF1_MARK, NAF0_MARK, FCDE_MARK,
	FOE_MARK, FSC_MARK, FWE_MARK, FRB_MARK,
	KEYIN0_MARK, KEYIN1_MARK, KEYIN2_MARK, KEYIN3_MARK, KEYIN4_MARK,
	KEYOUT0_MARK, KEYOUT1_MARK, KEYOUT2_MARK, KEYOUT3_MARK,
	KEYOUT4_IN6_MARK, KEYOUT5_IN5_MARK,
	PINMUX_MARK_END,

	PINMUX_FUNCTION_BEGIN,
	VIO_D7_SCIF1_SCK, VIO_D6_SCIF1_RXD, VIO_D5_SCIF1_TXD, VIO_D4,
	VIO_D3, VIO_D2, VIO_D1, VIO_D0_LCDLCLK,
	HPD55, HPD54, HPD53, HPD52, HPD51, HPD50, HPD49, HPD48,
	IOIS16, HPDQM7, HPDQM6, HPDQM5, HPDQM4,
	SDHICD, SDHIWP, SDHID3, IRQ2_SDHID2, SDHID1, SDHID0, SDHICMD, SDHICLK,
	A25, A24, A23, A22, IRQ5, IRQ4_BS,
	PTF6, SIOSCK_SIUBOBT, SIOSTRB1_SIUBOLR,
	SIOSTRB0_SIUBIBT, SIOD_SIUBILR, SIORXD_SIUBISLD, SIOTXD_SIUBOSLD,
	AUDSYNC, AUDATA3, AUDATA2, AUDATA1, AUDATA0,
	LCDVCPWC_LCDVCPWC2, LCDVSYN2_DACK, LCDVSYN, LCDDISP_LCDRS,
	LCDHSYN_LCDCS, LCDDON_LCDDON2, LCDD17_DV_HSYNC, LCDD16_DV_VSYNC,
	STATUS0, PDSTATUS, IRQ1, IRQ0,
	SIUAILR_SIOF1_SS2, SIUAIBT_SIOF1_SS1, SIUAOLR_SIOF1_SYNC,
	SIUAOBT_SIOF1_SCK, SIUAISLD_SIOF1_RXD, SIUAOSLD_SIOF1_TXD, PTK0,
	LCDD15_DV_D15, LCDD14_DV_D14, LCDD13_DV_D13, LCDD12_DV_D12,
	LCDD11_DV_D11, LCDD10_DV_D10, LCDD9_DV_D9, LCDD8_DV_D8,
	LCDD7_DV_D7, LCDD6_DV_D6, LCDD5_DV_D5, LCDD4_DV_D4,
	LCDD3_DV_D3, LCDD2_DV_D2, LCDD1_DV_D1, LCDD0_DV_D0,
	HPD63, HPD62, HPD61, HPD60, HPD59, HPD58, HPD57, HPD56,
	SIOF0_SS2_SIM_RST, SIOF0_SS1_TS_SPSYNC, SIOF0_SYNC_TS_SDEN,
	SIOF0_SCK_TS_SCK, PTQ2, PTQ1, PTQ0,
	LCDRD, CS6B_CE1B_LCDCS2, WAIT, LCDDCK_LCDWR, LCDVEPWC_LCDVEPWC2,
	SCIF0_CTS_SIUAISPD, SCIF0_RTS_SIUAOSPD,
	SCIF0_SCK_TPUTO, SCIF0_RXD, SCIF0_TXD,
	FOE_VIO_VD2, FWE, FSC, DREQ0, FCDE,
	NAF2_VIO_D10, NAF1_VIO_D9, NAF0_VIO_D8,
	FRB_VIO_CLK2, FCE_VIO_HD2,
	NAF7_VIO_D15, NAF6_VIO_D14, NAF5_VIO_D13, NAF4_VIO_D12, NAF3_VIO_D11,
	VIO_FLD_SCIF2_CTS, VIO_CKO_SCIF2_RTS, VIO_STEX_SCIF2_SCK,
	VIO_STEM_SCIF2_TXD, VIO_HD_SCIF2_RXD,
	VIO_VD_SCIF1_CTS, VIO_CLK_SCIF1_RTS,
	CS6A_CE2B, LCDD23, LCDD22, LCDD21, LCDD20,
	LCDD19_DV_CLKI, LCDD18_DV_CLK,
	KEYOUT5_IN5, KEYOUT4_IN6, KEYOUT3, KEYOUT2, KEYOUT1, KEYOUT0,
	KEYIN4_IRQ7, KEYIN3, KEYIN2, KEYIN1, KEYIN0_IRQ6,

	PSA15_KEYIN0, PSA15_IRQ6, PSA14_KEYIN4, PSA14_IRQ7,
	PSA9_IRQ4, PSA9_BS, PSA4_IRQ2, PSA4_SDHID2,
	PSB15_SIOTXD, PSB15_SIUBOSLD, PSB14_SIORXD, PSB14_SIUBISLD,
	PSB13_SIOD, PSB13_SIUBILR, PSB12_SIOSTRB0, PSB12_SIUBIBT,
	PSB11_SIOSTRB1, PSB11_SIUBOLR, PSB10_SIOSCK, PSB10_SIUBOBT,
	PSB9_SIOMCK, PSB9_SIUMCKB, PSB8_SIOF0_MCK, PSB8_IRQ3,
	PSB7_SIOF0_TXD, PSB7_IRDA_OUT, PSB6_SIOF0_RXD, PSB6_IRDA_IN,
	PSB5_SIOF0_SCK, PSB5_TS_SCK, PSB4_SIOF0_SYNC, PSB4_TS_SDEN,
	PSB3_SIOF0_SS1, PSB3_TS_SPSYNC, PSB2_SIOF0_SS2, PSB2_SIM_RST,
	PSB1_SIUMCKA, PSB1_SIOF1_MCK, PSB0_SIUAOSLD, PSB0_SIOF1_TXD,
	PSC15_SIUAISLD, PSC15_SIOF1_RXD, PSC14_SIUAOBT, PSC14_SIOF1_SCK,
	PSC13_SIUAOLR, PSC13_SIOF1_SYNC, PSC12_SIUAIBT, PSC12_SIOF1_SS1,
	PSC11_SIUAILR, PSC11_SIOF1_SS2, PSC0_NAF, PSC0_VIO,
	PSD13_VIO, PSD13_SCIF2, PSD12_VIO, PSD12_SCIF1,
	PSD11_VIO, PSD11_SCIF1, PSD10_VIO_D0, PSD10_LCDLCLK,
	PSD9_SIOMCK_SIUMCKB, PSD9_SIUFCKB, PSD8_SCIF0_SCK, PSD8_TPUTO,
	PSD7_SCIF0_RTS, PSD7_SIUAOSPD, PSD6_SCIF0_CTS, PSD6_SIUAISPD,
	PSD5_CS6B_CE1B, PSD5_LCDCS2,
	PSD3_LCDVEPWC_LCDVCPWC, PSD3_LCDVEPWC2_LCDVCPWC2,
	PSD2_LCDDON, PSD2_LCDDON2, PSD0_LCDD19_LCDD0, PSD0_DV,
	PSE15_SIOF0_MCK_IRQ3, PSE15_SIM_D,
	PSE14_SIOF0_TXD_IRDA_OUT, PSE14_SIM_CLK,
	PSE13_SIOF0_RXD_IRDA_IN, PSE13_TS_SDAT, PSE12_LCDVSYN2, PSE12_DACK,
	PSE11_SIUMCKA_SIOF1_MCK, PSE11_SIUFCKA,
	PSE3_FLCTL, PSE3_VIO, PSE2_NAF2, PSE2_VIO_D10,
	PSE1_NAF1, PSE1_VIO_D9, PSE0_NAF0, PSE0_VIO_D8,

	HIZA14_KEYSC, HIZA14_HIZ,
	HIZA10_NAF, HIZA10_HIZ,
	HIZA9_VIO, HIZA9_HIZ,
	HIZA8_LCDC, HIZA8_HIZ,
	HIZA7_LCDC, HIZA7_HIZ,
	HIZA6_LCDC, HIZA6_HIZ,
	HIZB4_SIUA, HIZB4_HIZ,
	HIZB1_VIO, HIZB1_HIZ,
	HIZB0_VIO, HIZB0_HIZ,
	HIZC15_IRQ7, HIZC15_HIZ,
	HIZC14_IRQ6, HIZC14_HIZ,
	HIZC13_IRQ5, HIZC13_HIZ,
	HIZC12_IRQ4, HIZC12_HIZ,
	HIZC11_IRQ3, HIZC11_HIZ,
	HIZC10_IRQ2, HIZC10_HIZ,
	HIZC9_IRQ1, HIZC9_HIZ,
	HIZC8_IRQ0, HIZC8_HIZ,
	MSELB9_VIO, MSELB9_VIO2,
	MSELB8_RGB, MSELB8_SYS,
	PINMUX_FUNCTION_END,
};

static const u16 pinmux_data[] = {
	/* PTA */
	PINMUX_DATA(PTA7_DATA, PTA7_IN, PTA7_OUT),
	PINMUX_DATA(PTA6_DATA, PTA6_IN),
	PINMUX_DATA(PTA5_DATA, PTA5_IN, PTA5_OUT),
	PINMUX_DATA(PTA4_DATA, PTA4_IN),
	PINMUX_DATA(PTA3_DATA, PTA3_IN),
	PINMUX_DATA(PTA2_DATA, PTA2_IN),
	PINMUX_DATA(PTA1_DATA, PTA1_IN),
	PINMUX_DATA(PTA0_DATA, PTA0_IN),

	/* PTB */
	PINMUX_DATA(PTB7_DATA, PTB7_IN, PTB7_OUT),
	PINMUX_DATA(PTB6_DATA, PTB6_IN, PTB6_OUT),
	PINMUX_DATA(PTB5_DATA, PTB5_IN, PTB5_OUT),
	PINMUX_DATA(PTB4_DATA, PTB4_IN, PTB4_OUT),
	PINMUX_DATA(PTB3_DATA, PTB3_IN, PTB3_OUT),
	PINMUX_DATA(PTB2_DATA, PTB2_IN, PTB2_OUT),
	PINMUX_DATA(PTB1_DATA, PTB1_IN, PTB1_OUT),
	PINMUX_DATA(PTB0_DATA, PTB0_IN, PTB0_OUT),

	/* PTC */
	PINMUX_DATA(PTC7_DATA, PTC7_IN),
	PINMUX_DATA(PTC5_DATA, PTC5_IN),
	PINMUX_DATA(PTC4_DATA, PTC4_IN, PTC4_OUT),
	PINMUX_DATA(PTC3_DATA, PTC3_IN, PTC3_OUT),
	PINMUX_DATA(PTC2_DATA, PTC2_IN, PTC2_OUT),
	PINMUX_DATA(PTC0_DATA, PTC0_IN, PTC0_OUT),

	/* PTD */
	PINMUX_DATA(PTD7_DATA, PTD7_IN),
	PINMUX_DATA(PTD6_DATA, PTD6_OUT, PTD6_IN),
	PINMUX_DATA(PTD5_DATA, PTD5_OUT, PTD5_IN),
	PINMUX_DATA(PTD4_DATA, PTD4_OUT, PTD4_IN),
	PINMUX_DATA(PTD3_DATA, PTD3_OUT, PTD3_IN),
	PINMUX_DATA(PTD2_DATA, PTD2_OUT, PTD2_IN),
	PINMUX_DATA(PTD1_DATA, PTD1_OUT, PTD1_IN),
	PINMUX_DATA(PTD0_DATA, PTD0_OUT),

	/* PTE */
	PINMUX_DATA(PTE7_DATA, PTE7_OUT, PTE7_IN),
	PINMUX_DATA(PTE6_DATA, PTE6_OUT, PTE6_IN),
	PINMUX_DATA(PTE5_DATA, PTE5_OUT, PTE5_IN),
	PINMUX_DATA(PTE4_DATA, PTE4_OUT, PTE4_IN),
	PINMUX_DATA(PTE1_DATA, PTE1_OUT, PTE1_IN),
	PINMUX_DATA(PTE0_DATA, PTE0_OUT, PTE0_IN),

	/* PTF */
	PINMUX_DATA(PTF6_DATA, PTF6_OUT, PTF6_IN),
	PINMUX_DATA(PTF5_DATA, PTF5_OUT, PTF5_IN),
	PINMUX_DATA(PTF4_DATA, PTF4_OUT, PTF4_IN),
	PINMUX_DATA(PTF3_DATA, PTF3_OUT, PTF3_IN),
	PINMUX_DATA(PTF2_DATA, PTF2_OUT, PTF2_IN),
	PINMUX_DATA(PTF1_DATA, PTF1_IN),
	PINMUX_DATA(PTF0_DATA, PTF0_OUT),

	/* PTG */
	PINMUX_DATA(PTG4_DATA, PTG4_OUT),
	PINMUX_DATA(PTG3_DATA, PTG3_OUT),
	PINMUX_DATA(PTG2_DATA, PTG2_OUT),
	PINMUX_DATA(PTG1_DATA, PTG1_OUT),
	PINMUX_DATA(PTG0_DATA, PTG0_OUT),

	/* PTH */
	PINMUX_DATA(PTH7_DATA, PTH7_OUT),
	PINMUX_DATA(PTH6_DATA, PTH6_OUT, PTH6_IN),
	PINMUX_DATA(PTH5_DATA, PTH5_OUT, PTH5_IN),
	PINMUX_DATA(PTH4_DATA, PTH4_OUT),
	PINMUX_DATA(PTH3_DATA, PTH3_OUT),
	PINMUX_DATA(PTH2_DATA, PTH2_OUT),
	PINMUX_DATA(PTH1_DATA, PTH1_OUT, PTH1_IN),
	PINMUX_DATA(PTH0_DATA, PTH0_OUT, PTH0_IN),

	/* PTJ */
	PINMUX_DATA(PTJ7_DATA, PTJ7_OUT),
	PINMUX_DATA(PTJ6_DATA, PTJ6_OUT),
	PINMUX_DATA(PTJ5_DATA, PTJ5_OUT),
	PINMUX_DATA(PTJ1_DATA, PTJ1_OUT, PTJ1_IN),
	PINMUX_DATA(PTJ0_DATA, PTJ0_OUT, PTJ0_IN),

	/* PTK */
	PINMUX_DATA(PTK6_DATA, PTK6_OUT, PTK6_IN),
	PINMUX_DATA(PTK5_DATA, PTK5_OUT, PTK5_IN),
	PINMUX_DATA(PTK4_DATA, PTK4_OUT, PTK4_IN),
	PINMUX_DATA(PTK3_DATA, PTK3_OUT, PTK3_IN),
	PINMUX_DATA(PTK2_DATA, PTK2_IN),
	PINMUX_DATA(PTK1_DATA, PTK1_OUT),
	PINMUX_DATA(PTK0_DATA, PTK0_OUT, PTK0_IN),

	/* PTL */
	PINMUX_DATA(PTL7_DATA, PTL7_OUT, PTL7_IN),
	PINMUX_DATA(PTL6_DATA, PTL6_OUT, PTL6_IN),
	PINMUX_DATA(PTL5_DATA, PTL5_OUT, PTL5_IN),
	PINMUX_DATA(PTL4_DATA, PTL4_OUT, PTL4_IN),
	PINMUX_DATA(PTL3_DATA, PTL3_OUT, PTL3_IN),
	PINMUX_DATA(PTL2_DATA, PTL2_OUT, PTL2_IN),
	PINMUX_DATA(PTL1_DATA, PTL1_OUT, PTL1_IN),
	PINMUX_DATA(PTL0_DATA, PTL0_OUT, PTL0_IN),

	/* PTM */
	PINMUX_DATA(PTM7_DATA, PTM7_OUT, PTM7_IN),
	PINMUX_DATA(PTM6_DATA, PTM6_OUT, PTM6_IN),
	PINMUX_DATA(PTM5_DATA, PTM5_OUT, PTM5_IN),
	PINMUX_DATA(PTM4_DATA, PTM4_OUT, PTM4_IN),
	PINMUX_DATA(PTM3_DATA, PTM3_OUT, PTM3_IN),
	PINMUX_DATA(PTM2_DATA, PTM2_OUT, PTM2_IN),
	PINMUX_DATA(PTM1_DATA, PTM1_OUT, PTM1_IN),
	PINMUX_DATA(PTM0_DATA, PTM0_OUT, PTM0_IN),

	/* PTN */
	PINMUX_DATA(PTN7_DATA, PTN7_OUT, PTN7_IN),
	PINMUX_DATA(PTN6_DATA, PTN6_OUT, PTN6_IN),
	PINMUX_DATA(PTN5_DATA, PTN5_OUT, PTN5_IN),
	PINMUX_DATA(PTN4_DATA, PTN4_OUT, PTN4_IN),
	PINMUX_DATA(PTN3_DATA, PTN3_OUT, PTN3_IN),
	PINMUX_DATA(PTN2_DATA, PTN2_OUT, PTN2_IN),
	PINMUX_DATA(PTN1_DATA, PTN1_OUT, PTN1_IN),
	PINMUX_DATA(PTN0_DATA, PTN0_OUT, PTN0_IN),

	/* PTQ */
	PINMUX_DATA(PTQ6_DATA, PTQ6_OUT),
	PINMUX_DATA(PTQ5_DATA, PTQ5_OUT, PTQ5_IN),
	PINMUX_DATA(PTQ4_DATA, PTQ4_OUT, PTQ4_IN),
	PINMUX_DATA(PTQ3_DATA, PTQ3_OUT, PTQ3_IN),
	PINMUX_DATA(PTQ2_DATA, PTQ2_IN),
	PINMUX_DATA(PTQ1_DATA, PTQ1_OUT),
	PINMUX_DATA(PTQ0_DATA, PTQ0_OUT, PTQ0_IN),

	/* PTR */
	PINMUX_DATA(PTR4_DATA, PTR4_OUT),
	PINMUX_DATA(PTR3_DATA, PTR3_OUT),
	PINMUX_DATA(PTR2_DATA, PTR2_IN),
	PINMUX_DATA(PTR1_DATA, PTR1_OUT),
	PINMUX_DATA(PTR0_DATA, PTR0_OUT),

	/* PTS */
	PINMUX_DATA(PTS4_DATA, PTS4_IN),
	PINMUX_DATA(PTS3_DATA, PTS3_OUT),
	PINMUX_DATA(PTS2_DATA, PTS2_OUT, PTS2_IN),
	PINMUX_DATA(PTS1_DATA, PTS1_IN),
	PINMUX_DATA(PTS0_DATA, PTS0_OUT),

	/* PTT */
	PINMUX_DATA(PTT4_DATA, PTT4_OUT, PTT4_IN),
	PINMUX_DATA(PTT3_DATA, PTT3_OUT, PTT3_IN),
	PINMUX_DATA(PTT2_DATA, PTT2_OUT, PTT2_IN),
	PINMUX_DATA(PTT1_DATA, PTT1_IN),
	PINMUX_DATA(PTT0_DATA, PTT0_OUT),

	/* PTU */
	PINMUX_DATA(PTU4_DATA, PTU4_OUT, PTU4_IN),
	PINMUX_DATA(PTU3_DATA, PTU3_OUT, PTU3_IN),
	PINMUX_DATA(PTU2_DATA, PTU2_OUT, PTU2_IN),
	PINMUX_DATA(PTU1_DATA, PTU1_IN),
	PINMUX_DATA(PTU0_DATA, PTU0_OUT, PTU0_IN),

	/* PTV */
	PINMUX_DATA(PTV4_DATA, PTV4_OUT, PTV4_IN),
	PINMUX_DATA(PTV3_DATA, PTV3_OUT, PTV3_IN),
	PINMUX_DATA(PTV2_DATA, PTV2_OUT, PTV2_IN),
	PINMUX_DATA(PTV1_DATA, PTV1_OUT, PTV1_IN),
	PINMUX_DATA(PTV0_DATA, PTV0_OUT, PTV0_IN),

	/* PTW */
	PINMUX_DATA(PTW6_DATA, PTW6_IN),
	PINMUX_DATA(PTW5_DATA, PTW5_OUT),
	PINMUX_DATA(PTW4_DATA, PTW4_OUT, PTW4_IN),
	PINMUX_DATA(PTW3_DATA, PTW3_OUT, PTW3_IN),
	PINMUX_DATA(PTW2_DATA, PTW2_OUT, PTW2_IN),
	PINMUX_DATA(PTW1_DATA, PTW1_OUT, PTW1_IN),
	PINMUX_DATA(PTW0_DATA, PTW0_OUT, PTW0_IN),

	/* PTX */
	PINMUX_DATA(PTX6_DATA, PTX6_OUT, PTX6_IN),
	PINMUX_DATA(PTX5_DATA, PTX5_OUT, PTX5_IN),
	PINMUX_DATA(PTX4_DATA, PTX4_OUT, PTX4_IN),
	PINMUX_DATA(PTX3_DATA, PTX3_OUT, PTX3_IN),
	PINMUX_DATA(PTX2_DATA, PTX2_OUT, PTX2_IN),
	PINMUX_DATA(PTX1_DATA, PTX1_OUT, PTX1_IN),
	PINMUX_DATA(PTX0_DATA, PTX0_OUT, PTX0_IN),

	/* PTY */
	PINMUX_DATA(PTY5_DATA, PTY5_OUT, PTY5_IN),
	PINMUX_DATA(PTY4_DATA, PTY4_OUT, PTY4_IN),
	PINMUX_DATA(PTY3_DATA, PTY3_OUT, PTY3_IN),
	PINMUX_DATA(PTY2_DATA, PTY2_OUT, PTY2_IN),
	PINMUX_DATA(PTY1_DATA, PTY1_OUT),
	PINMUX_DATA(PTY0_DATA, PTY0_OUT, PTY0_IN),

	/* PTZ */
	PINMUX_DATA(PTZ5_DATA, PTZ5_IN),
	PINMUX_DATA(PTZ4_DATA, PTZ4_IN),
	PINMUX_DATA(PTZ3_DATA, PTZ3_IN),
	PINMUX_DATA(PTZ2_DATA, PTZ2_IN),
	PINMUX_DATA(PTZ1_DATA, PTZ1_IN),

	/* SCIF0 */
	PINMUX_DATA(SCIF0_TXD_MARK, SCIF0_TXD),
	PINMUX_DATA(SCIF0_RXD_MARK, SCIF0_RXD),
	PINMUX_DATA(SCIF0_RTS_MARK, PSD7_SCIF0_RTS, SCIF0_RTS_SIUAOSPD),
	PINMUX_DATA(SCIF0_CTS_MARK, PSD6_SCIF0_CTS, SCIF0_CTS_SIUAISPD),
	PINMUX_DATA(SCIF0_SCK_MARK, PSD8_SCIF0_SCK, SCIF0_SCK_TPUTO),

	/* SCIF1 */
	PINMUX_DATA(SCIF1_TXD_MARK, PSD11_SCIF1, VIO_D5_SCIF1_TXD),
	PINMUX_DATA(SCIF1_RXD_MARK, PSD11_SCIF1, VIO_D6_SCIF1_RXD),
	PINMUX_DATA(SCIF1_RTS_MARK, PSD12_SCIF1, VIO_CLK_SCIF1_RTS),
	PINMUX_DATA(SCIF1_CTS_MARK, PSD12_SCIF1, VIO_VD_SCIF1_CTS),
	PINMUX_DATA(SCIF1_SCK_MARK, PSD11_SCIF1, VIO_D7_SCIF1_SCK),

	/* SCIF2 */
	PINMUX_DATA(SCIF2_TXD_MARK, PSD13_SCIF2, VIO_STEM_SCIF2_TXD),
	PINMUX_DATA(SCIF2_RXD_MARK, PSD13_SCIF2, VIO_HD_SCIF2_RXD),
	PINMUX_DATA(SCIF2_RTS_MARK, PSD13_SCIF2, VIO_CKO_SCIF2_RTS),
	PINMUX_DATA(SCIF2_CTS_MARK, PSD13_SCIF2, VIO_FLD_SCIF2_CTS),
	PINMUX_DATA(SCIF2_SCK_MARK, PSD13_SCIF2, VIO_STEX_SCIF2_SCK),

	/* SIO */
	PINMUX_DATA(SIOTXD_MARK, PSB15_SIOTXD, SIOTXD_SIUBOSLD),
	PINMUX_DATA(SIORXD_MARK, PSB14_SIORXD, SIORXD_SIUBISLD),
	PINMUX_DATA(SIOD_MARK, PSB13_SIOD, SIOD_SIUBILR),
	PINMUX_DATA(SIOSTRB0_MARK, PSB12_SIOSTRB0, SIOSTRB0_SIUBIBT),
	PINMUX_DATA(SIOSTRB1_MARK, PSB11_SIOSTRB1, SIOSTRB1_SIUBOLR),
	PINMUX_DATA(SIOSCK_MARK, PSB10_SIOSCK, SIOSCK_SIUBOBT),
	PINMUX_DATA(SIOMCK_MARK, PSD9_SIOMCK_SIUMCKB, PSB9_SIOMCK, PTF6),

	/* CEU */
	PINMUX_DATA(VIO_D15_MARK, PSC0_VIO, HIZA10_NAF, NAF7_VIO_D15),
	PINMUX_DATA(VIO_D14_MARK, PSC0_VIO, HIZA10_NAF, NAF6_VIO_D14),
	PINMUX_DATA(VIO_D13_MARK, PSC0_VIO, HIZA10_NAF, NAF5_VIO_D13),
	PINMUX_DATA(VIO_D12_MARK, PSC0_VIO, HIZA10_NAF, NAF4_VIO_D12),
	PINMUX_DATA(VIO_D11_MARK, PSC0_VIO, HIZA10_NAF, NAF3_VIO_D11),
	PINMUX_DATA(VIO_D10_MARK, PSE2_VIO_D10, HIZB0_VIO, NAF2_VIO_D10),
	PINMUX_DATA(VIO_D9_MARK, PSE1_VIO_D9, HIZB0_VIO, NAF1_VIO_D9),
	PINMUX_DATA(VIO_D8_MARK, PSE0_VIO_D8, HIZB0_VIO, NAF0_VIO_D8),
	PINMUX_DATA(VIO_D7_MARK, PSD11_VIO, VIO_D7_SCIF1_SCK),
	PINMUX_DATA(VIO_D6_MARK, PSD11_VIO, VIO_D6_SCIF1_RXD),
	PINMUX_DATA(VIO_D5_MARK, PSD11_VIO, VIO_D5_SCIF1_TXD),
	PINMUX_DATA(VIO_D4_MARK, VIO_D4),
	PINMUX_DATA(VIO_D3_MARK, VIO_D3),
	PINMUX_DATA(VIO_D2_MARK, VIO_D2),
	PINMUX_DATA(VIO_D1_MARK, VIO_D1),
	PINMUX_DATA(VIO_D0_MARK, PSD10_VIO_D0, VIO_D0_LCDLCLK),
	PINMUX_DATA(VIO_CLK_MARK, PSD12_VIO, MSELB9_VIO, VIO_CLK_SCIF1_RTS),
	PINMUX_DATA(VIO_VD_MARK, PSD12_VIO, MSELB9_VIO, VIO_VD_SCIF1_CTS),
	PINMUX_DATA(VIO_HD_MARK, PSD13_VIO, MSELB9_VIO, VIO_HD_SCIF2_RXD),
	PINMUX_DATA(VIO_FLD_MARK, PSD13_VIO, HIZA9_VIO, VIO_FLD_SCIF2_CTS),
	PINMUX_DATA(VIO_CKO_MARK, PSD13_VIO, HIZA9_VIO, VIO_CKO_SCIF2_RTS),
	PINMUX_DATA(VIO_STEX_MARK, PSD13_VIO, HIZA9_VIO, VIO_STEX_SCIF2_SCK),
	PINMUX_DATA(VIO_STEM_MARK, PSD13_VIO, HIZA9_VIO, VIO_STEM_SCIF2_TXD),
	PINMUX_DATA(VIO_VD2_MARK, PSE3_VIO, MSELB9_VIO2,
		    HIZB0_VIO, FOE_VIO_VD2),
	PINMUX_DATA(VIO_HD2_MARK, PSE3_VIO, MSELB9_VIO2,
		    HIZB1_VIO, FCE_VIO_HD2),
	PINMUX_DATA(VIO_CLK2_MARK, PSE3_VIO, MSELB9_VIO2,
		    HIZB1_VIO, FRB_VIO_CLK2),

	/* LCDC */
	PINMUX_DATA(LCDD23_MARK, HIZA8_LCDC, LCDD23),
	PINMUX_DATA(LCDD22_MARK, HIZA8_LCDC, LCDD22),
	PINMUX_DATA(LCDD21_MARK, HIZA8_LCDC, LCDD21),
	PINMUX_DATA(LCDD20_MARK, HIZA8_LCDC, LCDD20),
	PINMUX_DATA(LCDD19_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD19_DV_CLKI),
	PINMUX_DATA(LCDD18_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD18_DV_CLK),
	PINMUX_DATA(LCDD17_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC,
		    LCDD17_DV_HSYNC),
	PINMUX_DATA(LCDD16_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC,
		    LCDD16_DV_VSYNC),
	PINMUX_DATA(LCDD15_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD15_DV_D15),
	PINMUX_DATA(LCDD14_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD14_DV_D14),
	PINMUX_DATA(LCDD13_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD13_DV_D13),
	PINMUX_DATA(LCDD12_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD12_DV_D12),
	PINMUX_DATA(LCDD11_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD11_DV_D11),
	PINMUX_DATA(LCDD10_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD10_DV_D10),
	PINMUX_DATA(LCDD9_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD9_DV_D9),
	PINMUX_DATA(LCDD8_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD8_DV_D8),
	PINMUX_DATA(LCDD7_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD7_DV_D7),
	PINMUX_DATA(LCDD6_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD6_DV_D6),
	PINMUX_DATA(LCDD5_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD5_DV_D5),
	PINMUX_DATA(LCDD4_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD4_DV_D4),
	PINMUX_DATA(LCDD3_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD3_DV_D3),
	PINMUX_DATA(LCDD2_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD2_DV_D2),
	PINMUX_DATA(LCDD1_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD1_DV_D1),
	PINMUX_DATA(LCDD0_MARK, PSD0_LCDD19_LCDD0, HIZA8_LCDC, LCDD0_DV_D0),
	PINMUX_DATA(LCDLCLK_MARK, PSD10_LCDLCLK, VIO_D0_LCDLCLK),
	/* Main LCD */
	PINMUX_DATA(LCDDON_MARK, PSD2_LCDDON, HIZA7_LCDC, LCDDON_LCDDON2),
	PINMUX_DATA(LCDVCPWC_MARK, PSD3_LCDVEPWC_LCDVCPWC,
		    HIZA6_LCDC, LCDVCPWC_LCDVCPWC2),
	PINMUX_DATA(LCDVEPWC_MARK, PSD3_LCDVEPWC_LCDVCPWC,
		    HIZA6_LCDC, LCDVEPWC_LCDVEPWC2),
	PINMUX_DATA(LCDVSYN_MARK, HIZA7_LCDC, LCDVSYN),
	/* Main LCD - RGB Mode */
	PINMUX_DATA(LCDDCK_MARK, MSELB8_RGB, HIZA8_LCDC, LCDDCK_LCDWR),
	PINMUX_DATA(LCDHSYN_MARK, MSELB8_RGB, HIZA7_LCDC, LCDHSYN_LCDCS),
	PINMUX_DATA(LCDDISP_MARK, MSELB8_RGB, HIZA7_LCDC, LCDDISP_LCDRS),
	/* Main LCD - SYS Mode */
	PINMUX_DATA(LCDRS_MARK, MSELB8_SYS, HIZA7_LCDC, LCDDISP_LCDRS),
	PINMUX_DATA(LCDCS_MARK, MSELB8_SYS, HIZA7_LCDC, LCDHSYN_LCDCS),
	PINMUX_DATA(LCDWR_MARK, MSELB8_SYS, HIZA8_LCDC, LCDDCK_LCDWR),
	PINMUX_DATA(LCDRD_MARK, HIZA7_LCDC, LCDRD),
	/* Sub LCD - SYS Mode */
	PINMUX_DATA(LCDDON2_MARK, PSD2_LCDDON2, HIZA7_LCDC, LCDDON_LCDDON2),
	PINMUX_DATA(LCDVCPWC2_MARK, PSD3_LCDVEPWC2_LCDVCPWC2,
		    HIZA6_LCDC, LCDVCPWC_LCDVCPWC2),
	PINMUX_DATA(LCDVEPWC2_MARK, PSD3_LCDVEPWC2_LCDVCPWC2,
		    HIZA6_LCDC, LCDVEPWC_LCDVEPWC2),
	PINMUX_DATA(LCDVSYN2_MARK, PSE12_LCDVSYN2, HIZA8_LCDC, LCDVSYN2_DACK),
	PINMUX_DATA(LCDCS2_MARK, PSD5_LCDCS2, CS6B_CE1B_LCDCS2),

	/* BSC */
	PINMUX_DATA(IOIS16_MARK, IOIS16),
	PINMUX_DATA(A25_MARK, A25),
	PINMUX_DATA(A24_MARK, A24),
	PINMUX_DATA(A23_MARK, A23),
	PINMUX_DATA(A22_MARK, A22),
	PINMUX_DATA(BS_MARK, PSA9_BS, IRQ4_BS),
	PINMUX_DATA(CS6B_CE1B_MARK, PSD5_CS6B_CE1B, CS6B_CE1B_LCDCS2),
	PINMUX_DATA(WAIT_MARK, WAIT),
	PINMUX_DATA(CS6A_CE2B_MARK, CS6A_CE2B),

	/* SBSC */
	PINMUX_DATA(HPD63_MARK, HPD63),
	PINMUX_DATA(HPD62_MARK, HPD62),
	PINMUX_DATA(HPD61_MARK, HPD61),
	PINMUX_DATA(HPD60_MARK, HPD60),
	PINMUX_DATA(HPD59_MARK, HPD59),
	PINMUX_DATA(HPD58_MARK, HPD58),
	PINMUX_DATA(HPD57_MARK, HPD57),
	PINMUX_DATA(HPD56_MARK, HPD56),
	PINMUX_DATA(HPD55_MARK, HPD55),
	PINMUX_DATA(HPD54_MARK, HPD54),
	PINMUX_DATA(HPD53_MARK, HPD53),
	PINMUX_DATA(HPD52_MARK, HPD52),
	PINMUX_DATA(HPD51_MARK, HPD51),
	PINMUX_DATA(HPD50_MARK, HPD50),
	PINMUX_DATA(HPD49_MARK, HPD49),
	PINMUX_DATA(HPD48_MARK, HPD48),
	PINMUX_DATA(HPDQM7_MARK, HPDQM7),
	PINMUX_DATA(HPDQM6_MARK, HPDQM6),
	PINMUX_DATA(HPDQM5_MARK, HPDQM5),
	PINMUX_DATA(HPDQM4_MARK, HPDQM4),

	/* IRQ */
	PINMUX_DATA(IRQ0_MARK, HIZC8_IRQ0, IRQ0),
	PINMUX_DATA(IRQ1_MARK, HIZC9_IRQ1, IRQ1),
	PINMUX_DATA(IRQ2_MARK, PSA4_IRQ2, HIZC10_IRQ2, IRQ2_SDHID2),
	PINMUX_DATA(IRQ3_MARK, PSE15_SIOF0_MCK_IRQ3, PSB8_IRQ3,
		    HIZC11_IRQ3, PTQ0),
	PINMUX_DATA(IRQ4_MARK, PSA9_IRQ4, HIZC12_IRQ4, IRQ4_BS),
	PINMUX_DATA(IRQ5_MARK, HIZC13_IRQ5, IRQ5),
	PINMUX_DATA(IRQ6_MARK, PSA15_IRQ6, HIZC14_IRQ6, KEYIN0_IRQ6),
	PINMUX_DATA(IRQ7_MARK, PSA14_IRQ7, HIZC15_IRQ7, KEYIN4_IRQ7),

	/* SDHI */
	PINMUX_DATA(SDHICD_MARK, SDHICD),
	PINMUX_DATA(SDHIWP_MARK, SDHIWP),
	PINMUX_DATA(SDHID3_MARK, SDHID3),
	PINMUX_DATA(SDHID2_MARK, PSA4_SDHID2, IRQ2_SDHID2),
	PINMUX_DATA(SDHID1_MARK, SDHID1),
	PINMUX_DATA(SDHID0_MARK, SDHID0),
	PINMUX_DATA(SDHICMD_MARK, SDHICMD),
	PINMUX_DATA(SDHICLK_MARK, SDHICLK),

	/* SIU - Port A */
	PINMUX_DATA(SIUAOLR_MARK, PSC13_SIUAOLR, HIZB4_SIUA, SIUAOLR_SIOF1_SYNC),
	PINMUX_DATA(SIUAOBT_MARK, PSC14_SIUAOBT, HIZB4_SIUA, SIUAOBT_SIOF1_SCK),
	PINMUX_DATA(SIUAISLD_MARK, PSC15_SIUAISLD, HIZB4_SIUA, SIUAISLD_SIOF1_RXD),
	PINMUX_DATA(SIUAILR_MARK, PSC11_SIUAILR, HIZB4_SIUA, SIUAILR_SIOF1_SS2),
	PINMUX_DATA(SIUAIBT_MARK, PSC12_SIUAIBT, HIZB4_SIUA, SIUAIBT_SIOF1_SS1),
	PINMUX_DATA(SIUAOSLD_MARK, PSB0_SIUAOSLD, HIZB4_SIUA, SIUAOSLD_SIOF1_TXD),
	PINMUX_DATA(SIUMCKA_MARK, PSE11_SIUMCKA_SIOF1_MCK, HIZB4_SIUA, PSB1_SIUMCKA, PTK0),
	PINMUX_DATA(SIUFCKA_MARK, PSE11_SIUFCKA, HIZB4_SIUA, PTK0),

	/* SIU - Port B */
	PINMUX_DATA(SIUBOLR_MARK, PSB11_SIUBOLR, SIOSTRB1_SIUBOLR),
	PINMUX_DATA(SIUBOBT_MARK, PSB10_SIUBOBT, SIOSCK_SIUBOBT),
	PINMUX_DATA(SIUBISLD_MARK, PSB14_SIUBISLD, SIORXD_SIUBISLD),
	PINMUX_DATA(SIUBILR_MARK, PSB13_SIUBILR, SIOD_SIUBILR),
	PINMUX_DATA(SIUBIBT_MARK, PSB12_SIUBIBT, SIOSTRB0_SIUBIBT),
	PINMUX_DATA(SIUBOSLD_MARK, PSB15_SIUBOSLD, SIOTXD_SIUBOSLD),
	PINMUX_DATA(SIUMCKB_MARK, PSD9_SIOMCK_SIUMCKB, PSB9_SIUMCKB, PTF6),
	PINMUX_DATA(SIUFCKB_MARK, PSD9_SIUFCKB, PTF6),

	/* AUD */
	PINMUX_DATA(AUDSYNC_MARK, AUDSYNC),
	PINMUX_DATA(AUDATA3_MARK, AUDATA3),
	PINMUX_DATA(AUDATA2_MARK, AUDATA2),
	PINMUX_DATA(AUDATA1_MARK, AUDATA1),
	PINMUX_DATA(AUDATA0_MARK, AUDATA0),

	/* DMAC */
	PINMUX_DATA(DACK_MARK, PSE12_DACK, LCDVSYN2_DACK),
	PINMUX_DATA(DREQ0_MARK, DREQ0),

	/* VOU */
	PINMUX_DATA(DV_CLKI_MARK, PSD0_DV, LCDD19_DV_CLKI),
	PINMUX_DATA(DV_CLK_MARK, PSD0_DV, LCDD18_DV_CLK),
	PINMUX_DATA(DV_HSYNC_MARK, PSD0_DV, LCDD17_DV_HSYNC),
	PINMUX_DATA(DV_VSYNC_MARK, PSD0_DV, LCDD16_DV_VSYNC),
	PINMUX_DATA(DV_D15_MARK, PSD0_DV, LCDD15_DV_D15),
	PINMUX_DATA(DV_D14_MARK, PSD0_DV, LCDD14_DV_D14),
	PINMUX_DATA(DV_D13_MARK, PSD0_DV, LCDD13_DV_D13),
	PINMUX_DATA(DV_D12_MARK, PSD0_DV, LCDD12_DV_D12),
	PINMUX_DATA(DV_D11_MARK, PSD0_DV, LCDD11_DV_D11),
	PINMUX_DATA(DV_D10_MARK, PSD0_DV, LCDD10_DV_D10),
	PINMUX_DATA(DV_D9_MARK, PSD0_DV, LCDD9_DV_D9),
	PINMUX_DATA(DV_D8_MARK, PSD0_DV, LCDD8_DV_D8),
	PINMUX_DATA(DV_D7_MARK, PSD0_DV, LCDD7_DV_D7),
	PINMUX_DATA(DV_D6_MARK, PSD0_DV, LCDD6_DV_D6),
	PINMUX_DATA(DV_D5_MARK, PSD0_DV, LCDD5_DV_D5),
	PINMUX_DATA(DV_D4_MARK, PSD0_DV, LCDD4_DV_D4),
	PINMUX_DATA(DV_D3_MARK, PSD0_DV, LCDD3_DV_D3),
	PINMUX_DATA(DV_D2_MARK, PSD0_DV, LCDD2_DV_D2),
	PINMUX_DATA(DV_D1_MARK, PSD0_DV, LCDD1_DV_D1),
	PINMUX_DATA(DV_D0_MARK, PSD0_DV, LCDD0_DV_D0),

	/* CPG */
	PINMUX_DATA(STATUS0_MARK, STATUS0),
	PINMUX_DATA(PDSTATUS_MARK, PDSTATUS),

	/* SIOF0 */
	PINMUX_DATA(SIOF0_MCK_MARK, PSE15_SIOF0_MCK_IRQ3, PSB8_SIOF0_MCK, PTQ0),
	PINMUX_DATA(SIOF0_SCK_MARK, PSB5_SIOF0_SCK, SIOF0_SCK_TS_SCK),
	PINMUX_DATA(SIOF0_SYNC_MARK, PSB4_SIOF0_SYNC, SIOF0_SYNC_TS_SDEN),
	PINMUX_DATA(SIOF0_SS1_MARK, PSB3_SIOF0_SS1, SIOF0_SS1_TS_SPSYNC),
	PINMUX_DATA(SIOF0_SS2_MARK, PSB2_SIOF0_SS2, SIOF0_SS2_SIM_RST),
	PINMUX_DATA(SIOF0_TXD_MARK, PSE14_SIOF0_TXD_IRDA_OUT,
		    PSB7_SIOF0_TXD, PTQ1),
	PINMUX_DATA(SIOF0_RXD_MARK, PSE13_SIOF0_RXD_IRDA_IN,
		    PSB6_SIOF0_RXD, PTQ2),

	/* SIOF1 */
	PINMUX_DATA(SIOF1_MCK_MARK, PSE11_SIUMCKA_SIOF1_MCK,
		    PSB1_SIOF1_MCK, PTK0),
	PINMUX_DATA(SIOF1_SCK_MARK, PSC14_SIOF1_SCK, SIUAOBT_SIOF1_SCK),
	PINMUX_DATA(SIOF1_SYNC_MARK, PSC13_SIOF1_SYNC, SIUAOLR_SIOF1_SYNC),
	PINMUX_DATA(SIOF1_SS1_MARK, PSC12_SIOF1_SS1, SIUAIBT_SIOF1_SS1),
	PINMUX_DATA(SIOF1_SS2_MARK, PSC11_SIOF1_SS2, SIUAILR_SIOF1_SS2),
	PINMUX_DATA(SIOF1_TXD_MARK, PSB0_SIOF1_TXD, SIUAOSLD_SIOF1_TXD),
	PINMUX_DATA(SIOF1_RXD_MARK, PSC15_SIOF1_RXD, SIUAISLD_SIOF1_RXD),

	/* SIM */
	PINMUX_DATA(SIM_D_MARK, PSE15_SIM_D, PTQ0),
	PINMUX_DATA(SIM_CLK_MARK, PSE14_SIM_CLK, PTQ1),
	PINMUX_DATA(SIM_RST_MARK, PSB2_SIM_RST, SIOF0_SS2_SIM_RST),

	/* TSIF */
	PINMUX_DATA(TS_SDAT_MARK, PSE13_TS_SDAT, PTQ2),
	PINMUX_DATA(TS_SCK_MARK, PSB5_TS_SCK, SIOF0_SCK_TS_SCK),
	PINMUX_DATA(TS_SDEN_MARK, PSB4_TS_SDEN, SIOF0_SYNC_TS_SDEN),
	PINMUX_DATA(TS_SPSYNC_MARK, PSB3_TS_SPSYNC, SIOF0_SS1_TS_SPSYNC),

	/* IRDA */
	PINMUX_DATA(IRDA_IN_MARK, PSE13_SIOF0_RXD_IRDA_IN, PSB6_IRDA_IN, PTQ2),
	PINMUX_DATA(IRDA_OUT_MARK, PSE14_SIOF0_TXD_IRDA_OUT,
		    PSB7_IRDA_OUT, PTQ1),

	/* TPU */
	PINMUX_DATA(TPUTO_MARK, PSD8_TPUTO, SCIF0_SCK_TPUTO),

	/* FLCTL */
	PINMUX_DATA(FCE_MARK, PSE3_FLCTL, FCE_VIO_HD2),
	PINMUX_DATA(NAF7_MARK, PSC0_NAF, HIZA10_NAF, NAF7_VIO_D15),
	PINMUX_DATA(NAF6_MARK, PSC0_NAF, HIZA10_NAF, NAF6_VIO_D14),
	PINMUX_DATA(NAF5_MARK, PSC0_NAF, HIZA10_NAF, NAF5_VIO_D13),
	PINMUX_DATA(NAF4_MARK, PSC0_NAF, HIZA10_NAF, NAF4_VIO_D12),
	PINMUX_DATA(NAF3_MARK, PSC0_NAF, HIZA10_NAF, NAF3_VIO_D11),
	PINMUX_DATA(NAF2_MARK, PSE2_NAF2, HIZB0_VIO, NAF2_VIO_D10),
	PINMUX_DATA(NAF1_MARK, PSE1_NAF1, HIZB0_VIO, NAF1_VIO_D9),
	PINMUX_DATA(NAF0_MARK, PSE0_NAF0, HIZB0_VIO, NAF0_VIO_D8),
	PINMUX_DATA(FCDE_MARK, FCDE),
	PINMUX_DATA(FOE_MARK, PSE3_FLCTL, HIZB0_VIO, FOE_VIO_VD2),
	PINMUX_DATA(FSC_MARK, FSC),
	PINMUX_DATA(FWE_MARK, FWE),
	PINMUX_DATA(FRB_MARK, PSE3_FLCTL, FRB_VIO_CLK2),

	/* KEYSC */
	PINMUX_DATA(KEYIN0_MARK, PSA15_KEYIN0, HIZC14_IRQ6, KEYIN0_IRQ6),
	PINMUX_DATA(KEYIN1_MARK, HIZA14_KEYSC, KEYIN1),
	PINMUX_DATA(KEYIN2_MARK, HIZA14_KEYSC, KEYIN2),
	PINMUX_DATA(KEYIN3_MARK, HIZA14_KEYSC, KEYIN3),
	PINMUX_DATA(KEYIN4_MARK, PSA14_KEYIN4, HIZC15_IRQ7, KEYIN4_IRQ7),
	PINMUX_DATA(KEYOUT0_MARK, HIZA14_KEYSC, KEYOUT0),
	PINMUX_DATA(KEYOUT1_MARK, HIZA14_KEYSC, KEYOUT1),
	PINMUX_DATA(KEYOUT2_MARK, HIZA14_KEYSC, KEYOUT2),
	PINMUX_DATA(KEYOUT3_MARK, HIZA14_KEYSC, KEYOUT3),
	PINMUX_DATA(KEYOUT4_IN6_MARK, HIZA14_KEYSC, KEYOUT4_IN6),
	PINMUX_DATA(KEYOUT5_IN5_MARK, HIZA14_KEYSC, KEYOUT5_IN5),
};

static const struct sh_pfc_pin pinmux_pins[] = {
	/* PTA */
	PINMUX_GPIO(PTA7),
	PINMUX_GPIO(PTA6),
	PINMUX_GPIO(PTA5),
	PINMUX_GPIO(PTA4),
	PINMUX_GPIO(PTA3),
	PINMUX_GPIO(PTA2),
	PINMUX_GPIO(PTA1),
	PINMUX_GPIO(PTA0),

	/* PTB */
	PINMUX_GPIO(PTB7),
	PINMUX_GPIO(PTB6),
	PINMUX_GPIO(PTB5),
	PINMUX_GPIO(PTB4),
	PINMUX_GPIO(PTB3),
	PINMUX_GPIO(PTB2),
	PINMUX_GPIO(PTB1),
	PINMUX_GPIO(PTB0),

	/* PTC */
	PINMUX_GPIO(PTC7),
	PINMUX_GPIO(PTC5),
	PINMUX_GPIO(PTC4),
	PINMUX_GPIO(PTC3),
	PINMUX_GPIO(PTC2),
	PINMUX_GPIO(PTC0),

	/* PTD */
	PINMUX_GPIO(PTD7),
	PINMUX_GPIO(PTD6),
	PINMUX_GPIO(PTD5),
	PINMUX_GPIO(PTD4),
	PINMUX_GPIO(PTD3),
	PINMUX_GPIO(PTD2),
	PINMUX_GPIO(PTD1),
	PINMUX_GPIO(PTD0),

	/* PTE */
	PINMUX_GPIO(PTE7),
	PINMUX_GPIO(PTE6),
	PINMUX_GPIO(PTE5),
	PINMUX_GPIO(PTE4),
	PINMUX_GPIO(PTE1),
	PINMUX_GPIO(PTE0),

	/* PTF */
	PINMUX_GPIO(PTF6),
	PINMUX_GPIO(PTF5),
	PINMUX_GPIO(PTF4),
	PINMUX_GPIO(PTF3),
	PINMUX_GPIO(PTF2),
	PINMUX_GPIO(PTF1),
	PINMUX_GPIO(PTF0),

	/* PTG */
	PINMUX_GPIO(PTG4),
	PINMUX_GPIO(PTG3),
	PINMUX_GPIO(PTG2),
	PINMUX_GPIO(PTG1),
	PINMUX_GPIO(PTG0),

	/* PTH */
	PINMUX_GPIO(PTH7),
	PINMUX_GPIO(PTH6),
	PINMUX_GPIO(PTH5),
	PINMUX_GPIO(PTH4),
	PINMUX_GPIO(PTH3),
	PINMUX_GPIO(PTH2),
	PINMUX_GPIO(PTH1),
	PINMUX_GPIO(PTH0),

	/* PTJ */
	PINMUX_GPIO(PTJ7),
	PINMUX_GPIO(PTJ6),
	PINMUX_GPIO(PTJ5),
	PINMUX_GPIO(PTJ1),
	PINMUX_GPIO(PTJ0),

	/* PTK */
	PINMUX_GPIO(PTK6),
	PINMUX_GPIO(PTK5),
	PINMUX_GPIO(PTK4),
	PINMUX_GPIO(PTK3),
	PINMUX_GPIO(PTK2),
	PINMUX_GPIO(PTK1),
	PINMUX_GPIO(PTK0),

	/* PTL */
	PINMUX_GPIO(PTL7),
	PINMUX_GPIO(PTL6),
	PINMUX_GPIO(PTL5),
	PINMUX_GPIO(PTL4),
	PINMUX_GPIO(PTL3),
	PINMUX_GPIO(PTL2),
	PINMUX_GPIO(PTL1),
	PINMUX_GPIO(PTL0),

	/* PTM */
	PINMUX_GPIO(PTM7),
	PINMUX_GPIO(PTM6),
	PINMUX_GPIO(PTM5),
	PINMUX_GPIO(PTM4),
	PINMUX_GPIO(PTM3),
	PINMUX_GPIO(PTM2),
	PINMUX_GPIO(PTM1),
	PINMUX_GPIO(PTM0),

	/* PTN */
	PINMUX_GPIO(PTN7),
	PINMUX_GPIO(PTN6),
	PINMUX_GPIO(PTN5),
	PINMUX_GPIO(PTN4),
	PINMUX_GPIO(PTN3),
	PINMUX_GPIO(PTN2),
	PINMUX_GPIO(PTN1),
	PINMUX_GPIO(PTN0),

	/* PTQ */
	PINMUX_GPIO(PTQ6),
	PINMUX_GPIO(PTQ5),
	PINMUX_GPIO(PTQ4),
	PINMUX_GPIO(PTQ3),
	PINMUX_GPIO(PTQ2),
	PINMUX_GPIO(PTQ1),
	PINMUX_GPIO(PTQ0),

	/* PTR */
	PINMUX_GPIO(PTR4),
	PINMUX_GPIO(PTR3),
	PINMUX_GPIO(PTR2),
	PINMUX_GPIO(PTR1),
	PINMUX_GPIO(PTR0),

	/* PTS */
	PINMUX_GPIO(PTS4),
	PINMUX_GPIO(PTS3),
	PINMUX_GPIO(PTS2),
	PINMUX_GPIO(PTS1),
	PINMUX_GPIO(PTS0),

	/* PTT */
	PINMUX_GPIO(PTT4),
	PINMUX_GPIO(PTT3),
	PINMUX_GPIO(PTT2),
	PINMUX_GPIO(PTT1),
	PINMUX_GPIO(PTT0),

	/* PTU */
	PINMUX_GPIO(PTU4),
	PINMUX_GPIO(PTU3),
	PINMUX_GPIO(PTU2),
	PINMUX_GPIO(PTU1),
	PINMUX_GPIO(PTU0),

	/* PTV */
	PINMUX_GPIO(PTV4),
	PINMUX_GPIO(PTV3),
	PINMUX_GPIO(PTV2),
	PINMUX_GPIO(PTV1),
	PINMUX_GPIO(PTV0),

	/* PTW */
	PINMUX_GPIO(PTW6),
	PINMUX_GPIO(PTW5),
	PINMUX_GPIO(PTW4),
	PINMUX_GPIO(PTW3),
	PINMUX_GPIO(PTW2),
	PINMUX_GPIO(PTW1),
	PINMUX_GPIO(PTW0),

	/* PTX */
	PINMUX_GPIO(PTX6),
	PINMUX_GPIO(PTX5),
	PINMUX_GPIO(PTX4),
	PINMUX_GPIO(PTX3),
	PINMUX_GPIO(PTX2),
	PINMUX_GPIO(PTX1),
	PINMUX_GPIO(PTX0),

	/* PTY */
	PINMUX_GPIO(PTY5),
	PINMUX_GPIO(PTY4),
	PINMUX_GPIO(PTY3),
	PINMUX_GPIO(PTY2),
	PINMUX_GPIO(PTY1),
	PINMUX_GPIO(PTY0),

	/* PTZ */
	PINMUX_GPIO(PTZ5),
	PINMUX_GPIO(PTZ4),
	PINMUX_GPIO(PTZ3),
	PINMUX_GPIO(PTZ2),
	PINMUX_GPIO(PTZ1),
};

#define PINMUX_FN_BASE	ARRAY_SIZE(pinmux_pins)

static const struct pinmux_func pinmux_func_gpios[] = {
	/* SCIF0 */
	GPIO_FN(SCIF0_TXD),
	GPIO_FN(SCIF0_RXD),
	GPIO_FN(SCIF0_RTS),
	GPIO_FN(SCIF0_CTS),
	GPIO_FN(SCIF0_SCK),

	/* SCIF1 */
	GPIO_FN(SCIF1_TXD),
	GPIO_FN(SCIF1_RXD),
	GPIO_FN(SCIF1_RTS),
	GPIO_FN(SCIF1_CTS),
	GPIO_FN(SCIF1_SCK),

	/* SCIF2 */
	GPIO_FN(SCIF2_TXD),
	GPIO_FN(SCIF2_RXD),
	GPIO_FN(SCIF2_RTS),
	GPIO_FN(SCIF2_CTS),
	GPIO_FN(SCIF2_SCK),

	/* SIO */
	GPIO_FN(SIOTXD),
	GPIO_FN(SIORXD),
	GPIO_FN(SIOD),
	GPIO_FN(SIOSTRB0),
	GPIO_FN(SIOSTRB1),
	GPIO_FN(SIOSCK),
	GPIO_FN(SIOMCK),

	/* CEU */
	GPIO_FN(VIO_D15),
	GPIO_FN(VIO_D14),
	GPIO_FN(VIO_D13),
	GPIO_FN(VIO_D12),
	GPIO_FN(VIO_D11),
	GPIO_FN(VIO_D10),
	GPIO_FN(VIO_D9),
	GPIO_FN(VIO_D8),
	GPIO_FN(VIO_D7),
	GPIO_FN(VIO_D6),
	GPIO_FN(VIO_D5),
	GPIO_FN(VIO_D4),
	GPIO_FN(VIO_D3),
	GPIO_FN(VIO_D2),
	GPIO_FN(VIO_D1),
	GPIO_FN(VIO_D0),
	GPIO_FN(VIO_CLK),
	GPIO_FN(VIO_VD),
	GPIO_FN(VIO_HD),
	GPIO_FN(VIO_FLD),
	GPIO_FN(VIO_CKO),
	GPIO_FN(VIO_STEX),
	GPIO_FN(VIO_STEM),
	GPIO_FN(VIO_VD2),
	GPIO_FN(VIO_HD2),
	GPIO_FN(VIO_CLK2),

	/* LCDC */
	GPIO_FN(LCDD23),
	GPIO_FN(LCDD22),
	GPIO_FN(LCDD21),
	GPIO_FN(LCDD20),
	GPIO_FN(LCDD19),
	GPIO_FN(LCDD18),
	GPIO_FN(LCDD17),
	GPIO_FN(LCDD16),
	GPIO_FN(LCDD15),
	GPIO_FN(LCDD14),
	GPIO_FN(LCDD13),
	GPIO_FN(LCDD12),
	GPIO_FN(LCDD11),
	GPIO_FN(LCDD10),
	GPIO_FN(LCDD9),
	GPIO_FN(LCDD8),
	GPIO_FN(LCDD7),
	GPIO_FN(LCDD6),
	GPIO_FN(LCDD5),
	GPIO_FN(LCDD4),
	GPIO_FN(LCDD3),
	GPIO_FN(LCDD2),
	GPIO_FN(LCDD1),
	GPIO_FN(LCDD0),
	GPIO_FN(LCDLCLK),
	/* Main LCD */
	GPIO_FN(LCDDON),
	GPIO_FN(LCDVCPWC),
	GPIO_FN(LCDVEPWC),
	GPIO_FN(LCDVSYN),
	/* Main LCD - RGB Mode */
	GPIO_FN(LCDDCK),
	GPIO_FN(LCDHSYN),
	GPIO_FN(LCDDISP),
	/* Main LCD - SYS Mode */
	GPIO_FN(LCDRS),
	GPIO_FN(LCDCS),
	GPIO_FN(LCDWR),
	GPIO_FN(LCDRD),
	/* Sub LCD - SYS Mode */
	GPIO_FN(LCDDON2),
	GPIO_FN(LCDVCPWC2),
	GPIO_FN(LCDVEPWC2),
	GPIO_FN(LCDVSYN2),
	GPIO_FN(LCDCS2),

	/* BSC */
	GPIO_FN(IOIS16),
	GPIO_FN(A25),
	GPIO_FN(A24),
	GPIO_FN(A23),
	GPIO_FN(A22),
	GPIO_FN(BS),
	GPIO_FN(CS6B_CE1B),
	GPIO_FN(WAIT),
	GPIO_FN(CS6A_CE2B),

	/* SBSC */
	GPIO_FN(HPD63),
	GPIO_FN(HPD62),
	GPIO_FN(HPD61),
	GPIO_FN(HPD60),
	GPIO_FN(HPD59),
	GPIO_FN(HPD58),
	GPIO_FN(HPD57),
	GPIO_FN(HPD56),
	GPIO_FN(HPD55),
	GPIO_FN(HPD54),
	GPIO_FN(HPD53),
	GPIO_FN(HPD52),
	GPIO_FN(HPD51),
	GPIO_FN(HPD50),
	GPIO_FN(HPD49),
	GPIO_FN(HPD48),
	GPIO_FN(HPDQM7),
	GPIO_FN(HPDQM6),
	GPIO_FN(HPDQM5),
	GPIO_FN(HPDQM4),

	/* IRQ */
	GPIO_FN(IRQ0),
	GPIO_FN(IRQ1),
	GPIO_FN(IRQ2),
	GPIO_FN(IRQ3),
	GPIO_FN(IRQ4),
	GPIO_FN(IRQ5),
	GPIO_FN(IRQ6),
	GPIO_FN(IRQ7),

	/* SDHI */
	GPIO_FN(SDHICD),
	GPIO_FN(SDHIWP),
	GPIO_FN(SDHID3),
	GPIO_FN(SDHID2),
	GPIO_FN(SDHID1),
	GPIO_FN(SDHID0),
	GPIO_FN(SDHICMD),
	GPIO_FN(SDHICLK),

	/* SIU - Port A */
	GPIO_FN(SIUAOLR),
	GPIO_FN(SIUAOBT),
	GPIO_FN(SIUAISLD),
	GPIO_FN(SIUAILR),
	GPIO_FN(SIUAIBT),
	GPIO_FN(SIUAOSLD),
	GPIO_FN(SIUMCKA),
	GPIO_FN(SIUFCKA),

	/* SIU - Port B */
	GPIO_FN(SIUBOLR),
	GPIO_FN(SIUBOBT),
	GPIO_FN(SIUBISLD),
	GPIO_FN(SIUBILR),
	GPIO_FN(SIUBIBT),
	GPIO_FN(SIUBOSLD),
	GPIO_FN(SIUMCKB),
	GPIO_FN(SIUFCKB),

	/* AUD */
	GPIO_FN(AUDSYNC),
	GPIO_FN(AUDATA3),
	GPIO_FN(AUDATA2),
	GPIO_FN(AUDATA1),
	GPIO_FN(AUDATA0),

	/* DMAC */
	GPIO_FN(DACK),
	GPIO_FN(DREQ0),

	/* VOU */
	GPIO_FN(DV_CLKI),
	GPIO_FN(DV_CLK),
	GPIO_FN(DV_HSYNC),
	GPIO_FN(DV_VSYNC),
	GPIO_FN(DV_D15),
	GPIO_FN(DV_D14),
	GPIO_FN(DV_D13),
	GPIO_FN(DV_D12),
	GPIO_FN(DV_D11),
	GPIO_FN(DV_D10),
	GPIO_FN(DV_D9),
	GPIO_FN(DV_D8),
	GPIO_FN(DV_D7),
	GPIO_FN(DV_D6),
	GPIO_FN(DV_D5),
	GPIO_FN(DV_D4),
	GPIO_FN(DV_D3),
	GPIO_FN(DV_D2),
	GPIO_FN(DV_D1),
	GPIO_FN(DV_D0),

	/* CPG */
	GPIO_FN(STATUS0),
	GPIO_FN(PDSTATUS),

	/* SIOF0 */
	GPIO_FN(SIOF0_MCK),
	GPIO_FN(SIOF0_SCK),
	GPIO_FN(SIOF0_SYNC),
	GPIO_FN(SIOF0_SS1),
	GPIO_FN(SIOF0_SS2),
	GPIO_FN(SIOF0_TXD),
	GPIO_FN(SIOF0_RXD),

	/* SIOF1 */
	GPIO_FN(SIOF1_MCK),
	GPIO_FN(SIOF1_SCK),
	GPIO_FN(SIOF1_SYNC),
	GPIO_FN(SIOF1_SS1),
	GPIO_FN(SIOF1_SS2),
	GPIO_FN(SIOF1_TXD),
	GPIO_FN(SIOF1_RXD),

	/* SIM */
	GPIO_FN(SIM_D),
	GPIO_FN(SIM_CLK),
	GPIO_FN(SIM_RST),

	/* TSIF */
	GPIO_FN(TS_SDAT),
	GPIO_FN(TS_SCK),
	GPIO_FN(TS_SDEN),
	GPIO_FN(TS_SPSYNC),

	/* IRDA */
	GPIO_FN(IRDA_IN),
	GPIO_FN(IRDA_OUT),

	/* TPU */
	GPIO_FN(TPUTO),

	/* FLCTL */
	GPIO_FN(FCE),
	GPIO_FN(NAF7),
	GPIO_FN(NAF6),
	GPIO_FN(NAF5),
	GPIO_FN(NAF4),
	GPIO_FN(NAF3),
	GPIO_FN(NAF2),
	GPIO_FN(NAF1),
	GPIO_FN(NAF0),
	GPIO_FN(FCDE),
	GPIO_FN(FOE),
	GPIO_FN(FSC),
	GPIO_FN(FWE),
	GPIO_FN(FRB),

	/* KEYSC */
	GPIO_FN(KEYIN0),
	GPIO_FN(KEYIN1),
	GPIO_FN(KEYIN2),
	GPIO_FN(KEYIN3),
	GPIO_FN(KEYIN4),
	GPIO_FN(KEYOUT0),
	GPIO_FN(KEYOUT1),
	GPIO_FN(KEYOUT2),
	GPIO_FN(KEYOUT3),
	GPIO_FN(KEYOUT4_IN6),
	GPIO_FN(KEYOUT5_IN5),
};

static const struct pinmux_cfg_reg pinmux_config_regs[] = {
	{ PINMUX_CFG_REG("PACR", 0xa4050100, 16, 2, GROUP(
		VIO_D7_SCIF1_SCK, PTA7_OUT, 0, PTA7_IN,
		VIO_D6_SCIF1_RXD, 0, 0, PTA6_IN,
		VIO_D5_SCIF1_TXD, PTA5_OUT, 0, PTA5_IN,
		VIO_D4, 0, 0, PTA4_IN,
		VIO_D3, 0, 0, PTA3_IN,
		VIO_D2, 0, 0, PTA2_IN,
		VIO_D1, 0, 0, PTA1_IN,
		VIO_D0_LCDLCLK, 0, 0, PTA0_IN ))
	},
	{ PINMUX_CFG_REG("PBCR", 0xa4050102, 16, 2, GROUP(
		HPD55, PTB7_OUT, 0, PTB7_IN,
		HPD54, PTB6_OUT, 0, PTB6_IN,
		HPD53, PTB5_OUT, 0, PTB5_IN,
		HPD52, PTB4_OUT, 0, PTB4_IN,
		HPD51, PTB3_OUT, 0, PTB3_IN,
		HPD50, PTB2_OUT, 0, PTB2_IN,
		HPD49, PTB1_OUT, 0, PTB1_IN,
		HPD48, PTB0_OUT, 0, PTB0_IN ))
	},
	{ PINMUX_CFG_REG_VAR("PCCR", 0xa4050104, 16,
			     GROUP(2, -2, 2, 2, 2, 2, -2, 2),
			     GROUP(
		0, 0, 0, PTC7_IN,
		/* RESERVED [2] */
		IOIS16, 0, 0, PTC5_IN,
		HPDQM7, PTC4_OUT, 0, PTC4_IN,
		HPDQM6, PTC3_OUT, 0, PTC3_IN,
		HPDQM5, PTC2_OUT, 0, PTC2_IN,
		/* RESERVED [2] */
		HPDQM4, PTC0_OUT, 0, PTC0_IN ))
	},
	{ PINMUX_CFG_REG("PDCR", 0xa4050106, 16, 2, GROUP(
		SDHICD, 0, 0, PTD7_IN,
		SDHIWP, PTD6_OUT, 0, PTD6_IN,
		SDHID3, PTD5_OUT, 0, PTD5_IN,
		IRQ2_SDHID2, PTD4_OUT, 0, PTD4_IN,
		SDHID1, PTD3_OUT, 0, PTD3_IN,
		SDHID0, PTD2_OUT, 0, PTD2_IN,
		SDHICMD, PTD1_OUT, 0, PTD1_IN,
		SDHICLK, PTD0_OUT, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("PECR", 0xa4050108, 16,
			     GROUP(2, 2, 2, 2, -4, 2, 2),
			     GROUP(
		A25, PTE7_OUT, 0, PTE7_IN,
		A24, PTE6_OUT, 0, PTE6_IN,
		A23, PTE5_OUT, 0, PTE5_IN,
		A22, PTE4_OUT, 0, PTE4_IN,
		/* RESERVED [4] */
		IRQ5, PTE1_OUT, 0, PTE1_IN,
		IRQ4_BS, PTE0_OUT, 0, PTE0_IN ))
	},
	{ PINMUX_CFG_REG("PFCR", 0xa405010a, 16, 2, GROUP(
		0, 0, 0, 0,
		PTF6, PTF6_OUT, 0, PTF6_IN,
		SIOSCK_SIUBOBT, PTF5_OUT, 0, PTF5_IN,
		SIOSTRB1_SIUBOLR, PTF4_OUT, 0, PTF4_IN,
		SIOSTRB0_SIUBIBT, PTF3_OUT, 0, PTF3_IN,
		SIOD_SIUBILR, PTF2_OUT, 0, PTF2_IN,
		SIORXD_SIUBISLD, 0, 0, PTF1_IN,
		SIOTXD_SIUBOSLD, PTF0_OUT, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("PGCR", 0xa405010c, 16,
			     GROUP(-6, 2, 2, 2, 2, 2),
			     GROUP(
		/* RESERVED [6] */
		AUDSYNC, PTG4_OUT, 0, 0,
		AUDATA3, PTG3_OUT, 0, 0,
		AUDATA2, PTG2_OUT, 0, 0,
		AUDATA1, PTG1_OUT, 0, 0,
		AUDATA0, PTG0_OUT, 0, 0 ))
	},
	{ PINMUX_CFG_REG("PHCR", 0xa405010e, 16, 2, GROUP(
		LCDVCPWC_LCDVCPWC2, PTH7_OUT, 0, 0,
		LCDVSYN2_DACK, PTH6_OUT, 0, PTH6_IN,
		LCDVSYN, PTH5_OUT, 0, PTH5_IN,
		LCDDISP_LCDRS, PTH4_OUT, 0, 0,
		LCDHSYN_LCDCS, PTH3_OUT, 0, 0,
		LCDDON_LCDDON2, PTH2_OUT, 0, 0,
		LCDD17_DV_HSYNC, PTH1_OUT, 0, PTH1_IN,
		LCDD16_DV_VSYNC, PTH0_OUT, 0, PTH0_IN ))
	},
	{ PINMUX_CFG_REG_VAR("PJCR", 0xa4050110, 16,
			     GROUP(2, 2, 2, -6, 2, 2),
			     GROUP(
		STATUS0, PTJ7_OUT, 0, 0,
		0, PTJ6_OUT, 0, 0,
		PDSTATUS, PTJ5_OUT, 0, 0,
		/* RESERVED [6] */
		IRQ1, PTJ1_OUT, 0, PTJ1_IN,
		IRQ0, PTJ0_OUT, 0, PTJ0_IN ))
	},
	{ PINMUX_CFG_REG("PKCR", 0xa4050112, 16, 2, GROUP(
		0, 0, 0, 0,
		SIUAILR_SIOF1_SS2, PTK6_OUT, 0, PTK6_IN,
		SIUAIBT_SIOF1_SS1, PTK5_OUT, 0, PTK5_IN,
		SIUAOLR_SIOF1_SYNC, PTK4_OUT, 0, PTK4_IN,
		SIUAOBT_SIOF1_SCK, PTK3_OUT, 0, PTK3_IN,
		SIUAISLD_SIOF1_RXD, 0, 0, PTK2_IN,
		SIUAOSLD_SIOF1_TXD, PTK1_OUT, 0, 0,
		PTK0, PTK0_OUT, 0, PTK0_IN ))
	},
	{ PINMUX_CFG_REG("PLCR", 0xa4050114, 16, 2, GROUP(
		LCDD15_DV_D15, PTL7_OUT, 0, PTL7_IN,
		LCDD14_DV_D14, PTL6_OUT, 0, PTL6_IN,
		LCDD13_DV_D13, PTL5_OUT, 0, PTL5_IN,
		LCDD12_DV_D12, PTL4_OUT, 0, PTL4_IN,
		LCDD11_DV_D11, PTL3_OUT, 0, PTL3_IN,
		LCDD10_DV_D10, PTL2_OUT, 0, PTL2_IN,
		LCDD9_DV_D9, PTL1_OUT, 0, PTL1_IN,
		LCDD8_DV_D8, PTL0_OUT, 0, PTL0_IN ))
	},
	{ PINMUX_CFG_REG("PMCR", 0xa4050116, 16, 2, GROUP(
		LCDD7_DV_D7, PTM7_OUT, 0, PTM7_IN,
		LCDD6_DV_D6, PTM6_OUT, 0, PTM6_IN,
		LCDD5_DV_D5, PTM5_OUT, 0, PTM5_IN,
		LCDD4_DV_D4, PTM4_OUT, 0, PTM4_IN,
		LCDD3_DV_D3, PTM3_OUT, 0, PTM3_IN,
		LCDD2_DV_D2, PTM2_OUT, 0, PTM2_IN,
		LCDD1_DV_D1, PTM1_OUT, 0, PTM1_IN,
		LCDD0_DV_D0, PTM0_OUT, 0, PTM0_IN ))
	},
	{ PINMUX_CFG_REG("PNCR", 0xa4050118, 16, 2, GROUP(
		HPD63, PTN7_OUT, 0, PTN7_IN,
		HPD62, PTN6_OUT, 0, PTN6_IN,
		HPD61, PTN5_OUT, 0, PTN5_IN,
		HPD60, PTN4_OUT, 0, PTN4_IN,
		HPD59, PTN3_OUT, 0, PTN3_IN,
		HPD58, PTN2_OUT, 0, PTN2_IN,
		HPD57, PTN1_OUT, 0, PTN1_IN,
		HPD56, PTN0_OUT, 0, PTN0_IN ))
	},
	{ PINMUX_CFG_REG("PQCR", 0xa405011a, 16, 2, GROUP(
		0, 0, 0, 0,
		SIOF0_SS2_SIM_RST, PTQ6_OUT, 0, 0,
		SIOF0_SS1_TS_SPSYNC, PTQ5_OUT, 0, PTQ5_IN,
		SIOF0_SYNC_TS_SDEN, PTQ4_OUT, 0, PTQ4_IN,
		SIOF0_SCK_TS_SCK, PTQ3_OUT, 0, PTQ3_IN,
		PTQ2, 0, 0, PTQ2_IN,
		PTQ1, PTQ1_OUT, 0, 0,
		PTQ0, PTQ0_OUT, 0, PTQ0_IN ))
	},
	{ PINMUX_CFG_REG_VAR("PRCR", 0xa405011c, 16,
			     GROUP(-6, 2, 2, 2, 2, 2),
			     GROUP(
		/* RESERVED [6] */
		LCDRD, PTR4_OUT, 0, 0,
		CS6B_CE1B_LCDCS2, PTR3_OUT, 0, 0,
		WAIT, 0, 0, PTR2_IN,
		LCDDCK_LCDWR, PTR1_OUT, 0, 0,
		LCDVEPWC_LCDVEPWC2, PTR0_OUT, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("PSCR", 0xa405011e, 16,
			     GROUP(-6, 2, 2, 2, 2, 2),
			     GROUP(
		/* RESERVED [6] */
		SCIF0_CTS_SIUAISPD, 0, 0, PTS4_IN,
		SCIF0_RTS_SIUAOSPD, PTS3_OUT, 0, 0,
		SCIF0_SCK_TPUTO, PTS2_OUT, 0, PTS2_IN,
		SCIF0_RXD, 0, 0, PTS1_IN,
		SCIF0_TXD, PTS0_OUT, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("PTCR", 0xa4050140, 16,
			     GROUP(-6, 2, 2, 2, 2, 2),
			     GROUP(
		/* RESERVED [6] */
		FOE_VIO_VD2, PTT4_OUT, 0, PTT4_IN,
		FWE, PTT3_OUT, 0, PTT3_IN,
		FSC, PTT2_OUT, 0, PTT2_IN,
		DREQ0, 0, 0, PTT1_IN,
		FCDE, PTT0_OUT, 0, 0 ))
	},
	{ PINMUX_CFG_REG_VAR("PUCR", 0xa4050142, 16,
			     GROUP(-6, 2, 2, 2, 2, 2),
			     GROUP(
		/* RESERVED [6] */
		NAF2_VIO_D10, PTU4_OUT, 0, PTU4_IN,
		NAF1_VIO_D9, PTU3_OUT, 0, PTU3_IN,
		NAF0_VIO_D8, PTU2_OUT, 0, PTU2_IN,
		FRB_VIO_CLK2, 0, 0, PTU1_IN,
		FCE_VIO_HD2, PTU0_OUT, 0, PTU0_IN ))
	},
	{ PINMUX_CFG_REG_VAR("PVCR", 0xa4050144, 16,
			     GROUP(-6, 2, 2, 2, 2, 2),
			     GROUP(
		/* RESERVED [6] */
		NAF7_VIO_D15, PTV4_OUT, 0, PTV4_IN,
		NAF6_VIO_D14, PTV3_OUT, 0, PTV3_IN,
		NAF5_VIO_D13, PTV2_OUT, 0, PTV2_IN,
		NAF4_VIO_D12, PTV1_OUT, 0, PTV1_IN,
		NAF3_VIO_D11, PTV0_OUT, 0, PTV0_IN ))
	},
	{ PINMUX_CFG_REG("PWCR", 0xa4050146, 16, 2, GROUP(
		0, 0, 0, 0,
		VIO_FLD_SCIF2_CTS, 0, 0, PTW6_IN,
		VIO_CKO_SCIF2_RTS, PTW5_OUT, 0, 0,
		VIO_STEX_SCIF2_SCK, PTW4_OUT, 0, PTW4_IN,
		VIO_STEM_SCIF2_TXD, PTW3_OUT, 0, PTW3_IN,
		VIO_HD_SCIF2_RXD, PTW2_OUT, 0, PTW2_IN,
		VIO_VD_SCIF1_CTS, PTW1_OUT, 0, PTW1_IN,
		VIO_CLK_SCIF1_RTS, PTW0_OUT, 0, PTW0_IN ))
	},
	{ PINMUX_CFG_REG("PXCR", 0xa4050148, 16, 2, GROUP(
		0, 0, 0, 0,
		CS6A_CE2B, PTX6_OUT, 0, PTX6_IN,
		LCDD23, PTX5_OUT, 0, PTX5_IN,
		LCDD22, PTX4_OUT, 0, PTX4_IN,
		LCDD21, PTX3_OUT, 0, PTX3_IN,
		LCDD20, PTX2_OUT, 0, PTX2_IN,
		LCDD19_DV_CLKI, PTX1_OUT, 0, PTX1_IN,
		LCDD18_DV_CLK, PTX0_OUT, 0, PTX0_IN ))
	},
	{ PINMUX_CFG_REG_VAR("PYCR", 0xa405014a, 16,
			     GROUP(-4, 2, 2, 2, 2, 2, 2),
			     GROUP(
		/* RESERVED [4] */
		KEYOUT5_IN5, PTY5_OUT, 0, PTY5_IN,
		KEYOUT4_IN6, PTY4_OUT, 0, PTY4_IN,
		KEYOUT3, PTY3_OUT, 0, PTY3_IN,
		KEYOUT2, PTY2_OUT, 0, PTY2_IN,
		KEYOUT1, PTY1_OUT, 0, 0,
		KEYOUT0, PTY0_OUT, 0, PTY0_IN ))
	},
	{ PINMUX_CFG_REG_VAR("PZCR", 0xa405014c, 16,
			     GROUP(-4, 2, 2, 2, 2, 2, -2),
			     GROUP(
		/* RESERVED [4] */
		KEYIN4_IRQ7, 0, 0, PTZ5_IN,
		KEYIN3, 0, 0, PTZ4_IN,
		KEYIN2, 0, 0, PTZ3_IN,
		KEYIN1, 0, 0, PTZ2_IN,
		KEYIN0_IRQ6, 0, 0, PTZ1_IN,
		/* RESERVED [2] */ ))
	},
	{ PINMUX_CFG_REG_VAR("PSELA", 0xa405014e, 16,
			     GROUP(1, 1, -4, 1, -4, 1, -4),
			     GROUP(
		PSA15_KEYIN0, PSA15_IRQ6,
		PSA14_KEYIN4, PSA14_IRQ7,
		/* RESERVED [4] */
		PSA9_IRQ4, PSA9_BS,
		/* RESERVED [4] */
		PSA4_IRQ2, PSA4_SDHID2,
		/* RESERVED [4] */ ))
	},
	{ PINMUX_CFG_REG("PSELB", 0xa4050150, 16, 1, GROUP(
		PSB15_SIOTXD, PSB15_SIUBOSLD,
		PSB14_SIORXD, PSB14_SIUBISLD,
		PSB13_SIOD, PSB13_SIUBILR,
		PSB12_SIOSTRB0, PSB12_SIUBIBT,
		PSB11_SIOSTRB1, PSB11_SIUBOLR,
		PSB10_SIOSCK, PSB10_SIUBOBT,
		PSB9_SIOMCK, PSB9_SIUMCKB,
		PSB8_SIOF0_MCK, PSB8_IRQ3,
		PSB7_SIOF0_TXD, PSB7_IRDA_OUT,
		PSB6_SIOF0_RXD, PSB6_IRDA_IN,
		PSB5_SIOF0_SCK, PSB5_TS_SCK,
		PSB4_SIOF0_SYNC, PSB4_TS_SDEN,
		PSB3_SIOF0_SS1, PSB3_TS_SPSYNC,
		PSB2_SIOF0_SS2, PSB2_SIM_RST,
		PSB1_SIUMCKA, PSB1_SIOF1_MCK,
		PSB0_SIUAOSLD, PSB0_SIOF1_TXD ))
	},
	{ PINMUX_CFG_REG_VAR("PSELC", 0xa4050152, 16,
			     GROUP(1, 1, 1, 1, 1, -10, 1),
			     GROUP(
		PSC15_SIUAISLD, PSC15_SIOF1_RXD,
		PSC14_SIUAOBT, PSC14_SIOF1_SCK,
		PSC13_SIUAOLR, PSC13_SIOF1_SYNC,
		PSC12_SIUAIBT, PSC12_SIOF1_SS1,
		PSC11_SIUAILR, PSC11_SIOF1_SS2,
		/* RESERVED [10] */
		PSC0_NAF, PSC0_VIO ))
	},
	{ PINMUX_CFG_REG("PSELD", 0xa4050154, 16, 1, GROUP(
		0, 0,
		0, 0,
		PSD13_VIO, PSD13_SCIF2,
		PSD12_VIO, PSD12_SCIF1,
		PSD11_VIO, PSD11_SCIF1,
		PSD10_VIO_D0, PSD10_LCDLCLK,
		PSD9_SIOMCK_SIUMCKB, PSD9_SIUFCKB,
		PSD8_SCIF0_SCK, PSD8_TPUTO,
		PSD7_SCIF0_RTS, PSD7_SIUAOSPD,
		PSD6_SCIF0_CTS, PSD6_SIUAISPD,
		PSD5_CS6B_CE1B, PSD5_LCDCS2,
		0, 0,
		PSD3_LCDVEPWC_LCDVCPWC, PSD3_LCDVEPWC2_LCDVCPWC2,
		PSD2_LCDDON, PSD2_LCDDON2,
		0, 0,
		PSD0_LCDD19_LCDD0, PSD0_DV ))
	},
	{ PINMUX_CFG_REG_VAR("PSELE", 0xa4050156, 16,
			     GROUP(1, 1, 1, 1, 1, -7, 1, 1, 1, 1),
			     GROUP(
		PSE15_SIOF0_MCK_IRQ3, PSE15_SIM_D,
		PSE14_SIOF0_TXD_IRDA_OUT, PSE14_SIM_CLK,
		PSE13_SIOF0_RXD_IRDA_IN, PSE13_TS_SDAT,
		PSE12_LCDVSYN2, PSE12_DACK,
		PSE11_SIUMCKA_SIOF1_MCK, PSE11_SIUFCKA,
		/* RESERVED [7] */
		PSE3_FLCTL, PSE3_VIO,
		PSE2_NAF2, PSE2_VIO_D10,
		PSE1_NAF1, PSE1_VIO_D9,
		PSE0_NAF0, PSE0_VIO_D8 ))
	},
	{ PINMUX_CFG_REG_VAR("HIZCRA", 0xa4050158, 16,
			     GROUP(-1, 1, -3, 1, 1, 1, 1, 1, -6),
			     GROUP(
		/* RESERVED [1] */
		HIZA14_KEYSC, HIZA14_HIZ,
		/* RESERVED [3] */
		HIZA10_NAF, HIZA10_HIZ,
		HIZA9_VIO, HIZA9_HIZ,
		HIZA8_LCDC, HIZA8_HIZ,
		HIZA7_LCDC, HIZA7_HIZ,
		HIZA6_LCDC, HIZA6_HIZ,
		/* RESERVED [6] */ ))
	},
	{ PINMUX_CFG_REG_VAR("HIZCRB", 0xa405015a, 16,
			     GROUP(-11, 1, -2, 1, 1),
			     GROUP(
		/* RESERVED [11] */
		HIZB4_SIUA, HIZB4_HIZ,
		/* RESERVED [2] */
		HIZB1_VIO, HIZB1_HIZ,
		HIZB0_VIO, HIZB0_HIZ ))
	},
	{ PINMUX_CFG_REG_VAR("HIZCRC", 0xa405015c, 16,
			     GROUP(1, 1, 1, 1, 1, 1, 1, 1, -8),
			     GROUP(
		HIZC15_IRQ7, HIZC15_HIZ,
		HIZC14_IRQ6, HIZC14_HIZ,
		HIZC13_IRQ5, HIZC13_HIZ,
		HIZC12_IRQ4, HIZC12_HIZ,
		HIZC11_IRQ3, HIZC11_HIZ,
		HIZC10_IRQ2, HIZC10_HIZ,
		HIZC9_IRQ1, HIZC9_HIZ,
		HIZC8_IRQ0, HIZC8_HIZ,
		/* RESERVED [8] */ ))
	},
	{ PINMUX_CFG_REG_VAR("MSELCRB", 0xa4050182, 16,
			     GROUP(-6, 1, 1, -8),
			     GROUP(
		/* RESERVED [6] */
		MSELB9_VIO, MSELB9_VIO2,
		MSELB8_RGB, MSELB8_SYS,
		/* RESERVED [8] */ ))
	},
	{ /* sentinel */ }
};

static const struct pinmux_data_reg pinmux_data_regs[] = {
	{ PINMUX_DATA_REG("PADR", 0xa4050120, 8, GROUP(
		PTA7_DATA, PTA6_DATA, PTA5_DATA, PTA4_DATA,
		PTA3_DATA, PTA2_DATA, PTA1_DATA, PTA0_DATA ))
	},
	{ PINMUX_DATA_REG("PBDR", 0xa4050122, 8, GROUP(
		PTB7_DATA, PTB6_DATA, PTB5_DATA, PTB4_DATA,
		PTB3_DATA, PTB2_DATA, PTB1_DATA, PTB0_DATA ))
	},
	{ PINMUX_DATA_REG("PCDR", 0xa4050124, 8, GROUP(
		PTC7_DATA, 0, PTC5_DATA, PTC4_DATA,
		PTC3_DATA, PTC2_DATA, 0, PTC0_DATA ))
	},
	{ PINMUX_DATA_REG("PDDR", 0xa4050126, 8, GROUP(
		PTD7_DATA, PTD6_DATA, PTD5_DATA, PTD4_DATA,
		PTD3_DATA, PTD2_DATA, PTD1_DATA, PTD0_DATA ))
	},
	{ PINMUX_DATA_REG("PEDR", 0xa4050128, 8, GROUP(
		PTE7_DATA, PTE6_DATA, PTE5_DATA, PTE4_DATA,
		0, 0, PTE1_DATA, PTE0_DATA ))
	},
	{ PINMUX_DATA_REG("PFDR", 0xa405012a, 8, GROUP(
		0, PTF6_DATA, PTF5_DATA, PTF4_DATA,
		PTF3_DATA, PTF2_DATA, PTF1_DATA, PTF0_DATA ))
	},
	{ PINMUX_DATA_REG("PGDR", 0xa405012c, 8, GROUP(
		0, 0, 0, PTG4_DATA,
		PTG3_DATA, PTG2_DATA, PTG1_DATA, PTG0_DATA ))
	},
	{ PINMUX_DATA_REG("PHDR", 0xa405012e, 8, GROUP(
		PTH7_DATA, PTH6_DATA, PTH5_DATA, PTH4_DATA,
		PTH3_DATA, PTH2_DATA, PTH1_DATA, PTH0_DATA ))
	},
	{ PINMUX_DATA_REG("PJDR", 0xa4050130, 8, GROUP(
		PTJ7_DATA, PTJ6_DATA, PTJ5_DATA, 0,
		0, 0, PTJ1_DATA, PTJ0_DATA ))
	},
	{ PINMUX_DATA_REG("PKDR", 0xa4050132, 8, GROUP(
		0, PTK6_DATA, PTK5_DATA, PTK4_DATA,
		PTK3_DATA, PTK2_DATA, PTK1_DATA, PTK0_DATA ))
	},
	{ PINMUX_DATA_REG("PLDR", 0xa4050134, 8, GROUP(
		PTL7_DATA, PTL6_DATA, PTL5_DATA, PTL4_DATA,
		PTL3_DATA, PTL2_DATA, PTL1_DATA, PTL0_DATA ))
	},
	{ PINMUX_DATA_REG("PMDR", 0xa4050136, 8, GROUP(
		PTM7_DATA, PTM6_DATA, PTM5_DATA, PTM4_DATA,
		PTM3_DATA, PTM2_DATA, PTM1_DATA, PTM0_DATA ))
	},
	{ PINMUX_DATA_REG("PNDR", 0xa4050138, 8, GROUP(
		PTN7_DATA, PTN6_DATA, PTN5_DATA, PTN4_DATA,
		PTN3_DATA, PTN2_DATA, PTN1_DATA, PTN0_DATA ))
	},
	{ PINMUX_DATA_REG("PQDR", 0xa405013a, 8, GROUP(
		0, PTQ6_DATA, PTQ5_DATA, PTQ4_DATA,
		PTQ3_DATA, PTQ2_DATA, PTQ1_DATA, PTQ0_DATA ))
	},
	{ PINMUX_DATA_REG("PRDR", 0xa405013c, 8, GROUP(
		0, 0, 0, PTR4_DATA,
		PTR3_DATA, PTR2_DATA, PTR1_DATA, PTR0_DATA ))
	},
	{ PINMUX_DATA_REG("PSDR", 0xa405013e, 8, GROUP(
		0, 0, 0, PTS4_DATA,
		PTS3_DATA, PTS2_DATA, PTS1_DATA, PTS0_DATA ))
	},
	{ PINMUX_DATA_REG("PTDR", 0xa4050160, 8, GROUP(
		0, 0, 0, PTT4_DATA,
		PTT3_DATA, PTT2_DATA, PTT1_DATA, PTT0_DATA ))
	},
	{ PINMUX_DATA_REG("PUDR", 0xa4050162, 8, GROUP(
		0, 0, 0, PTU4_DATA,
		PTU3_DATA, PTU2_DATA, PTU1_DATA, PTU0_DATA ))
	},
	{ PINMUX_DATA_REG("PVDR", 0xa4050164, 8, GROUP(
		0, 0, 0, PTV4_DATA,
		PTV3_DATA, PTV2_DATA, PTV1_DATA, PTV0_DATA ))
	},
	{ PINMUX_DATA_REG("PWDR", 0xa4050166, 8, GROUP(
		0, PTW6_DATA, PTW5_DATA, PTW4_DATA,
		PTW3_DATA, PTW2_DATA, PTW1_DATA, PTW0_DATA ))
	},
	{ PINMUX_DATA_REG("PXDR", 0xa4050168, 8, GROUP(
		0, PTX6_DATA, PTX5_DATA, PTX4_DATA,
		PTX3_DATA, PTX2_DATA, PTX1_DATA, PTX0_DATA ))
	},
	{ PINMUX_DATA_REG("PYDR", 0xa405016a, 8, GROUP(
		0, PTY6_DATA, PTY5_DATA, PTY4_DATA,
		PTY3_DATA, PTY2_DATA, PTY1_DATA, PTY0_DATA ))
	},
	{ PINMUX_DATA_REG("PZDR", 0xa405016c, 8, GROUP(
		0, 0, PTZ5_DATA, PTZ4_DATA,
		PTZ3_DATA, PTZ2_DATA, PTZ1_DATA, PTZ0_DATA ))
	},
	{ /* sentinel */ }
};

const struct sh_pfc_soc_info sh7722_pinmux_info = {
	.name = "sh7722_pfc",
	.input = { PINMUX_INPUT_BEGIN, PINMUX_INPUT_END },
	.output = { PINMUX_OUTPUT_BEGIN, PINMUX_OUTPUT_END },
	.function = { PINMUX_FUNCTION_BEGIN, PINMUX_FUNCTION_END },

	.pins = pinmux_pins,
	.nr_pins = ARRAY_SIZE(pinmux_pins),
	.func_gpios = pinmux_func_gpios,
	.nr_func_gpios = ARRAY_SIZE(pinmux_func_gpios),

	.cfg_regs = pinmux_config_regs,
	.data_regs = pinmux_data_regs,

	.pinmux_data = pinmux_data,
	.pinmux_data_size = ARRAY_SIZE(pinmux_data),
};
