// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file XtypesTestsType1.hpp
 * This header file contains the declaration of the described types in the IDL file.
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#ifndef FAST_DDS_GENERATED__XTYPESTESTSTYPE1_HPP
#define FAST_DDS_GENERATED__XTYPESTESTSTYPE1_HPP

#include <cstdint>
#include <string>
#include <utility>
#include <fastcdr/cdr/fixed_size_string.hpp>

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#define eProsima_user_DllExport __declspec( dllexport )
#else
#define eProsima_user_DllExport
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define eProsima_user_DllExport
#endif  // _WIN32

#if defined(_WIN32)
#if defined(EPROSIMA_USER_DLL_EXPORT)
#if defined(XTYPESTESTSTYPE1_SOURCE)
#define XTYPESTESTSTYPE1_DllAPI __declspec( dllexport )
#else
#define XTYPESTESTSTYPE1_DllAPI __declspec( dllimport )
#endif // XTYPESTESTSTYPE1_SOURCE
#else
#define XTYPESTESTSTYPE1_DllAPI
#endif  // EPROSIMA_USER_DLL_EXPORT
#else
#define XTYPESTESTSTYPE1_DllAPI
#endif // _WIN32

/*!
 * @brief This class represents the structure Type1 defined by the user in the IDL file.
 * @ingroup XtypesTestsType1
 */
class Type1
{
public:

    /*!
     * @brief Default constructor.
     */
    eProsima_user_DllExport Type1()
    {
    }

    /*!
     * @brief Default destructor.
     */
    eProsima_user_DllExport ~Type1()
    {
    }

    /*!
     * @brief Copy constructor.
     * @param x Reference to the object Type1 that will be copied.
     */
    eProsima_user_DllExport Type1(
            const Type1& x)
    {
                    m_content = x.m_content;

    }

    /*!
     * @brief Move constructor.
     * @param x Reference to the object Type1 that will be copied.
     */
    eProsima_user_DllExport Type1(
            Type1&& x) noexcept
    {
        m_content = std::move(x.m_content);
    }

    /*!
     * @brief Copy assignment.
     * @param x Reference to the object Type1 that will be copied.
     */
    eProsima_user_DllExport Type1& operator =(
            const Type1& x)
    {

                    m_content = x.m_content;

        return *this;
    }

    /*!
     * @brief Move assignment.
     * @param x Reference to the object Type1 that will be copied.
     */
    eProsima_user_DllExport Type1& operator =(
            Type1&& x) noexcept
    {

        m_content = std::move(x.m_content);
        return *this;
    }

    /*!
     * @brief Comparison operator.
     * @param x Type1 object to compare.
     */
    eProsima_user_DllExport bool operator ==(
            const Type1& x) const
    {
        return (m_content == x.m_content);
    }

    /*!
     * @brief Comparison operator.
     * @param x Type1 object to compare.
     */
    eProsima_user_DllExport bool operator !=(
            const Type1& x) const
    {
        return !(*this == x);
    }

    /*!
     * @brief This function copies the value in member content
     * @param _content New value to be copied in member content
     */
    eProsima_user_DllExport void content(
            const std::string& _content)
    {
        m_content = _content;
    }

    /*!
     * @brief This function moves the value in member content
     * @param _content New value to be moved in member content
     */
    eProsima_user_DllExport void content(
            std::string&& _content)
    {
        m_content = std::move(_content);
    }

    /*!
     * @brief This function returns a constant reference to member content
     * @return Constant reference to member content
     */
    eProsima_user_DllExport const std::string& content() const
    {
        return m_content;
    }

    /*!
     * @brief This function returns a reference to member content
     * @return Reference to member content
     */
    eProsima_user_DllExport std::string& content()
    {
        return m_content;
    }



private:

    std::string m_content;

};

#endif // _FAST_DDS_GENERATED_XTYPESTESTSTYPE1_HPP_


