/*
 * Copyright (C) 2023, KylinSoft Co., Ltd.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see <http://www.gnu.org/licenses/>.
 *
**/
#ifndef BRIGHTNESSFRAME_H
#define BRIGHTNESSFRAME_H

#include <QFrame>
#include <QLabel>
#include <QWidget>
#include <QLabel>
#include "uslider.h"
#include <QMutex>
#include <QFuture>
#include "fixlabel.h"
#include "getBrightnessThread.h"
#include "ukccframe.h"
#include "lightlabel.h"
#include <kslider.h>
using namespace kdk;

class BrightnessFrame : public UkccFrame
{
    Q_OBJECT
public:
    BrightnessFrame(const QString &name, const bool &isBattery, const QString &edidHash = "", QWidget *parent = nullptr);
    ~BrightnessFrame();
    void setTextLabelName(QString text);
    void setTextLabelValue(QString text);
    void setOutputEnable(const bool &enable);
    bool getOutputEnable();
    void runConnectThread(const bool &openFlag);
    bool getSliderEnable();
    void setSliderEnable(const bool &enable);
    void setDDCBrightness(const int &value);
    void updateEdidHash(const QString &edid);
    QString getEdidHash();
    QString getOutputName();
    void setI2cbus(QString busNum);

Q_SIGNALS:
    void sliderEnableChanged();

private:
    FixLabel *labelName = nullptr;
    QLabel *labelValue = nullptr;
    KSlider *slider = nullptr;
    QString outputName;          //屏幕名
    bool    outputEnable;     //该屏幕是否打开
    bool    connectFlag;  //该屏幕是否连接
    QString edidHash;
    QMutex      mLock;
    bool exitFlag;
    bool isBattery;
    LightLabel *labelMsg = nullptr;
    QString i2cBus;
    GetBrightnessThread *mGetBrightnessThread;
};

#endif // BRIGHTNESSFRAME_H
