# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from copy import deepcopy
from typing import Any, Awaitable, Optional, TYPE_CHECKING, cast
from typing_extensions import Self

from azure.core.pipeline import policies
from azure.core.rest import AsyncHttpResponse, HttpRequest
from azure.core.settings import settings
from azure.mgmt.core import AsyncARMPipelineClient
from azure.mgmt.core.policies import AsyncARMAutoResourceProviderRegistrationPolicy
from azure.mgmt.core.tools import get_arm_endpoints

from .._utils.serialization import Deserializer, Serializer
from ._configuration import AVSClientConfiguration
from .operations import (
    AddonsOperations,
    AuthorizationsOperations,
    CloudLinksOperations,
    ClustersOperations,
    DatastoresOperations,
    GlobalReachConnectionsOperations,
    HcxEnterpriseSitesOperations,
    HostsOperations,
    IscsiPathsOperations,
    LicensesOperations,
    LocationsOperations,
    MaintenancesOperations,
    Operations,
    PlacementPoliciesOperations,
    PrivateCloudsOperations,
    ProvisionedNetworksOperations,
    PureStoragePoliciesOperations,
    ScriptCmdletsOperations,
    ScriptExecutionsOperations,
    ScriptPackagesOperations,
    SkusOperations,
    VirtualMachinesOperations,
    WorkloadNetworksOperations,
)

if TYPE_CHECKING:
    from azure.core import AzureClouds
    from azure.core.credentials_async import AsyncTokenCredential


class AVSClient:  # pylint: disable=too-many-instance-attributes
    """Azure VMware Solution API.

    :ivar operations: Operations operations
    :vartype operations: azure.mgmt.avs.aio.operations.Operations
    :ivar addons: AddonsOperations operations
    :vartype addons: azure.mgmt.avs.aio.operations.AddonsOperations
    :ivar authorizations: AuthorizationsOperations operations
    :vartype authorizations: azure.mgmt.avs.aio.operations.AuthorizationsOperations
    :ivar cloud_links: CloudLinksOperations operations
    :vartype cloud_links: azure.mgmt.avs.aio.operations.CloudLinksOperations
    :ivar clusters: ClustersOperations operations
    :vartype clusters: azure.mgmt.avs.aio.operations.ClustersOperations
    :ivar datastores: DatastoresOperations operations
    :vartype datastores: azure.mgmt.avs.aio.operations.DatastoresOperations
    :ivar global_reach_connections: GlobalReachConnectionsOperations operations
    :vartype global_reach_connections:
     azure.mgmt.avs.aio.operations.GlobalReachConnectionsOperations
    :ivar hcx_enterprise_sites: HcxEnterpriseSitesOperations operations
    :vartype hcx_enterprise_sites: azure.mgmt.avs.aio.operations.HcxEnterpriseSitesOperations
    :ivar hosts: HostsOperations operations
    :vartype hosts: azure.mgmt.avs.aio.operations.HostsOperations
    :ivar iscsi_paths: IscsiPathsOperations operations
    :vartype iscsi_paths: azure.mgmt.avs.aio.operations.IscsiPathsOperations
    :ivar licenses: LicensesOperations operations
    :vartype licenses: azure.mgmt.avs.aio.operations.LicensesOperations
    :ivar locations: LocationsOperations operations
    :vartype locations: azure.mgmt.avs.aio.operations.LocationsOperations
    :ivar maintenances: MaintenancesOperations operations
    :vartype maintenances: azure.mgmt.avs.aio.operations.MaintenancesOperations
    :ivar placement_policies: PlacementPoliciesOperations operations
    :vartype placement_policies: azure.mgmt.avs.aio.operations.PlacementPoliciesOperations
    :ivar private_clouds: PrivateCloudsOperations operations
    :vartype private_clouds: azure.mgmt.avs.aio.operations.PrivateCloudsOperations
    :ivar provisioned_networks: ProvisionedNetworksOperations operations
    :vartype provisioned_networks: azure.mgmt.avs.aio.operations.ProvisionedNetworksOperations
    :ivar pure_storage_policies: PureStoragePoliciesOperations operations
    :vartype pure_storage_policies: azure.mgmt.avs.aio.operations.PureStoragePoliciesOperations
    :ivar script_cmdlets: ScriptCmdletsOperations operations
    :vartype script_cmdlets: azure.mgmt.avs.aio.operations.ScriptCmdletsOperations
    :ivar script_executions: ScriptExecutionsOperations operations
    :vartype script_executions: azure.mgmt.avs.aio.operations.ScriptExecutionsOperations
    :ivar script_packages: ScriptPackagesOperations operations
    :vartype script_packages: azure.mgmt.avs.aio.operations.ScriptPackagesOperations
    :ivar skus: SkusOperations operations
    :vartype skus: azure.mgmt.avs.aio.operations.SkusOperations
    :ivar virtual_machines: VirtualMachinesOperations operations
    :vartype virtual_machines: azure.mgmt.avs.aio.operations.VirtualMachinesOperations
    :ivar workload_networks: WorkloadNetworksOperations operations
    :vartype workload_networks: azure.mgmt.avs.aio.operations.WorkloadNetworksOperations
    :param credential: Credential used to authenticate requests to the service. Required.
    :type credential: ~azure.core.credentials_async.AsyncTokenCredential
    :param subscription_id: The ID of the target subscription. The value must be an UUID. Required.
    :type subscription_id: str
    :param base_url: Service host. Default value is None.
    :type base_url: str
    :keyword cloud_setting: The cloud setting for which to get the ARM endpoint. Default value is
     None.
    :paramtype cloud_setting: ~azure.core.AzureClouds
    :keyword api_version: The API version to use for this operation. Default value is "2025-09-01".
     Note that overriding this default value may result in unsupported behavior.
    :paramtype api_version: str
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no
     Retry-After header is present.
    """

    def __init__(
        self,
        credential: "AsyncTokenCredential",
        subscription_id: str,
        base_url: Optional[str] = None,
        *,
        cloud_setting: Optional["AzureClouds"] = None,
        **kwargs: Any
    ) -> None:
        _endpoint = "{endpoint}"
        _cloud = cloud_setting or settings.current.azure_cloud  # type: ignore
        _endpoints = get_arm_endpoints(_cloud)
        if not base_url:
            base_url = _endpoints["resource_manager"]
        credential_scopes = kwargs.pop("credential_scopes", _endpoints["credential_scopes"])
        self._config = AVSClientConfiguration(
            credential=credential,
            subscription_id=subscription_id,
            base_url=cast(str, base_url),
            cloud_setting=cloud_setting,
            credential_scopes=credential_scopes,
            **kwargs
        )

        _policies = kwargs.pop("policies", None)
        if _policies is None:
            _policies = [
                policies.RequestIdPolicy(**kwargs),
                self._config.headers_policy,
                self._config.user_agent_policy,
                self._config.proxy_policy,
                policies.ContentDecodePolicy(**kwargs),
                AsyncARMAutoResourceProviderRegistrationPolicy(),
                self._config.redirect_policy,
                self._config.retry_policy,
                self._config.authentication_policy,
                self._config.custom_hook_policy,
                self._config.logging_policy,
                policies.DistributedTracingPolicy(**kwargs),
                policies.SensitiveHeaderCleanupPolicy(**kwargs) if self._config.redirect_policy else None,
                self._config.http_logging_policy,
            ]
        self._client: AsyncARMPipelineClient = AsyncARMPipelineClient(
            base_url=cast(str, _endpoint), policies=_policies, **kwargs
        )

        self._serialize = Serializer()
        self._deserialize = Deserializer()
        self._serialize.client_side_validation = False
        self.operations = Operations(self._client, self._config, self._serialize, self._deserialize)
        self.addons = AddonsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.authorizations = AuthorizationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.cloud_links = CloudLinksOperations(self._client, self._config, self._serialize, self._deserialize)
        self.clusters = ClustersOperations(self._client, self._config, self._serialize, self._deserialize)
        self.datastores = DatastoresOperations(self._client, self._config, self._serialize, self._deserialize)
        self.global_reach_connections = GlobalReachConnectionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.hcx_enterprise_sites = HcxEnterpriseSitesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.hosts = HostsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.iscsi_paths = IscsiPathsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.licenses = LicensesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.locations = LocationsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.maintenances = MaintenancesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.placement_policies = PlacementPoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.private_clouds = PrivateCloudsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.provisioned_networks = ProvisionedNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.pure_storage_policies = PureStoragePoliciesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.script_cmdlets = ScriptCmdletsOperations(self._client, self._config, self._serialize, self._deserialize)
        self.script_executions = ScriptExecutionsOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.script_packages = ScriptPackagesOperations(self._client, self._config, self._serialize, self._deserialize)
        self.skus = SkusOperations(self._client, self._config, self._serialize, self._deserialize)
        self.virtual_machines = VirtualMachinesOperations(
            self._client, self._config, self._serialize, self._deserialize
        )
        self.workload_networks = WorkloadNetworksOperations(
            self._client, self._config, self._serialize, self._deserialize
        )

    def send_request(
        self, request: HttpRequest, *, stream: bool = False, **kwargs: Any
    ) -> Awaitable[AsyncHttpResponse]:
        """Runs the network request through the client's chained policies.

        >>> from azure.core.rest import HttpRequest
        >>> request = HttpRequest("GET", "https://www.example.org/")
        <HttpRequest [GET], url: 'https://www.example.org/'>
        >>> response = await client.send_request(request)
        <AsyncHttpResponse: 200 OK>

        For more information on this code flow, see https://aka.ms/azsdk/dpcodegen/python/send_request

        :param request: The network request you want to make. Required.
        :type request: ~azure.core.rest.HttpRequest
        :keyword bool stream: Whether the response payload will be streamed. Defaults to False.
        :return: The response of your network call. Does not do error handling on your response.
        :rtype: ~azure.core.rest.AsyncHttpResponse
        """

        request_copy = deepcopy(request)
        path_format_arguments = {
            "endpoint": self._serialize.url("self._config.base_url", self._config.base_url, "str", skip_quote=True),
        }

        request_copy.url = self._client.format_url(request_copy.url, **path_format_arguments)
        return self._client.send_request(request_copy, stream=stream, **kwargs)  # type: ignore

    async def close(self) -> None:
        await self._client.close()

    async def __aenter__(self) -> Self:
        await self._client.__aenter__()
        return self

    async def __aexit__(self, *exc_details: Any) -> None:
        await self._client.__aexit__(*exc_details)
