# KiCad 3D Models
This repository contains 3D models for rendering and MCAD integration, for use with [KiCAD EDA](http://kicad.org/) software.
The model needs a mechanical model source (a manually-modelled or script-generated file); its WRL counterpart file must be obtained as a conversion from the MCAD model

## Supported File Formats
The 3D model library supports two file formats:

### STEP
STEP files are used for integration with MCAD software packages.  
STEP models must be 1:1 in mm, better if the model is a solid single object (a union of parts) for size and loading optimization. KiCad supports STEP file integration and can export board and component models into an integrated STEP file. This file can then be imported by a MCAD package.

### WRL
WRL files must be exported from its mechanical model counterpart. WRL files are used for photo-realistic rendering using KiCad's raytracing rendering engine. This format supports more complex material properties, allowing various common component materials to be accurately rendered. 

## Source Files
Source files for generated models should be submitted to (https://gitlab.com/kicad/libraries/kicad-packages3D-source). This includes generator scripts, or native model files from source software (e.g. [FreeCAD](https://www.freecadweb.org/))

## Preferred method to create 3D models
The model has to be created in a mechanical program, able to generate STEP export. The model can be created by automatic scripts or manually.
[FreeCAD](https://www.freecadweb.org/) is the preferred software because it is open source, and anyone can rework the model for future improvements, but also other proprietary MCAD software are allowed.
In case the model is generated by scripts, the scripts should be linked to the PR stating sw and version used to run the scripts;
when the model is manually created, the MCAD source file should be added to the PR as well as STEP file.
STEP models should be 1:1 in mm, better if the model is a solid single object (a union of parts) for size and loading optimization;
text is not suggested on models because of size increasing, anyway in case of text the fonts must be licensed free as the word.
WRL models should be exported from its mechanical counterpart and, when possible, have the suggested material properties as in these documents:
* [WRL Material Properties](Vrml_materials_doc/KiCad_3D-Viewer_component-materials-reference-list_MarioLuzeiro.pdf)
* [WRL Illumination model](Vrml_materials_doc/KiCad_3D-Viewer_Illumination_model_and_materials-MarioLuzeiro.pdf)

A simple method to export a fully compliant WRL model from a mechanical STEP model is through [KiCad StepUp](https://github.com/easyw/kicadStepUpMod).
A tutorial video can be found [here](https://youtu.be/O6vr8QFnYGw)
A good starting point to learn how to create models by script is this github repo [kicad-3d-models-in-freecad](https://github.com/easyw/kicad-3d-models-in-freecad).
The scripts are made in Python and run in FreeCAD with [CadQuery module](https://github.com/jmwright/cadquery-freecad-module) add-on.

### Model Alignment
The 3D models in this library are aligned with the footprints available in the KiCad footprint libraries.

### Model Scaling
* The STEP file format includes model scaling information, and so the 3D model scaling parameter must always be set to 1:1 in mm
* The WRL file format does not specify absolute dimensions. KiCad normalizes WRL model dimension to units of *0.1 Inches*, and the internal units of the WRL files should be scaled accordingly

## Model Licencing
Refer to the LICENSE.md file

## Generating model list

For pruning models from footprints when the model doesn't exist in this library, a list of models
can be generated:

```
mkdir build
cd build
cmake ..
make list_models
```

The model list will be at `model_names.txt`

## External Model Libraries
In addition to the 3D model data provided in this library, there are other sources that designers may use to source 3D models.

* Many manufacturers provide accurate 3D models for specific components.
* Online repositories, e.g.
    * [FreeCAD Electric Library](https://github.com/FreeCAD/FreeCAD-library/tree/master/Electrical%20Parts)
    * [FreeCAD Electronic Library](https://github.com/FreeCAD/FreeCAD-library/tree/master/Electronics%20Parts)
    * [GrabCAD](https://grabcad.com/)
    * [3D ContentCentral](http://www.3dcontentcentral.com/)
    * [traceparts](http://www.traceparts.com/)

Ensure that the LICENSE of any 3D data used is compatible with the intended use-case of the project.
