// EDITED 2011/01/14 to add SDS hydrogen.

// Time 2004/01/14 12:49:37
// Time zone: ('PST', 'PDT')

// Module: cctbx.eltbx.gaussian_fit
//   size: 9773
//   MD5 hexdigest: 5365e30f327bb2fe410f60a1390ddc87

// Module: scitbx.math.gaussian_fit
//   size: 19723
//   MD5 hexdigest: 582025cc1ac5ad109ddced4e5ae7ed9a

// Parameters:
//   shift_sqrt_b_mod_n: [0, 1, 2]
//   max_max_error: 0.01
//   n_repeats_minimization: 5
//   n_start_fractions: 5
//   b_min: 1e-06
//   max_n_terms: 5
//   target_powers: [2, 4]
//   negligible_max_error: 0.001
//   minimize_using_sigmas: 0

#include <cctbx/eltbx/xray_scattering/n_gaussian_raw.h>
#include <cstring>

namespace {

#undef D
#define D static const double

D h_sds_s[] = { 6.0, 1.6317, 0.9447, 0.9447, 0.4723, 0.1718 };
D h_sds_e[] = {
0.00163423683277,
0.00549200241595,
0.00787166490151,
0.00977572348627,
0.00720243683578,
0.00967491465765
};
D h_sds_6[] = {
-1.09389877635, 1.7298482421,
0.767521006066, 2.01966794458,
0.442917711399, 1.47691208171,
0.426815007605, 9.30887772639,
0.350065008233, 20.9666815726,
0.106474638445, 44.6312548375
};
D h_sds_5[] = {
0.484695901679, 10.4556852572,
0.324555322398, 25.6501857528,
0.13780976132, 3.25938027505,
0.0458737688963, 55.9771445774,
0.00701257573104, 0.627898035503
};
D h_sds_4[] = {
0.419120062187, 8.79274369694,
0.378950247327, 20.659643742,
0.101530704485, 45.5893408514,
0.100313289825, 2.44711752894
};
D h_sds_3[] = {
0.537945059276, 10.0800344439,
0.347994898641, 29.7475975707,
0.113198626354, 2.57510160853
};
D h_sds_2[] = {
0.513452217998, 24.7312236967,
0.4847206249, 6.32584259074
};
D h_sds_1[] = {
0.996273887199, 14.8425411863
};
D* h_sds_c[] = { h_sds_6, h_sds_5, h_sds_4, h_sds_3, h_sds_2, h_sds_1 };

D h_hf_s[] = { 6.0, 1.5, 1.1, 0.7, 0.42, 0.17 };
D h_hf_e[] = {
0.0925231340143,
0.00793246563421,
0.00773845885581,
0.00540009573968,
0.00635766892427,
0.0095847609644
};
D h_hf_6[] = {
0.272216556604, 19.5577039949,
0.252718382532, 7.10394957621,
0.24971456488, 21.423627494,
0.186671966216, 51.052182666,
0.0368000207616, 1.88645928848,
0.00186163591119, 0.31198464636
};
D h_hf_5[] = {
0.501132411829, 20.813430025,
0.263299808961, 7.6217477827,
0.187705461374, 50.6640960034,
0.0454998296169, 2.15567217463,
0.00229991268332, 0.298390968356
};
D h_hf_4[] = {
0.505781130231, 19.5290872033,
0.243432443284, 6.93336686621,
0.214754907432, 48.319470148,
0.0358934518663, 1.65454820045
};
D h_hf_3[] = {
0.502196691881, 13.478927669,
0.373818972889, 38.6665372038,
0.123052629233, 3.38304689207
};
D h_hf_2[] = {
0.551640798898, 32.0164865956,
0.446109079168, 7.84106986687
};
D h_hf_1[] = {
0.990236162259, 19.1456852561
};
D* h_hf_c[] = { h_hf_6, h_hf_5, h_hf_4, h_hf_3, h_hf_2, h_hf_1 };

D he_s[] = { 6.0, 2.5, 1.8, 1.0, 0.7, 0.22 };
D he_e[] = {
0.0341039477683,
0.00394419028509,
0.0074464848713,
0.00684822466406,
0.00827020087466,
0.00523142850858
};
D he_6[] = {
0.781325633983, 10.6894419493,
0.724096266859, 4.12710472737,
0.232489353787, 1.35353110465,
0.228206017596, 25.0768385907,
0.0313290333127, 0.373007654295,
0.00218960614104, 0.0834476635646
};
D he_5[] = {
0.796748970148, 10.5081981183,
0.708787643754, 4.05013012032,
0.23324546859, 25.0310729875,
0.230260491119, 1.33354714048,
0.0306320409407, 0.318670947095
};
D he_4[] = {
0.968409354575, 6.81523509182,
0.496727700042, 19.2555572848,
0.4528578511, 2.24364815502,
0.0810002330739, 0.547207033888
};
D he_3[] = {
1.08189530121, 6.70265036943,
0.467245206939, 19.957676141,
0.4501601147, 1.5821652553
};
D he_2[] = {
1.13295268048, 12.0004583738,
0.854410935178, 2.56544856723
};
D he_1[] = {
1.98909216216, 7.71449090343
};
D* he_c[] = { he_6, he_5, he_4, he_3, he_2, he_1 };

D li_s[] = { 6.0, 4.0, 2.0, 1.1, 0.5, 0.08 };
D li_e[] = {
0.00352444781129,
0.00315645322396,
0.00324625523755,
0.00806928839544,
0.00761116825383,
0.00859216311004
};
D li_6[] = {
1.07045659159, 3.86127314755,
1.0166272038, 121.342587267,
0.66900195705, 1.25824460648,
0.140707279546, 0.364428717952,
0.0891599329858, 22.6806895306,
0.00972160733206, 0.0642382444215
};
D li_5[] = {
1.04570763299, 117.671036636,
0.97445473427, 2.36260167438,
0.531841465421, 5.9790773224,
0.395879096289, 0.749363422498,
0.0463612293121, 0.161471228153
};
D li_4[] = {
1.04893664331, 117.157929729,
0.929593611589, 1.79077149812,
0.765630110305, 5.1109517763,
0.249851507493, 0.43820675375
};
D li_3[] = {
1.07146599943, 4.30327380157,
1.05534384128, 114.129734127,
0.863685495839, 1.03599382371
};
D li_2[] = {
1.89366416641, 2.4492524585,
1.0931961874, 107.209531186
};
D li_1[] = {
2.98013839504, 35.2094457643
};
D* li_c[] = { li_6, li_5, li_4, li_3, li_2, li_1 };

D be_s[] = { 6.0, 4.0, 1.9, 1.5, 0.5, 0.1 };
D be_e[] = {
0.00248433710313,
0.00455183293536,
0.00376822209748,
0.00912592883048,
0.00979295036254,
0.00718699833643
};
D be_6[] = {
1.54207738345, 42.7933290205,
1.09586862401, 1.86088577542,
0.62654729028, 0.631462443709,
0.592221997766, 99.731721907,
0.128336066753, 0.203003770863,
0.0151173594594, 0.0482004471351
};
D be_5[] = {
1.46501885843, 41.691472835,
1.14062498081, 1.81546695494,
0.671653721772, 94.5421696144,
0.627026557138, 0.573051829079,
0.0953828506206, 0.132145506827
};
D be_4[] = {
1.45744583075, 41.3479973017,
1.26047966666, 1.72341364347,
0.682451089888, 94.6366746158,
0.59967397234, 0.411648121935
};
D be_3[] = {
2.06778108412, 54.3775616887,
1.03403401833, 2.21128244408,
0.878360479364, 0.548264395981
};
D be_2[] = {
2.07352792432, 54.6421373667,
1.90909686309, 1.37608684981
};
D be_1[] = {
3.97352063751, 26.2795963327
};
D* be_c[] = { be_6, be_5, be_4, be_3, be_2, be_1 };

D b_s[] = { 6.0, 5.0, 2.5, 1.2, 0.4, 0.12 };
D b_e[] = {
0.00121614064647,
0.00293507091013,
0.00671836199566,
0.00987906807809,
0.00657973164529,
0.00737212079566
};
D b_6[] = {
2.08649669745, 23.5093898891,
1.0610713703, 61.2833321151,
1.04239939299, 1.1494608001,
0.649305701097, 0.414046165599,
0.150927802114, 0.125191094255,
0.00848720478682, 0.0212876546113
};
D b_5[] = {
2.05779003713, 23.3058421937,
1.10113446805, 1.11789587206,
1.09150189626, 60.411666904,
0.640774523795, 0.369176544579,
0.107171955898, 0.0889344365819
};
D b_4[] = {
2.00503658591, 22.783701605,
1.26604333677, 1.02929422267,
1.15189878009, 59.233116086,
0.575547079636, 0.246821624956
};
D b_3[] = {
2.40390483689, 40.6492977422,
1.74082003938, 0.649340687236,
0.840968677045, 12.2463914516
};
D b_2[] = {
2.74416704897, 37.8492138764,
2.23878630949, 1.85375798893
};
D b_1[] = {
4.97741133311, 20.0756200757
};
D* b_c[] = { b_6, b_5, b_4, b_3, b_2, b_1 };

D c_s[] = { 6.0, 6.0, 3.0, 1.4, 0.5, 0.15 };
D c_e[] = {
0.000973555400753,
0.00597919822483,
0.00649627598441,
0.00729469686667,
0.00995574533403,
0.00975980236455
};
D c_6[] = {
2.18188567686, 13.4533708328,
1.77612377639, 32.5790123523,
1.08772011297, 0.747293264573,
0.641460989931, 0.251251498175,
0.207885994451, 80.9799313275,
0.105219184507, 0.0587297979816
};
D c_5[] = {
2.65463431663, 14.7665037505,
1.49420264709, 42.0409767208,
1.05563210943, 0.780856499884,
0.688021531597, 0.258963998784,
0.104681246572, 0.0579465611728
};
D c_4[] = {
2.21557580709, 12.7523000206,
1.98306066831, 36.4905110196,
1.31636728472, 0.632825354093,
0.480812064621, 0.148079120135
};
D c_3[] = {
2.51340127252, 31.8053433708,
1.74867019409, 0.445605499982,
1.72398202356, 10.5831679451
};
D c_2[] = {
3.54355550695, 25.6239838191,
2.42579673735, 1.50364460774
};
D c_1[] = {
5.96792806111, 14.8957682987
};
D* c_c[] = { c_6, c_5, c_4, c_3, c_2, c_1 };

D n_s[] = { 6.0, 5.0, 3.0, 1.7, 0.5, 0.17 };
D n_e[] = {
0.00174936368848,
0.00378607883957,
0.00812450990726,
0.00974384919663,
0.00712055235301,
0.00877728869515
};
D n_6[] = {
2.77545321643, 15.0644760293,
1.37595750403, 7.17746883597,
1.06289560478, 0.527446769306,
1.03805703625, 37.9622771317,
0.625821830249, 0.187618748878,
0.120841771171, 0.0471843880812
};
D n_5[] = {
3.290377358, 10.3009938633,
1.83751629445, 30.4991869731,
1.00843354744, 0.286891277694,
0.627115494512, 0.765912546206,
0.233020950338, 0.0682199217083
};
D n_4[] = {
3.16212239104, 9.94082738119,
1.98555889282, 29.2341683858,
1.07984555802, 0.575668823648,
0.767239655802, 0.151761276156
};
D n_3[] = {
2.99954939487, 23.2726795155,
2.25583887941, 7.45433091596,
1.7278842283, 0.316224876669
};
D n_2[] = {
4.0103185728, 19.9718879528,
2.96436307327, 1.75589053867
};
D n_1[] = {
6.96715024214, 11.4372299305
};
D* n_c[] = { n_6, n_5, n_4, n_3, n_2, n_1 };

D o_s[] = { 6.0, 4.0, 4.0, 1.9, 0.55, 0.19 };
D o_e[] = {
0.000221919906779,
0.00218224483836,
0.00986789175277,
0.00907981841986,
0.00720745883713,
0.00823965256062
};
D o_6[] = {
2.91262062551, 14.4846217841,
2.58808134565, 6.03817696541,
0.98056775412, 0.422545666842,
0.696629143599, 0.154463824621,
0.685079864349, 35.5389178226,
0.136773884437, 0.0384134680409
};
D o_5[] = {
3.40470472063, 12.0427262729,
1.81331239792, 5.18001989831,
1.23689567101, 0.364131660811,
0.991313286014, 32.1461057555,
0.55406648494, 0.090613796066
};
D o_4[] = {
3.44353626658, 17.9370802761,
2.77942207924, 5.6692824851,
1.23264721297, 0.343345713626,
0.523752798328, 0.0882621458128
};
D o_3[] = {
3.21184129664, 18.8370006399,
3.04156392126, 5.90590162558,
1.73156010601, 0.241263012791
};
D o_2[] = {
4.49882080091, 15.8054240822,
3.47563036365, 1.70748239462
};
D o_1[] = {
7.9652690671, 9.0526662027
};
D* o_c[] = { o_6, o_5, o_4, o_3, o_2, o_1 };

D f_s[] = { 6.0, 4.0, 3.5, 2.0, 0.6, 0.22 };
D f_e[] = {
0.000417259072399,
0.000457725452902,
0.00904144226373,
0.00900738229702,
0.00697259205611,
0.00984187413228
};
D f_6[] = {
3.45429724648, 10.9155367588,
2.86373677364, 4.46289905515,
0.872647810615, 27.6707970367,
0.789193654941, 0.153245585458,
0.786475326738, 0.361687002613,
0.233254739503, 0.0418247586665
};
D f_5[] = {
3.59328188729, 9.72501335424,
2.43150861713, 4.16594165335,
1.18042180286, 24.8260882669,
1.17144607759, 0.299329557104,
0.622072886008, 0.0775163740033
};
D f_4[] = {
4.30494211, 5.46367312289,
2.83080306476, 17.3034348915,
1.13206510147, 0.341279958392,
0.722479968452, 0.0851703789239
};
D f_3[] = {
3.76051707547, 4.73185569767,
3.47766990973, 15.4384441173,
1.74594840518, 0.194238121265
};
D f_2[] = {
4.9042760979, 12.9953847006,
4.07043799606, 1.63650943149
};
D f_1[] = {
8.95735423378, 7.27483688266
};
D* f_c[] = { f_6, f_5, f_4, f_3, f_2, f_1 };

D ne_s[] = { 6.0, 3.5, 3.5, 2.0, 0.65, 0.24 };
D ne_e[] = {
0.0251525461788,
0.00447396571894,
0.00709463363607,
0.00832031297543,
0.0073181690269,
0.00950377906548
};
D ne_6[] = {
4.44469451654, 12.9824873876,
4.22653623919, 3.9513829441,
1.3388565605, 0.223239767883,
-1.24656672286, 10.5177659159,
0.756159316155, 6.18608571434,
0.465978443148, 0.0499683215558
};
D ne_5[] = {
3.64648771666, 9.10285523968,
3.513231219, 3.70200152542,
1.33608666714, 0.114118556652,
0.979384663703, 22.5547967378,
0.523780999276, 0.464175486324
};
D ne_4[] = {
5.10938238916, 4.61527149776,
2.89326148732, 14.927813893,
1.42563502388, 0.119960804291,
0.564238351557, 0.646777445236
};
D ne_3[] = {
4.38310831035, 3.82501909721,
3.83422263038, 12.6640899017,
1.76279016611, 0.161786329667
};
D ne_2[] = {
5.2904805802, 10.8943369737,
4.68405197317, 1.52467856059
};
D ne_1[] = {
9.95478155917, 6.02945952834
};
D* ne_c[] = { ne_6, ne_5, ne_4, ne_3, ne_2, ne_1 };

D na_s[] = { 6.0, 6.0, 2.5, 1.0, 0.42, 0.11 };
D na_e[] = {
0.00242053580248,
0.00657507629406,
0.00560868312278,
0.00668403828246,
0.00940694527152,
0.00898725360975
};
D na_6[] = {
4.84620840159, 4.57598906868,
1.72305593592, 11.6614683224,
1.61774677929, 1.99381420013,
1.23350676032, 0.175768136126,
1.07331812004, 135.713502419,
0.501214254558, 0.0435539213005
};
D na_5[] = {
4.06595597836, 2.81423469884,
4.04385789925, 7.88627526797,
1.26189645726, 0.180503043439,
1.13080219426, 135.713502419,
0.506066216617, 0.0435539213005
};
D na_4[] = {
4.6872441894, 7.05852531149,
3.4173122207, 2.48606028583,
1.69648083794, 0.1227851644,
1.17912510627, 115.206276124
};
D na_3[] = {
6.6351112713, 5.5442312674,
3.01293367286, 0.545797156151,
1.30238479723, 90.8590190323
};
D na_2[] = {
9.38062355211, 3.38349243799,
1.54874787085, 72.3273437928
};
D na_1[] = {
10.923956319, 11.384695953
};
D* na_c[] = { na_6, na_5, na_4, na_3, na_2, na_1 };

D mg_s[] = { 6.0, 5.0, 3.0, 1.1, 0.46, 0.11 };
D mg_e[] = {
0.00117828911264,
0.00869380929865,
0.00652454620191,
0.00701321612779,
0.00718879490383,
0.00777709416448
};
D mg_6[] = {
4.6987773943, 4.59988618945,
3.03788768418, 1.97020721208,
1.95148497894, 86.6420609211,
1.19203432552, 0.151668906172,
0.563800617663, 22.7024704247,
0.548719374786, 0.0388236330761
};
D mg_5[] = {
5.46318962789, 2.55944243635,
2.65095915973, 7.54004994713,
2.10503756632, 86.6420437271,
1.22645142581, 0.16168166804,
0.567452807241, 0.0388215402747
};
D mg_4[] = {
5.06266855345, 4.86482807548,
2.99878699919, 1.80232627584,
2.26061026796, 75.025915131,
1.65609099779, 0.0979278205559
};
D mg_3[] = {
6.67814146187, 4.14073262313,
2.96430131029, 0.428901927646,
2.32496434711, 71.0199150719
};
D mg_2[] = {
9.41153041745, 2.59044372852,
2.53737414996, 63.0356609037
};
D mg_1[] = {
11.9326735924, 13.1148070383
};
D* mg_c[] = { mg_6, mg_5, mg_4, mg_3, mg_2, mg_1 };

D al_s[] = { 6.0, 6.0, 3.5, 1.2, 0.5, 0.11 };
D al_e[] = {
0.000794517294785,
0.00688747570819,
0.00840637465667,
0.00865862059007,
0.0076510280457,
0.00755005617137
};
D al_6[] = {
4.15276033335, 3.83740575225,
3.68699548977, 1.71939573361,
2.37014137713, 44.1366719544,
1.13006029337, 0.134474847873,
1.04425613511, 111.942930095,
0.61461826964, 0.0357498688549
};
D al_5[] = {
5.45454027298, 2.01409340464,
3.13795408585, 62.9657816843,
2.60693118131, 5.56082384765,
1.10356234621, 0.142199910059,
0.668318351599, 0.0376165178656
};
D al_4[] = {
5.31740345971, 3.62241974805,
3.27833149018, 58.9556725256,
2.74804539054, 1.35863352542,
1.61372117406, 0.0793531242746
};
D al_3[] = {
6.62238016224, 3.3038329346,
3.27781520856, 59.3145382378,
3.05972557508, 0.374151395498
};
D al_2[] = {
9.46133544309, 2.0636863664,
3.47971497473, 54.4208736204
};
D al_1[] = {
12.9306219735, 14.1594727215
};
D* al_c[] = { al_6, al_5, al_4, al_3, al_2, al_1 };

D si_s[] = { 6.0, 4.0, 3.5, 1.2, 0.5, 0.12 };
D si_e[] = {
0.0072841264885,
0.00739861914937,
0.00947542056444,
0.00762206734436,
0.00858193227598,
0.00792771073284
};
D si_6[] = {
6.75433996364, 2.19901771761,
3.04903543251, 60.0122250811,
1.69343539647, 20.7446895797,
1.2180799282, 0.0886376441561,
0.888178882408, 0.68167731079,
0.386530760983, 0.0227555429962
};
D si_5[] = {
6.71145424729, 1.93832631838,
3.9434272597, 50.8735470222,
1.38910706379, 0.0564993687012,
1.3219584024, 8.64214728094,
0.607366732451, 0.340258564314
};
D si_4[] = {
5.27110758818, 1.53779353843,
4.18585603736, 47.8672667409,
2.83842144792, 4.19063053874,
1.66676936251, 0.0716820895631
};
D si_3[] = {
6.08447684913, 2.83886951807,
4.2732659722, 46.6331390474,
3.59835544898, 0.418767784547
};
D si_2[] = {
9.56314609737, 1.74257668846,
4.39227125605, 45.6770062132
};
D si_1[] = {
13.9256816622, 13.4431524725
};
D* si_c[] = { si_6, si_5, si_4, si_3, si_2, si_1 };

D p_s[] = { 6.0, 4.0, 3.0, 1.2, 0.55, 0.14 };
D p_e[] = {
0.000976152265733,
0.00451278820602,
0.00944668425643,
0.0094116702538,
0.00970775644168,
0.009895980191
};
D p_6[] = {
4.58130864999, 2.17601600204,
4.57605457281, 28.9931294943,
3.08152339098, 1.11652407588,
1.12796052602, 0.0956320460069,
1.05066132618, 81.0370412982,
0.585707561577, 0.0257396812627
};
D p_5[] = {
6.31332818841, 1.88546780551,
3.95647254644, 25.9779789403,
1.74517831887, 64.2335571203,
1.57923341409, 0.0574967439024,
1.40490935013, 0.73408729382
};
D p_4[] = {
6.72209392583, 1.48771615441,
5.05462352165, 38.3530763956,
1.74551545599, 0.0692916714846,
1.44573054207, 6.1512117456
};
D p_3[] = {
5.27941125504, 36.7775304861,
5.27354842119, 2.58877453733,
4.40634943423, 0.47041178021
};
D p_2[] = {
9.51134864276, 1.42068756465,
5.44231374624, 35.7280054673
};
D p_1[] = {
14.9079727022, 11.9131810173
};
D* p_c[] = { p_6, p_5, p_4, p_3, p_2, p_1 };

D s_s[] = { 6.0, 5.0, 3.0, 1.1, 0.55, 0.15 };
D s_e[] = {
0.00148516873654,
0.0083627384529,
0.00766274806175,
0.0093867295563,
0.00879783495931,
0.00930015149122
};
D s_6[] = {
6.19471472659, 1.53178413602,
5.16819319919, 22.1507217003,
1.61773530525, 55.6787080933,
1.3650575984, 0.703821007249,
1.34512095473, 0.0683366362597,
0.308863001721, 0.0118868832735
};
D s_5[] = {
6.92361477451, 1.4439335419,
4.98084916497, 21.5002215505,
1.83668699464, 52.805752941,
1.47429511469, 0.0456920572715,
0.783177471826, 0.383978349639
};
D s_4[] = {
6.65133928668, 1.22887267072,
6.21241682524, 29.6457029906,
1.72932018828, 0.0606320912539,
1.3617601041, 4.54445334666
};
D s_3[] = {
6.83012748437, 0.664089368899,
6.13863224738, 30.1886951281,
2.99357763173, 3.52397406633
};
D s_2[] = {
9.55731991435, 1.2373726213,
6.39886637904, 29.1933572566
};
D s_1[] = {
15.911119329, 10.8469011094
};
D* s_c[] = { s_6, s_5, s_4, s_3, s_2, s_1 };

D cl_s[] = { 6.0, 5.0, 3.5, 1.1, 0.6, 0.16 };
D cl_e[] = {
0.00344499454176,
0.0032412373672,
0.00976640377037,
0.00581687535724,
0.0096261327592,
0.0087032665233
};
D cl_6[] = {
6.8564037704, 1.19467491733,
6.15705161548, 18.3556781549,
1.7443134136, 46.468955818,
1.42564293798, 0.053354594712,
0.644067530579, 0.40947951395,
0.172325300892, 0.00251075608437
};
D cl_5[] = {
6.96109724758, 1.18517321604,
6.14476519653, 18.3182738088,
1.76002114241, 46.3052856485,
1.47919569648, 0.0406789459349,
0.654671141188, 0.311945412149
};
D cl_4[] = {
7.10651627622, 1.08411020464,
6.22801807808, 26.7294655181,
1.90667190218, 9.28900883363,
1.72757349023, 0.0524773720508
};
D cl_3[] = {
8.12176088935, 0.697928192858,
6.65345104038, 25.8943955401,
2.19043698007, 6.00738032174
};
D cl_2[] = {
9.50761197188, 1.04373347458,
7.4434129217, 23.8373153363
};
D cl_1[] = {
16.9135920927, 9.84057627794
};
D* cl_c[] = { cl_6, cl_5, cl_4, cl_3, cl_2, cl_1 };

D ar_s[] = { 6.0, 6.0, 3.5, 1.2, 0.6, 0.17 };
D ar_e[] = {
0.00419335864962,
0.00521403402077,
0.00679641936391,
0.00652489149797,
0.00870071101649,
0.00822579141589
};
D ar_6[] = {
7.17800800022, 15.527552579,
7.03656202525, 0.977832726232,
1.82258588849, 39.915689392,
0.930990067636, 0.0601418162601,
0.659585913984, 0.0208493380958,
0.372369207565, 0.260577175279
};
D ar_5[] = {
7.23716885417, 15.6392801829,
7.11799051521, 0.970590288271,
1.75715405154, 39.9437171077,
1.27799032676, 0.031257493769,
0.605772593364, 0.147757100702
};
D ar_4[] = {
7.14684704776, 0.932964994336,
4.75329473354, 26.4765058776,
4.35020748226, 12.0896688994,
1.73186917066, 0.0475762628488
};
D ar_3[] = {
8.1978704772, 0.603152037749,
7.25214271687, 22.1423332433,
2.51643840211, 6.28874083466
};
D ar_2[] = {
9.62022845255, 0.960018016644,
8.33376638765, 20.3064854701
};
D ar_1[] = {
17.9155276842, 8.92673227319
};
D* ar_c[] = { ar_6, ar_5, ar_4, ar_3, ar_2, ar_1 };

D k_s[] = { 6.0, 6.0, 4.0, 1.2, 0.3, 0.11 };
D k_e[] = {
0.00307383452037,
0.00670500485202,
0.00846100427241,
0.00972125850907,
0.00827058927682,
0.00914952128619
};
D k_6[] = {
8.50074362541, 13.2958577307,
7.09238507615, 0.825526772022,
1.3019672971, 0.0285151198603,
0.804532522001, 243.711706998,
0.761427365728, 77.912953854,
0.538295582111, 0.130289877235
};
D k_5[] = {
8.64400831945, 13.6076746465,
7.13583887573, 0.83075901795,
1.37530608832, 161.234887982,
1.09509164679, 0.0244151308484,
0.732757795421, 0.0994969581656
};
D k_4[] = {
8.5646837937, 13.0363756083,
7.1724376137, 0.797558167798,
1.68472962513, 0.0396790403845,
1.5290811984, 127.915376708
};
D k_3[] = {
8.66788257982, 12.3159255661,
8.58340898529, 0.562749994595,
1.68051604224, 110.002273029
};
D k_2[] = {
16.3797701165, 4.54127406462,
2.54834776786, 84.2822534434
};
D k_1[] = {
18.8641841059, 12.1498669428
};
D* k_c[] = { k_6, k_5, k_4, k_3, k_2, k_1 };

D ca_s[] = { 6.0, 6.0, 5.0, 1.3, 0.35, 0.11 };
D ca_e[] = {
0.00278246839473,
0.00672578159293,
0.00990239226751,
0.00573680843859,
0.00970409438343,
0.00992240946981
};
D ca_6[] = {
8.71536771754, 10.5897214385,
7.50391068049, 0.736628230545,
2.49253389178, 118.736978402,
1.36733992959, 0.0268650230392,
-0.576598625738, 1.33460206767,
0.482694253556, 0.133372892421
};
D ca_5[] = {
8.683497199, 10.6539181982,
7.12131855025, 0.694648250135,
2.48276018209, 119.347277963,
1.40197943106, 0.04594348421,
0.296404867481, 0.00402189243709
};
D ca_4[] = {
8.69995431417, 10.6272186716,
7.15824767779, 0.686099679675,
2.4833225657, 119.079409362,
1.64274103305, 0.0336801196246
};
D ca_3[] = {
8.75937156177, 9.64475680185,
8.41257168569, 0.475138202259,
2.76798129934, 97.3905740758
};
D ca_2[] = {
16.2689321285, 3.58508760428,
3.65394674472, 77.2858902336
};
D ca_1[] = {
19.8547182678, 13.7185970012
};
D* ca_c[] = { ca_6, ca_5, ca_4, ca_3, ca_2, ca_1 };

D sc_s[] = { 6.0, 6.0, 5.0, 1.4, 0.36, 0.11 };
D sc_e[] = {
0.00403267302388,
0.00421560811144,
0.00895335585017,
0.00927725558934,
0.00900028008081,
0.00813164162064
};
D sc_6[] = {
9.40471736402, 9.43589804966,
7.08643043413, 0.615560741934,
2.76665036076, 97.7694100778,
1.16817599931, 0.0430655446768,
0.446605640988, 0.00864056761553,
0.105808974452, 0.0916525758341
};
D sc_5[] = {
9.40251407968, 9.44020049437,
7.06561871215, 0.617552038104,
2.76581592626, 97.7716670853,
1.17813774224, 0.0215448833783,
0.566127704341, 0.077835529731
};
D sc_4[] = {
9.40453520631, 9.39294251811,
7.14254006341, 0.60716010664,
2.78205338465, 96.7521012371,
1.64674026886, 0.0307386310383
};
D sc_3[] = {
9.51340433555, 8.72304034893,
8.43057223084, 0.421969259986,
3.00293226194, 85.1544003488
};
D sc_2[] = {
16.9832041251, 3.40292273854,
3.94295025317, 67.9639291791
};
D sc_1[] = {
20.8752585398, 12.9474059257
};
D* sc_c[] = { sc_6, sc_5, sc_4, sc_3, sc_2, sc_1 };

D ti_s[] = { 6.0, 6.0, 5.0, 1.4, 0.38, 0.12 };
D ti_e[] = {
0.00441967250091,
0.00534027359583,
0.00913466455674,
0.00763891738706,
0.0096801215092,
0.00894994033572
};
D ti_6[] = {
8.59949508502, 7.96319234098,
7.0703748761, 0.543259755454,
2.91445281827, 84.7518935908,
1.69524418271, 11.4444586221,
1.42821487147, 0.0373689195616,
0.263984087305, 0.00073880949284
};
D ti_5[] = {
10.190289958, 8.44896740875,
6.96707047106, 0.559188715884,
2.96466465104, 83.4545565323,
1.41697425583, 0.0230253456003,
0.431127442127, 0.120438422257
};
D ti_4[] = {
10.1982141455, 8.41711577502,
7.13525580668, 0.543201076752,
2.97716227502, 82.8273017823,
1.65808499042, 0.0285079220314
};
D ti_3[] = {
10.2799540619, 7.88841343088,
8.45913489426, 0.381270873952,
3.20116956042, 73.589906538
};
D ti_2[] = {
17.6938549618, 3.19135556676,
4.22663845289, 59.0215851326
};
D ti_1[] = {
21.8594011757, 11.5487480059
};
D* ti_c[] = { ti_6, ti_5, ti_4, ti_3, ti_2, ti_1 };

D v_s[] = { 6.0, 6.0, 6.0, 1.4, 0.38, 0.13 };
D v_e[] = {
0.00699300046273,
0.00670764766347,
0.00915064972514,
0.0098955305771,
0.00813268331315,
0.00973139707717
};
D v_6[] = {
11.0090688433, 7.64813287987,
4.02879836881, 0.590450031942,
3.25161062679, 0.380404779461,
3.10464859469, 73.6686188469,
0.926368797402, 0.0227952344244,
0.645440840964, 0.0245060486041
};
D v_5[] = {
10.9947812199, 7.62894151302,
4.34329754705, 0.408234148412,
3.12015811717, 72.8704236619,
2.92580172581, 0.629314996681,
1.5786347607, 0.0236297737483
};
D v_4[] = {
10.9619767761, 7.38668259017,
7.09968840754, 0.477849398339,
3.26725489693, 67.3815551346,
1.61365900794, 0.02437159445
};
D v_3[] = {
11.1458421487, 7.26900302269,
8.52770210726, 0.350572882934,
3.27333965837, 67.9662846278
};
D v_2[] = {
18.6613397742, 3.12588931629,
4.26681478221, 55.3164235794
};
D v_1[] = {
22.8432607643, 10.3424506087
};
D* v_c[] = { v_6, v_5, v_4, v_3, v_2, v_1 };

D cr_s[] = { 6.0, 6.0, 3.5, 1.3, 0.42, 0.15 };
D cr_e[] = {
0.00514424337882,
0.00727704011609,
0.00603651934285,
0.00986498678036,
0.00978094813889,
0.00997758187928
};
D cr_6[] = {
11.065606215, 6.43856665362,
7.02193399793, 0.433846089005,
2.86321565805, 23.1880703925,
1.38233423395, 102.869936045,
1.31062315222, 0.0303434184841,
0.348953443726, 0.00553592615139
};
D cr_5[] = {
11.0371894162, 6.36335138225,
7.03344238718, 0.428742255227,
2.9545749328, 23.5622556246,
1.61666159349, 0.0225369073195,
1.34778367626, 102.774722147
};
D cr_4[] = {
12.0211434545, 6.91005485239,
6.97597932212, 0.451620946665,
3.12337761884, 49.9504748708,
1.80368656434, 0.0310875074827
};
D cr_3[] = {
12.1965729193, 6.89852281719,
8.6651380941, 0.333439737044,
3.06905493686, 51.4431406852
};
D cr_2[] = {
19.1721559275, 2.82867170552,
4.73356055431, 37.7572552423
};
D cr_1[] = {
23.8327397906, 8.19028906226
};
D* cr_c[] = { cr_6, cr_5, cr_4, cr_3, cr_2, cr_1 };

D mn_s[] = { 6.0, 6.0, 2.0, 1.3, 0.42, 0.14 };
D mn_e[] = {
0.00404756817139,
0.00537419728964,
0.00675032503027,
0.00966450947519,
0.00923224859305,
0.00911048007801
};
D mn_6[] = {
12.1721224376, 5.79872154871,
6.98332451765, 0.3910188971,
2.55206024065, 29.7105884853,
1.61759310306, 95.1435856136,
0.882518017523, 0.0330592932008,
0.778535522907, 0.0124176780231
};
D mn_5[] = {
12.0233275381, 5.72086848766,
7.00603366555, 0.386234173525,
2.52330547996, 26.1850646504,
1.82562665346, 91.241010079,
1.61057103036, 0.0206495512211
};
D mn_4[] = {
11.3854895639, 7.07349841067,
7.63884131528, 0.238547974185,
3.12148509754, 63.713434104,
2.82015603273, 2.11239596397
};
D mn_3[] = {
12.7428954458, 6.09717645893,
8.68059401604, 0.307362041711,
3.51227744547, 54.7923744615
};
D mn_2[] = {
20.2359098056, 2.76514374487,
4.67902384096, 44.0119097511
};
D mn_1[] = {
24.8414215548, 8.72905236378
};
D* mn_c[] = { mn_6, mn_5, mn_4, mn_3, mn_2, mn_1 };

D fe_s[] = { 6.0, 6.0, 2.0, 1.3, 0.45, 0.15 };
D fe_e[] = {
0.00476794701676,
0.00494571166059,
0.00542353691859,
0.00998411421239,
0.00995489588014,
0.00981807218804
};
D fe_6[] = {
12.7417916091, 5.15201253128,
6.97403780812, 0.351246950794,
2.63080832939, 24.1129518356,
1.61365990733, 0.019173290581,
1.55189700453, 103.10333368,
0.497473200113, 26.5691985821
};
D fe_5[] = {
12.731412777, 5.14494221222,
6.97210486558, 0.35068965132,
3.13102034256, 24.274383359,
1.61066441925, 0.0190965371064,
1.5656062125, 103.08163618
};
D fe_4[] = {
10.9312903403, 6.83763130557,
7.82132777847, 0.225225849969,
4.01337957379, 2.58698666595,
3.19041685829, 57.4468920838
};
D fe_3[] = {
13.5386808693, 5.5999743031,
8.76290322281, 0.290387429344,
3.6282889925, 49.6184457459
};
D fe_2[] = {
20.903269971, 2.55100384374,
4.99816287547, 38.4687019055
};
D fe_1[] = {
25.8245754261, 7.91008592968
};
D* fe_c[] = { fe_6, fe_5, fe_4, fe_3, fe_2, fe_1 };

D co_s[] = { 6.0, 6.0, 2.0, 1.2, 0.46, 0.15 };
D co_e[] = {
0.00429998924461,
0.00427238341357,
0.00349022647849,
0.00971085444117,
0.00935731056715,
0.00868173233298
};
D co_6[] = {
15.3182377812, 3.9184585578,
6.99100976354, 0.323208218937,
4.27410224251, 13.5837582381,
-3.49483771394, 2.77580109986,
2.28190467272, 73.3116022747,
1.62164008091, 0.0179743211168
};
D co_5[] = {
13.4638282936, 4.67867736479,
6.95542797212, 0.322201509485,
3.36204268186, 21.5098076686,
1.619880924, 0.0179297591558,
1.60872836177, 95.5934949765
};
D co_4[] = {
9.01983850026, 7.35879244242,
7.91075041194, 0.210234274351,
6.97860360036, 3.06067861926,
3.05341612766, 56.380006153
};
D co_3[] = {
14.2511611792, 5.36759291075,
9.13683816117, 0.305437893913,
3.55259119666, 48.447700971
};
D co_2[] = {
21.8531332278, 2.45199578804,
5.04979333089, 36.113609417
};
D co_1[] = {
26.8380213142, 7.44108181966
};
D* co_c[] = { co_6, co_5, co_4, co_3, co_2, co_1 };

D ni_s[] = { 6.0, 6.0, 2.0, 1.2, 0.46, 0.16 };
D ni_e[] = {
0.00419310631036,
0.00410361760011,
0.00236791554616,
0.00963644264285,
0.00819328489928,
0.00932559948351
};
D ni_6[] = {
8.48931957809, 4.24127077343,
6.92797139403, 0.294898295897,
5.65985939889, 4.24194206539,
3.62236221266, 18.8997133824,
1.6798311759, 84.6861575593,
1.61647515975, 0.0165858072119
};
D ni_5[] = {
14.1491702957, 4.24154369788,
6.92795914847, 0.294929687936,
3.62236093255, 18.8997133824,
1.6798315143, 84.6861755747,
1.61646357048, 0.0165858072119
};
D ni_4[] = {
8.99502999953, 3.10637989017,
7.99926712416, 7.50879241456,
7.95622048406, 0.195636124121,
3.01205009698, 53.5687686876
};
D ni_3[] = {
14.9767789806, 5.01191696697,
9.35030169796, 0.302607553312,
3.61038378024, 44.9232209459
};
D ni_2[] = {
22.9357856279, 2.39429839383,
4.97431636672, 34.9904579371
};
D ni_1[] = {
27.8214256829, 6.78831954259
};
D* ni_c[] = { ni_6, ni_5, ni_4, ni_3, ni_2, ni_1 };

D cu_s[] = { 6.0, 6.0, 2.0, 1.2, 0.5, 0.18 };
D cu_e[] = {
0.00323620744902,
0.00377976368247,
0.0018624569904,
0.00950963837324,
0.00909699805447,
0.00895789826336
};
D cu_6[] = {
14.6467997675, 3.86627957384,
10.1789463499, 18.7191151901,
6.90109656327, 0.272652686432,
-6.67090658404, 24.7139474213,
2.30775992161, 60.4325748314,
1.62583736462, 0.0156201581129
};
D cu_5[] = {
14.3974551847, 3.81921375623,
6.89968232275, 0.270931464153,
4.88008551885, 14.5554416896,
1.60804651255, 0.0151380250491,
1.22326976451, 87.9636514666
};
D cu_4[] = {
10.8726524547, 3.06096761411,
7.98784956471, 0.182583928707,
7.89410774767, 8.26898032508,
2.21228399124, 50.8308037827
};
D cu_3[] = {
15.9430456345, 4.82663324046,
9.6553328387, 0.306553792833,
3.33083077178, 35.4599869576
};
D cu_2[] = {
23.4244928861, 2.18334602232,
5.47273767028, 24.9623408597
};
D cu_1[] = {
28.8212366506, 5.57286886543
};
D* cu_c[] = { cu_6, cu_5, cu_4, cu_3, cu_2, cu_1 };

D zn_s[] = { 6.0, 6.0, 2.5, 1.1, 0.5, 0.17 };
D zn_e[] = {
0.00242976268436,
0.00375580417529,
0.00815290483478,
0.00689031095814,
0.00927307824229,
0.00892902763499
};
D zn_6[] = {
15.7260614478, 2.85695823085,
6.98693452848, 0.255524171665,
6.14439780415, 9.37777241811,
-2.97265224177, 1.72920082788,
2.46115963328, 58.1675885754,
1.63956766638, 0.014840518864
};
D zn_5[] = {
15.1571643868, 3.46817577195,
6.86288275849, 0.24914156523,
4.42309036364, 13.5208520142,
1.951294829, 69.7461924509,
1.60567080108, 0.0140798718398
};
D zn_4[] = {
13.7261283411, 5.1009809136,
7.43038705926, 0.149223200233,
5.43481942203, 1.7000541834,
3.36517010543, 44.02185585
};
D zn_3[] = {
15.9676170894, 4.64159415074,
10.4463803921, 0.358107174158,
3.5271729716, 41.3067132366
};
D zn_2[] = {
24.6459639685, 2.14387421399,
5.25405383615, 29.7637500698
};
D zn_1[] = {
29.8172050801, 5.87945103167
};
D* zn_c[] = { zn_6, zn_5, zn_4, zn_3, zn_2, zn_1 };

D ga_s[] = { 6.0, 6.0, 2.5, 1.2, 0.5, 0.16 };
D ga_e[] = {
0.0029937558669,
0.00439727601908,
0.00674991049039,
0.00942025094723,
0.00961539165343,
0.00951349406607
};
D ga_6[] = {
15.7465692575, 3.00538643943,
6.92825595603, 0.235760002194,
4.44383245599, 11.4142036001,
2.81825825913, 64.42797415,
1.64386141715, 0.0139307068399,
-0.598895131598, 1.13986728199
};
D ga_5[] = {
15.8415852818, 3.14728852396,
6.82889170277, 0.229068970047,
4.04943957472, 12.8778287124,
2.67156660404, 66.9559282972,
1.59334494132, 0.0129109327109
};
D ga_4[] = {
11.8148060979, 2.43143438317,
8.01458689319, 6.75567295404,
7.73948516784, 0.1475966827,
3.39873667726, 55.3138812146
};
D ga_3[] = {
16.4944618554, 4.12737191087,
10.3236971493, 0.318425619984,
4.10716029583, 44.5159627214
};
D ga_2[] = {
25.5859347215, 2.0670834809,
5.30419564392, 35.3816407389
};
D ga_1[] = {
30.7943358949, 6.37959648688
};
D* ga_c[] = { ga_6, ga_5, ga_4, ga_3, ga_2, ga_1 };

D ge_s[] = { 6.0, 6.0, 2.5, 1.2, 0.5, 0.16 };
D ge_e[] = {
0.00321453291025,
0.00400486325508,
0.00424363345607,
0.00807225010636,
0.00802069010566,
0.00965847011109
};
D ge_6[] = {
27.7341971758, 2.39176691495,
-12.4595892273, 2.01605090977,
6.83320787704, 0.217141560318,
4.46177021249, 10.0251873917,
3.75598163759, 54.4507446264,
1.65285837947, 0.0132890571211
};
D ge_5[] = {
16.6213612862, 2.88270192562,
6.80042437772, 0.211753431344,
3.75689554962, 14.1260524612,
3.22235535709, 60.5782381363,
1.58753135033, 0.0119832262389
};
D ge_4[] = {
12.7123372928, 2.2925086357,
7.74607796839, 0.13772667505,
7.05810398144, 6.05170563388,
4.43707238725, 46.8441052888
};
D ge_3[] = {
16.4458600761, 3.72882293769,
10.5599493419, 0.316174473194,
4.92533026545, 42.0934525241
};
D ge_2[] = {
26.0242954035, 1.92192945648,
5.88190167729, 36.0754952465
};
D ge_1[] = {
31.7901474639, 6.60934134132
};
D* ge_c[] = { ge_6, ge_5, ge_4, ge_3, ge_2, ge_1 };

D as_s[] = { 6.0, 6.0, 2.5, 1.4, 0.55, 0.16 };
D as_e[] = {
0.00284738635812,
0.00404924844003,
0.00310664663641,
0.00999005498339,
0.00952076220767,
0.00879068669767
};
D as_6[] = {
16.8295993188, 2.54910284726,
11.1667733455, 0.22437191364,
-4.6363484051, 0.274886891447,
4.3315626955, 47.6099998554,
3.60701051059, 12.2376166897,
1.68423129584, 0.0129471652852
};
D as_5[] = {
17.0270746647, 2.60006969197,
6.74403603813, 0.194766008322,
3.84509352763, 14.6656518214,
3.7984148904, 51.7109584127,
1.57515187202, 0.011031573674
};
D as_4[] = {
14.8535741232, 2.23992499799,
7.76393263091, 0.129019980666,
5.26968223477, 41.4399018186,
5.07634987495, 6.6413750402
};
D as_3[] = {
17.1960878679, 3.12619083301,
9.69900138738, 0.234035807171,
6.04192031603, 36.5140401994
};
D as_2[] = {
25.8802189704, 1.67970886303,
7.0206024597, 31.5899126311
};
D as_1[] = {
32.8077317711, 6.70741734934
};
D* as_c[] = { as_6, as_5, as_4, as_3, as_2, as_1 };

D se_s[] = { 6.0, 6.0, 3.0, 1.4, 0.55, 0.17 };
D se_e[] = {
0.00287489184044,
0.00476371260697,
0.00812527727982,
0.00883517707195,
0.00741546605048,
0.00952383764908
};
D se_6[] = {
17.2768180281, 2.33102560067,
9.16660654752, 0.1603154705,
4.50821648644, 43.2977383756,
4.00155978598, 14.2929240931,
-2.80109328916, 0.110854365863,
1.83632028986, 0.0139037684536
};
D se_5[] = {
17.3527927141, 2.35174900102,
6.71219051599, 0.178614354153,
4.34981613621, 15.787404989,
4.04131517775, 45.8153267929,
1.53662634972, 0.00961992032065
};
D se_4[] = {
14.7314047233, 2.99977545299,
7.2310261038, 0.107899140689,
7.046023543, 32.1454176997,
4.93308570343, 1.13185231582
};
D se_3[] = {
17.0504033455, 2.79743745985,
9.78301185102, 0.227209294309,
7.10176272738, 31.7723375223
};
D se_2[] = {
26.0232600999, 1.54239993989,
7.89457103835, 29.1250120748
};
D se_1[] = {
33.7929399267, 6.51140389521
};
D* se_c[] = { se_6, se_5, se_4, se_3, se_2, se_1 };

D br_s[] = { 6.0, 6.0, 3.0, 1.6, 0.6, 0.17 };
D br_e[] = {
0.00191349697253,
0.00567057867017,
0.00764918357534,
0.00985645815072,
0.00804728676207,
0.00833937395998
};
D br_6[] = {
31.2092726318, 0.21690922801,
-24.9751942689, 0.233418887713,
17.4499978404, 2.06246375265,
5.34990247295, 36.5229483632,
4.2395355045, 13.0466474417,
1.71268683195, 0.0118949576424
};
D br_5[] = {
17.7005413658, 2.15231999613,
7.19063336947, 20.4107890731,
6.6711804336, 0.166635918572,
1.90253322135, 59.7835079529,
1.54481332506, 0.00911835906298
};
D br_4[] = {
13.6254496787, 2.76545584028,
8.11347398115, 28.191227815,
7.22947017376, 0.100330064622,
5.97442361133, 1.16316367117
};
D br_3[] = {
17.5420861481, 2.3876252301,
9.08359865439, 0.174206423325,
8.30546540071, 27.4378361399
};
D br_2[] = {
25.7982197344, 1.35699807506,
9.11300507123, 25.3489553667
};
D br_1[] = {
34.8156152415, 6.45270323292
};
D* br_c[] = { br_6, br_5, br_4, br_3, br_2, br_1 };

D kr_s[] = { 6.0, 6.0, 3.0, 1.6, 0.65, 0.18 };
D kr_e[] = {
0.00209737520547,
0.00831453219755,
0.00586163373437,
0.0091078715788,
0.00848233297511,
0.00886378882673
};
D kr_6[] = {
17.5211206376, 1.82770557067,
14.2096508075, 0.199871802901,
-8.26683300979, 0.253543791777,
6.99011767633, 29.4008411949,
3.77448458791, 10.5244116762,
1.74518819303, 0.0116589845797
};
D kr_5[] = {
17.749879555, 1.92568690536,
8.25543896932, 18.7720056422,
6.66851719287, 0.148867752245,
1.92697820895, 53.06034727,
1.41002761908, 0.00608291092322
};
D kr_4[] = {
16.7224852505, 1.72935889306,
8.05668825541, 27.4945860792,
7.53725412744, 0.100148873089,
3.65212173716, 6.82667475184
};
D kr_3[] = {
17.3989367325, 2.16761932439,
9.36450036612, 24.4439214341,
9.17346482754, 0.170251945105
};
D kr_2[] = {
25.6020924203, 1.20447351799,
10.3054318509, 22.3890952037
};
D kr_1[] = {
35.8041680425, 6.19229169183
};
D* kr_c[] = { kr_6, kr_5, kr_4, kr_3, kr_2, kr_1 };

D rb_s[] = { 6.0, 6.0, 3.0, 0.8, 0.46, 0.14 };
D rb_e[] = {
0.00321662411447,
0.00757144366108,
0.00443459788963,
0.00516058041728,
0.00854895058267,
0.00962480852305
};
D rb_6[] = {
-89.8132287615, 0.062995066071,
54.9316435213, 0.0810766059468,
42.7922299262, 0.0482974611832,
17.8702688896, 1.73562971685,
9.68525141154, 17.3438877377,
1.51011229356, 166.127548169
};
D rb_5[] = {
17.7958643483, 1.75220512343,
9.67662978019, 17.5201009577,
6.54871972611, 0.140706150944,
1.48471268028, 0.00738522278584,
1.4774871496, 173.841327599
};
D rb_4[] = {
17.9004796678, 1.64746608083,
10.0531137117, 16.5768983023,
7.52582355265, 0.0938707197234,
1.56397070298, 204.367779712
};
D rb_3[] = {
23.910804374, 0.928223646688,
10.5360489582, 13.1425847975,
2.44931455737, 87.5230688031
};
D rb_2[] = {
28.6351140959, 1.65703527376,
8.07799949718, 30.2702946694
};
D rb_1[] = {
36.7145630168, 7.28839849755
};
D* rb_c[] = { rb_6, rb_5, rb_4, rb_3, rb_2, rb_1 };

D sr_s[] = { 6.0, 5.0, 3.0, 0.9, 0.38, 0.12 };
D sr_e[] = {
0.00262072208704,
0.00788011590788,
0.00178317029396,
0.00635379938916,
0.00920560275623,
0.00842256799422
};
D sr_6[] = {
23.0075489425, 0.18553318051,
17.9495241204, 1.54046415911,
-17.2484655936, 0.211534750962,
9.83455883703, 14.2402359039,
2.62526195302, 135.362314852,
1.8158647333, 0.0115058923721
};
D sr_5[] = {
17.7347387904, 1.57089763496,
9.77963397205, 14.4183304996,
6.67765069268, 0.122854921676,
2.59794740743, 137.207492339,
1.19760154915, 0.000892496990375
};
D sr_4[] = {
17.8521657029, 1.50977022688,
9.90878126776, 13.8496382201,
7.50685158, 0.088158849265,
2.70985520504, 128.91349352
};
D sr_3[] = {
23.3302207832, 0.805464539522,
11.1676164796, 10.7378777121,
3.40901694124, 93.295102231
};
D sr_2[] = {
32.18651682, 2.35430012584,
5.63918874569, 57.9039268894
};
D sr_1[] = {
37.7531600872, 8.84309194742
};
D* sr_c[] = { sr_6, sr_5, sr_4, sr_3, sr_2, sr_1 };

D y_s[] = { 6.0, 5.0, 3.5, 0.9, 0.4, 0.13 };
D y_e[] = {
0.00301262505509,
0.00993558858366,
0.00618716150791,
0.0046687360765,
0.00936086575048,
0.00941204875515
};
D y_6[] = {
18.2612626613, 1.38684415758,
15.2269090909, 0.179985616667,
10.3271252869, 12.9841663163,
-9.96459632469, 0.236120340722,
3.19453481464, 107.379164463,
1.93416760325, 0.012553707986
};
D y_5[] = {
17.7990873595, 1.43324146849,
10.2508546564, 13.1878693895,
6.64178962466, 0.112651790291,
3.15381053015, 109.09079633,
1.13725062777, 6.31349546386e-06
};
D y_4[] = {
17.750087766, 1.3583256402,
10.2006041228, 11.8546431447,
7.35830023707, 0.0799761166811,
3.62665654128, 89.4265124846
};
D y_3[] = {
23.5235691064, 0.757601750963,
11.4829330129, 10.2442370891,
3.916262423, 83.0146587908
};
D y_2[] = {
32.3152842574, 2.16542166542,
6.51405706076, 51.3748078785
};
D y_1[] = {
38.727326109, 8.50609886878
};
D* y_c[] = { y_6, y_5, y_4, y_3, y_2, y_1 };

D zr_s[] = { 6.0, 4.0, 3.5, 1.0, 0.42, 0.13 };
D zr_e[] = {
0.00394301611894,
0.00763799137612,
0.0017206821232,
0.00831632280276,
0.00955119205582,
0.00831618355902
};
D zr_6[] = {
18.686344668, 1.25349666805,
10.9914524605, 12.129026392,
8.42027502185, 0.151802189188,
-3.66059282459, 0.319992558906,
3.55967150736, 90.4893896311,
1.97621349053, 0.0127265325507
};
D zr_5[] = {
17.9131888822, 1.30963484436,
10.9553662719, 12.4154409776,
6.5583601521, 0.100216533964,
3.45798803498, 93.6942802815,
1.09448154673, 0.00564648647742
};
D zr_4[] = {
17.9786814077, 1.26743844478,
10.9253197088, 11.8175323869,
7.35251891645, 0.0755021731929,
3.70392774924, 85.750802794
};
D zr_3[] = {
23.3726972532, 0.684926546016,
12.2519628369, 9.56037750445,
4.31377561634, 74.3015056094
};
D zr_2[] = {
32.4306384545, 2.00117759265,
7.39398027778, 44.4746843492
};
D zr_1[] = {
39.7558436724, 8.41559513997
};
D* zr_c[] = { zr_6, zr_5, zr_4, zr_3, zr_2, zr_1 };

D nb_s[] = { 6.0, 4.0, 4.0, 1.0, 0.46, 0.15 };
D nb_e[] = {
0.0078951655881,
0.00360761639162,
0.00988548820971,
0.00551243655082,
0.0087594660205,
0.00921287562834
};
D nb_6[] = {
18.8461803715, 1.15402781213,
18.8256098879, 0.178757683135,
-14.3436311229, 0.229444364454,
12.1187078596, 12.0109586422,
3.37367252098, 73.3942709233,
2.14644289927, 0.0141535636048
};
D nb_5[] = {
18.1253198634, 1.19152518185,
12.1245434592, 12.1782781502,
6.65340050105, 0.0823324025544,
3.2933978054, 75.3234425928,
0.776095978534, 0.0146534339501
};
D nb_4[] = {
18.2073473674, 1.17379191075,
12.0742350999, 11.9579925575,
7.26373922109, 0.0697180976445,
3.41925740806, 72.1567842258
};
D nb_3[] = {
23.5031600172, 0.642934099047,
12.6386032107, 9.20719558971,
4.7681241134, 52.8701133916
};
D nb_2[] = {
31.6548103273, 1.68975002415,
9.1631557685, 31.8688195797
};
D nb_1[] = {
40.7324058119, 7.2599484596
};
D* nb_c[] = { nb_6, nb_5, nb_4, nb_3, nb_2, nb_1 };

D mo_s[] = { 6.0, 4.0, 3.5, 1.1, 0.48, 0.16 };
D mo_e[] = {
0.00226779257457,
0.00431605926984,
0.00191553087314,
0.00745039544259,
0.00929806073757,
0.00981545157143
};
D mo_6[] = {
18.535222829, 1.0707162225,
16.1446345189, 0.14781169068,
13.0042162204, 11.3008045636,
-11.1043303024, 0.191261254009,
3.52967016692, 65.3993022118,
1.85620445707, 0.0097540824549
};
D mo_5[] = {
18.0769654048, 1.10097757613,
13.0191142334, 11.4686757914,
5.93378419897, 0.0858375697,
3.42984592431, 67.3711233297,
1.51068933204, 0.0217011230085
};
D mo_4[] = {
18.148863768, 1.08459645015,
12.9402828675, 11.2257507486,
7.27679221548, 0.0666668910403,
3.59775525604, 64.218824661
};
D mo_3[] = {
23.1827814092, 0.577001089934,
13.2100575903, 8.23840117065,
5.50231022913, 43.9978888806
};
D mo_2[] = {
31.8195555804, 1.58633927585,
9.99777514441, 28.5196004699
};
D mo_1[] = {
41.714508047, 6.84716333087
};
D* mo_c[] = { mo_6, mo_5, mo_4, mo_3, mo_2, mo_1 };

D tc_s[] = { 6.0, 4.0, 4.0, 1.1, 0.46, 0.15 };
D tc_e[] = {
0.00246092257068,
0.0038943115425,
0.00563866161243,
0.00784002215198,
0.00877322189116,
0.00890205340019
};
D tc_6[] = {
21.3521717149, 0.151475569004,
18.7575802784, 0.973127075642,
-16.7747915935, 0.186389191451,
13.6458659843, 10.2312293393,
4.03664776512, 65.9178820854,
1.94829213441, 0.0101849081957
};
D tc_5[] = {
18.1026426744, 1.00666276387,
13.6457938849, 10.371257497,
6.2933826882, 0.0713308596716,
3.94873807149, 67.7426675671,
0.981850823471, 0.0236146225411
};
D tc_4[] = {
18.1717757227, 0.997022150125,
13.622037454, 10.29238409,
7.16440540448, 0.0615853275419,
4.00834281854, 66.329347174
};
D tc_3[] = {
23.5346902744, 0.555290522238,
14.5111421298, 8.51654999704,
4.88999302843, 55.4141673419
};
D tc_2[] = {
33.4487721592, 1.74017675273,
9.37181483324, 32.2433865902
};
D tc_1[] = {
42.7322347753, 7.21233503359
};
D* tc_c[] = { tc_6, tc_5, tc_4, tc_3, tc_2, tc_1 };

D ru_s[] = { 6.0, 4.0, 4.0, 1.2, 0.5, 0.17 };
D ru_e[] = {
0.00239954045399,
0.00365574394259,
0.00417589028671,
0.00813501270095,
0.00886595773831,
0.00935917217461
};
D ru_6[] = {
20.3208376077, 0.866135644103,
15.0281212521, 9.95345986685,
7.13685052856, 0.0967401516457,
3.73187622427, 54.3141277003,
-3.62388095074, 0.397131691008,
1.36674557919, 0.00243842425016
};
D ru_5[] = {
18.2024800815, 0.930236515906,
15.0117001994, 10.1620985037,
7.1368006832, 0.0587887074235,
3.58736281075, 55.9969586945,
0.0244168512596, 4.84475486034e-05
};
D ru_4[] = {
18.2041670551, 0.928515517055,
15.0408027844, 10.1620985037,
7.14877642632, 0.0583722740779,
3.57215593516, 56.4987498394
};
D ru_3[] = {
23.122417304, 0.497739492816,
14.8125929435, 7.50901560896,
5.95928154858, 36.7823648354
};
D ru_2[] = {
32.5815612902, 1.48680706354,
11.2420276439, 24.076062776
};
D ru_1[] = {
43.7196180164, 6.2849315349
};
D* ru_c[] = { ru_6, ru_5, ru_4, ru_3, ru_2, ru_1 };

D rh_s[] = { 6.0, 4.0, 4.0, 1.2, 0.5, 0.18 };
D rh_e[] = {
0.00264859444159,
0.00291946907399,
0.00410135770157,
0.00677260789679,
0.00819331452009,
0.00992459582602
};
D rh_6[] = {
22.9826093228, 0.152403487568,
-19.7249633508, 0.19089770637,
19.5493479431, 0.807213184465,
16.0882138247, 9.37855020089,
3.76449689499, 50.4790346005,
2.29928656969, 0.0128801763867
};
D rh_5[] = {
40.0550504215, 0.749334696179,
-22.1870270075, 0.670020301645,
16.0891533377, 9.38619966299,
7.24382914488, 0.0564308736081,
3.75812509931, 50.5476884709
};
D rh_4[] = {
18.2210574506, 0.864996637224,
16.3192166011, 9.77855416159,
7.12382764354, 0.0554598833646,
3.33926694172, 58.6124107502
};
D rh_3[] = {
23.3012159473, 0.473398855106,
15.9533741871, 7.49282025419,
5.6515846267, 36.2469928289
};
D rh_2[] = {
33.2607585933, 1.4864723274,
11.572283256, 22.7220956286
};
D rh_1[] = {
44.7004804223, 5.93248940065
};
D* rh_c[] = { rh_6, rh_5, rh_4, rh_3, rh_2, rh_1 };

D pd_s[] = { 6.0, 4.0, 4.0, 1.3, 0.65, 0.2 };
D pd_e[] = {
0.00158899651144,
0.00197122505991,
0.00939692786965,
0.0058551425383,
0.00999573303073,
0.00890563746125
};
D pd_6[] = {
39.8870557767, 0.626512069265,
-23.7017223859, 0.497307679552,
16.5938194628, 8.50121609214,
7.06083385834, 0.0908379068446,
4.60293011407, 33.2430826626,
1.53956827467, 0.00456639450764
};
D pd_5[] = {
154.111871675, 0.984115874331,
-136.642775215, 1.01558394131,
16.6539060559, 8.38348616505,
7.14346270448, 0.0526615681183,
4.71505034106, 32.8059572898
};
D pd_4[] = {
18.1703887225, 0.78641825968,
16.9879488494, 8.95591184824,
6.93107165155, 0.0500994392411,
3.91079036031, 37.5057834319
};
D pd_3[] = {
22.7629045939, 0.423182233992,
14.6226398022, 6.12063761773,
8.54242304795, 22.660232699
};
D pd_2[] = {
29.6043096176, 0.933315857251,
16.2296755103, 15.1940642305
};
D pd_1[] = {
45.7503424041, 5.33851037453
};
D* pd_c[] = { pd_6, pd_5, pd_4, pd_3, pd_2, pd_1 };

D ag_s[] = { 6.0, 4.0, 4.0, 1.3, 0.55, 0.19 };
D ag_e[] = {
0.00310715273264,
0.00338734705759,
0.00914352313392,
0.00864771230529,
0.00931002357814,
0.00951490820175
};
D ag_6[] = {
35.6803520737, 0.591008513418,
-19.9951000873, 0.441699712844,
18.2913213872, 8.2413015584,
6.7533476488, 0.102707519257,
3.86861993254, 43.7112679159,
2.35621014645, 0.0131844545605
};
D ag_5[] = {
55.7217916187, 0.609692377373,
-38.1286111093, 0.554704224089,
18.3178085738, 8.33393101093,
7.29373999187, 0.0514182992985,
3.75482667586, 44.9519519601
};
D ag_4[] = {
18.2217246207, 8.42699145722,
18.1660814635, 0.730536329344,
6.86960082665, 0.0470424905849,
3.70074112493, 45.1828459129
};
D ag_3[] = {
23.3122067553, 0.414662819069,
18.4080605903, 7.07241088531,
5.20642112685, 34.9460945594
};
D ag_2[] = {
33.3268772567, 1.29436525052,
13.4834448837, 18.3147170373
};
D ag_1[] = {
46.7035926735, 5.43095277676
};
D* ag_c[] = { ag_6, ag_5, ag_4, ag_3, ag_2, ag_1 };

D cd_s[] = { 6.0, 5.0, 3.5, 1.4, 0.5, 0.18 };
D cd_e[] = {
0.00333269696097,
0.0083306136274,
0.00707239752779,
0.00981395365859,
0.00843661408651,
0.00933144431572
};
D cd_6[] = {
43.3140287834, 0.541492030264,
-27.1571474594, 0.441675332866,
19.0279627014, 7.60051103705,
6.82816303055, 0.0827958141305,
4.25017985492, 47.2959211639,
1.69299459365, 0.00630439426309
};
D cd_5[] = {
19.2737326752, 8.05021223028,
18.0754749336, 0.696241434133,
6.43914911214, 0.0527274691727,
3.66206008519, 59.0588627072,
0.586314031186, 0.000234203420665
};
D cd_4[] = {
18.9612657206, 7.7044375212,
18.1361345173, 0.672460321513,
6.71328347815, 0.0422735232998,
4.15351251571, 48.5867151418
};
D cd_3[] = {
22.9961521829, 0.378523645723,
19.1440914287, 6.39052944494,
5.75799203993, 35.7007532116
};
D cd_2[] = {
36.6901177217, 1.60905970342,
11.1366912682, 22.9461141438
};
D cd_1[] = {
47.6995812609, 5.62610954324
};
D* cd_c[] = { cd_6, cd_5, cd_4, cd_3, cd_2, cd_1 };

D in_s[] = { 6.0, 5.0, 5.0, 1.4, 0.48, 0.17 };
D in_e[] = {
0.00412659989792,
0.0087118648736,
0.00940049684148,
0.00925704991635,
0.00876163377675,
0.00969238783527
};
D in_6[] = {
22.1657097372, 0.562854586336,
19.7053877533, 7.04845972369,
-8.53990157481, 0.250120803362,
8.3385537672, 0.106729621627,
4.63122372548, 52.8793854965,
2.64208747304, 0.0144716997457
};
D in_5[] = {
19.3550049958, 7.1453314629,
18.0804495958, 0.637593543216,
6.78892390259, 0.0417864465044,
4.15296514693, 45.1707909995,
0.62580059282, 164.365365713
};
D in_4[] = {
19.5709540709, 7.18754979498,
18.063717017, 0.637593543216,
6.79356003558, 0.0417864465044,
4.51932795943, 54.1673545474
};
D in_3[] = {
23.1150202427, 0.361318740795,
20.2733776757, 6.21302979882,
5.50800401336, 43.859239884
};
D in_2[] = {
39.0476264996, 1.78786275224,
9.76445896246, 28.2404216143
};
D in_1[] = {
48.6709220774, 5.92772418661
};
D* in_c[] = { in_6, in_5, in_4, in_3, in_2, in_1 };

D sn_s[] = { 6.0, 5.0, 3.5, 1.4, 0.48, 0.16 };
D sn_e[] = {
0.00407298057071,
0.00718497266875,
0.0085733244785,
0.00767944156683,
0.00855856334234,
0.00867647337271
};
D sn_6[] = {
-60.8006570888, 0.170523764181,
59.6799250354, 0.152781761614,
22.4721071534, 0.512782420575,
20.0502830075, 6.37087893451,
5.51115486449, 50.5413231976,
3.03126849864, 0.0156661382457
};
D sn_5[] = {
58.8340511498, 0.704612458222,
-41.3744442789, 0.763860432499,
20.11483798, 6.36358904568,
6.86560677083, 0.0405620900785,
5.50512923054, 50.6560105834
};
D sn_4[] = {
19.9952246314, 6.43896084234,
18.1087065659, 0.574695348995,
6.4117143787, 0.0343137850643,
5.43550334104, 51.529812741
};
D sn_3[] = {
23.073115678, 0.341229928758,
20.721043971, 5.77195480985,
6.11619707401, 45.0386050033
};
D sn_2[] = {
40.1093893081, 1.78792124312,
9.71449502171, 30.8280279167
};
D sn_1[] = {
49.7004623614, 6.2748102914
};
D* sn_c[] = { sn_6, sn_5, sn_4, sn_3, sn_2, sn_1 };

D sb_s[] = { 6.0, 5.0, 3.5, 1.5, 0.5, 0.16 };
D sb_e[] = {
0.00357245678043,
0.0051513282733,
0.00941620492915,
0.00792064420944,
0.00892602076893,
0.00854551950608
};
D sb_6[] = {
162.293224248, 0.361618002738,
-153.299606964, 0.333208062641,
20.3177180414, 5.70949598696,
11.2095741918, 0.142472983863,
6.57735043072, 46.0358157978,
3.85133379761, 0.0204436505074
};
D sb_5[] = {
171.96900568, 0.694125011617,
-154.833627419, 0.71436852774,
20.398862485, 5.69481591031,
6.83216173118, 0.0383965255484,
6.58310207273, 45.9963598709
};
D sb_4[] = {
20.0568373898, 5.85889464738,
17.8145348384, 0.548389983717,
6.63082605442, 0.0365995215138,
6.45216458604, 46.8970867425
};
D sb_3[] = {
22.7485769177, 0.312929289314,
21.0063112152, 5.18082235944,
7.16102625262, 41.8483442701
};
D sb_2[] = {
40.3668479835, 1.67754651195,
10.4626958439, 30.3947364154
};
D sb_1[] = {
50.7056166486, 6.39583632796
};
D* sb_c[] = { sb_6, sb_5, sb_4, sb_3, sb_2, sb_1 };

D te_s[] = { 6.0, 5.0, 3.0, 1.6, 0.5, 0.17 };
D te_e[] = {
0.00339770264071,
0.00442488181536,
0.0052444280839,
0.00820400307575,
0.00755295813415,
0.00990635445282
};
D te_6[] = {
-1862.15407356, 0.265532855658,
1200.76810786, 0.280766929412,
680.720528627, 0.243456005018,
20.4542873243, 5.15554967652,
7.69642125993, 41.4879536422,
4.46627374474, 0.0227459435725
};
D te_5[] = {
1199.46446151, 0.682683239349,
-1182.7371369, 0.685823343654,
20.6441520037, 5.10332755071,
7.73809217968, 41.2639837408,
6.84046214922, 0.0368293568221
};
D te_4[] = {
20.3585530696, 5.17105927475,
18.5823286934, 0.465577168657,
7.69573049839, 41.4617805212,
5.31406716504, 0.0118178192857
};
D te_3[] = {
22.4342311303, 0.28840668083,
21.2105816232, 4.66744106421,
8.27410663564, 38.2957918128
};
D te_2[] = {
40.8130570602, 1.61660208865,
11.0432771598, 30.3369215116
};
D te_1[] = {
51.6632105532, 6.27525342766
};
D* te_c[] = { te_6, te_5, te_4, te_3, te_2, te_1 };

D i_s[] = { 6.0, 5.0, 3.0, 1.7, 0.55, 0.17 };
D i_e[] = {
0.00472567188756,
0.00416698599005,
0.00444038264504,
0.00852684523642,
0.00956439232295,
0.00924429965406
};
D i_6[] = {
-2577.6661171, 0.243508875603,
1745.23093576, 0.254581895705,
851.731195352, 0.224353557197,
20.4992769754, 4.65171049937,
8.89110614762, 37.0481674283,
4.26698582529, 0.0206993418778
};
D i_5[] = {
1743.75431008, 0.654371114377,
-1727.41168754, 0.656662778771,
20.836372554, 4.57238808975,
8.9528540963, 36.8163822773,
6.81958331695, 0.0350752153117
};
D i_4[] = {
20.4260830954, 4.65757773783,
18.6962583512, 0.423783993144,
8.89470721278, 37.0034255701,
4.93452444616, 0.00470506653655
};
D i_3[] = {
22.1334760622, 0.265661657324,
21.3152722398, 4.19946212892,
9.47258237105, 34.5739885559
};
D i_2[] = {
40.2681891358, 1.42647377126,
12.5650100309, 27.0211469354
};
D i_1[] = {
52.6844484255, 6.30156628153
};
D* i_c[] = { i_6, i_5, i_4, i_3, i_2, i_1 };

D xe_s[] = { 6.0, 5.0, 3.5, 1.8, 0.55, 0.17 };
D xe_e[] = {
0.00614155596635,
0.00428612509547,
0.00862139026039,
0.00898412604566,
0.0078837691759,
0.00853291374084
};
D xe_6[] = {
-3898.74992842, 0.210914935946,
3335.7418498, 0.206797361993,
582.485996998, 0.239647677899,
20.5226417357, 4.21665769454,
10.1014750651, 33.3072484077,
3.85162531439, 0.0173218909818
};
D xe_5[] = {
580.736623891, 0.625646458828,
-564.756799036, 0.632897537466,
21.0480721422, 4.13858816546,
10.1242005351, 33.3667543221,
6.80576049633, 0.0334828449635
};
D xe_4[] = {
20.2479154546, 4.31589168094,
17.6767526317, 0.429861225039,
9.9932268949, 33.6365828724,
6.03920879618, 0.0250596499773
};
D xe_3[] = {
21.8411079371, 0.245775394234,
21.3868466973, 3.79473697198,
10.6938907155, 31.3171324821
};
D xe_2[] = {
40.5118924702, 1.36158496012,
13.3475681124, 26.1028010964
};
D xe_1[] = {
53.7062100789, 6.29786570461
};
D* xe_c[] = { xe_6, xe_5, xe_4, xe_3, xe_2, xe_1 };

D cs_s[] = { 6.0, 5.0, 3.5, 1.5, 0.5, 0.15 };
D cs_e[] = {
0.00769416141987,
0.00795113675835,
0.00665376369184,
0.00953118858103,
0.00926919514614,
0.00978039144361
};
D cs_6[] = {
22.3779274151, 0.369243928628,
20.9109171245, 4.19169862173,
-12.611295402, 0.152720951813,
12.1989059946, 0.0793728666631,
9.99559764409, 34.0101067336,
1.79111065557, 0.00338395546268
};
D cs_5[] = {
32.5794889693, 0.35206977481,
20.9041666773, 4.19444786667,
-16.1033217035, 0.273168909253,
9.99229092671, 34.0212386868,
7.29067694924, 0.0347806612779
};
D cs_4[] = {
20.8566175196, 4.20830336892,
18.0204957202, 0.405538495428,
9.9778134692, 34.0694848166,
5.80893076385, 0.0202963209874
};
D cs_3[] = {
22.8179575499, 0.259744914265,
21.6168657338, 3.9855472225,
10.2194107472, 33.2798098986
};
D cs_2[] = {
42.5516446431, 1.51952150639,
12.1282677432, 30.2869121302
};
D cs_1[] = {
54.569814547, 6.80000405102
};
D* cs_c[] = { cs_6, cs_5, cs_4, cs_3, cs_2, cs_1 };

D ba_s[] = { 6.0, 3.5, 2.0, 0.8, 0.4, 0.13 };
D ba_e[] = {
0.00988707503434,
0.0086398226671,
0.00800476883784,
0.00843124077086,
0.00935072270832,
0.00929348551668
};
D ba_6[] = {
26.9940512618, 2.89406266357,
19.447508401, 0.438241162869,
10.9842302406, 20.6864927375,
-10.604348019, 1.5723150737,
6.59093650494, 0.0291869832178,
2.56842755727, 170.771966995
};
D ba_5[] = {
20.0272629743, 3.47450702494,
18.1825388421, 0.346124826967,
10.1491406052, 21.1181994124,
4.82533338006, 0.00566003600568,
2.7637056092, 147.264543686
};
D ba_4[] = {
21.0944395639, 0.20912553582,
20.5994141888, 2.95613553749,
11.4472186126, 18.85195561,
2.86221211171, 161.054061854
};
D ba_3[] = {
34.7609654622, 0.761795076118,
16.4611270654, 10.7352763157,
4.65258742134, 90.2140100279
};
D ba_2[] = {
46.6944387421, 2.07616488777,
9.0098505593, 47.0403145067
};
D ba_1[] = {
55.5934374733, 7.84715456318
};
D* ba_c[] = { ba_6, ba_5, ba_4, ba_3, ba_2, ba_1 };

D la_s[] = { 6.0, 3.5, 2.0, 0.8, 0.42, 0.13 };
D la_e[] = {
0.00846933415167,
0.00838318255973,
0.0038094696517,
0.00701357216391,
0.00981595159893,
0.00880239850635
};
D la_6[] = {
25.8054917326, 2.64715754727,
20.8966000064, 0.433890185516,
11.6100821709, 18.6672035543,
-11.212484664, 1.23455118169,
6.65008811143, 0.0284237808379,
3.24428132467, 137.836455293
};
D la_5[] = {
20.1789191691, 3.17304707303,
18.2832751171, 0.316235141042,
11.0627211245, 20.1162719158,
4.44208883839, 2.03749250637e-05,
3.03730669, 145.684420101
};
D la_4[] = {
20.9015631195, 0.196792289288,
19.8738576589, 2.64285629149,
11.4835115412, 14.5861137514,
4.6283147692, 88.5935258907
};
D la_3[] = {
35.298101035, 0.748911322219,
16.3784006874, 10.5711423577,
5.21732437386, 83.4097120602
};
D la_2[] = {
46.6508769587, 1.92352526336,
10.0549791705, 43.8147639096
};
D la_1[] = {
56.6182085397, 8.01193054571
};
D* la_c[] = { la_6, la_5, la_4, la_3, la_2, la_1 };

D ce_s[] = { 6.0, 3.0, 2.0, 0.9, 0.42, 0.13 };
D ce_e[] = {
0.00614561283207,
0.00972844216969,
0.00277720046536,
0.00957342619547,
0.00942707571503,
0.00831204388981
};
D ce_6[] = {
25.7592696089, 0.45127114261,
24.3892573772, 2.59082178436,
-14.2758045612, 0.88296981422,
12.0440369027, 17.4474579491,
6.73991930441, 0.0278359255692,
3.32591547702, 127.859469646
};
D ce_5[] = {
20.8768898047, 3.14075182756,
18.006322762, 0.31582496156,
11.2668059991, 19.8898642833,
4.95573083174, 0.00897420792869,
2.87434882147, 143.620797979
};
D ce_4[] = {
20.9643441885, 0.189105227817,
20.6438488133, 2.5884903572,
12.0262837675, 14.7054628811,
4.27574280974, 93.8232873758
};
D ce_3[] = {
33.9408133443, 0.6364666144,
17.9459455785, 8.69495587947,
5.96576714084, 69.5737589899
};
D ce_2[] = {
47.6950602334, 1.92740707671,
10.0171575837, 42.8149455032
};
D ce_1[] = {
57.6326266364, 7.78470449354
};
D* ce_c[] = { ce_6, ce_5, ce_4, ce_3, ce_2, ce_1 };

D pr_s[] = { 6.0, 3.0, 2.0, 0.9, 0.45, 0.14 };
D pr_e[] = {
0.0050303281629,
0.00923904245895,
0.00231466135643,
0.00987097002879,
0.00994566660978,
0.0093945533364
};
D pr_6[] = {
30.2562666961, 2.31243886511,
22.7183602375, 0.418958746281,
-16.5745293068, 1.13000275545,
12.9252927257, 16.0688568634,
6.74866158754, 0.0268151828942,
2.90411773416, 139.83432307
};
D pr_5[] = {
21.773682134, 3.01568419345,
18.3721145571, 0.290461277312,
11.8333950891, 18.1167891528,
4.42215650198, 0.000414376213777,
2.58652486617, 156.000911548
};
D pr_4[] = {
21.7123955502, 2.58417218699,
21.0754028886, 0.182872920265,
12.7336559373, 14.7822841209,
3.40122332392, 110.143811546
};
D pr_3[] = {
34.7138344685, 0.644144322647,
19.0120594982, 8.7343974981,
5.11861495935, 72.9483618924
};
D pr_2[] = {
48.1477656125, 1.79053711109,
10.498785153, 36.1327797176
};
D pr_1[] = {
58.569782832, 6.92348676789
};
D* pr_c[] = { pr_6, pr_5, pr_4, pr_3, pr_2, pr_1 };

D nd_s[] = { 6.0, 3.0, 2.0, 0.9, 0.46, 0.14 };
D nd_e[] = {
0.00417889237646,
0.00842950022314,
0.0016019575124,
0.00937541827098,
0.00989178914561,
0.00894432184537
};
D nd_6[] = {
75.1747685999, 0.487057307612,
-62.35530919, 0.56933223008,
24.6428651155, 2.53109284867,
12.8979969244, 15.9237344541,
6.81059144951, 0.0261326907995,
2.81162595056, 140.695116961
};
D nd_5[] = {
22.6276492772, 2.94770166306,
18.2244011335, 0.282617064885,
12.0337409153, 17.8777444144,
4.64608736505, 0.0045530637355,
2.46795960615, 163.572190088
};
D nd_4[] = {
22.4082854635, 2.50181845842,
21.0775859349, 0.175289335371,
13.1736543953, 14.3792228887,
3.27601898413, 113.062449517
};
D nd_3[] = {
35.4389476948, 0.646208144879,
19.4667421022, 8.6566708759,
4.9468773747, 73.3893256206
};
D nd_2[] = {
48.9286192001, 1.74462339315,
10.7107303488, 34.3371813548
};
D nd_1[] = {
59.582934423, 6.73248114978
};
D* nd_c[] = { nd_6, nd_5, nd_4, nd_3, nd_2, nd_1 };

D pm_s[] = { 6.0, 3.0, 2.0, 0.9, 0.46, 0.15 };
D pm_e[] = {
0.00268692575661,
0.00775491046912,
0.0012719391839,
0.00889448992478,
0.00957242355684,
0.0099605078614
};
D pm_6[] = {
29.6331890023, 0.413504425411,
26.3078050643, 2.36219022007,
-17.9986078492, 0.708464586253,
13.3935788272, 14.9550394642,
6.78107681524, 0.0249489949768,
2.86135747721, 134.032081795
};
D pm_5[] = {
23.3444397684, 2.82152921359,
18.2898912949, 0.267171949393,
12.3712132262, 16.9286675924,
4.49181351104, 0.00205475117837,
2.49962929351, 156.063786707
};
D pm_4[] = {
23.2525253153, 2.44573424133,
21.11082285, 0.168545627481,
13.4036242053, 14.1024301008,
3.17522481325, 114.119212907
};
D pm_3[] = {
36.1702196099, 0.647743429157,
19.8955538505, 8.55074709176,
4.79397878053, 73.713195953
};
D pm_2[] = {
50.0438656995, 1.74546108388,
10.602181952, 33.828728046
};
D pm_1[] = {
60.5304311959, 6.27372308359
};
D* pm_c[] = { pm_6, pm_5, pm_4, pm_3, pm_2, pm_1 };

D sm_s[] = { 6.0, 4.0, 2.0, 0.9, 0.46, 0.15 };
D sm_e[] = {
0.00203861609369,
0.00986775122202,
0.000969844029643,
0.00842538217186,
0.00925552578057,
0.00952013935298
};
D sm_6[] = {
32.2984149625, 0.399394086949,
26.3429700657, 2.32380416423,
-19.9136004053, 0.625516473774,
13.6425912693, 14.3637058751,
6.74529686761, 0.0237454480136,
2.86214070124, 130.37065237
};
D sm_5[] = {
23.8441623593, 2.66585947516,
18.1172765366, 0.254781328358,
12.8615344246, 15.5313311382,
4.52305723827, 0.00172933088813,
2.64255593557, 142.901235787
};
D sm_4[] = {
24.0330206155, 2.37766759733,
21.1216525174, 0.161944674816,
13.6752857492, 13.6865884687,
3.11723038438, 113.92693454
};
D sm_3[] = {
36.9183414503, 0.649126169356,
20.2958684511, 8.43192523404,
4.65266856191, 74.0664253574
};
D sm_2[] = {
51.1800594126, 1.74481883041,
10.4729269653, 33.4115753664
};
D sm_1[] = {
61.5433975959, 6.10309445109
};
D* sm_c[] = { sm_6, sm_5, sm_4, sm_3, sm_2, sm_1 };

D eu_s[] = { 6.0, 4.0, 2.0, 0.9, 0.46, 0.15 };
D eu_e[] = {
0.00248665120675,
0.00763072406122,
0.000966976473259,
0.00794503507894,
0.0089380299378,
0.00909384205164
};
D eu_6[] = {
27.6776388667, 2.2194475922,
23.0431267036, 0.345901758621,
13.9956556653, 13.7192179825,
-11.2783099555, 0.757520818595,
6.65526282644, 0.0224176169314,
2.88305719547, 125.813689355
};
D eu_5[] = {
24.7169028793, 2.61460702741,
17.7677777034, 0.252747662611,
12.8823392063, 15.2450230519,
4.9879510981, 0.00777771192231,
2.62762445797, 136.905620758
};
D eu_4[] = {
24.7859364884, 2.31378498765,
21.1563664736, 0.156096113434,
13.9314054154, 13.2838341595,
3.07737834557, 112.910597472
};
D eu_3[] = {
37.6669662037, 0.64963247348,
20.669373732, 8.30614260456,
4.53727770627, 74.1414627045
};
D eu_2[] = {
52.3105705666, 1.74206426177,
10.3502310749, 33.0422609993
};
D eu_1[] = {
62.5566539266, 5.94431634966
};
D* eu_c[] = { eu_6, eu_5, eu_4, eu_3, eu_2, eu_1 };

D gd_s[] = { 6.0, 4.0, 2.0, 0.9, 0.46, 0.15 };
D gd_e[] = {
0.00568838575539,
0.00966407384026,
0.000837193867467,
0.00686020792178,
0.00862175879825,
0.00888401638689
};
D gd_6[] = {
31.9166487233, 0.356271818554,
27.5121570972, 2.07315238595,
-19.9045044626, 0.5624846004,
14.2360930165, 12.6137223615,
6.60706800351, 0.0212011605491,
3.59490109518, 99.7474162763
};
D gd_5[] = {
25.1894374613, 2.43472851436,
18.0450089226, 0.229724775998,
13.098986784, 14.2640740023,
4.40454288253, 0.000887642126485,
3.23355042973, 108.834559243
};
D gd_4[] = {
25.2144488462, 2.19290838634,
21.0490281412, 0.1485343624,
13.9869599506, 12.5338890614,
3.69929375007, 95.2683337839
};
D gd_3[] = {
38.2672888055, 0.641925916443,
20.53429285, 8.03856392974,
5.08823597232, 69.4395614399
};
D gd_2[] = {
53.2038651293, 1.72546108609,
10.4867319554, 34.3640292703
};
D gd_1[] = {
63.5710856102, 6.02891058364
};
D* gd_c[] = { gd_6, gd_5, gd_4, gd_3, gd_2, gd_1 };

D tb_s[] = { 6.0, 3.0, 2.5, 0.9, 0.48, 0.16 };
D tb_e[] = {
0.00795683206807,
0.00111071867486,
0.00998756985625,
0.00711265562772,
0.00957005320292,
0.00960379765886
};
D tb_6[] = {
58.8830617207, 0.384014260993,
-47.6191909942, 0.479766420563,
28.4986728201, 1.96027388479,
15.1503921071, 11.6625629031,
6.79694932878, 0.0213998914293,
3.23065466387, 101.528227275
};
D tb_5[] = {
25.8777866986, 2.28849755415,
15.4773121961, 0.231870250173,
14.1528221668, 13.0068621677,
6.62882733311, 0.0345349810668,
2.83753582638, 121.220124915
};
D tb_4[] = {
25.7211570587, 1.99100333986,
20.3559514241, 0.132503172245,
15.535281259, 11.2294785241,
3.33186735804, 100.037890306
};
D tb_3[] = {
39.2328707128, 0.650991514953,
21.3321948635, 8.0518651764,
4.31969753733, 74.3439216467
};
D tb_2[] = {
54.0128148863, 1.65715498819,
10.6366367413, 30.4260604361
};
D tb_1[] = {
64.5179352065, 5.42366375199
};
D* tb_c[] = { tb_6, tb_5, tb_4, tb_3, tb_2, tb_1 };

D dy_s[] = { 6.0, 3.0, 2.5, 0.9, 0.48, 0.16 };
D dy_e[] = {
0.00936902185314,
0.00131222820408,
0.00977628587931,
0.00670251991613,
0.00923723887685,
0.00921132073283
};
D dy_6[] = {
34.7943180001, 0.328018140694,
28.7721920077, 1.96055302804,
-22.4697366556, 0.483932800866,
15.2162955838, 11.6062633374,
6.54413250411, 0.0193134367306,
3.09742094323, 105.356980847
};
D dy_5[] = {
26.4606422768, 2.23898580469,
14.286558338, 12.5930263953,
12.0270465636, 0.07266731782,
10.3441811796, 0.296720456235,
2.85350811014, 116.549664994
};
D dy_4[] = {
26.5027640731, 1.94484893631,
20.3829365102, 0.127701195669,
15.6033292372, 10.7965415259,
3.43085942316, 90.8690665514
};
D dy_3[] = {
40.0351781924, 0.651155697371,
21.6293633913, 7.91850437368,
4.22519686664, 74.323902512
};
D dy_2[] = {
55.1678872168, 1.65119454513,
10.4886218973, 30.1723085482
};
D dy_1[] = {
65.5299079924, 5.28447156164
};
D* dy_c[] = { dy_6, dy_5, dy_4, dy_3, dy_2, dy_1 };

D ho_s[] = { 6.0, 3.0, 2.5, 1.0, 0.48, 0.16 };
D ho_e[] = {
0.0100336744546,
0.00118701855347,
0.00781377950806,
0.00877404420056,
0.00903636042777,
0.00918009182021
};
D ho_6[] = {
32.3954950214, 1.737293232,
21.8110303556, 0.276795499743,
15.5701535461, 10.6307422208,
-13.0609144108, 0.716644548388,
6.39624846101, 0.0177934041961,
3.83880975541, 87.3695438106
};
D ho_5[] = {
26.4063423374, 2.14258875328,
16.4446055615, 0.0945513588798,
14.2784317858, 11.7169461616,
6.26135533639, 0.426890917246,
3.57031966283, 93.6663327612
};
D ho_4[] = {
27.0337491596, 1.86711597265,
20.3457758481, 0.122565699828,
15.4897236519, 10.2862871302,
4.05942858389, 80.6568822974
};
D ho_3[] = {
38.3932404839, 0.559517372689,
22.9127027568, 6.61024638922,
5.55506664698, 58.6150191714
};
D ho_2[] = {
56.1541146946, 1.63848351534,
10.5310021752, 31.8285319406
};
D ho_1[] = {
66.5384221334, 5.36863492488
};
D* ho_c[] = { ho_6, ho_5, ho_4, ho_3, ho_2, ho_1 };

D er_s[] = { 6.0, 3.0, 2.5, 1.0, 0.5, 0.17 };
D er_e[] = {
0.00899480013708,
0.00107368568089,
0.00697025500645,
0.00908375687469,
0.00945963834527,
0.00965839437786
};
D er_6[] = {
30.9887856969, 1.80752987539,
23.3010447409, 0.271239744195,
15.8998599329, 10.7404474066,
-11.7203542903, 0.573289319571,
6.38847244267, 0.0170318600799,
3.1011323909, 101.370736539
};
D er_5[] = {
27.0146070511, 2.12522747052,
17.4691119546, 0.0967084133986,
14.7747465616, 11.4494268934,
5.70786189129, 0.503753622572,
2.98858738866, 103.291828855
};
D er_4[] = {
27.8321252948, 1.82074449148,
20.3544131156, 0.118356868658,
16.3810901226, 10.0352134789,
3.37601836993, 91.7454535809
};
D er_3[] = {
39.4031324078, 0.568356523176,
23.6640665687, 6.65462403572,
4.78377747874, 60.7166784997
};
D er_2[] = {
56.8587003605, 1.56547033011,
10.7854485395, 27.8170919375
};
D er_1[] = {
67.4929396173, 4.84387378532
};
D* er_c[] = { er_6, er_5, er_4, er_3, er_2, er_1 };

D tm_s[] = { 6.0, 3.0, 2.5, 1.0, 0.5, 0.17 };
D tm_e[] = {
0.0087953485775,
0.00128596620889,
0.00665636370879,
0.00865826765936,
0.00914088348511,
0.00929596259832
};
D tm_6[] = {
106.081526006, 0.314910520834,
-92.8867141876, 0.346585570428,
30.2535142513, 1.81539231381,
15.9782690255, 10.4196582511,
6.40422975625, 0.0164278772413,
3.11856307792, 96.8865150605
};
D tm_5[] = {
27.5481869308, 2.07914820004,
17.9063609986, 0.0958731181922,
14.9450340645, 11.1522830584,
5.60009481411, 0.543289243478,
2.95862861308, 102.550218621
};
D tm_4[] = {
28.7328433548, 1.78382754785,
20.397868458, 0.114611364301,
16.499937045, 9.86166051007,
3.31496208224, 91.3602869475
};
D tm_3[] = {
40.2446544325, 0.569898365182,
23.9351735514, 6.56519059712,
4.67702355954, 60.8164738353
};
D tm_2[] = {
58.0236868961, 1.55727451846,
10.6274763222, 27.6331524347
};
D tm_1[] = {
68.5046303825, 4.72384468522
};
D* tm_c[] = { tm_6, tm_5, tm_4, tm_3, tm_2, tm_1 };

D yb_s[] = { 6.0, 3.5, 3.0, 1.0, 0.5, 0.17 };
D yb_e[] = {
0.00865073809173,
0.00985940956809,
0.0082281229687,
0.00822403066555,
0.00882845257011,
0.00894433090448
};
D yb_6[] = {
32.2147941813, 1.71003309839,
27.0258122387, 0.268350966596,
16.4026039327, 10.0472464063,
-15.3401233016, 0.477295913815,
6.55417889942, 0.0167524785225,
3.10036111748, 96.8177154642
};
D yb_5[] = {
29.9393600516, 1.96277959486,
17.2215077886, 0.17839896488,
15.1581911702, 11.03514727,
4.81313034687, 0.00977702448247,
2.84746989463, 107.728615749
};
D yb_4[] = {
28.3470464476, 1.63326651873,
19.9787729285, 0.105601631353,
17.2390972232, 8.22123925174,
4.27286449649, 60.7342252993
};
D yb_3[] = {
41.0953828041, 0.571041172208,
24.1853459796, 6.47259332266,
4.58124621111, 60.8047334141
};
D yb_2[] = {
59.1916873229, 1.54810590343,
10.4664363106, 27.4722289131
};
D yb_1[] = {
69.5158756016, 4.60741842832
};
D* yb_c[] = { yb_6, yb_5, yb_4, yb_3, yb_2, yb_1 };

D lu_s[] = { 6.0, 3.5, 3.0, 1.0, 0.5, 0.17 };
D lu_e[] = {
0.00892600798361,
0.00861154076715,
0.00546636805793,
0.00710131499071,
0.00880977447836,
0.00913890352045
};
D lu_6[] = {
32.5540589918, 0.261192648017,
31.7345373829, 1.68622303412,
-19.5997330686, 0.386727188442,
16.1020255104, 9.55928083031,
6.38685746553, 0.0152385869663,
3.78075940673, 83.2831205709
};
D lu_5[] = {
30.7258158926, 1.8758931628,
17.094612878, 0.168984394931,
15.1991194251, 10.8544917538,
4.78201066354, 0.0105992802354,
3.23437289552, 107.587998175
};
D lu_4[] = {
28.7314606766, 1.56308520084,
19.9378752755, 0.101900320967,
17.3114915622, 7.78350993621,
4.88323956783, 59.280364015
};
D lu_3[] = {
41.6792603844, 0.563194429806,
24.036633249, 6.22067541699,
5.16621739146, 58.898193346
};
D lu_2[] = {
60.282469656, 1.53930500775,
10.4002911163, 29.5603765496
};
D lu_1[] = {
70.5135085506, 4.6955017242
};
D* lu_c[] = { lu_6, lu_5, lu_4, lu_3, lu_2, lu_1 };

D hf_s[] = { 6.0, 3.5, 3.0, 1.1, 0.5, 0.17 };
D hf_e[] = {
0.0080136096273,
0.00752635748788,
0.00583953290784,
0.00918362868666,
0.00811898670786,
0.00879545491534
};
D hf_6[] = {
77.1802726657, 0.280026605138,
-64.7218870234, 0.323791542411,
31.9734536346, 1.5633359329,
16.3854033031, 8.59822684598,
6.36393379504, 0.0144486231968,
4.74405743998, 64.1863308044
};
D hf_5[] = {
31.0603694338, 1.75954111909,
17.8254583715, 0.151451040863,
15.4648749693, 10.092200047,
3.91541207688, 84.6326239636,
3.75741575617, 0.000534695573148
};
D hf_4[] = {
30.4335848116, 1.56991543077,
20.0862580202, 0.0996887469468,
16.7856294029, 8.54516825699,
4.64056806121, 67.4373411458
};
D hf_3[] = {
39.9831507751, 0.489847330914,
25.3219948989, 5.27947078072,
6.54673874356, 46.8193021086
};
D hf_2[] = {
60.9554703256, 1.50443858353,
10.7605022355, 29.7573656447
};
D hf_1[] = {
71.535795218, 4.73448674751
};
D* hf_c[] = { hf_6, hf_5, hf_4, hf_3, hf_2, hf_1 };

D ta_s[] = { 6.0, 3.5, 3.0, 1.1, 0.5, 0.18 };
D ta_e[] = {
0.00576622996829,
0.00582026475223,
0.00496744156186,
0.00828490693892,
0.00737141801276,
0.00961291837622
};
D ta_6[] = {
34.4075066399, 1.44307767804,
26.8450822663, 0.243661749198,
-16.7868488766, 0.45336841857,
16.6494354047, 8.37712491969,
6.62942444586, 0.0154330836772,
5.18816072968, 58.2600273197
};
D ta_5[] = {
31.3736983148, 1.66716931514,
17.5864239941, 0.145248788873,
15.6774539431, 9.57620216904,
4.49275934257, 69.1285550619,
3.85580465912, 0.00245463489787
};
D ta_4[] = {
31.1202408647, 1.51983931673,
20.0766975579, 0.0963214084101,
16.6326579954, 8.42941700661,
5.12088083563, 60.0286801549
};
D ta_3[] = {
40.7632693754, 0.487972100991,
24.9779770626, 5.18115010973,
7.12129748092, 43.3424677952
};
D ta_2[] = {
61.4767661944, 1.46375359558,
11.2667137015, 29.0645873738
};
D ta_1[] = {
72.4978278383, 4.58832546455
};
D* ta_c[] = { ta_6, ta_5, ta_4, ta_3, ta_2, ta_1 };

D w_s[] = { 6.0, 3.5, 3.0, 1.1, 0.55, 0.18 };
D w_e[] = {
0.00665542139274,
0.00461002045455,
0.00444802923011,
0.00758672690766,
0.00918120436032,
0.00905478593528
};
D w_6[] = {
33.9763278459, 1.44556758903,
24.6288268159, 0.219424189117,
16.5744023209, 8.64087431994,
-12.7907958718, 0.419525555753,
6.2814017138, 0.0131606474735,
5.28104528745, 56.0743413346
};
D w_5[] = {
31.7846267077, 1.58381343914,
17.6335091869, 0.136718468498,
16.0122375199, 9.29463372094,
4.89253883074, 60.6823921905,
3.64888595241, 0.00165703035782
};
D w_4[] = {
31.4668800058, 1.45915318181,
20.0682388418, 0.0932943105854,
16.5880372692, 8.08609284579,
5.79803588637, 50.6032781082
};
D w_3[] = {
41.6196167513, 0.487044940522,
24.6216219083, 5.13762255237,
7.62925242667, 40.1875550381
};
D w_2[] = {
60.5912797671, 1.30334646035,
13.1065811893, 24.6176174892
};
D w_1[] = {
73.527059185, 4.57752839666
};
D* w_c[] = { w_6, w_5, w_4, w_3, w_2, w_1 };

D re_s[] = { 6.0, 3.5, 3.0, 1.2, 0.55, 0.19 };
D re_e[] = {
0.00419372087496,
0.00387742288061,
0.00361600279772,
0.00971683668716,
0.00840008500456,
0.0098516923285
};
D re_6[] = {
35.0830315754, 1.34917064479,
29.4519966446, 0.230716084605,
-18.9006619866, 0.39164277541,
17.0420973678, 8.33176457867,
6.53797957568, 0.0137931520895,
5.73274377484, 50.3856305144
};
D re_5[] = {
32.0891608907, 1.49959090184,
17.4133299724, 0.129597681914,
16.3949439003, 8.93222288996,
5.37766466681, 53.1577034695,
3.68270224997, 0.00410943568197
};
D re_4[] = {
31.9691670269, 1.4042263502,
20.0388378078, 0.0901167539878,
16.7645635708, 8.01166460821,
6.15168017738, 46.6871207299
};
D re_3[] = {
40.0515025458, 0.428779630068,
25.7381332568, 4.44915424864,
9.05162794176, 33.744420781
};
D re_2[] = {
61.0353215362, 1.26910595531,
13.6847987174, 23.8212493417
};
D re_1[] = {
74.4889365568, 4.42623559849
};
D* re_c[] = { re_6, re_5, re_4, re_3, re_2, re_1 };

D os_s[] = { 6.0, 3.5, 3.0, 1.2, 0.6, 0.19 };
D os_e[] = {
0.00550162742147,
0.00323260279633,
0.00283967782206,
0.00901909664907,
0.0095172859086,
0.00924099877437
};
D os_6[] = {
36.6083794321, 1.29403502078,
19.9170288589, 0.186965179558,
17.3756881552, 8.35114598647,
-9.97449910746, 0.529616412143,
6.12318104912, 0.0116410937138,
5.90100514695, 47.2498125719
};
D os_5[] = {
32.6274849045, 1.45178122999,
16.7529797701, 9.06015108052,
16.0171171674, 0.133708453643,
5.436370416, 50.5293894731,
5.13282071159, 0.0176539228869
};
D os_4[] = {
32.3060904503, 1.34365021219,
19.9796191573, 0.0869397018601,
17.0866506553, 7.84212993864,
6.54902727707, 42.6569815522
};
D os_3[] = {
40.9701626063, 0.429580204696,
25.3522890946, 4.45313818662,
9.52466083248, 31.6935956143
};
D os_2[] = {
60.1427580372, 1.13660428208,
15.5355607224, 20.7122324834
};
D os_1[] = {
75.5161965832, 4.39819391471
};
D* os_c[] = { os_6, os_5, os_4, os_3, os_2, os_1 };

D ir_s[] = { 6.0, 4.0, 3.0, 1.2, 0.6, 0.2 };
D ir_e[] = {
0.00560034459069,
0.00859062774258,
0.0033234276192,
0.00842514204279,
0.00877510734624,
0.00999748293742
};
D ir_6[] = {
39.6403596751, 1.18248064084,
20.5188958396, 0.191926525942,
18.0871256717, 8.0344578267,
-14.1115546843, 0.543235504161,
6.53662253117, 0.0131934313483,
6.27566756029, 43.0347318458
};
D ir_5[] = {
32.5996264914, 1.40509089464,
17.3217981649, 8.91602806729,
17.2551003863, 0.13264740067,
5.60192604894, 46.8624180166,
4.18273550619, 0.00110262168051
};
D ir_4[] = {
32.6477109096, 1.28286429196,
19.9046099017, 0.0837397472528,
17.9175960062, 7.8851625496,
6.47496992357, 42.0532132623
};
D ir_3[] = {
41.9025653369, 0.430057433954,
25.0337657091, 4.48788197817,
9.91931850384, 29.9300953446
};
D ir_2[] = {
60.5391252413, 1.10831297268,
16.161517513, 19.949935941
};
D ir_1[] = {
76.4819590396, 4.24549203223
};
D* ir_c[] = { ir_6, ir_5, ir_4, ir_3, ir_2, ir_1 };

D pt_s[] = { 6.0, 4.0, 3.0, 1.3, 0.65, 0.2 };
D pt_e[] = {
0.004102480633,
0.00842434182734,
0.00204859032198,
0.00929491286556,
0.00850394910315,
0.00827261977465
};
D pt_6[] = {
36.0398346416, 1.19206744147,
27.6603120019, 0.202474479184,
18.7458839487, 8.24483919469,
-17.1180124906, 0.351940143809,
6.5294934061, 0.0126175040425,
6.09893957193, 37.7694108785
};
D pt_5[] = {
32.9839520034, 1.34898058134,
18.4405633491, 9.16929213475,
16.629885753, 0.131823322472,
5.13965855119, 42.5079190446,
4.77921490264, 0.00662132875008
};
D pt_4[] = {
33.3286839069, 1.24544270263,
19.8891230645, 0.0809203378286,
18.4979118387, 8.21403660509,
6.23669647954, 37.024885747
};
D pt_3[] = {
39.9472361181, 0.374935203747,
25.4673392993, 3.72595175729,
12.4217153628, 22.7724379384
};
D pt_2[] = {
59.1541682934, 0.976929225905,
18.5618954611, 16.7294577403
};
D pt_1[] = {
77.5715711168, 4.12673410379
};
D* pt_c[] = { pt_6, pt_5, pt_4, pt_3, pt_2, pt_1 };

D au_s[] = { 6.0, 4.0, 3.0, 1.3, 0.7, 0.2 };
D au_e[] = {
0.00392437513485,
0.00584932351033,
0.00196505536878,
0.00867533542728,
0.00985413635691,
0.00769646078848
};
D au_6[] = {
35.9760527014, 1.15053446035,
21.512902834, 0.172861540614,
19.5198483445, 8.15484844806,
-10.3085446771, 0.383099058737,
6.14626833932, 0.010645672412,
6.11357376008, 35.9068783738
};
D au_5[] = {
33.1587332709, 1.2709878909,
19.2169094027, 8.79115903454,
16.1504311839, 0.125240856223,
5.45012392917, 38.3671539211,
4.98838967238, 0.00947794154317
};
D au_4[] = {
33.5258156507, 1.19107393524,
19.8409104923, 0.0783119570886,
19.3445444323, 8.10732226843,
6.24590205659, 35.3010616125
};
D au_3[] = {
40.9241495287, 0.376504091449,
25.0971233279, 3.77685353526,
12.8253805725, 21.673799139
};
D au_2[] = {
58.4686800668, 0.892070840898,
20.2255909997, 15.2022600168
};
D au_1[] = {
78.5992185388, 4.07486691304
};
D* au_c[] = { au_6, au_5, au_4, au_3, au_2, au_1 };

D hg_s[] = { 6.0, 4.0, 3.5, 1.3, 0.65, 0.2 };
D hg_e[] = {
0.00333421136757,
0.00510948934102,
0.0079804721071,
0.00913581626526,
0.00860388112032,
0.00817734735641
};
D hg_6[] = {
39.997811623, 1.03470984516,
20.4948270514, 7.74711200035,
20.445530684, 0.166414469182,
-13.5705745411, 0.465937997374,
6.38874327834, 37.1597965614,
6.20105934498, 0.0104617321997
};
D hg_5[] = {
33.4991938213, 1.2002828195,
20.4512784909, 8.59193349059,
17.0233727932, 0.110415272626,
5.27060215153, 44.3282068374,
3.77446647681, 0.0011638554644
};
D hg_4[] = {
33.1565522113, 1.08760379991,
19.7313571948, 7.03697156473,
19.2900615269, 0.0716862054465,
7.74016935959, 31.7910770315
};
D hg_3[] = {
42.250520114, 0.382882567089,
25.51363075, 4.03482946811,
12.0790174828, 23.3930785954
};
D hg_2[] = {
60.5238338897, 0.959702571045,
19.1821602326, 16.4589599983
};
D hg_1[] = {
79.5674876573, 4.10057364974
};
D* hg_c[] = { hg_6, hg_5, hg_4, hg_3, hg_2, hg_1 };

D tl_s[] = { 6.0, 4.0, 3.5, 1.2, 0.6, 0.2 };
D tl_e[] = {
0.00511799969014,
0.00405090154454,
0.00668338067065,
0.00764889215786,
0.00845404379124,
0.00941720921486
};
D tl_6[] = {
40.8803342666, 1.01366176953,
21.393919793, 7.74503500567,
18.079641282, 0.139412407145,
-10.9233624301, 0.553467461207,
6.04697934279, 43.4664922619,
5.46062652885, 0.00684781160579
};
D tl_5[] = {
33.5241093541, 1.13271150395,
21.1023452316, 8.02984598338,
17.024783373, 0.103126370523,
5.76437350267, 45.2409555552,
3.53147025132, 0.000479153558957
};
D tl_4[] = {
33.7862457369, 1.06299367767,
21.1259089022, 7.38054721581,
19.3385449169, 0.0697000728686,
6.6619478826, 39.6149586967
};
D tl_3[] = {
45.6811443237, 0.429361915616,
25.8656182364, 5.07110810431,
9.31102171233, 30.8313759062
};
D tl_2[] = {
63.1492426756, 1.0640910761,
17.5286648959, 18.6332437733
};
D tl_1[] = {
80.4780516345, 4.14534912978
};
D* tl_c[] = { tl_6, tl_5, tl_4, tl_3, tl_2, tl_1 };

D pb_s[] = { 6.0, 4.0, 3.5, 1.2, 0.6, 0.19 };
D pb_e[] = {
0.00361412676401,
0.00442644375193,
0.00521107406273,
0.00730700982164,
0.00928083402772,
0.0088224833329
};
D pb_6[] = {
39.3923578085, 0.96736874328,
21.9249565944, 7.29813256829,
18.8850431065, 0.140310956469,
-10.5486598808, 0.456092797479,
6.65662737081, 43.9806471104,
5.62912936235, 0.00734129232002
};
D pb_5[] = {
33.59417541, 1.08321417312,
21.5529664268, 7.629801335,
15.7971419426, 0.104229131195,
6.31035056939, 46.2749363746,
4.69959513202, 0.010610076802
};
D pb_4[] = {
33.8187848502, 1.02172112926,
21.5254169319, 7.01653253939,
19.3495448281, 0.0676318110122,
7.21638586789, 40.3761395294
};
D pb_3[] = {
46.2716704653, 0.423453386942,
26.4475623058, 5.11201440917,
9.14991731451, 33.6941780747
};
D pb_2[] = {
64.4137173892, 1.08121021852,
17.2424097166, 19.6873315457
};
D pb_1[] = {
81.503760679, 4.32269795685
};
D* pb_c[] = { pb_6, pb_5, pb_4, pb_3, pb_2, pb_1 };

D bi_s[] = { 6.0, 4.0, 3.5, 1.3, 0.6, 0.19 };
D bi_e[] = {
0.0041058787402,
0.00388880428786,
0.00408070410058,
0.00950895792766,
0.00988679899513,
0.0094144016933
};
D bi_6[] = {
36.841029815, 0.95381489256,
22.1618878448, 6.88686839902,
19.9394736189, 0.140452928967,
-9.16003954915, 0.355156369815,
7.38875907549, 43.6941380906,
5.76716986584, 0.00771025553671
};
D bi_5[] = {
33.5958057455, 1.0253846501,
21.9586003208, 7.10360833706,
16.4441527218, 0.0951795267699,
7.12358008649, 45.4503669059,
3.83183227368, 0.00478772096546
};
D bi_4[] = {
33.9780436976, 0.982735844614,
22.0379538229, 6.78285834459,
19.3213068167, 0.0654363826186,
7.58965979891, 42.4083839268
};
D bi_3[] = {
45.124090015, 0.384398850803,
27.6060104556, 4.59608673286,
10.1195377847, 33.0856036997
};
D bi_2[] = {
65.6110697518, 1.09424994111,
17.032793927, 20.8480301915
};
D bi_1[] = {
82.4681880071, 4.39979822067
};
D* bi_c[] = { bi_6, bi_5, bi_4, bi_3, bi_2, bi_1 };

D po_s[] = { 6.0, 4.0, 3.5, 1.3, 0.6, 0.19 };
D po_e[] = {
0.00374579588047,
0.00395400633245,
0.00206912080926,
0.00840866700789,
0.00988744641857,
0.00967175550356
};
D po_6[] = {
257.203131155, 0.174381669301,
-244.721900532, 0.180998716862,
35.148091894, 0.925360757512,
22.3831544829, 6.43950340934,
8.30056235344, 41.9332265665,
5.62847719565, 0.0065126771519
};
D po_5[] = {
33.5907104506, 0.963123964359,
22.1712152069, 6.49154891385,
17.0528163235, 0.0838929251992,
8.28090713805, 41.9634049141,
2.8450969326, 4.83043100028e-05
};
D po_4[] = {
33.9530811413, 0.936279956153,
22.3052722936, 6.3497863891,
19.2035893977, 0.06278059933,
8.46916140764, 40.9947940364
};
D po_3[] = {
45.4165877071, 0.375473024124,
27.8248646856, 4.47401906809,
10.6213316226, 33.563188542
};
D po_2[] = {
66.5780184869, 1.09504522028,
17.0760604982, 21.7762685774
};
D po_1[] = {
83.4526695178, 4.4717751984
};
D* po_c[] = { po_6, po_5, po_4, po_3, po_2, po_1 };

D at_s[] = { 6.0, 4.0, 3.5, 1.3, 0.6, 0.19 };
D at_e[] = {
0.003305967777,
0.00347341674745,
0.00188809675132,
0.00714475063391,
0.00938166444427,
0.00964825486381
};
D at_6[] = {
273.754987808, 0.172379505818,
-261.930034306, 0.178929473292,
35.4382605161, 0.870737874043,
22.5527764591, 5.93621131723,
9.44456805259, 38.9499797318,
5.6827029501, 0.00648304323253
};
D at_5[] = {
33.5580695941, 0.912026640872,
22.3078836764, 5.99220942686,
17.1267833975, 0.0775841521403,
9.41839699046, 38.9987125923,
2.53147532888, 2.29475956397e-05
};
D at_4[] = {
33.8576793604, 0.888001652686,
22.5132778061, 5.88700053607,
19.0364165802, 0.0599740279948,
9.5323506437, 38.6055267405
};
D at_3[] = {
45.5713925292, 0.364888413356,
27.9522074451, 4.30067008001,
11.3562222486, 33.0223890262
};
D at_2[] = {
67.3275831139, 1.08486675911,
17.3533705375, 22.366951474
};
D at_1[] = {
84.4550982312, 4.53315033825
};
D* at_c[] = { at_6, at_5, at_4, at_3, at_2, at_1 };

D rn_s[] = { 6.0, 4.0, 4.0, 1.4, 0.6, 0.19 };
D rn_e[] = {
0.0028713341549,
0.00294908782061,
0.00883084695801,
0.00855347027465,
0.00858479320781,
0.00944952129954
};
D rn_6[] = {
36.1779558468, 0.813028916745,
30.5901448779, 0.143146488771,
22.6971333235, 5.454282959,
-19.8786281785, 0.227210562537,
10.6815202533, 35.8868843556,
5.67684306839, 0.00625657034128
};
D rn_5[] = {
33.5521278381, 0.870095722823,
22.3709508656, 5.59727491441,
15.4022234351, 0.0780193457042,
10.5054414353, 36.4908488628,
4.12250080315, 0.0149259328626
};
D rn_4[] = {
33.0278127019, 0.813628162471,
22.8511233172, 5.04640828962,
18.6235130244, 0.055873110078,
11.4065500874, 33.5395077548
};
D rn_3[] = {
44.2799550147, 0.330621677005,
28.7542161985, 3.80729587932,
12.8362499958, 30.3515024347
};
D rn_2[] = {
67.8958384944, 1.06626222093,
17.8180794968, 22.5991532745
};
D rn_1[] = {
85.4678419559, 4.58066038336
};
D* rn_c[] = { rn_6, rn_5, rn_4, rn_3, rn_2, rn_1 };

D fr_s[] = { 6.0, 6.0, 3.5, 1.3, 0.55, 0.17 };
D fr_e[] = {
0.00546147839171,
0.00920763172801,
0.00409855808227,
0.00888433236338,
0.00832445813234,
0.00897457654004
};
D fr_6[] = {
34.3169214659, 0.868619252261,
26.7893074926, 0.11019807556,
22.7676761063, 5.8717278326,
-11.3367646275, 0.153317234598,
9.88242958955, 39.7007778899,
4.29910797441, 1.68143329972e-06
};
D fr_5[] = {
34.0300555097, 0.918788695621,
22.5853013627, 6.27408770745,
16.2471287181, 0.096807824396,
9.24431375346, 43.1766040335,
4.66544979875, 0.00267133497935
};
D fr_4[] = {
34.4286450975, 0.841129701558,
23.0189969096, 5.7117057952,
19.177086481, 0.0573448782278,
10.085149766, 38.9179290962
};
D fr_3[] = {
47.0739726707, 0.361983568923,
28.2805846179, 4.40390629828,
11.3615440503, 35.9142354878
};
D fr_2[] = {
70.2168632086, 1.16540113529,
16.3725725474, 25.9590396512
};
D fr_1[] = {
86.3845219725, 4.89578339895
};
D* fr_c[] = { fr_6, fr_5, fr_4, fr_3, fr_2, fr_1 };

D ra_s[] = { 6.0, 6.0, 3.5, 1.1, 0.5, 0.16 };
D ra_e[] = {
0.00920801706669,
0.00920789756503,
0.00994399679013,
0.00894564661487,
0.00854741702997,
0.00985700912605
};
D ra_6[] = {
23.2117875568, 6.61229076824,
17.4048240648, 0.90894006756,
17.4048240648, 0.90894006756,
16.7904948531, 0.092449175376,
8.62891352391, 50.8862622686,
4.26238631868, 0.000215243082637
};
D ra_5[] = {
34.8096481281, 0.90894006756,
23.2117875479, 6.61229076853,
16.7904948547, 0.092449175376,
8.62891350809, 50.8862622686,
4.26238635151, 0.000215361680914
};
D ra_4[] = {
35.4203300412, 0.857229704337,
23.5987683961, 6.30565355037,
19.6806198803, 0.0583107989729,
8.98056064364, 48.5639875364
};
D ra_3[] = {
52.1618545736, 0.443719159779,
26.5152202227, 5.84599416674,
9.03211970869, 49.5023378236
};
D ra_2[] = {
72.9264645853, 1.30781608983,
14.6065767836, 31.486798655
};
D ra_1[] = {
87.3185871226, 5.22967902475
};
D* ra_c[] = { ra_6, ra_5, ra_4, ra_3, ra_2, ra_1 };

D ac_s[] = { 6.0, 4.0, 1.8, 1.1, 0.5, 0.15 };
D ac_e[] = {
0.0130080480168,
0.00284707181044,
0.00796353739257,
0.00892071419685,
0.00899073573506,
0.00880681500985
};
D ac_6[] = {
35.0042347689, 0.892404727848,
23.3986598575, 6.52966091702,
16.8064927221, 0.0924094242919,
9.05995628878, 53.1057453473,
2.23893972739, 0.00122487807402,
2.23893972739, 0.00122487807402
};
D ac_5[] = {
33.2244801077, 0.728443157174,
21.9577226297, 4.21811579117,
18.5093052472, 0.0506338336618,
11.438685989, 20.6175927025,
3.84406170054, 121.53417203
};
D ac_4[] = {
35.3768765156, 0.198704923311,
28.7354143303, 1.7814852119,
17.638121731, 9.8897966982,
7.07634012771, 67.4013206083
};
D ac_3[] = {
52.7408771231, 0.439727178476,
26.4780200216, 5.78730977946,
9.51670453874, 50.804491922
};
D ac_2[] = {
73.7601541397, 1.30726619099,
14.7841741345, 33.0284744391
};
D ac_1[] = {
88.4006059239, 5.61314466583
};
D* ac_c[] = { ac_6, ac_5, ac_4, ac_3, ac_2, ac_1 };

D th_s[] = { 6.0, 4.0, 1.9, 1.1, 0.5, 0.15 };
D th_e[] = {
0.0128797656485,
0.00281824462928,
0.00909145945379,
0.00832894006708,
0.00870436140192,
0.00856275593305
};
D th_6[] = {
34.8239050688, 0.868854662807,
23.4056167973, 6.22332646986,
15.7623083178, 0.0990776934882,
5.80188439692, 0.00697670691554,
4.98938548252, 50.5809949756,
4.98938548252, 50.5809949756
};
D th_5[] = {
33.1942443223, 0.698224627577,
22.2932308781, 4.0122033164,
18.4201746665, 0.0486967010347,
11.6812549071, 20.1565353212,
4.38948374705, 105.5442209
};
D th_4[] = {
34.1300540953, 0.179831852651,
29.5397046159, 1.6166426766,
18.0920767881, 9.16063713523,
8.08316552044, 61.8365081974
};
D th_3[] = {
53.0933413679, 0.432119308926,
26.3029461888, 5.59767551187,
10.3636965748, 48.8084214022
};
D th_2[] = {
74.3118445245, 1.28899995767,
15.2693181704, 33.5152256149
};
D th_1[] = {
89.4249505376, 5.72636690571
};
D* th_c[] = { th_6, th_5, th_4, th_3, th_2, th_1 };

D pa_s[] = { 6.0, 4.0, 1.9, 1.1, 0.5, 0.16 };
D pa_e[] = {
0.0153577345161,
0.00354429375167,
0.00912647671546,
0.00857226014839,
0.00840570337478,
0.00928247359801
};
D pa_6[] = {
33.1546560165, 0.726251004244,
22.4483667856, 4.32781707583,
15.9231847417, 0.0752399793894,
12.4207044431, 21.5674951462,
3.91613913626, 1.36906323356e-06,
3.15227265711, 138.105605653
};
D pa_5[] = {
33.3534580855, 0.673970490426,
22.199242674, 3.90308088194,
18.3856987047, 0.0471389903968,
13.261978121, 18.6435501247,
3.78716388028, 115.545874818
};
D pa_4[] = {
35.2072947185, 0.183523490478,
29.2979514471, 1.65503368747,
19.2769000271, 9.70352585197,
7.06322567644, 63.6657784956
};
D pa_3[] = {
53.8807050795, 0.430832616263,
26.9743676365, 5.82802375829,
9.88897919208, 46.499037254
};
D pa_2[] = {
74.954503915, 1.28447526737,
15.6142511856, 30.6804459339
};
D pa_1[] = {
90.3646487027, 5.28730287265
};
D* pa_c[] = { pa_6, pa_5, pa_4, pa_3, pa_2, pa_1 };

D u_s[] = { 6.0, 4.0, 1.9, 1.1, 0.5, 0.16 };
D u_e[] = {
0.0120458470072,
0.00297547050391,
0.0086018838517,
0.00838525346955,
0.00815532490438,
0.00881211801078
};
D u_6[] = {
33.9446772809, 0.734313442614,
23.9897841537, 4.84414989971,
15.8736252056, 0.0788851035171,
11.9851664745, 27.2542392326,
4.4656306301, 0.00201405447751,
1.84782267708, 261.483688618
};
D u_5[] = {
33.6662272303, 0.653144320716,
22.6241885675, 3.91369013504,
18.3618073257, 0.0457668261363,
12.9460463573, 17.4076033275,
4.33043426327, 90.9943440418
};
D u_4[] = {
36.0456935031, 0.184887776897,
29.0747503953, 1.67263509373,
19.8688885561, 9.76885181312,
6.86568852467, 62.9355031713
};
D u_3[] = {
54.4171674941, 0.426088500545,
27.4451672162, 5.86732783089,
9.88832541989, 45.0308779062
};
D u_2[] = {
75.65233062, 1.2790592485,
15.9269679332, 29.5634040414
};
D u_1[] = {
91.3926143804, 5.21364889554
};
D* u_c[] = { u_6, u_5, u_4, u_3, u_2, u_1 };

D np_s[] = { 6.0, 4.0, 1.9, 1.2, 0.5, 0.17 };
D np_e[] = {
0.0177751240291,
0.00379356305513,
0.00802979612802,
0.0099882996207,
0.0079691110144,
0.00974808697305
};
D np_6[] = {
33.3984409118, 0.673473043647,
23.3314632705, 4.14447214741,
15.882377863, 0.0695780390516,
13.4584301101, 19.6363174875,
3.81579791602, 2.07613159035e-06,
3.13151170316, 129.791876363
};
D np_5[] = {
33.8552668824, 0.633773962013,
22.5757852275, 3.8235016017,
18.3634211981, 0.0443963544191,
13.5030788971, 15.9706068858,
4.61435689705, 82.8532948515
};
D np_4[] = {
36.9425987911, 0.186526472132,
28.9759711901, 1.70698776544,
20.3448621373, 9.89867311408,
6.59574187464, 62.8881429413
};
D np_3[] = {
52.8912959469, 0.381055556658,
28.9848092387, 5.23788474805,
10.8369852864, 39.9024212946
};
D np_2[] = {
76.4328032053, 1.27797113717,
16.1509485426, 28.6392352087
};
D np_1[] = {
92.3254746365, 4.95355267111
};
D* np_c[] = { np_6, np_5, np_4, np_3, np_2, np_1 };

D pu_s[] = { 6.0, 4.0, 1.9, 1.2, 0.55, 0.18 };
D pu_e[] = {
0.0191728930453,
0.00592173820078,
0.00796414049205,
0.00969761388202,
0.00933075472885,
0.00999935201203
};
D pu_6[] = {
35.1424372063, 0.757903310109,
27.2020981327, 5.96161929522,
9.77686409593, 39.4497208139,
8.10733702619, 0.0875480626811,
8.10733702619, 0.0875480626811,
5.38507159156, 0.00388029499315
};
D pu_5[] = {
33.9391185066, 0.606971801528,
23.319245982, 3.7462253898,
18.2142643981, 0.0423958039556,
15.4714322847, 16.6148304595,
3.03208272139, 121.140473949
};
D pu_4[] = {
37.9031283854, 0.188546902844,
28.6550683146, 1.74209682172,
21.6542222543, 10.0755140649,
5.64349077187, 64.6628551153
};
D pu_3[] = {
53.3351630899, 0.37547113085,
29.8625043312, 5.30818106087,
10.5023470846, 37.0859392489
};
D pu_2[] = {
75.1809556584, 1.13708577638,
18.328265284, 23.1446771095
};
D pu_1[] = {
93.2898475135, 4.59495590831
};
D* pu_c[] = { pu_6, pu_5, pu_4, pu_3, pu_2, pu_1 };

D am_s[] = { 6.0, 4.0, 1.9, 1.2, 0.55, 0.18 };
D am_e[] = {
0.0195854363852,
0.00748449487942,
0.00749170220484,
0.00949943207276,
0.00909589253804,
0.00959757339383
};
D am_6[] = {
35.3587067134, 0.718673550944,
28.2126534876, 5.76408677154,
16.6316663223, 0.078472898401,
9.95861049643, 37.6705272622,
2.27743059509, 0.000648137895929,
2.27743059509, 0.000648137895929
};
D am_5[] = {
34.1571054706, 0.587419988402,
23.4878434903, 3.67086519677,
18.1508956307, 0.0408349501265,
16.0558052129, 15.6776343176,
3.12064312066, 112.8697098
};
D am_4[] = {
38.6568046455, 0.188759093263,
28.5061768011, 1.76282344392,
22.2951132689, 10.0050487693,
5.41231997858, 65.6318056935
};
D am_3[] = {
53.7815750186, 0.37059233815,
30.5830449656, 5.33019958407,
10.3424883429, 36.561426406
};
D am_2[] = {
75.9445424321, 1.13536230269,
18.5710573815, 22.4671048062
};
D am_1[] = {
94.3118408167, 4.5285325164
};
D* am_c[] = { am_6, am_5, am_4, am_3, am_2, am_1 };

D cm_s[] = { 6.0, 5.0, 2.0, 1.2, 0.55, 0.18 };
D cm_e[] = {
0.0203812001735,
0.00930253021003,
0.00918432977824,
0.00939455064143,
0.00954408000779,
0.00981245673701
};
D cm_6[] = {
35.4430219585, 0.688341187648,
28.9836294461, 5.55623483642,
16.0912831935, 0.0763115684231,
5.14940251873, 38.2149613507,
5.14940251873, 38.2149613507,
4.91423089059, 0.00287801032067
};
D cm_5[] = {
34.2703026063, 0.565967372259,
24.1345786251, 3.5925827103,
18.0407287703, 0.0391146058034,
15.8674791755, 15.1104796263,
3.68313992202, 102.209868654
};
D cm_4[] = {
37.5611024755, 0.173684649856,
28.7409193653, 1.59082388396,
23.4024551638, 9.11704656309,
6.18470796028, 62.2944809364
};
D cm_3[] = {
54.2332953805, 0.366384321844,
31.1268833527, 5.30472927701,
10.3712588766, 38.1229960913
};
D cm_2[] = {
77.105187857, 1.14966374128,
18.4123073802, 23.2255516435
};
D cm_1[] = {
95.3052479395, 4.57207918852
};
D* cm_c[] = { cm_6, cm_5, cm_4, cm_3, cm_2, cm_1 };

D bk_s[] = { 6.0, 3.5, 2.0, 1.2, 0.55, 0.18 };
D bk_e[] = {
0.0208184746506,
0.00835470291304,
0.00866774867079,
0.00916201356964,
0.0093496214478,
0.00944512894878
};
D bk_6[] = {
35.6688023542, 0.653100774058,
15.9716213675, 0.0695270974481,
15.0474676327, 5.38783667498,
15.0474676327, 5.38783667498,
10.3821580746, 36.9024175322,
4.60918713264, 0.00307727482652
};
D bk_5[] = {
35.1206469709, 0.5263708064,
25.9074363216, 3.62134292858,
17.0323462982, 0.0319017796588,
15.6390560686, 15.7017776827,
3.30123051786, 111.353501554
};
D bk_4[] = {
38.3185529807, 0.174041464942,
28.5360249684, 1.61000358479,
24.0157053249, 8.98653940664,
6.02478918486, 62.2272748043
};
D bk_3[] = {
54.6392861046, 0.361414356604,
31.9904852011, 5.31758440221,
10.1106633118, 38.0542970213
};
D bk_2[] = {
77.9890432494, 1.15201421628,
18.5333086478, 22.6630875649
};
D bk_1[] = {
96.3247439982, 4.50139165095
};
D* bk_c[] = { bk_6, bk_5, bk_4, bk_3, bk_2, bk_1 };

D cf_s[] = { 6.0, 3.0, 2.0, 1.2, 0.55, 0.18 };
D cf_e[] = {
0.0226052224537,
0.00165150134088,
0.00818225677306,
0.00893781305159,
0.00915890826352,
0.00909676687481
};
D cf_6[] = {
35.9081275944, 0.620360140927,
31.228417434, 5.2302611381,
16.5069843612, 0.0613028356456,
5.21663517976, 35.7610610604,
5.21663517976, 35.7610610604,
3.64603149308, 2.59795970275e-05
};
D cf_5[] = {
36.3709751646, 0.4035655952,
25.3370195256, 2.74469549222,
19.4649331082, 11.7956913845,
12.3981075698, 1.89285065898e-05,
4.38724785923, 81.8307486345
};
D cf_4[] = {
39.0393038428, 0.174030239689,
28.3750008016, 1.62946531202,
24.6017248003, 8.83439864828,
5.88371031947, 62.0803639612
};
D cf_3[] = {
54.9978994347, 0.356115255232,
32.8522373697, 5.30148940061,
9.89627173817, 37.8057896311
};
D cf_2[] = {
78.9202539292, 1.15559702054,
18.6068244831, 22.1635430857
};
D cf_1[] = {
97.3427953556, 4.42965302853
};
D* cf_c[] = { cf_6, cf_5, cf_4, cf_3, cf_2, cf_1 };

D h1minus_s[] = { 6.0, 1.0, 0.9, 0.5, 0.2, 0.07 };
D h1minus_e[] = {
0.303661098457,
0.000247703476045,
0.00483931201113,
0.00998342327923,
0.00679755814842,
0.00653254994468
};
D h1minus_6[] = {
0.736719929236, 76.1264343335,
0.680865996139, 25.6119493385,
0.270568743226, 8.23747406798,
0.261345412705, 232.505123582,
0.0463784729692, 2.40571474728,
0.00342458031461, 0.421345064906
};
D h1minus_5[] = {
0.680392583284, 30.4439243177,
0.659219480133, 83.3825564242,
0.350663361595, 10.3566681098,
0.238950055157, 239.110521471,
0.0700493268795, 2.54204204357
};
D h1minus_4[] = {
0.905420344063, 43.5036169054,
0.53657059443, 159.418304213,
0.467219076227, 12.4802886516,
0.0871618808457, 2.86295400858
};
D h1minus_3[] = {
0.953955415745, 31.4033097957,
0.7155260931, 131.355227269,
0.323157810876, 6.55477959726
};
D h1minus_2[] = {
1.17011993549, 20.8032642649,
0.816487723135, 119.337276407
};
D h1minus_1[] = {
1.99245907974, 59.2096693809
};
D* h1minus_c[] = { h1minus_6, h1minus_5, h1minus_4, h1minus_3, h1minus_2, h1minus_1 };

D li1plus_s[] = { 6.0, 4.0, 3.0, 1.9, 1.1, 0.4 };
D li1plus_e[] = {
0.00794874365617,
0.00152898274247,
0.00629110074991,
0.00943264650705,
0.00664514522469,
0.00995900544929
};
D li1plus_6[] = {
0.7904931757, 1.91122015149,
0.740798403749, 4.78973146362,
0.284338787579, 0.712873886013,
0.115628286338, 11.2006795943,
0.0607378927259, 0.260451759168,
0.00817865488882, 0.0667963201847
};
D li1plus_5[] = {
0.881456545768, 3.29114929335,
0.578198165374, 1.31020984378,
0.348094143583, 8.03649779747,
0.170411904345, 0.455307425232,
0.0217222847432, 0.112343947271
};
D li1plus_4[] = {
0.997286066343, 2.67774220461,
0.470395598686, 7.27086835283,
0.458846945092, 0.891843370549,
0.0731654654094, 0.213722203643
};
D li1plus_3[] = {
1.0526943914, 2.0458243944,
0.656535171704, 6.35127646947,
0.289886168874, 0.479043128591
};
D li1plus_2[] = {
1.13346052831, 4.55377854507,
0.856273642056, 1.02879391135
};
D li1plus_1[] = {
1.98889415146, 2.88827739351
};
D* li1plus_c[] = { li1plus_6, li1plus_5, li1plus_4, li1plus_3, li1plus_2, li1plus_1 };

D be2plus_s[] = { 6.0, 6.0, 3.5, 2.5, 1.5, 0.55 };
D be2plus_e[] = {
0.00101937880261,
0.00457588329998,
0.00529833171163,
0.0022681418914,
0.00891625718838,
0.00826003454907
};
D be2plus_6[] = {
0.688878675383, 1.1831148593,
0.641034815411, 2.49900989893,
0.390007618418, 0.542027389997,
0.145897170972, 5.22151085972,
0.119263926406, 0.201837382504,
0.0149608614363, 0.0505195369277
};
D be2plus_5[] = {
0.876981279701, 1.90748046057,
0.656499675367, 0.742870278875,
0.269050831716, 4.47986468592,
0.176586354147, 0.247982844272,
0.0208761621104, 0.0595392661655
};
D be2plus_4[] = {
0.947909369575, 1.60142756267,
0.559413207625, 0.578994520704,
0.38665341857, 3.99492204555,
0.105884344887, 0.144198124338
};
D be2plus_3[] = {
1.05674999997, 1.10072695216,
0.644323530897, 3.30968118776,
0.298305313502, 0.263851354839
};
D be2plus_2[] = {
1.09475122152, 2.50843291885,
0.90119124862, 0.568323747378
};
D be2plus_1[] = {
1.98907112461, 1.50354831442
};
D* be2plus_c[] = { be2plus_6, be2plus_5, be2plus_4, be2plus_3, be2plus_2, be2plus_1 };

D cval_s[] = { 6.0, 4.0, 2.0, 1.2, 0.42, 0.14 };
D cval_e[] = {
0.0103708799784,
0.0093988932352,
0.00931184756933,
0.00666370468323,
0.00624488474904,
0.00833249944912
};
D cval_6[] = {
2.50282210482, 15.2590068534,
1.5425518282, 44.3624931514,
0.887175412532, 0.531530529164,
0.512171713258, 1.51424147442,
0.45359785329, 0.219208200089,
0.098918426441, 0.0576032213122
};
D cval_5[] = {
2.48622549514, 15.0981811072,
1.56870397653, 44.0133507603,
1.02871333621, 0.405050305588,
0.663663832605, 1.30523280232,
0.249755251209, 0.0991522914934
};
D cval_4[] = {
2.4254948232, 14.7520206625,
1.64121800078, 42.9500421199,
1.0300164109, 0.26066563919,
0.899493290071, 1.10114773802
};
D cval_3[] = {
2.1787540755, 37.2495434656,
2.00360470516, 11.8420934786,
1.81022249193, 0.494887872964
};
D cval_2[] = {
3.1845926394, 30.1806339779,
2.79854407471, 2.25581077172
};
D cval_1[] = {
5.97110070447, 15.6869668379
};
D* cval_c[] = { cval_6, cval_5, cval_4, cval_3, cval_2, cval_1 };

D o1minus_s[] = { 6.0, 4.0, 2.0, 1.3, 0.42, 0.15 };
D o1minus_e[] = {
0.00241272287319,
0.0056544391669,
0.00920250961723,
0.00939488367443,
0.00639838648909,
0.00886993587352
};
D o1minus_6[] = {
3.32196224234, 18.3248057328,
2.95509323847, 6.4721535207,
0.936373652027, 0.443683676665,
0.895785058779, 61.8270306575,
0.740809893756, 0.161251626152,
0.147400662232, 0.040491522036
};
D o1minus_5[] = {
3.47678096414, 16.8345422878,
2.66584887439, 6.09826029463,
1.20638768171, 0.380987129295,
1.04709459201, 57.1264758743,
0.600037462636, 0.0954940029214
};
D o1minus_4[] = {
4.16283951579, 12.9731064172,
1.69552605437, 0.233128106663,
1.6121937703, 4.29170573486,
1.5225430632, 47.0182794824
};
D o1minus_3[] = {
4.31556811477, 8.03600032293,
2.79155909219, 32.3646995752,
1.86576192493, 0.295798183981
};
D o1minus_2[] = {
5.1236601009, 3.49405661888,
3.84316627652, 27.4797887969
};
D o1minus_1[] = {
8.95259928511, 12.6747666467
};
D* o1minus_c[] = { o1minus_6, o1minus_5, o1minus_4, o1minus_3, o1minus_2, o1minus_1 };

D o2minus_s[] = { 6.0, 4.0, 2.5, 1.4, 0.45, 0.15 };
D o2minus_e[] = {
0.00415916581447,
0.00517952349864,
0.00895918064274,
0.00895143367094,
0.00917749621313,
0.00756289692107
};
D o2minus_6[] = {
3.68731252347, 19.9369203335,
2.9786073499, 6.67841439198,
1.48435005109, 51.6711966386,
0.961550175089, 0.224589839851,
0.624284612731, 0.553252194706,
0.263007687399, 0.0560529815645
};
D o2minus_5[] = {
3.77247843459, 13.3400448798,
2.66397680119, 40.4603054664,
1.75959859653, 5.18339306265,
1.23184505972, 0.372139186071,
0.56636283963, 0.0921101890468
};
D o2minus_4[] = {
4.11369033611, 8.02325425015,
3.97787843536, 32.281999216,
1.12657584914, 0.468145649884,
0.761075326186, 0.109457162354
};
D o2minus_3[] = {
4.26789411068, 30.4587509897,
3.88085864195, 7.43902968461,
1.82136904689, 0.274952322725
};
D o2minus_2[] = {
5.0705371428, 28.3370875547,
4.90374874548, 3.2637994157
};
D o2minus_1[] = {
9.94967244177, 14.5882601803
};
D* o2minus_c[] = { o2minus_6, o2minus_5, o2minus_4, o2minus_3, o2minus_2, o2minus_1 };

D f1minus_s[] = { 6.0, 4.0, 2.0, 1.3, 0.48, 0.17 };
D f1minus_e[] = {
0.0019471411956,
0.00289052017332,
0.00614596413535,
0.00878829300513,
0.00735585566702,
0.00844384633705
};
D f1minus_6[] = {
3.77891908766, 13.9406793172,
3.38927640217, 4.8801359065,
1.02334173388, 0.185334460383,
0.998199162965, 46.3664389883,
0.52079737221, 0.457458828129,
0.286939035388, 0.0466206824817
};
D f1minus_5[] = {
3.98251139742, 12.7434521894,
3.03897371824, 4.55875688048,
1.17422194018, 42.8815123553,
1.13623096044, 0.309602986715,
0.664364842764, 0.0812944843309
};
D f1minus_4[] = {
5.10897286045, 7.3647996124,
2.49872861724, 28.5454565195,
1.62574044684, 0.172775863309,
0.749685536005, 1.84508095416
};
D f1minus_3[] = {
4.98029180356, 6.24490809298,
3.06763539203, 24.8560183548,
1.92410013411, 0.259793491674
};
D f1minus_2[] = {
5.80696336852, 2.96098570153,
4.16198283686, 21.5379405708
};
D f1minus_1[] = {
9.95104455035, 9.84581317808
};
D* f1minus_c[] = { f1minus_6, f1minus_5, f1minus_4, f1minus_3, f1minus_2, f1minus_1 };

D na1plus_s[] = { 6.0, 6.0, 5.0, 2.5, 0.8, 0.3 };
D na1plus_e[] = {
0.000288883594211,
0.00490493047547,
0.00647716871796,
0.0077155256431,
0.00950128531624,
0.00942039929988
};
D na1plus_6[] = {
4.00656435388, 6.1616600585,
3.24720043127, 2.64548741495,
1.13513207237, 0.15808498858,
0.949148439788, 14.3094079119,
0.449307257518, 0.0409115034977,
0.212404857856, 0.377084113718
};
D na1plus_5[] = {
4.58233286451, 4.64924181948,
1.85614010271, 11.6027465958,
1.81576863559, 2.10836673232,
1.22161517125, 0.179798967585,
0.522568064352, 0.0447402437829
};
D na1plus_4[] = {
4.70828412828, 3.08790923973,
3.47209893939, 9.01158955316,
1.17046533395, 0.206090071244,
0.640956653409, 0.0514165821502
};
D na1plus_3[] = {
4.22593713785, 2.77264209542,
4.04412990773, 8.34372115078,
1.7171861197, 0.125277298664
};
D na1plus_2[] = {
5.56094399899, 7.30807666506,
4.42394613001, 1.06976247553
};
D na1plus_1[] = {
9.95752945621, 4.19128663695
};
D* na1plus_c[] = { na1plus_6, na1plus_5, na1plus_4, na1plus_3, na1plus_2, na1plus_1 };

D mg2plus_s[] = { 6.0, 6.0, 6.0, 3.0, 0.9, 0.36 };
D mg2plus_e[] = {
0.000645792658927,
0.000607688711633,
0.00765002828228,
0.00885427160331,
0.0058556639595,
0.00931930390815
};
D mg2plus_6[] = {
3.33772115314, 2.56812958454,
3.31498584245, 5.0873352616,
1.19274747187, 0.149246040696,
0.867948455786, 1.45335094378,
0.750277319985, 10.3952972794,
0.536313169572, 0.0382714453184
};
D mg2plus_5[] = {
4.61361561629, 3.75146086539,
2.10174342828, 1.73925632338,
1.55455506508, 8.67031948321,
1.19289654497, 0.149246040696,
0.536815530416, 0.0383190202567
};
D mg2plus_4[] = {
4.70395592989, 2.39440555713,
3.49576018802, 6.45968231731,
1.15787629732, 0.169140050989,
0.634976961218, 0.042634949439
};
D mg2plus_3[] = {
4.36297453919, 5.84416794424,
3.95402186199, 2.0522287083,
1.67261115359, 0.0990905852289
};
D mg2plus_2[] = {
5.76884111662, 5.25913932997,
4.22002959795, 0.792486028716
};
D mg2plus_1[] = {
9.95819735431, 3.10186877453
};
D* mg2plus_c[] = { mg2plus_6, mg2plus_5, mg2plus_4, mg2plus_3, mg2plus_2, mg2plus_1 };

D al3plus_s[] = { 6.0, 6.0, 6.0, 3.0, 1.1, 0.4 };
D al3plus_e[] = {
0.000238817763701,
0.000226569819487,
0.00818358395843,
0.00583274208156,
0.00838841687658,
0.00835029004531
};
D al3plus_6[] = {
4.14180693994, 3.48768726114,
1.58212207398, 1.63588041787,
1.58212207398, 1.63588041787,
1.15123960797, 0.130868819466,
0.957987092566, 7.28699497396,
0.584599616449, 0.0345469643868
};
D al3plus_5[] = {
4.14180318481, 3.48769167413,
3.16423810499, 1.63588470708,
1.1512303666, 0.130872753766,
0.957986053767, 7.28699540481,
0.58459045631, 0.0345422184178
};
D al3plus_4[] = {
4.14123490898, 4.53737955917,
4.09640060224, 1.7680404617,
1.16029137658, 0.134969726384,
0.593518661431, 0.0348285494916
};
D al3plus_3[] = {
4.1982011524, 1.73308116771,
4.10980380127, 4.58815466909,
1.68447184661, 0.0858298380754
};
D al3plus_2[] = {
6.18777943064, 3.86512735013,
3.8004977032, 0.54482929695
};
D al3plus_1[] = {
9.96541545906, 2.42967157301
};
D* al3plus_c[] = { al3plus_6, al3plus_5, al3plus_4, al3plus_3, al3plus_2, al3plus_1 };

D sival_s[] = { 6.0, 4.0, 3.5, 1.5, 0.5, 0.12 };
D sival_e[] = {
0.00771704891104,
0.00902683642137,
0.00901253002938,
0.00959602100386,
0.00651789961282,
0.00951741517674
};
D sival_6[] = {
5.33730600814, 2.6350357654,
2.44937950771, 1.20394705105,
2.35791911584, 33.2600021706,
2.14835168411, 77.5672219783,
1.06306906999, 0.111338759682,
0.638135902448, 0.0320522534658
};
D sival_5[] = {
5.50936260101, 1.67433105398,
4.20295240346, 52.9636410913,
2.45559765201, 4.21440870643,
0.969671286682, 0.0425608345246,
0.820822268273, 0.154206303357
};
D sival_4[] = {
4.92420267932, 1.49337290763,
4.17153760048, 54.0033765146,
3.21024144577, 3.93354577124,
1.66046023071, 0.0713792822997
};
D sival_3[] = {
6.93967749466, 2.48269284394,
4.32653782043, 50.6585251459,
2.6793561159, 0.241688201533
};
D sival_2[] = {
9.55184836936, 1.72694419625,
4.3942444488, 50.1702426832
};
D sival_1[] = {
13.9117479756, 14.4340788795
};
D* sival_c[] = { sival_6, sival_5, sival_4, sival_3, sival_2, sival_1 };

D si4plus_s[] = { 6.0, 6.0, 5.0, 3.5, 1.3, 0.46 };
D si4plus_e[] = {
0.00516364940539,
0.00516364940539,
0.00424324088356,
0.00903029515746,
0.00937723509281,
0.00847449715906
};
D si4plus_6[] = {
3.8369831496, 1.66278089536,
3.27073869961, 3.93524039356,
1.37091541724, 0.0709609635155,
0.959711559962, 1.66388245752,
0.430156950997, 0.362613786136,
0.128263665221, 0.00332346399651
};
D si4plus_5[] = {
4.79669470956, 1.66278089536,
3.27073869961, 3.93524039356,
1.37091541724, 0.0709609635155,
0.430156950997, 0.362613786136,
0.128263665221, 0.00332346399651
};
D si4plus_4[] = {
5.08314129435, 1.65981678075,
3.07902631207, 4.08013837353,
1.2057089968, 0.0499523042828,
0.630332399679, 0.209199114508
};
D si4plus_3[] = {
4.47168612436, 1.44515163245,
3.87243074662, 3.79224664386,
1.66071703302, 0.0714406145137
};
D si4plus_2[] = {
6.70685469685, 2.88545019113,
3.27535806181, 0.350360374206
};
D si4plus_1[] = {
9.96389814678, 1.93447620764
};
D* si4plus_c[] = { si4plus_6, si4plus_5, si4plus_4, si4plus_3, si4plus_2, si4plus_1 };

D cl1minus_s[] = { 6.0, 5.0, 3.0, 1.0, 0.46, 0.14 };
D cl1minus_e[] = {
0.00207233562539,
0.00356554302989,
0.00797876196007,
0.00601263672792,
0.00906465848438,
0.00920634100452
};
D cl1minus_6[] = {
6.64667429491, 1.22449466533,
6.57640513729, 19.698998335,
2.2804601311, 61.3135611435,
1.46073539468, 0.0542535430486,
0.869665077156, 0.498801680234,
0.161005339667, 0.000246538484964
};
D cl1minus_5[] = {
6.95450049623, 1.19185774027,
6.45499606894, 19.3568551638,
2.42065011486, 59.2658136591,
1.48436076846, 0.0408272089999,
0.678750300112, 0.323181949106
};
D cl1minus_4[] = {
7.17980189106, 1.114148213,
4.75525842229, 15.5319580322,
4.24744751662, 43.235734479,
1.78778688839, 0.0581151648208
};
D cl1minus_3[] = {
8.62983874026, 0.769107033276,
4.80316974257, 41.12717632,
4.53532168621, 13.3272985944
};
D cl1minus_2[] = {
10.4509112448, 1.5445666034,
7.48832733513, 31.6712767053
};
D cl1minus_1[] = {
17.8981386893, 12.5347562918
};
D* cl1minus_c[] = { cl1minus_6, cl1minus_5, cl1minus_4, cl1minus_3, cl1minus_2, cl1minus_1 };

D k1plus_s[] = { 6.0, 6.0, 4.0, 1.8, 0.8, 0.2 };
D k1plus_e[] = {
0.00351682091503,
0.00491203479454,
0.00698758423846,
0.00971049288526,
0.00944981162119,
0.00826112528259
};
D k1plus_6[] = {
28.7007018096, 10.4507191888,
-21.3123676484, 9.85105475401,
7.10812372126, 0.827302044594,
1.66445633952, 28.9857144204,
1.29256336912, 0.0283306454989,
0.549160186113, 0.128462945746
};
D k1plus_5[] = {
7.93391365313, 12.7332036476,
7.12007319332, 0.813605095402,
1.17442083109, 31.6238980094,
0.918920638882, 0.0214265728864,
0.854282904571, 0.0794884462394
};
D k1plus_4[] = {
7.10750272123, 0.791345695585,
6.6701036426, 16.8283621382,
2.51634077262, 8.37380818968,
1.68592932495, 0.0400518251844
};
D k1plus_3[] = {
8.75677764738, 14.736158971,
5.87346494698, 1.05492292946,
3.32959641847, 0.184009881742
};
D k1plus_2[] = {
9.10363928704, 0.676525988054,
8.85531058568, 14.6269757831
};
D k1plus_1[] = {
17.9194109935, 6.81126959702
};
D* k1plus_c[] = { k1plus_6, k1plus_5, k1plus_4, k1plus_3, k1plus_2, k1plus_1 };

D ca2plus_s[] = { 6.0, 6.0, 6.0, 3.0, 1.0, 0.22 };
D ca2plus_e[] = {
0.00252210199587,
0.00645417693189,
0.00729114323053,
0.00726399770167,
0.00908147704829,
0.00734272885094
};
D ca2plus_6[] = {
11.1350637296, 7.50648642162,
7.12031633791, 0.73613365772,
-5.1076895785, 5.47497980462,
2.92290635789, 17.8717800421,
1.43092501111, 0.0280109568606,
0.4984761871, 0.171076847898
};
D ca2plus_5[] = {
9.00980333822, 11.4711934996,
6.70887728138, 0.75549916063,
1.50173283688, 0.0294563058375,
0.727636449726, 0.263086434189,
0.0212426571715, 0.446016225023
};
D ca2plus_4[] = {
9.00858535679, 11.4726964549,
6.72639807129, 0.755505337142,
1.50859270657, 0.0296063317274,
0.725671416161, 0.263086434189
};
D ca2plus_3[] = {
9.00614617514, 11.5043846011,
7.11474468263, 0.730949041574,
1.85112246997, 0.0473828343711
};
D ca2plus_2[] = {
9.15732942125, 11.2916311058,
8.80693146359, 0.534393153719
};
D ca2plus_1[] = {
17.9318062875, 5.48960700721
};
D* ca2plus_c[] = { ca2plus_6, ca2plus_5, ca2plus_4, ca2plus_3, ca2plus_2, ca2plus_1 };

D sc3plus_s[] = { 6.0, 6.0, 6.0, 4.0, 1.2, 0.26 };
D sc3plus_e[] = {
0.00257749159927,
0.00453350398834,
0.00453466705524,
0.00636843291605,
0.00872706582753,
0.00895520255281
};
D sc3plus_6[] = {
9.70181903525, 6.2950553557,
6.96247870063, 0.668545847612,
-3.90824283526, 4.069478402,
3.11077502759, 13.7259147283,
1.48858165552, 0.026389847202,
0.644342167863, 0.217767088785
};
D sc3plus_5[] = {
9.16852754218, 9.32934105842,
4.1528398478, 0.630656272005,
2.76855801348, 0.630652535923,
1.46396786646, 0.026016190999,
0.424172645851, 0.163279754647
};
D sc3plus_4[] = {
9.16852754218, 9.32934105842,
6.92139786128, 0.630656272005,
1.46396786646, 0.026016190999,
0.424172645851, 0.163279754647
};
D sc3plus_3[] = {
9.16075817591, 9.35476737709,
7.1050465418, 0.620771447674,
1.71459201986, 0.0342761622543
};
D sc3plus_2[] = {
9.36485084292, 9.12678938539,
8.60581799457, 0.447828883328
};
D sc3plus_1[] = {
17.9182591817, 4.45734766376
};
D* sc3plus_c[] = { sc3plus_6, sc3plus_5, sc3plus_4, sc3plus_3, sc3plus_2, sc3plus_1 };

D ti2plus_s[] = { 6.0, 6.0, 6.0, 1.6, 0.7, 0.22 };
D ti2plus_e[] = {
0.00388926815894,
0.00517841020815,
0.00971815364709,
0.00914814857186,
0.00756114348451,
0.00720301424333
};
D ti2plus_6[] = {
11.1927263845, 7.03432073478,
6.79898621152, 0.572099713844,
-2.29161362032, 4.54336525591,
2.25759665117, 21.3887689441,
1.5172822103, 0.0246099263436,
0.521694914746, 0.205752610117
};
D ti2plus_5[] = {
9.71453884773, 8.0570505466,
7.00849006385, 0.541825980244,
1.58503904331, 24.7053810687,
0.955259923083, 0.0458015578663,
0.735545229061, 0.0141088176246
};
D ti2plus_4[] = {
8.14515020177, 7.21967723958,
7.00188438345, 0.526508968986,
3.23300136992, 17.1791596926,
1.60364048552, 0.0263700210558
};
D ti2plus_3[] = {
7.93431359573, 0.344341308343,
7.75702894924, 12.0850676027,
4.27186054645, 4.28886237826
};
D ti2plus_2[] = {
10.2372010963, 0.74243909135,
9.71976771659, 10.9365966973
};
D ti2plus_1[] = {
19.9229849029, 5.2382778459
};
D* ti2plus_c[] = { ti2plus_6, ti2plus_5, ti2plus_4, ti2plus_3, ti2plus_2, ti2plus_1 };

D ti3plus_s[] = { 6.0, 6.0, 6.0, 2.5, 1.0, 0.26 };
D ti3plus_e[] = {
0.00242283352909,
0.00779680060277,
0.00983105790712,
0.00996384627301,
0.0087940042842,
0.00846186366225
};
D ti3plus_6[] = {
11.0835730223, 5.96000059528,
6.9400740863, 0.579218783792,
-3.75281710184, 3.8756141771,
2.70789007765, 14.6375048757,
1.48522101123, 0.0239662058209,
0.534848037574, 0.181675547017
};
D ti3plus_5[] = {
9.55629735292, 7.84628862834,
7.0282810045, 0.53446700876,
1.39839024994, 0.0333550631139,
0.770668719218, 22.2927976185,
0.247712812231, 0.00537439085478
};
D ti3plus_4[] = {
7.0199482231, 0.526308997932,
6.81201856539, 6.94341858878,
3.54855676311, 11.9130771486,
1.60342764216, 0.0263788280964
};
D ti3plus_3[] = {
10.0039669344, 8.68083236931,
6.48634784642, 0.63076461812,
2.47486846392, 0.080571202237
};
D ti3plus_2[] = {
10.1000409535, 8.60830208386,
8.86153996177, 0.44455261194
};
D ti3plus_1[] = {
18.9170495643, 4.35562009491
};
D* ti3plus_c[] = { ti3plus_6, ti3plus_5, ti3plus_4, ti3plus_3, ti3plus_2, ti3plus_1 };

D ti4plus_s[] = { 6.0, 6.0, 6.0, 6.0, 1.4, 0.28 };
D ti4plus_e[] = {
0.000898241798227,
0.00483710474284,
0.00724269044657,
0.00993421735248,
0.00865026078035,
0.00832528468241
};
D ti4plus_6[] = {
79.4012542623, 4.20965035817,
-74.5099430141, 4.06285247426,
7.00262802089, 0.594714325474,
3.9645133053, 10.4742154482,
1.50557782559, 0.0243677199616,
0.63532330399, 0.208606873359
};
D ti4plus_5[] = {
15.7923167113, 0.616210591183,
9.30101889586, 7.74693413049,
-8.88733314446, 0.679890275008,
1.05333410152, 0.0171795227954,
0.72613239212, 0.0683353025677
};
D ti4plus_4[] = {
9.27266013762, 7.76899450455,
7.05924718574, 0.53644972324,
1.31648542048, 0.0353196755997,
0.337775103289, 0.00767476614151
};
D ti4plus_3[] = {
9.30135876449, 7.7294767073,
7.07501002111, 0.529160463879,
1.60674098372, 0.026439065502
};
D ti4plus_2[] = {
9.52574600011, 7.5376234065,
8.44906236272, 0.381562745051
};
D ti4plus_1[] = {
17.9274098797, 3.77041634319
};
D* ti4plus_c[] = { ti4plus_6, ti4plus_5, ti4plus_4, ti4plus_3, ti4plus_2, ti4plus_1 };

D v2plus_s[] = { 6.0, 6.0, 6.0, 1.7, 0.7, 0.24 };
D v2plus_e[] = {
0.00140667524198,
0.00858713295463,
0.00848275108162,
0.00702031474009,
0.00776037346204,
0.00909010938235
};
D v2plus_6[] = {
236.816441518, 0.771781353919,
-231.778995814, 0.778904541192,
10.1220582716, 6.70409363239,
2.46154765689, 20.0752196948,
1.83518682126, 0.291480373244,
1.53993910186, 0.0228647442978
};
D v2plus_5[] = {
-236.775927922, 14.0054394357,
234.241093097, 14.1572054161,
14.8349532954, 7.83689143695,
7.08312155507, 0.476540223929,
1.61161453795, 0.024343278961
};
D v2plus_4[] = {
10.6588853149, 7.24427113237,
7.07738388951, 0.476115686548,
1.6600659916, 25.1665453968,
1.61116164026, 0.0243417750892
};
D v2plus_3[] = {
7.97543708242, 0.309079820533,
7.63636302328, 11.6025702687,
5.34474255061, 4.25903863771
};
D v2plus_2[] = {
10.8717989684, 0.79047276478,
10.0834502728, 10.3975838741
};
D v2plus_1[] = {
20.9028981878, 4.8976279231
};
D* v2plus_c[] = { v2plus_6, v2plus_5, v2plus_4, v2plus_3, v2plus_2, v2plus_1 };

D v3plus_s[] = { 6.0, 6.0, 6.0, 1.7, 0.9, 0.26 };
D v3plus_e[] = {
0.00220170293176,
0.00729703442797,
0.00823022905123,
0.00833992716564,
0.00829510018625,
0.00774243413838
};
D v3plus_6[] = {
9.73033719182, 6.19514114735,
6.96860125924, 0.51907585114,
2.26352434089, 15.315344661,
1.49501234454, 0.0220489336409,
-0.982426543134, 2.1081279525,
0.523581118218, 0.170552590633
};
D v3plus_5[] = {
10.136129784, 6.91857595001,
6.99251150499, 0.476272876258,
1.3738582492, 0.0297964911079,
1.23616241433, 19.0935046378,
0.262057365339, 0.0068520164663
};
D v3plus_4[] = {
10.0816044125, 6.89965823794,
7.01112077696, 0.47342424187,
1.60907713946, 0.0242984433104,
1.29697126983, 18.2772992537
};
D v3plus_3[] = {
8.18999077376, 9.4272329602,
7.90783514463, 0.307235108471,
3.88300169133, 3.6928463073
};
D v3plus_2[] = {
10.6828395363, 8.19409623872,
9.27686618575, 0.474508421507
};
D v3plus_1[] = {
19.9190455175, 4.21969266905
};
D* v3plus_c[] = { v3plus_6, v3plus_5, v3plus_4, v3plus_3, v3plus_2, v3plus_1 };

D v5plus_s[] = { 6.0, 6.0, 6.0, 6.0, 1.6, 0.32 };
D v5plus_e[] = {
0.00123830072992,
0.00602001766222,
0.00926338279574,
0.00930271097669,
0.0089059619109,
0.00997615723214
};
D v5plus_6[] = {
22.7908503542, 3.48865128527,
-18.8628859798, 3.0047709368,
6.63344558029, 0.577389269417,
4.62250707912, 8.38649860148,
1.53555283937, 0.022780152127,
1.27988217123, 0.265198269062
};
D v5plus_5[] = {
24.1332741433, 0.612418029161,
-17.5345866865, 0.671966104718,
9.46603739022, 6.50865515818,
1.38551076436, 0.0202025597947,
0.537948551936, 0.115359093242
};
D v5plus_4[] = {
9.35096106679, 6.58145940428,
7.03337974598, 0.47100169955,
1.60170231799, 0.0241281665827,
0.00519386032025, 7.85381484868
};
D v5plus_3[] = {
9.35615562168, 6.58156213681,
7.03336806389, 0.47100169955,
1.60169919909, 0.0241326952344
};
D v5plus_2[] = {
9.65214783211, 6.35511794754,
8.32646261695, 0.331090273882
};
D v5plus_1[] = {
17.9180983889, 3.18150605872
};
D* v5plus_c[] = { v5plus_6, v5plus_5, v5plus_4, v5plus_3, v5plus_2, v5plus_1 };

D cr2plus_s[] = { 6.0, 6.0, 6.0, 1.7, 0.7, 0.25 };
D cr2plus_e[] = {
0.00358053571551,
0.00475475777927,
0.00677087112047,
0.00754778568541,
0.00754463101442,
0.00916506862039
};
D cr2plus_6[] = {
10.8578513665, 6.19447766493,
8.55503538966, 0.469717775931,
2.59544610782, 19.074855473,
-1.76573058461, 0.647777226935,
1.15205099493, 0.0420487115618,
0.601414618697, 0.00675866040824
};
D cr2plus_5[] = {
10.9345429788, 6.27836959096,
6.91355505643, 0.43264384053,
2.46345660652, 19.6570186529,
1.12393313517, 0.0374806388314,
0.564083068035, 0.00720758312238
};
D cr2plus_4[] = {
10.8001493387, 6.21358476041,
6.96755348942, 0.426960991624,
2.61236876249, 18.9117148745,
1.61502398349, 0.0224868608438
};
D cr2plus_3[] = {
7.99912950446, 0.283923739083,
7.38596545164, 4.4824019183,
6.58011100415, 12.0615843142
};
D cr2plus_2[] = {
11.4960061548, 0.837761877651,
10.4593514339, 9.90944902001
};
D cr2plus_1[] = {
21.893636098, 4.64701533423
};
D* cr2plus_c[] = { cr2plus_6, cr2plus_5, cr2plus_4, cr2plus_3, cr2plus_2, cr2plus_1 };

D cr3plus_s[] = { 6.0, 6.0, 6.0, 1.8, 0.9, 0.28 };
D cr3plus_e[] = {
0.00207329082733,
0.00504528373677,
0.00676900556652,
0.00715923394743,
0.00903145025611,
0.0096071691128
};
D cr3plus_6[] = {
15.7434412756, 0.591900301925,
10.3621987193, 5.81483907262,
-9.98646481733, 0.699789007483,
2.27370919634, 15.0338683763,
1.51382452507, 0.0204806900192,
1.09203921099, 0.212246922925
};
D cr3plus_5[] = {
11.1360998552, 6.31466437017,
6.96247013778, 0.431495458284,
1.31295136167, 0.0299867706885,
1.25014834534, 19.9043748652,
0.343353343758, 0.00598282173104
};
D cr3plus_4[] = {
11.1060711642, 6.27092224327,
6.98182435383, 0.427509476217,
1.6158887455, 0.0225094051578,
1.30402880395, 19.8708955593
};
D cr3plus_3[] = {
8.70462787589, 8.79040932546,
7.86457501857, 0.275593957027,
4.40400027591, 3.39537512496
};
D cr3plus_2[] = {
11.3404471591, 7.70028032148,
9.61490094489, 0.483747059127
};
D cr3plus_1[] = {
20.9027163353, 3.99473186823
};
D* cr3plus_c[] = { cr3plus_6, cr3plus_5, cr3plus_4, cr3plus_3, cr3plus_2, cr3plus_1 };

D mn2plus_s[] = { 6.0, 6.0, 6.0, 1.8, 0.7, 0.26 };
D mn2plus_e[] = {
0.00151962817004,
0.00508093112596,
0.00508174836354,
0.00470183719118,
0.00707999686913,
0.00930515455513
};
D mn2plus_6[] = {
25.6376893846, 0.542944998019,
-19.7318459838, 0.594161258119,
11.4710208458, 5.43325091435,
3.10086091175, 17.0178078366,
1.51548723203, 0.01886461006,
1.00170033265, 0.189259669299
};
D mn2plus_5[] = {
11.5837299837, 5.62919771339,
6.99783108564, 0.386675966081,
2.79961515794, 17.7506108157,
1.29111450326, 0.0207476987808,
0.322768170467, 0.0207459627137
};
D mn2plus_4[] = {
11.5837299837, 5.62919771339,
6.99783108564, 0.386675966081,
2.79961515794, 17.7506108157,
1.61388267373, 0.0207459627137
};
D mn2plus_3[] = {
9.56593817028, 4.56386883527,
8.07602885623, 0.259145646999,
5.33445562929, 12.8970300261
};
D mn2plus_2[] = {
12.2767650475, 0.882704243597,
10.6798687876, 9.45354632275
};
D mn2plus_1[] = {
22.8872265683, 4.37063183528
};
D* mn2plus_c[] = { mn2plus_6, mn2plus_5, mn2plus_4, mn2plus_3, mn2plus_2, mn2plus_1 };

D mn3plus_s[] = { 6.0, 6.0, 6.0, 1.9, 0.9, 0.28 };
D mn3plus_e[] = {
0.00336278538911,
0.0046695277836,
0.00467462878661,
0.008351280683,
0.00931482654432,
0.00857124650733
};
D mn3plus_6[] = {
41.1780879499, 0.516636235755,
-34.8559464558, 0.544098628419,
10.9318908635, 5.2163144986,
2.71247176068, 13.7145860072,
1.41332734225, 0.017187450778,
0.618082264213, 0.11703093213
};
D mn3plus_5[] = {
11.7337345005, 5.5935500492,
6.93834400484, 0.38422319867,
1.72394907065, 17.1773718514,
0.965873270615, 0.0206721322334,
0.644118341047, 0.0206621210862
};
D mn3plus_4[] = {
11.7337282449, 5.59354228395,
6.93833356653, 0.384221323401,
1.72395533945, 17.177382983,
1.60998285702, 0.0206657300152
};
D mn3plus_3[] = {
7.89836965773, 0.251091897431,
7.08191595383, 9.28582994856,
7.00167267967, 3.8036260062
};
D mn3plus_2[] = {
11.932380227, 7.26167377537,
10.0208424112, 0.50029520942
};
D mn3plus_1[] = {
21.9079799851, 3.83716883486
};
D* mn3plus_c[] = { mn3plus_6, mn3plus_5, mn3plus_4, mn3plus_3, mn3plus_2, mn3plus_1 };

D mn4plus_s[] = { 6.0, 6.0, 6.0, 1.9, 1.1, 0.3 };
D mn4plus_e[] = {
0.0018006754712,
0.00466249362137,
0.00478478583866,
0.00497300150234,
0.00975314299351,
0.00809424760315
};
D mn4plus_6[] = {
34.0733936233, 0.595505613793,
-28.8965417306, 0.642416483744,
10.4236032648, 4.9171808473,
2.40954403986, 11.4106286243,
1.51965321037, 0.0189048651404,
1.4696059146, 0.216169177346
};
D mn4plus_5[] = {
6.94638329912, 0.38470038483,
6.40172130109, 5.54143018738,
5.29681268858, 5.55703802121,
1.61131974891, 0.0206959306673,
0.753385989176, 19.7995546008
};
D mn4plus_4[] = {
11.6996877052, 5.54767424328,
6.94522301951, 0.384567693203,
1.6110901023, 0.0206838919443,
0.753805487268, 19.7991945826
};
D mn4plus_3[] = {
8.78159491796, 7.25270024967,
7.82567400183, 0.247385674714,
4.37597058338, 3.06034043675
};
D mn4plus_2[] = {
11.9487753259, 6.18626767023,
9.00968958842, 0.353682231611
};
D mn4plus_1[] = {
20.9185835402, 3.39311339505
};
D* mn4plus_c[] = { mn4plus_6, mn4plus_5, mn4plus_4, mn4plus_3, mn4plus_2, mn4plus_1 };

D fe2plus_s[] = { 6.0, 6.0, 6.0, 1.9, 0.7, 0.26 };
D fe2plus_e[] = {
0.00191199227336,
0.00474361186011,
0.004753706457,
0.00693833705295,
0.0064712493835,
0.00827707788254
};
D fe2plus_6[] = {
12.1569781127, 4.92819140659,
11.0031834428, 0.434668440791,
-4.68444485914, 0.562857628433,
3.40324859485, 15.7097156046,
1.46546284482, 0.0165619202633,
0.649807742691, 0.130211442719
};
D fe2plus_5[] = {
12.4090513449, 5.10442902005,
6.97182682798, 0.351484666473,
3.00369842519, 16.7871068003,
0.968234155625, 0.0191804897929,
0.645538886866, 0.0191716633527
};
D fe2plus_4[] = {
12.4090210807, 5.10440883972,
6.97176294656, 0.35147755854,
3.00368687054, 16.7871096047,
1.61370944164, 0.0191748252546
};
D fe2plus_3[] = {
10.7556787804, 4.30170995299,
8.08468656259, 0.237147049617,
5.13923400598, 12.6864130192
};
D fe2plus_2[] = {
13.0769161878, 0.923763382111,
10.8817293861, 9.04640661972
};
D fe2plus_1[] = {
23.8943161573, 4.16816272329
};
D* fe2plus_c[] = { fe2plus_6, fe2plus_5, fe2plus_4, fe2plus_3, fe2plus_2, fe2plus_1 };

D fe3plus_s[] = { 6.0, 6.0, 6.0, 2.0, 0.9, 0.3 };
D fe3plus_e[] = {
0.000947238973264,
0.00539667304419,
0.00763738772881,
0.00951859137721,
0.00937148751528,
0.00988390706617
};
D fe3plus_6[] = {
11.560180773, 4.60965975478,
9.93108358964, 0.482748611916,
-4.74604107086, 0.675524263885,
3.22102389662, 12.5021033119,
1.53275532175, 0.0176377349946,
1.49864533126, 0.20817029932
};
D fe3plus_5[] = {
18.7093819976, 4.28342981963,
-7.38741479545, 3.59412734337,
6.99598023273, 0.350739021631,
3.07369118281, 12.9034255184,
1.60774385941, 0.0190020199751
};
D fe3plus_4[] = {
11.9266915364, 4.9053335128,
6.94464511287, 0.345992747465,
2.53875933216, 13.7355396725,
1.58940911105, 0.0185863500202
};
D fe3plus_3[] = {
11.1450231671, 7.10765696463,
7.57801275896, 0.214122838685,
4.22386820999, 2.25363704097
};
D fe3plus_2[] = {
12.4090714298, 6.86442449598,
10.5433021369, 0.521290749828
};
D fe3plus_1[] = {
22.8923829783, 3.5971480183
};
D* fe3plus_c[] = { fe3plus_6, fe3plus_5, fe3plus_4, fe3plus_3, fe3plus_2, fe3plus_1 };

D co2plus_s[] = { 6.0, 6.0, 6.0, 2.0, 0.7, 0.28 };
D co2plus_e[] = {
0.00219625491844,
0.00436197678874,
0.00484437485123,
0.00735709958515,
0.00590725303918,
0.00998222576519
};
D co2plus_6[] = {
19.1400628035, 0.388864500653,
12.8570135195, 4.4940044325,
-12.4774292113, 0.429802689375,
3.6821779188, 14.5734502697,
1.26410418566, 0.0348077193355,
0.526755878667, 0.00190087586956
};
D co2plus_5[] = {
16.8163333452, 4.95788921255,
-14.948068709, 8.97445477414,
14.5431755325, 11.0871186478,
6.95675169291, 0.321886067144,
1.61721903553, 0.017865602532
};
D co2plus_4[] = {
13.2426088042, 4.65602911079,
6.94613519199, 0.322425789036,
3.18320138017, 15.9666446329,
1.62544034561, 0.0180484409889
};
D co2plus_3[] = {
9.30087028578, 3.34124560949,
7.86055043642, 0.207379836561,
7.79103605212, 9.72882671072
};
D co2plus_2[] = {
13.9542728903, 0.962307418671,
11.0060819663, 8.69019464583
};
D co2plus_1[] = {
24.8765475385, 3.89890350166
};
D* co2plus_c[] = { co2plus_6, co2plus_5, co2plus_4, co2plus_3, co2plus_2, co2plus_1 };

D co3plus_s[] = { 6.0, 6.0, 6.0, 2.0, 0.9, 0.3 };
D co3plus_e[] = {
0.00385782257551,
0.00476297315294,
0.00616137157412,
0.00489506126928,
0.00912693054605,
0.00880264077405
};
D co3plus_6[] = {
11.4512374092, 3.97818059958,
5.67232063628, 0.493851482887,
4.49073395244, 10.4557053428,
4.48582432766, 0.289367969708,
-3.71834498325, 0.659630470624,
1.60959760238, 0.0177664439272
};
D co3plus_5[] = {
13.4045181295, 3.67576103223,
6.95346122051, 0.32181136694,
4.6998110467, 10.4064195162,
-2.68286296277, 2.27524857676,
1.61810308052, 0.017847004551
};
D co3plus_4[] = {
13.3315822534, 4.61419229664,
6.8839471178, 0.317933312744,
2.19071524758, 15.0925689908,
1.60420310991, 0.0175749407997
};
D co3plus_3[] = {
9.35811523679, 3.45256987642,
7.88288171805, 0.209910830837,
6.7382513407, 8.73850168377
};
D co3plus_2[] = {
12.9251859599, 6.52405653334,
11.0272724069, 0.544936221967
};
D co3plus_1[] = {
23.8983819591, 3.46039296317
};
D* co3plus_c[] = { co3plus_6, co3plus_5, co3plus_4, co3plus_3, co3plus_2, co3plus_1 };

D ni2plus_s[] = { 6.0, 6.0, 6.0, 2.0, 0.8, 0.28 };
D ni2plus_e[] = {
0.00346049678513,
0.0039266193141,
0.00437685553372,
0.00552918284071,
0.00975049219941,
0.00886203680432
};
D ni2plus_6[] = {
13.5332109257, 4.10216210753,
9.91320413063, 0.25489406417,
-6.11650357161, 0.140060881576,
3.99581587409, 13.4756763258,
3.87261851811, 0.0832413877969,
0.794303908849, 0.00209143014194
};
D ni2plus_5[] = {
21.2233579454, 3.80279558517,
-7.84188826934, 3.32870573088,
6.93787356092, 0.294858927061,
4.07316443103, 13.5911024378,
1.61190385858, 0.016416613217
};
D ni2plus_4[] = {
13.7713954431, 4.18646865174,
6.91665177169, 0.294330302198,
3.69714814337, 14.1793716961,
1.61446274417, 0.0165660947647
};
D ni2plus_3[] = {
10.9574548068, 3.30397344741,
7.91364440258, 0.193332220057,
7.09037754465, 9.84576083535
};
D ni2plus_2[] = {
13.57690477, 0.803597607168,
12.3662190649, 7.64452398047
};
D ni2plus_1[] = {
25.8850742468, 3.71631714724
};
D* ni2plus_c[] = { ni2plus_6, ni2plus_5, ni2plus_4, ni2plus_3, ni2plus_2, ni2plus_1 };

D ni3plus_s[] = { 6.0, 6.0, 6.0, 2.0, 0.9, 0.3 };
D ni3plus_e[] = {
0.00394859251684,
0.00429158684867,
0.00782320157504,
0.00472147829125,
0.00871347553178,
0.00784242367912
};
D ni3plus_6[] = {
11.3171197081, 3.24478943398,
6.25684639254, 8.76516261949,
4.73348758961, 0.264947410724,
4.7114446401, 0.499078987925,
-3.64761412996, 0.805789949445,
1.61245391499, 0.0165629135732
};
D ni3plus_5[] = {
15.2468355731, 3.14343687061,
6.94276530902, 0.295704119489,
5.64901380917, 9.26431186915,
-4.47123937257, 2.13639446918,
1.6216156623, 0.0167168588902
};
D ni3plus_4[] = {
13.7292947777, 4.11541841395,
6.82862529539, 0.288792750041,
2.85548683386, 12.8041494278,
1.5947458425, 0.0163081734117
};
D ni3plus_3[] = {
9.03277595215, 2.96007681004,
8.16707734383, 7.67163956047,
7.76819167497, 0.188408691652
};
D ni3plus_2[] = {
13.3232686557, 6.21648646989,
11.6303088773, 0.569983209369
};
D ni3plus_1[] = {
24.9045184963, 3.30949375793
};
D* ni3plus_c[] = { ni3plus_6, ni3plus_5, ni3plus_4, ni3plus_3, ni3plus_2, ni3plus_1 };

D cu1plus_s[] = { 6.0, 6.0, 6.0, 2.0, 0.7, 0.26 };
D cu1plus_e[] = {
0.00314355275783,
0.00314355275783,
0.00346063782977,
0.00697106251849,
0.00877648941636,
0.00921744205565
};
D cu1plus_6[] = {
14.0929879923, 3.81074374373,
6.8997608378, 0.272437621713,
3.03603693476, 10.6190344671,
2.33582292618, 19.5611344864,
0.810975774903, 0.0154850953757,
0.810975774903, 0.0154850953757
};
D cu1plus_5[] = {
14.0929879923, 3.81074374373,
6.8997608378, 0.272437621713,
3.03603693476, 10.6190344671,
2.33582292618, 19.5611344864,
1.62195154981, 0.0154850953757
};
D cu1plus_4[] = {
14.605321628, 3.86429417962,
6.8941311715, 0.272695146046,
4.84528424975, 15.081548203,
1.62919833713, 0.0156993555181
};
D cu1plus_3[] = {
14.2771915877, 3.61593689683,
8.15790291767, 0.18931579726,
5.53109774694, 13.918525977
};
D cu1plus_2[] = {
17.2345630192, 1.17659611713,
10.7016604755, 9.87120756963
};
D cu1plus_1[] = {
27.8580302931, 4.03797902856
};
D* cu1plus_c[] = { cu1plus_6, cu1plus_5, cu1plus_4, cu1plus_3, cu1plus_2, cu1plus_1 };

D cu2plus_s[] = { 6.0, 6.0, 6.0, 2.0, 0.8, 0.3 };
D cu2plus_e[] = {
0.00395242876453,
0.00516801588509,
0.00706926875048,
0.00448695595254,
0.00873622038586,
0.0099776034679
};
D cu2plus_6[] = {
10.6706326243, 2.156568259,
9.91717193871, 5.42483442933,
7.1399300502, 0.279000926902,
-4.86417620003, 1.42021837657,
2.49269049607, 15.1886199686,
1.63830100163, 0.0158531758343
};
D cu2plus_5[] = {
13.924763571, 3.62992903647,
9.98829470313, 0.297769621989,
4.80607137581, 11.722105353,
-3.37056391455, 0.385303939901,
1.63973938897, 0.0158042271847
};
D cu2plus_4[] = {
14.4188336753, 3.77542550431,
6.80641632104, 0.265227358796,
4.19529106085, 12.7958609845,
1.58286335673, 0.014740506922
};
D cu2plus_3[] = {
12.359628475, 3.18130979285,
7.87131386986, 0.178269967352,
6.73863127449, 9.74802018078
};
D cu2plus_2[] = {
14.3286525216, 0.828652871389,
12.6186080179, 7.29928360348
};
D cu2plus_1[] = {
26.8689510292, 3.4858640882
};
D* cu2plus_c[] = { cu2plus_6, cu2plus_5, cu2plus_4, cu2plus_3, cu2plus_2, cu2plus_1 };

D zn2plus_s[] = { 6.0, 6.0, 6.0, 2.0, 0.8, 0.3 };
D zn2plus_e[] = {
0.00235553832264,
0.00283162049203,
0.00349175955266,
0.00352292649034,
0.00798036801717,
0.00902145768424
};
D zn2plus_6[] = {
13.659752149, 2.7768937884,
6.95497061889, 0.253798822399,
6.91367955652, 7.32919332873,
-2.26690452161, 1.61904466177,
1.63251237188, 0.0146815855964,
1.10619800601, 19.7435649436
};
D zn2plus_5[] = {
15.7950174932, 0.271078128318,
14.7825146486, 3.4196105535,
-8.99391658392, 0.288916867438,
4.7685814615, 11.3898240181,
1.63609396928, 0.0147867506485
};
D zn2plus_4[] = {
14.8950311265, 3.45073656291,
6.85913865351, 0.249702627076,
4.625613958, 11.6126543012,
1.61113150069, 0.0141822500128
};
D zn2plus_3[] = {
13.4378597184, 3.02261523908,
7.98154466967, 0.1687408754,
6.5512483394, 9.55493525266
};
D zn2plus_2[] = {
15.3631767605, 0.855037231694,
12.5863578719, 7.08054903791
};
D zn2plus_1[] = {
27.8752972356, 3.31736292715
};
D* zn2plus_c[] = { zn2plus_6, zn2plus_5, zn2plus_4, zn2plus_3, zn2plus_2, zn2plus_1 };

D ga3plus_s[] = { 6.0, 6.0, 6.0, 2.5, 0.9, 0.35 };
D ga3plus_e[] = {
0.00413068131504,
0.00494559046266,
0.00947114052019,
0.00790509616727,
0.00702772250403,
0.00975973741188
};
D ga3plus_6[] = {
12.2978128018, 2.35180688785,
8.59959414123, 6.33497982604,
7.42041831869, 0.24567650994,
-2.25758960143, 0.823240822089,
1.66792320496, 0.0143684362387,
0.280191375671, 31.5005227463
};
D ga3plus_5[] = {
14.278951916, 2.83824272262,
10.0211351216, 0.26620286755,
5.78008753252, 8.17564600637,
-3.78062623576, 0.391490973015,
1.68936097358, 0.014720220412
};
D ga3plus_4[] = {
15.4255943614, 3.08846110501,
6.74243699336, 0.220570830434,
4.31352638787, 9.56157847238,
1.52331795421, 0.0116258609622
};
D ga3plus_3[] = {
11.4539, 2.37794666223,
8.90972752105, 6.59530146321,
7.60276831073, 0.142862536768
};
D ga3plus_2[] = {
14.1321671044, 5.48255881396,
13.8270611501, 0.642854148374
};
D ga3plus_1[] = {
27.8692705192, 2.79000270005
};
D* ga3plus_c[] = { ga3plus_6, ga3plus_5, ga3plus_4, ga3plus_3, ga3plus_2, ga3plus_1 };

D ge4plus_s[] = { 6.0, 6.0, 5.0, 2.5, 1.0, 0.38 };
D ge4plus_e[] = {
0.00403735025329,
0.00403864819791,
0.00879802823411,
0.00399110954905,
0.00673625306713,
0.00959398630645
};
D ge4plus_6[] = {
13.8689156976, 2.32593713236,
7.48603320187, 0.229063146197,
6.99424830179, 6.24812703594,
1.67623902056, 0.0136244617637,
-1.62896387654, 0.68884826239,
-0.407242654814, 0.688842140256
};
D ge4plus_5[] = {
13.868909309, 2.32593713236,
7.48603896511, 0.229063146197,
6.99423810234, 6.24812703594,
-2.03621001488, 0.688907602847,
1.67624556361, 0.0136413935087
};
D ge4plus_4[] = {
15.9851805774, 2.80880621741,
6.7565885833, 0.200369801479,
3.82092557702, 8.27976674332,
1.44603896664, 0.00875037380469
};
D ge4plus_3[] = {
13.8480203642, 2.4567640923,
7.75041063864, 0.137907723422,
6.39192497212, 6.46766456568
};
D ge4plus_2[] = {
15.2574942303, 4.46754987249,
12.7067910365, 0.497439111925
};
D ge4plus_1[] = {
27.8826470792, 2.42850476692
};
D* ge4plus_c[] = { ge4plus_6, ge4plus_5, ge4plus_4, ge4plus_3, ge4plus_2, ge4plus_1 };

D br1minus_s[] = { 6.0, 6.0, 2.5, 1.1, 0.55, 0.15 };
D br1minus_e[] = {
0.00265177240569,
0.00552762790894,
0.00257958193983,
0.00939813833393,
0.00958352871916,
0.0086573299302
};
D br1minus_6[] = {
17.6106518758, 2.11002272355,
17.4303271711, 0.126433989932,
-11.8388557499, 0.100874440101,
5.73274927883, 17.1453393884,
4.53890085076, 52.135764185,
2.50116165065, 0.0191765499506
};
D br1minus_5[] = {
17.7105578028, 2.14884711207,
6.91132836502, 20.3835464613,
6.6764723839, 0.165653598023,
3.16546655427, 64.1156658323,
1.5266045028, 0.00881502680427
};
D br1minus_4[] = {
17.3705999542, 2.00739616179,
7.76484464958, 0.113153157007,
6.24696158824, 43.5187193428,
4.57241579773, 12.1950994993
};
D br1minus_3[] = {
15.0620754512, 0.513989008282,
12.7192689275, 3.69519714711,
8.14051603141, 36.2772130372
};
D br1minus_2[] = {
26.5209157486, 1.4801116945,
9.35721705331, 31.7093150563
};
D br1minus_1[] = {
35.7929132999, 7.97546184337
};
D* br1minus_c[] = { br1minus_6, br1minus_5, br1minus_4, br1minus_3, br1minus_2, br1minus_1 };

D rb1plus_s[] = { 6.0, 6.0, 6.0, 2.0, 0.7, 0.2 };
D rb1plus_e[] = {
0.000892458826383,
0.00789549843582,
0.00901595414494,
0.00742412575637,
0.00672308587846,
0.00819956066154
};
D rb1plus_6[] = {
17.8405120092, 1.66069687206,
9.54662461484, 0.177519747148,
5.62192344389, 12.4473073103,
5.02413632129, 25.7223705038,
-3.80625533313, 0.287884215588,
1.76725802734, 0.0114607706848
};
D rb1plus_5[] = {
17.9823420529, 1.78218018989,
11.1726633057, 0.1184016019,
9.90607250448, 18.9939902803,
-7.14926380279, 0.0688979440264,
4.04566357291, 0.0254108334271
};
D rb1plus_4[] = {
17.9411727907, 1.78857969749,
9.89507166343, 19.01584948,
6.56763461729, 0.144907190866,
1.55404334479, 0.00839932686787
};
D rb1plus_3[] = {
17.9638183497, 1.79702915215,
9.87116079979, 19.02539945,
8.12079560471, 0.113939650531
};
D rb1plus_2[] = {
25.1635379343, 1.05255271041,
10.770947683, 17.693896835
};
D rb1plus_1[] = {
35.8249867166, 5.15348914404
};
D* rb1plus_c[] = { rb1plus_6, rb1plus_5, rb1plus_4, rb1plus_3, rb1plus_2, rb1plus_1 };

D sr2plus_s[] = { 6.0, 6.0, 6.0, 3.0, 0.8, 0.22 };
D sr2plus_e[] = {
0.00105484875999,
0.0057844797335,
0.00640504197101,
0.00785619599043,
0.00795262562728,
0.00836332808348
};
D sr2plus_6[] = {
18.0283908302, 1.50684125965,
10.3562161247, 0.172852587859,
8.9341922761, 13.2732950369,
-4.85342353631, 0.270175680849,
1.82502764088, 0.0116903682697,
1.71187242608, 28.3770617032
};
D sr2plus_5[] = {
18.449102396, 0.0935985775476,
17.914349352, 1.58852763748,
-15.4493430392, 0.0672069127815,
10.1760931771, 15.6252258228,
4.88109965771, 0.0253483459103
};
D sr2plus_4[] = {
17.8601976949, 1.59949055674,
10.1451810165, 15.6586385759,
6.63041469439, 0.127295727605,
1.33019142263, 0.0038412422291
};
D sr2plus_3[] = {
18.0767914951, 1.56063518321,
10.2422601571, 15.475201363,
7.64105919371, 0.0908340434334
};
D sr2plus_2[] = {
24.5530418265, 0.904477097841,
11.3795692216, 14.1333627341
};
D sr2plus_1[] = {
35.8328511095, 4.40455895851
};
D* sr2plus_c[] = { sr2plus_6, sr2plus_5, sr2plus_4, sr2plus_3, sr2plus_2, sr2plus_1 };

D y3plus_s[] = { 6.0, 6.0, 6.0, 3.0, 0.9, 0.25 };
D y3plus_e[] = {
0.0020574423623,
0.00559195598096,
0.00814763885859,
0.0054670532347,
0.00950766718693,
0.0094015098788
};
D y3plus_6[] = {
18.3968325733, 1.30900687263,
7.34274247851, 0.143189999366,
6.53615870289, 15.7347848863,
4.64056516728, 8.4285868169,
-2.64562288622, 0.445653654124,
1.72300123514, 0.00987452300105
};
D y3plus_5[] = {
-355.858723493, 0.05586035192,
214.413568992, 0.0626539429026,
149.229652503, 0.0481014103254,
17.7588559145, 1.4361074459,
10.4322619157, 13.1106161002
};
D y3plus_4[] = {
17.6808947672, 1.44440381718,
10.4253416002, 13.0924347216,
6.69467508867, 0.115058334353,
1.1723584006, 0.000430966894583
};
D y3plus_3[] = {
17.9433074992, 1.40475303467,
10.5236761903, 12.9752454537,
7.50305231095, 0.0824340965413
};
D y3plus_2[] = {
23.9639688518, 0.787691209582,
11.9643771825, 11.5729262765
};
D y3plus_1[] = {
35.8121155422, 3.76796329056
};
D* y3plus_c[] = { y3plus_6, y3plus_5, y3plus_4, y3plus_3, y3plus_2, y3plus_1 };

D zr4plus_s[] = { 6.0, 6.0, 4.0, 3.5, 0.9, 0.26 };
D zr4plus_e[] = {
0.00293413638327,
0.00563346805204,
0.00715629366289,
0.00501078857249,
0.00630913003878,
0.00806994376292
};
D zr4plus_6[] = {
18.447340881, 1.18405200364,
8.89780058783, 0.157269399817,
7.80444206419, 12.6246660211,
-4.68325571064, 0.330145000746,
3.51328354727, 6.98161099211,
2.01328764548, 0.0130827941965
};
D zr4plus_5[] = {
18.0176942779, 1.27489641144,
11.1949385723, 0.157539500551,
10.6895351724, 11.2068031147,
-5.84845365887, 0.229424694873,
1.9284170646, 0.01216728654
};
D zr4plus_4[] = {
17.6345055358, 1.30791203643,
10.6179843045, 11.2726622598,
6.60592626307, 0.103599876018,
1.12564708693, 0.00303478249644
};
D zr4plus_3[] = {
17.7734133861, 1.26744992396,
10.7877635507, 11.0724056318,
7.41457517106, 0.0764947481608
};
D zr4plus_2[] = {
23.8891540324, 0.728142950785,
12.0607768116, 10.1409335332
};
D zr4plus_1[] = {
35.8381192947, 3.36415474195
};
D* zr4plus_c[] = { zr4plus_6, zr4plus_5, zr4plus_4, zr4plus_3, zr4plus_2, zr4plus_1 };

D nb3plus_s[] = { 6.0, 4.0, 4.0, 2.0, 0.8, 0.24 };
D nb3plus_e[] = {
0.00588955502773,
0.00499466474875,
0.00814214735406,
0.00945237342265,
0.00737339901853,
0.00967316108841
};
D nb3plus_6[] = {
19.3497463696, 1.0412386389,
12.6248153046, 0.179883427127,
-9.77760632936, 0.301400069199,
7.11133719627, 7.5163117548,
6.36685950741, 17.2438828806,
2.30192248471, 0.0157787647734
};
D nb3plus_5[] = {
17.6163232355, 1.16156183482,
9.74462763424, 9.57976188864,
5.36943928833, 0.0581038625261,
3.1946722409, 22.0848701884,
2.061198819, 0.125027046495
};
D nb3plus_4[] = {
17.4202226204, 1.12261041173,
7.64648627696, 15.9440613885,
7.20545824082, 0.069104186493,
5.69776849767, 6.92958302064
};
D nb3plus_3[] = {
17.6183400651, 1.31193510861,
11.881198903, 12.7973587692,
8.43509868407, 0.105008616681
};
D nb3plus_2[] = {
25.1744688648, 0.770773818286,
12.7429795033, 12.1163156199
};
D nb3plus_1[] = {
37.7998547132, 3.95823489846
};
D* nb3plus_c[] = { nb3plus_6, nb3plus_5, nb3plus_4, nb3plus_3, nb3plus_2, nb3plus_1 };

D nb5plus_s[] = { 6.0, 6.0, 4.0, 3.5, 1.0, 0.28 };
D nb5plus_e[] = {
0.00306834047881,
0.0073981050464,
0.00326650270902,
0.00104730579893,
0.00757732902595,
0.00838705599843
};
D nb5plus_6[] = {
-56.2190777781, 0.326546150819,
33.6145218004, 0.232823223275,
30.7645923816, 0.442049239588,
14.5449725594, 1.27136718274,
10.7923764712, 9.80242317976,
2.49152337324, 0.0176365980791
};
D nb5plus_5[] = {
28.9548584488, 0.183740210645,
-24.4192325003, 0.21525956176,
18.4624180081, 1.12997313415,
10.9512980577, 9.68298144636,
2.03519584365, 0.01230110402
};
D nb5plus_4[] = {
17.6685160414, 1.16887533703,
10.8925998102, 9.72032030251,
6.90996750854, 0.0803793984007,
0.514562405651, 0.00330615600007
};
D nb5plus_3[] = {
17.7398863368, 1.160593637,
10.9188297535, 9.69655399567,
7.32567504128, 0.0710750543894
};
D nb5plus_2[] = {
23.4326914522, 0.644662003231,
12.5153646084, 8.66117479592
};
D nb5plus_1[] = {
35.8418277295, 2.99462374439
};
D* nb5plus_c[] = { nb5plus_6, nb5plus_5, nb5plus_4, nb5plus_3, nb5plus_2, nb5plus_1 };

D mo3plus_s[] = { 6.0, 6.0, 6.0, 3.0, 0.8, 0.24 };
D mo3plus_e[] = {
0.000987887786112,
0.00898290231337,
0.00866815508521,
0.00986138559721,
0.00745309111384,
0.00951269037884
};
D mo3plus_6[] = {
19.0027905873, 1.01566468463,
11.7326817764, 9.54795240694,
8.01554706305, 0.131593416767,
-4.00013521014, 0.322593353267,
2.3089202859, 26.5951153669,
1.93918757608, 0.0110589219682
};
D mo3plus_5[] = {
19.2333201294, 1.16278118356,
12.9707009396, 12.1137456413,
6.44150914637, 0.100469753678,
1.39664922236, 0.00432852835252,
-1.1226568231, 1.1625936947
};
D mo3plus_4[] = {
18.117718933, 1.1620915576,
12.972574808, 12.1119816692,
6.48788483962, 0.0994473987233,
1.34128035268, 0.0033466983436
};
D mo3plus_3[] = {
18.3188870634, 1.14468107806,
13.0152411164, 12.0720126341,
7.58377586849, 0.072546006161
};
D mo3plus_2[] = {
25.4208365472, 0.737305145491,
13.4926440089, 11.8078959621
};
D mo3plus_1[] = {
38.7986318021, 3.97319932477
};
D* mo3plus_c[] = { mo3plus_6, mo3plus_5, mo3plus_4, mo3plus_3, mo3plus_2, mo3plus_1 };

D mo5plus_s[] = { 6.0, 6.0, 4.0, 3.5, 1.0, 0.28 };
D mo5plus_e[] = {
0.000820439504605,
0.00319319920423,
0.00362497783278,
0.00240173848844,
0.00756874570276,
0.00892523834256
};
D mo5plus_6[] = {
19.2576252463, 1.00207133412,
11.3758258832, 8.76540039153,
7.26068942029, 0.117542211222,
-3.38691635623, 0.395834839339,
1.67446345381, 0.00772127083872,
0.819138873305, 22.089536559
};
D mo5plus_5[] = {
72.6284626041, 0.148729861062,
-67.1008046407, 0.155080545736,
18.0497510929, 1.08078341179,
11.7461434515, 9.61629345502,
1.65180130819, 0.00700256313106
};
D mo5plus_4[] = {
17.7636481537, 1.09496090857,
11.7366923009, 9.60681940761,
6.47801242876, 0.0834016117058,
0.995258265208, 0.00852829336942
};
D mo5plus_3[] = {
17.8887257598, 1.08358761954,
11.7699020256, 9.58289387385,
7.31427079503, 0.0671699356635
};
D mo5plus_2[] = {
23.7755845674, 0.617840682456,
13.1650736575, 8.7263474437
};
D mo5plus_1[] = {
36.8272738481, 3.05195553879
};
D* mo5plus_c[] = { mo5plus_6, mo5plus_5, mo5plus_4, mo5plus_3, mo5plus_2, mo5plus_1 };

D mo6plus_s[] = { 6.0, 6.0, 4.0, 3.5, 1.1, 0.3 };
D mo6plus_e[] = {
0.000731642181526,
0.000834146908842,
0.00583353557461,
0.002129006579,
0.00922339183816,
0.00846063322484
};
D mo6plus_6[] = {
19.523987123, 0.996596652025,
11.169668631, 8.39726515365,
7.11487043803, 0.116119498082,
-3.54677673126, 0.430154200183,
1.66891781045, 0.00771782253782,
0.0729398246087, 54.0601871999
};
D mo6plus_5[] = {
19.5104626887, 0.997387534245,
11.2067020086, 8.47002175751,
7.1008985643, 0.115510905817,
-3.4868388967, 0.429552161348,
1.65568850298, 0.00757035306243
};
D mo6plus_4[] = {
17.6401585685, 1.07412929741,
11.0062336479, 8.62282841749,
6.41508554979, 0.077983665949,
0.933904229469, 0.0159267505472
};
D mo6plus_3[] = {
17.6781713727, 1.06872809116,
11.0390849019, 8.57978579159,
7.27524687075, 0.0667266185651
};
D mo6plus_2[] = {
22.9956609582, 0.574694451584,
12.9489940491, 7.48998188084
};
D mo6plus_1[] = {
35.8431397313, 2.68594762429
};
D* mo6plus_c[] = { mo6plus_6, mo6plus_5, mo6plus_4, mo6plus_3, mo6plus_2, mo6plus_1 };

D ru3plus_s[] = { 6.0, 6.0, 6.0, 3.0, 0.9, 0.25 };
D ru3plus_e[] = {
0.00161911486737,
0.00878953306791,
0.00878930578527,
0.00998562474456,
0.00968365643369,
0.00961074415008
};
D ru3plus_6[] = {
21.107471488, 0.825216168521,
13.4137506582, 8.50142283988,
7.20499319191, 0.104441594113,
-5.16643017272, 0.408376797089,
2.80942048482, 23.5246931501,
1.63013984871, 0.00623660733456
};
D ru3plus_5[] = {
23.6148903904, 1.00030000457,
14.9694026017, 10.8934429555,
6.54271233524, 0.086883032148,
-5.43350691421, 1.00026761216,
1.21312871534, 0.000755987515403
};
D ru3plus_4[] = {
18.1813665302, 1.00031455779,
14.9693863275, 10.8934456506,
6.54267765561, 0.0868847505505,
1.21320096196, 0.000757290215604
};
D ru3plus_3[] = {
18.3425380073, 0.990303247192,
14.9935363225, 10.8757033155,
7.56968941267, 0.0658550377396
};
D ru3plus_2[] = {
25.2636559402, 0.626066140846,
15.6269361429, 10.5151447485
};
D ru3plus_1[] = {
40.7809620761, 3.87077660948
};
D* ru3plus_c[] = { ru3plus_6, ru3plus_5, ru3plus_4, ru3plus_3, ru3plus_2, ru3plus_1 };

D ru4plus_s[] = { 6.0, 5.0, 4.0, 3.5, 1.0, 0.26 };
D ru4plus_e[] = {
0.00181156592033,
0.00702669386547,
0.00437889998029,
0.00603930889364,
0.0095101476793,
0.00839975265616
};
D ru4plus_6[] = {
21.4272547018, 0.817026207572,
13.2364962727, 8.21713667309,
7.2049472298, 0.105789884374,
-5.60671815784, 0.415514745049,
2.06097483497, 21.1942830935,
1.67765148459, 0.00686805867913
};
D ru4plus_5[] = {
18.048625874, 0.966876037902,
15.2957175225, 0.0629730552785,
14.3601854436, 9.86579233291,
-11.3619717207, 0.0440019856127,
3.59740875438, 0.0140047014119
};
D ru4plus_4[] = {
17.9771489871, 0.922353844983,
14.3821496011, 9.17815870058,
7.16706143799, 0.0585829972925,
0.499750468468, 56.2200878586
};
D ru4plus_3[] = {
18.2136421714, 0.953792258618,
14.4015964784, 9.83764291281,
7.32335925891, 0.0610368319049
};
D ru4plus_2[] = {
24.4962028811, 0.574243900585,
15.4130622099, 9.25471351926
};
D ru4plus_1[] = {
39.8131972302, 3.47692811954
};
D* ru4plus_c[] = { ru4plus_6, ru4plus_5, ru4plus_4, ru4plus_3, ru4plus_2, ru4plus_1 };

D rh3plus_s[] = { 6.0, 6.0, 6.0, 1.8, 0.9, 0.25 };
D rh3plus_e[] = {
0.001983977929,
0.00959974526958,
0.00959980051996,
0.00859984129514,
0.00926162289011,
0.00896707908067
};
D rh3plus_6[] = {
23.2094786428, 0.735294966214,
14.3312662717, 8.01092619429,
-7.54234663325, 0.410978690516,
7.2500964329, 0.102265570267,
3.01764598365, 22.1098053961,
1.73343278776, 0.00719984272944
};
D rh3plus_5[] = {
25.9621454227, 0.929076207851,
16.0059786694, 10.2733638457,
-7.78219237311, 0.929047445827,
6.50793029736, 0.0818318025069,
1.20785328816, 0.00078858802598
};
D rh3plus_4[] = {
18.1799527998, 0.92908794105,
16.0059787129, 10.2733658992,
6.50792945666, 0.0818318094135,
1.20785352297, 0.000788582801558
};
D rh3plus_3[] = {
15.5169232348, 10.5233527721,
14.6084670706, 1.19805976888,
11.7836912415, 0.173293763471
};
D rh3plus_2[] = {
25.3912751991, 0.597033874742,
16.5008230918, 10.046765914
};
D rh3plus_1[] = {
41.7910854983, 3.82745825435
};
D* rh3plus_c[] = { rh3plus_6, rh3plus_5, rh3plus_4, rh3plus_3, rh3plus_2, rh3plus_1 };

D rh4plus_s[] = { 6.0, 5.0, 5.0, 4.0, 1.0, 0.26 };
D rh4plus_e[] = {
0.00207211081996,
0.00789748305301,
0.00747418395124,
0.00644870488763,
0.00904369082261,
0.00795585289494
};
D rh4plus_6[] = {
24.0376087766, 0.724980735344,
14.0468199457, 7.7272824511,
-8.40748442367, 0.424990109394,
7.22429301577, 0.101706672503,
2.38032370293, 19.6616569841,
1.71871448272, 0.00702602536367
};
D rh4plus_5[] = {
17.9846763838, 0.907678946374,
15.4506874526, 0.0872826023325,
15.3418882561, 9.40701068347,
-9.56371426722, 0.0890368533825,
1.72318977349, 0.011193405478
};
D rh4plus_4[] = {
17.9239776947, 0.902800423718,
15.4179774074, 9.3280591505,
5.87562386811, 0.0832491285081,
1.71073763172, 0.0120134884047
};
D rh4plus_3[] = {
18.2500753825, 0.883340061883,
15.4398316764, 9.34400156369,
7.24317937151, 0.0566949236825
};
D rh4plus_2[] = {
24.6154253394, 0.545696484295,
16.2939204412, 8.91355229968
};
D rh4plus_1[] = {
40.8186654851, 3.45694650832
};
D* rh4plus_c[] = { rh4plus_6, rh4plus_5, rh4plus_4, rh4plus_3, rh4plus_2, rh4plus_1 };

D pd2plus_s[] = { 6.0, 4.0, 4.0, 1.4, 0.8, 0.24 };
D pd2plus_e[] = {
0.00193028513459,
0.00145483161322,
0.00780911105704,
0.00509063286569,
0.00948501104854,
0.00973322897885
};
D pd2plus_6[] = {
157.16586142, 0.576787004705,
-141.143667044, 0.550872493802,
15.4465014971, 7.71915756733,
7.02790454146, 0.0898637649771,
3.98940373854, 23.4119697685,
1.50997670794, 0.00420515609988
};
D pd2plus_5[] = {
162.519965656, 4.82389477534,
-151.19619299, 4.64330975487,
18.845332064, 0.824076306382,
7.1234110719, 0.0524833925021,
6.69093680319, 18.7293748969
};
D pd2plus_4[] = {
17.9496291224, 0.777215701352,
15.7045797337, 8.07054391051,
6.91929646033, 0.0500936692966,
3.42497306788, 25.0747286279
};
D pd2plus_3[] = {
21.4258951173, 0.382415912786,
12.2630134383, 13.6148868752,
10.2462505043, 3.88227600024
};
D pd2plus_2[] = {
26.711476392, 0.660762661168,
17.1648123972, 11.0354693855
};
D pd2plus_1[] = {
43.7702594496, 4.18206674843
};
D* pd2plus_c[] = { pd2plus_6, pd2plus_5, pd2plus_4, pd2plus_3, pd2plus_2, pd2plus_1 };

D pd4plus_s[] = { 6.0, 5.0, 5.0, 4.0, 1.0, 0.26 };
D pd4plus_e[] = {
0.0020616875785,
0.00716152827551,
0.00715988664634,
0.00734975002622,
0.00864214858004,
0.00746080760987
};
D pd4plus_6[] = {
21.3127966913, 0.693701052045,
15.2595197562, 7.45068921223,
8.01277861145, 0.105170437163,
-6.64908641412, 0.307833818964,
2.20664264338, 19.8410651014,
1.85925660486, 0.00799005253239
};
D pd4plus_5[] = {
23.0649852807, 8.87424409418,
18.0287981641, 0.83503096192,
-6.62661953945, 8.84979966368,
5.41607201862, 0.0790344880633,
2.04704094721, 0.0167022362603
};
D pd4plus_4[] = {
18.0284107487, 0.835034545943,
16.4385481718, 8.8841137693,
5.41613054001, 0.0790438794463,
2.04723773906, 0.0167030745885
};
D pd4plus_3[] = {
18.2501716117, 0.820905236411,
16.4875851039, 8.85744233571,
7.19092695047, 0.0533496503559
};
D pd4plus_2[] = {
24.7115837745, 0.518886199758,
17.1984970672, 8.54851654297
};
D pd4plus_1[] = {
41.8259707479, 3.42334388181
};
D* pd4plus_c[] = { pd4plus_6, pd4plus_5, pd4plus_4, pd4plus_3, pd4plus_2, pd4plus_1 };

D ag1plus_s[] = { 6.0, 4.0, 4.0, 1.4, 0.7, 0.22 };
D ag1plus_e[] = {
0.0015145481622,
0.00125164590644,
0.00832094753016,
0.00594953075075,
0.00885791864512,
0.00884941847706
};
D ag1plus_6[] = {
120.305545175, 0.531861433357,
-104.737476607, 0.497127069824,
16.8624488709, 7.53158878924,
6.85820964488, 0.0974890341502,
4.59489951165, 26.3184612332,
2.1060788151, 0.0107673982083
};
D ag1plus_5[] = {
193.296146844, 0.927348574778,
-176.122775075, 0.952158987023,
16.9181765605, 7.3903820323,
7.1271283682, 0.0499211462512,
4.7700318169, 25.8456399965
};
D ag1plus_4[] = {
17.9606825512, 0.726372701908,
16.6013516251, 7.72935357902,
6.89115040564, 0.0472819241496,
4.52772828012, 25.8503230693
};
D ag1plus_3[] = {
22.1645885354, 0.378690545867,
13.5173628366, 4.90734708179,
10.2505273867, 16.9025105798
};
D ag1plus_2[] = {
28.8585499501, 0.805245374717,
17.0076588784, 12.5918275879
};
D ag1plus_1[] = {
45.7710851591, 4.61281099401
};
D* ag1plus_c[] = { ag1plus_6, ag1plus_5, ag1plus_4, ag1plus_3, ag1plus_2, ag1plus_1 };

D ag2plus_s[] = { 6.0, 4.0, 4.0, 1.5, 0.8, 0.25 };
D ag2plus_e[] = {
0.00191151386032,
0.00135489499535,
0.00996860614188,
0.00683171727551,
0.00898936508273,
0.00992839744263
};
D ag2plus_6[] = {
33.8879079722, 0.573794311198,
-19.1646590826, 0.406702472407,
16.4171365818, 7.28961144793,
7.23036961966, 0.110277061042,
4.13440501935, 21.9885766436,
2.49128654735, 0.0141307162113
};
D ag2plus_5[] = {
35.1853600519, 0.879672594689,
-18.3387919206, 1.09606051514,
16.3499074491, 6.97660827759,
7.14781613495, 0.0501486970492,
4.65024729014, 20.918539344
};
D ag2plus_4[] = {
17.9537655166, 0.72454113549,
16.7503059496, 7.69729941161,
6.8723106467, 0.0470088773754,
3.43280138767, 24.0035541151
};
D ag2plus_3[] = {
21.1212947884, 0.349668807221,
13.6396062605, 12.3702805418,
10.1654365258, 3.44568968188
};
D ag2plus_2[] = {
26.9172699642, 0.640835842507,
17.9640807728, 10.474192227
};
D ag2plus_1[] = {
44.7535837331, 4.02872590104
};
D* ag2plus_c[] = { ag2plus_6, ag2plus_5, ag2plus_4, ag2plus_3, ag2plus_2, ag2plus_1 };

D cd2plus_s[] = { 6.0, 5.0, 4.0, 1.6, 0.8, 0.25 };
D cd2plus_e[] = {
0.0029309531318,
0.00976963915877,
0.00982348559269,
0.00881517355345,
0.00851050397208,
0.00903342752881
};
D cd2plus_6[] = {
22.1300304254, 0.598167298573,
18.4308426357, 7.30282146019,
-11.9379769198, 0.244947576914,
11.1663744475, 0.139655056693,
3.19404351584, 0.0188384298709,
3.03670233612, 25.6525194494
};
D cd2plus_5[] = {
18.1996453188, 7.46294927339,
17.9096697331, 0.683185411671,
5.06369496132, 0.0552885080096,
2.96862186531, 24.8278650163,
1.86439169781, 0.0238940011104
};
D cd2plus_4[] = {
18.2457757248, 7.46294927339,
18.0020421454, 0.676781821552,
6.80878961096, 0.0441074032037,
2.94793484695, 24.8399846262
};
D cd2plus_3[] = {
20.8284525128, 0.320672873475,
15.0096107479, 11.3005350502,
10.0792911382, 3.06922248664
};
D cd2plus_2[] = {
27.1454698729, 0.624428972539,
18.7407005389, 9.94904012017
};
D cd2plus_1[] = {
45.7703602668, 3.93848543708
};
D* cd2plus_c[] = { cd2plus_6, cd2plus_5, cd2plus_4, cd2plus_3, cd2plus_2, cd2plus_1 };

D in3plus_s[] = { 6.0, 5.0, 3.5, 1.7, 0.9, 0.26 };
D in3plus_e[] = {
0.00352048326414,
0.00908780880781,
0.00807729429872,
0.00960552351929,
0.0077326709051,
0.00737550639198
};
D in3plus_6[] = {
-634.576286348, 0.265428084616,
596.680527888, 0.258565034489,
57.5394479271, 0.42597065927,
18.1484069261, 6.33700103639,
4.44927510908, 0.026211771009,
3.75865336851, 17.3734316354
};
D in3plus_5[] = {
623.7323416, 4.65422053057,
-607.534827374, 4.61062459548,
18.3641568353, 0.64617846246,
6.81932904722, 0.0420410643163,
4.63045696968, 16.8699400996
};
D in3plus_4[] = {
18.7677658438, 6.77327298848,
18.0044848641, 0.617852660511,
6.55892327939, 0.0381509160055,
2.68008637265, 19.9466998735
};
D in3plus_3[] = {
20.1774443662, 0.288373343583,
16.9816497138, 9.13033692607,
8.77051768304, 2.35002850502
};
D in3plus_2[] = {
25.9363676085, 0.510222494044,
19.9654228912, 8.2854902324
};
D in3plus_1[] = {
45.8127671045, 3.51809012229
};
D* in3plus_c[] = { in3plus_6, in3plus_5, in3plus_4, in3plus_3, in3plus_2, in3plus_1 };

D sn2plus_s[] = { 6.0, 5.0, 3.5, 1.6, 0.65, 0.22 };
D sn2plus_e[] = {
0.00509336354232,
0.00615150967518,
0.00704929703123,
0.00930086832668,
0.00842347070077,
0.00846737755618
};
D sn2plus_6[] = {
-1567.9428928, 0.305511623349,
1286.30646136, 0.318286423815,
301.208126617, 0.262936556474,
19.5331509843, 6.00773478977,
4.46157759949, 28.0503330679,
4.42205926038, 0.0245725480579
};
D sn2plus_5[] = {
20.0330568462, 5.74639849893,
19.9056770606, 0.633694647413,
6.84423920759, 0.0403958054294,
4.78454360834, 26.8031155079,
-3.58367347475, 1.51269820949
};
D sn2plus_4[] = {
20.0811224685, 6.55574581876,
18.0662024811, 0.584864837143,
6.56834501216, 0.0366044320553,
3.33192657115, 37.4467030875
};
D sn2plus_3[] = {
22.1164438441, 0.312440051695,
18.4102698652, 4.73418318858,
7.39983890917, 19.5310272638
};
D sn2plus_2[] = {
32.9016961599, 0.994781826346,
14.9564057783, 12.9537101973
};
D sn2plus_1[] = {
47.7646728338, 4.20826102918
};
D* sn2plus_c[] = { sn2plus_6, sn2plus_5, sn2plus_4, sn2plus_3, sn2plus_2, sn2plus_1 };

D sn4plus_s[] = { 6.0, 6.0, 5.0, 5.0, 1.1, 0.3 };
D sn4plus_e[] = {
0.00464477728368,
0.00787675347349,
0.00756058279951,
0.00788603094198,
0.00837317948979,
0.00917085859016
};
D sn4plus_6[] = {
-760.894464324, 0.296266659282,
527.121227902, 0.323228422228,
253.531301243, 0.254868933641,
20.2156390019, 6.15819984538,
4.22629420871, 0.0232601115027,
1.81012858085, 18.4995649583
};
D sn4plus_5[] = {
-762.376203634, 0.00504419181718,
521.399977434, 0.00713734440562,
247.75231589, 0.00154417272663,
20.950683649, 7.01693489096,
18.202224899, 0.605628520681
};
D sn4plus_4[] = {
21.0402923469, 6.8775323132,
18.0341546059, 0.596792086768,
6.75140351833, 0.0394898706512,
0.226362198339, 251.297006319
};
D sn4plus_3[] = {
20.9547831947, 7.0152600456,
18.1555765089, 0.605887177524,
6.81840971331, 0.0401455609886
};
D sn4plus_2[] = {
24.41113694, 0.397977747211,
21.5004891476, 6.86042893956
};
D sn4plus_1[] = {
45.7910139295, 3.06252494641
};
D* sn4plus_c[] = { sn4plus_6, sn4plus_5, sn4plus_4, sn4plus_3, sn4plus_2, sn4plus_1 };

D sb3plus_s[] = { 6.0, 5.0, 4.0, 1.6, 0.7, 0.25 };
D sb3plus_e[] = {
0.00376892598101,
0.00423045105671,
0.00779213854793,
0.00618300875931,
0.00779735770231,
0.00946522662851
};
D sb3plus_6[] = {
-4238.2371317, 0.308885635857,
4208.82500028, 0.310756458642,
48.9128296192, 0.206567295864,
19.3752657857, 5.37787114721,
4.81603216055, 22.3099934553,
4.30103305539, 0.0228853864079
};
D sb3plus_5[] = {
20.4711321901, 0.604786841687,
19.9132254246, 5.03972926552,
6.8493567917, 0.0386110280133,
5.38186375497, 20.8500766723,
-4.63030646933, 1.35362258731
};
D sb3plus_4[] = {
20.3082979432, 6.01052792913,
17.8884553558, 0.553763185852,
6.65624052065, 0.0366233731277,
3.19832247451, 31.7722539655
};
D sb3plus_3[] = {
21.9870799745, 0.294069193351,
18.1894285843, 4.28026514278,
7.77246946156, 16.4477064302
};
D sb3plus_2[] = {
31.9453094641, 0.854182484565,
15.9332430384, 10.9446005597
};
D sb3plus_1[] = {
47.7396813223, 3.67822011258
};
D* sb3plus_c[] = { sb3plus_6, sb3plus_5, sb3plus_4, sb3plus_3, sb3plus_2, sb3plus_1 };

D sb5plus_s[] = { 6.0, 6.0, 5.0, 5.0, 1.2, 0.32 };
D sb5plus_e[] = {
0.00407459413798,
0.00756813045944,
0.00673760903722,
0.00755796773455,
0.00887539662358,
0.00957541123556
};
D sb5plus_6[] = {
-2328.70702825, 0.272373234051,
1185.15032115, 0.256560325477,
1163.01557701, 0.291526460714,
20.0311854776, 5.50790092296,
4.31617190619, 0.0228696658634,
2.20024374027, 14.6305371168
};
D sb5plus_5[] = {
-2332.95762725, 0.00231811193919,
1180.89962254, 0.000940014213883,
1158.76302362, 0.00391397346343,
21.1571263469, 6.32669299444,
18.0736092555, 0.564324546322
};
D sb5plus_4[] = {
2339.62932409, 0.0249335233597,
-2332.99094923, 0.0249032533001,
21.2541175668, 6.2904776026,
18.0401110766, 0.557085579948
};
D sb5plus_3[] = {
21.1518685061, 6.32805369701,
17.9939494168, 0.566290989365,
6.78998333403, 0.0381542687902
};
D sb5plus_2[] = {
24.0216976766, 0.360967227696,
21.8908007915, 6.13238482723
};
D sb5plus_1[] = {
45.7876618776, 2.78218542082
};
D* sb5plus_c[] = { sb5plus_6, sb5plus_5, sb5plus_4, sb5plus_3, sb5plus_2, sb5plus_1 };

D i1minus_s[] = { 6.0, 5.0, 4.0, 1.6, 0.5, 0.15 };
D i1minus_e[] = {
0.00465008030814,
0.00643346415144,
0.00992368291445,
0.00886247683701,
0.00874908802485,
0.00906110752683
};
D i1minus_6[] = {
329.169202799, 0.311113167229,
-320.346878377, 0.299142365986,
20.6984318651, 4.8038511332,
11.1318035764, 0.12679808016,
9.4237752503, 43.9201277325,
3.83093515527, 0.0187001130234
};
D i1minus_5[] = {
338.807248972, 0.611065936534,
-321.840893745, 0.619535856147,
20.7677761614, 4.79812481211,
9.42133772109, 43.9362735834,
6.75198364245, 0.0345621440114
};
D i1minus_4[] = {
20.4879192989, 4.88070372747,
17.7573224018, 0.470591331217,
9.35667462567, 44.2792744823,
6.30904643427, 0.0297341086923
};
D i1minus_3[] = {
22.5412646105, 0.276232036173,
21.5568900804, 4.44048498121,
9.78920624061, 42.0845640354
};
D i1minus_2[] = {
41.6864265701, 1.60617362519,
12.1311085949, 34.7057303676
};
D i1minus_1[] = {
53.668291278, 7.55027846233
};
D* i1minus_c[] = { i1minus_6, i1minus_5, i1minus_4, i1minus_3, i1minus_2, i1minus_1 };

D cs1plus_s[] = { 6.0, 5.0, 3.5, 1.9, 0.65, 0.19 };
D cs1plus_e[] = {
0.00813120217248,
0.00269163274402,
0.00858941776391,
0.00818906207446,
0.00981648145079,
0.00871390790555
};
D cs1plus_6[] = {
-305.457274554, 0.195502380709,
211.201157523, 0.230354058067,
114.538284173, 0.153490487194,
20.3416080264, 3.77032936608,
10.6197180873, 26.7958729937,
2.73035386686, 0.00867848425648
};
D cs1plus_5[] = {
323.018561835, 0.621128453989,
-308.179221824, 0.637711985111,
21.4536149874, 3.56394238546,
10.835958741, 26.3641402198,
6.8400879773, 0.0323235597482
};
D cs1plus_4[] = {
20.2542255619, 3.85984073357,
18.0479302224, 0.380509988814,
10.4409679608, 27.5069327862,
5.26253957237, 0.0126082268642
};
D cs1plus_3[] = {
21.4445422345, 0.226114975517,
21.1250634503, 3.34948829134,
11.3691161048, 25.0183962417
};
D cs1plus_2[] = {
38.8911867376, 1.10587892831,
14.9551421606, 19.8500564684
};
D cs1plus_1[] = {
53.7125209621, 5.40821017566
};
D* cs1plus_c[] = { cs1plus_6, cs1plus_5, cs1plus_4, cs1plus_3, cs1plus_2, cs1plus_1 };

D ba2plus_s[] = { 6.0, 5.0, 3.5, 2.0, 0.7, 0.2 };
D ba2plus_e[] = {
0.00669049616088,
0.0032920201101,
0.0082402572853,
0.00980063239482,
0.00987624120068,
0.00779247755924
};
D ba2plus_6[] = {
258.118319029, 0.592850752882,
-243.765877359, 0.613364894568,
21.3815111215, 3.21304491131,
11.291174073, 21.871624454,
4.15574949201, 0.0225589152651,
2.79048087159, 0.0498187211682
};
D ba2plus_5[] = {
235.090478387, 0.585716687746,
-220.576716276, 0.608037384413,
21.3866231831, 3.21773687023,
11.2703698668, 21.9379732896,
6.80317168089, 0.0307164248698
};
D ba2plus_4[] = {
20.0145031901, 3.45763530755,
18.1352463692, 0.347180296047,
10.971382176, 22.376164182,
4.85742581455, 0.00610908651286
};
D ba2plus_3[] = {
21.1630869164, 0.210389821776,
21.0100813199, 3.02998473007,
11.7840131487, 21.0793404078
};
D ba2plus_2[] = {
38.1039891225, 0.976555552599,
15.7521651662, 16.5694035577
};
D ba2plus_1[] = {
53.7459734492, 4.82729909238
};
D* ba2plus_c[] = { ba2plus_6, ba2plus_5, ba2plus_4, ba2plus_3, ba2plus_2, ba2plus_1 };

D la3plus_s[] = { 6.0, 6.0, 3.5, 2.0, 0.7, 0.22 };
D la3plus_e[] = {
0.00652408528993,
0.00867830040578,
0.00695129977694,
0.00626345477975,
0.00690507339998,
0.00862024663809
};
D la3plus_6[] = {
26.9291863376, 0.542854259347,
26.2659624214, 2.54588835763,
-20.4351185579, 0.998658646985,
12.1132762331, 18.2019683179,
6.55054198764, 0.0279645154554,
2.55025948017, 0.243348620872
};
D la3plus_5[] = {
29.9538434106, 2.50497203209,
20.3682809206, 0.430624897855,
-15.0347903902, 1.43249314316,
12.0394004, 18.2915231808,
6.64911261903, 0.0284099122691
};
D la3plus_4[] = {
20.1247548337, 3.20864310052,
18.3381222385, 0.320060005467,
11.0714846457, 19.7579847469,
4.48600117368, 9.74135032991e-05
};
D la3plus_3[] = {
21.0804021467, 0.199673111193,
20.8151618259, 2.79814148162,
12.0770890516, 18.1887619054
};
D la3plus_2[] = {
37.987255752, 0.91872348709,
15.9103020664, 14.7576639019
};
D la3plus_1[] = {
53.7378598091, 4.28123558998
};
D* la3plus_c[] = { la3plus_6, la3plus_5, la3plus_4, la3plus_3, la3plus_2, la3plus_1 };

D ce3plus_s[] = { 6.0, 6.0, 3.5, 2.0, 0.7, 0.22 };
D ce3plus_e[] = {
0.00578296406457,
0.00618518649835,
0.00928707205334,
0.00497288826131,
0.0063915125957,
0.00806316751787
};
D ce3plus_6[] = {
25.1210885122, 0.447017506291,
23.8791817549, 2.63157744211,
-13.1065908212, 0.877709754184,
12.343264795, 17.5475080762,
4.04247711897, 0.0262896681545,
2.69566989427, 0.0302841025097
};
D ce3plus_5[] = {
25.1291551379, 0.447017915339,
23.8970493478, 2.63157744211,
-13.1235663209, 0.879124612424,
12.3411249919, 17.5475080762,
6.73094781013, 0.0277814013077
};
D ce3plus_4[] = {
20.5063845788, 3.02475548855,
18.2925286548, 0.30253714099,
11.7590349933, 18.171973198,
4.42743838709, 0.000179352092979
};
D ce3plus_3[] = {
21.4048896854, 2.71981130742,
21.1439594267, 0.191986366764,
12.4234177628, 17.4344394691
};
D ce3plus_2[] = {
38.5963664788, 0.90892551935,
16.305470287, 14.2534679621
};
D ce3plus_1[] = {
54.749718388, 4.19549351493
};
D* ce3plus_c[] = { ce3plus_6, ce3plus_5, ce3plus_4, ce3plus_3, ce3plus_2, ce3plus_1 };

D ce4plus_s[] = { 6.0, 6.0, 3.0, 2.0, 0.7, 0.24 };
D ce4plus_e[] = {
0.00581176468612,
0.00611434828942,
0.00995817886286,
0.00372879003718,
0.00484409139469,
0.00938318932861
};
D ce4plus_6[] = {
28.3404768223, 2.23643713032,
23.4867824525, 0.439904815607,
-17.373040211, 1.10132245695,
12.3673703671, 14.9403575413,
6.72761542685, 0.0277769451146,
0.454879172939, 44.8552332354
};
D ce4plus_5[] = {
28.2666583342, 2.27778589179,
23.4646269047, 0.440224105865,
-16.9621186216, 1.10132245695,
12.4831139004, 15.8429252044,
6.7296489896, 0.0277769451146
};
D ce4plus_4[] = {
20.0218216387, 2.94863484531,
18.2578332187, 0.29927982774,
11.3566135664, 17.1757202043,
4.38628293788, 0.000382421533415
};
D ce4plus_3[] = {
20.9908629841, 0.189432580324,
20.669308223, 2.59460492669,
12.322165203, 15.9526440666
};
D ce4plus_2[] = {
37.8676926073, 0.864824670926,
16.0588830913, 13.2476829808
};
D ce4plus_1[] = {
53.7250851185, 3.83671984099
};
D* ce4plus_c[] = { ce4plus_6, ce4plus_5, ce4plus_4, ce4plus_3, ce4plus_2, ce4plus_1 };

D pr3plus_s[] = { 6.0, 6.0, 3.0, 2.0, 0.7, 0.22 };
D pr3plus_e[] = {
0.00483326219662,
0.00483646860271,
0.0093307072373,
0.00420848753728,
0.00592993175659,
0.00752995339044
};
D pr3plus_6[] = {
30.1586811609, 2.2910290047,
22.4194684835, 0.416923472504,
-16.3938113238, 1.14605678053,
13.0297427056, 16.4538677647,
5.40166093065, 0.0268428546138,
1.35053060192, 0.0268439572145
};
D pr3plus_5[] = {
30.1586809995, 2.29112554841,
22.4194748394, 0.416923472504,
-16.3937997348, 1.14609912363,
13.0297362841, 16.4538677647,
6.75227138978, 0.0268439572145
};
D pr3plus_4[] = {
21.1580192165, 2.92308111067,
18.3250618555, 0.289603416534,
12.0950774344, 17.4088597123,
4.41358393413, 0.000383649188423
};
D pr3plus_3[] = {
22.0178511723, 2.64329847812,
21.2061937021, 0.18476878471,
12.7465381846, 16.6985204062
};
D pr3plus_2[] = {
39.2398227919, 0.900520772332,
16.6661450299, 13.7623510105
};
D pr3plus_1[] = {
55.761102624, 4.10270192056
};
D* pr3plus_c[] = { pr3plus_6, pr3plus_5, pr3plus_4, pr3plus_3, pr3plus_2, pr3plus_1 };

D pr4plus_s[] = { 6.0, 6.0, 2.5, 2.0, 0.8, 0.25 };
D pr4plus_e[] = {
0.00487081857043,
0.00550144106242,
0.00230984882681,
0.00286996463352,
0.00935063217742,
0.00982979213539
};
D pr4plus_6[] = {
42.5446964195, 1.86667856077,
-31.8420753268, 1.22961964587,
23.5569586008, 0.425271512969,
9.18884530937, 11.5945081401,
6.76273725414, 0.0269028670389,
4.79315952028, 20.4041559542
};
D pr4plus_5[] = {
30.6603962589, 0.455729063063,
24.8425956659, 2.34276427232,
-20.0567784798, 0.780979331753,
12.7485061282, 15.2154599179,
6.78574492387, 0.0270110425593
};
D pr4plus_4[] = {
20.9007689905, 2.78242922342,
17.7724338948, 0.272633622336,
11.8241722227, 16.2731765936,
4.52077906452, 0.0163487924072
};
D pr4plus_3[] = {
21.3133244716, 2.52458422863,
21.0342405812, 0.182012219369,
12.6341335887, 15.2920934381
};
D pr4plus_2[] = {
37.3100394871, 0.77285443019,
17.5665543578, 11.8285039063
};
D pr4plus_1[] = {
54.6968227198, 3.69072025619
};
D* pr4plus_c[] = { pr4plus_6, pr4plus_5, pr4plus_4, pr4plus_3, pr4plus_2, pr4plus_1 };

D nd3plus_s[] = { 6.0, 6.0, 3.0, 2.0, 0.7, 0.24 };
D nd3plus_e[] = {
0.00393010347065,
0.00560868869042,
0.00862208582446,
0.00368116348225,
0.00551880848634,
0.0097293262564
};
D nd3plus_6[] = {
44.9473646939, 1.72995106884,
-35.5140668532, 1.15637603454,
24.4809811733, 0.415075481802,
9.3787754927, 18.6786547059,
6.92538263403, 7.69302251088,
6.77501543582, 0.025923817195
};
D nd3plus_5[] = {
189.905619845, 0.49576961181,
-176.447098132, 0.522989503842,
23.8120399696, 2.54214291997,
12.9469858887, 16.1510004168,
6.75653886729, 0.0257932034747
};
D nd3plus_4[] = {
21.9516934567, 2.85243000294,
18.168050019, 0.280976257377,
12.2616590108, 16.9206404303,
4.62803407437, 0.00467325529075
};
D nd3plus_3[] = {
22.6824690864, 2.56783655062,
21.2517500723, 0.177790851228,
13.0361144999, 16.0417508645
};
D nd3plus_2[] = {
39.9199697133, 0.893406504855,
16.9898617096, 13.3065868862
};
D nd3plus_1[] = {
56.6986538679, 3.88428537889
};
D* nd3plus_c[] = { nd3plus_6, nd3plus_5, nd3plus_4, nd3plus_3, nd3plus_2, nd3plus_1 };

D pm3plus_s[] = { 6.0, 6.0, 3.0, 2.0, 0.7, 0.24 };
D pm3plus_e[] = {
0.00278140423083,
0.00426192461386,
0.00775540524329,
0.00354078090447,
0.00516658048785,
0.00908651892547
};
D pm3plus_6[] = {
28.2173536388, 2.00667068185,
27.1293932749, 0.406854865674,
-19.6351769656, 0.830764065578,
8.95514344399, 9.86980276379,
6.77247671053, 0.0248953179369,
6.56133939766, 20.2506668176
};
D pm3plus_5[] = {
26.0283355814, 0.394662560597,
25.6142967376, 2.37270103759,
-13.8365852287, 0.738227370461,
13.4369524424, 15.3019888702,
6.72352997751, 0.0246400202913
};
D pm3plus_4[] = {
22.6715975754, 2.72201675771,
18.271863271, 0.263388972329,
12.639915535, 16.0396254446,
4.39468659128, 0.00142990139981
};
D pm3plus_3[] = {
23.331886105, 2.48816227783,
21.285199741, 0.17114331453,
13.3501674631, 15.3600615187
};
D pm3plus_2[] = {
40.6279232066, 0.887044540556,
17.2852431433, 12.8702331946
};
D pm3plus_1[] = {
57.7125982248, 3.79593150066
};
D* pm3plus_c[] = { pm3plus_6, pm3plus_5, pm3plus_4, pm3plus_3, pm3plus_2, pm3plus_1 };

D sm3plus_s[] = { 6.0, 6.0, 4.0, 2.0, 0.8, 0.25 };
D sm3plus_e[] = {
0.00152619509103,
0.00484409422172,
0.00974734635157,
0.00348527037337,
0.00954977681872,
0.00953325796928
};
D sm3plus_6[] = {
33.1400677006, 0.406182276227,
26.2908094931, 2.02844618017,
-23.0270016025, 0.661173774439,
8.63578989994, 9.26436425583,
7.18002045986, 18.9916423127,
6.77533626113, 0.0239300684137
};
D sm3plus_5[] = {
336.205921614, 0.444483129951,
-322.17272267, 0.456588891124,
24.7605294826, 2.41533189733,
13.4885203239, 14.9112348433,
6.68887644357, 0.0234761809793
};
D sm3plus_4[] = {
23.2826144249, 2.58614489817,
18.1496741593, 0.251719831428,
13.1444084978, 15.1619483921,
4.39836057469, 2.7867127489e-05
};
D sm3plus_3[] = {
24.0245618162, 2.41107440418,
21.3056157912, 0.164760602993,
13.6348934968, 14.7550195056
};
D sm3plus_2[] = {
40.0048406242, 0.792045216296,
18.8553333486, 11.507435326
};
D sm3plus_1[] = {
58.6826309215, 3.64557103472
};
D* sm3plus_c[] = { sm3plus_6, sm3plus_5, sm3plus_4, sm3plus_3, sm3plus_2, sm3plus_1 };

D eu2plus_s[] = { 6.0, 6.0, 4.0, 2.0, 0.7, 0.24 };
D eu2plus_e[] = {
0.000730532398591,
0.0064546496971,
0.00681475941209,
0.0053666169062,
0.00623913603942,
0.00997356827706
};
D eu2plus_6[] = {
156.493236264, 0.437542362671,
-143.96267043, 0.469379491159,
25.6853696031, 2.14899759706,
11.8105836898, 11.1859417369,
6.74849801549, 0.0228463400406,
4.22168583861, 25.9458796359
};
D eu2plus_5[] = {
529.925441983, 0.395391345153,
-514.552408839, 0.400468512959,
25.3508334877, 2.52418796947,
13.671419278, 16.1055060701,
6.55536279834, 0.021874383221
};
D eu2plus_4[] = {
24.651285709, 2.57542562731,
18.0735164254, 0.245605165198,
13.6498143868, 16.0695204006,
4.57259581137, 0.00224082595851
};
D eu2plus_3[] = {
25.4185380879, 2.43862442388,
21.536102904, 0.16182587189,
13.9864118123, 15.7936925456
};
D eu2plus_2[] = {
43.0147478011, 0.921143546159,
17.8701052211, 13.3135057532
};
D eu2plus_1[] = {
60.6655239174, 3.85980362333
};
D* eu2plus_c[] = { eu2plus_6, eu2plus_5, eu2plus_4, eu2plus_3, eu2plus_2, eu2plus_1 };

D eu3plus_s[] = { 6.0, 6.0, 4.0, 2.0, 0.8, 0.25 };
D eu3plus_e[] = {
0.000601443625719,
0.00412817195804,
0.00788380141159,
0.00355504558995,
0.00895452669007,
0.00893407649443
};
D eu3plus_6[] = {
94.7667132544, 0.432500454587,
-82.8489860836, 0.490716279433,
25.7171569463, 2.0710543015,
11.1713531387, 10.4896537767,
6.76238630455, 0.0229155187437,
4.43002809475, 21.2375198268
};
D eu3plus_5[] = {
95.1145140401, 0.438999164899,
-82.4913406152, 0.495683992405,
26.4423703695, 2.23865463544,
14.0462569887, 14.0882377537,
6.84898554223, 0.0233333825208
};
D eu3plus_4[] = {
24.0284749446, 2.49146664336,
18.116117145, 0.240526043079,
13.442635867, 14.5428605261,
4.38432892225, 1.48594269373e-05
};
D eu3plus_3[] = {
24.7258476423, 2.33589478196,
21.3224795375, 0.158717504942,
13.9142444768, 14.1751287636
};
D eu3plus_2[] = {
40.739108912, 0.788062759633,
19.1260943449, 11.1674430851
};
D eu3plus_1[] = {
59.696380793, 3.56104267751
};
D* eu3plus_c[] = { eu3plus_6, eu3plus_5, eu3plus_4, eu3plus_3, eu3plus_2, eu3plus_1 };

D gd3plus_s[] = { 6.0, 6.0, 4.0, 2.0, 0.8, 0.26 };
D gd3plus_e[] = {
0.00289088586819,
0.0076101752596,
0.00924963918556,
0.0034174425166,
0.00842621267059,
0.00960471256883
};
D gd3plus_6[] = {
-159.753359726, 0.516325305037,
158.621446004, 0.458142632045,
26.6652363306, 1.11880807092,
15.8588412419, 3.18460195233,
12.7912744066, 14.5870666905,
6.79538452757, 0.0221096325627
};
D gd3plus_5[] = {
159.39421081, 0.412493032055,
-146.167444991, 0.439612787024,
26.6537998392, 2.18959854689,
14.3106504486, 13.5617491364,
6.76634063242, 0.0221644569785
};
D gd3plus_4[] = {
24.7923432008, 2.3915648324,
18.0607619651, 0.228525161613,
13.7740394253, 13.9429653098,
4.34013070086, 4.03666865233e-06
};
D gd3plus_3[] = {
25.3996299828, 2.25190636852,
21.3008937432, 0.152525206594,
14.2595695419, 13.5881342174
};
D gd3plus_2[] = {
41.4993543373, 0.784503680489,
19.3698824584, 10.855396912
};
D gd3plus_1[] = {
60.6688643918, 3.42683166487
};
D* gd3plus_c[] = { gd3plus_6, gd3plus_5, gd3plus_4, gd3plus_3, gd3plus_2, gd3plus_1 };

D tb3plus_s[] = { 6.0, 6.0, 3.0, 2.0, 0.8, 0.26 };
D tb3plus_e[] = {
0.00484137717382,
0.00960507481787,
0.00468031937054,
0.0046748294372,
0.00849284418704,
0.00910193078563
};
D tb3plus_6[] = {
-65.3230400775, 0.543880792115,
63.2803295286, 0.400086539035,
27.096825565, 1.06120318084,
16.5660249152, 2.87183698242,
13.761381273, 13.7064795004,
6.71328395217, 0.0207921339007
};
D tb3plus_5[] = {
63.2086895453, 0.349883306032,
-48.828637439, 0.40504247339,
26.7432360345, 2.17609710051,
14.5285158076, 13.3285747017,
6.43972171745, 0.019481096442
};
D tb3plus_4[] = {
25.6178109627, 2.27720682119,
17.1393665061, 0.21992443137,
14.2970414373, 13.4574199998,
5.03896754725, 0.014176194764
};
D tb3plus_3[] = {
26.2280612716, 2.20042501902,
21.3663102478, 0.147886034957,
14.4973010129, 13.3445316941
};
D tb3plus_2[] = {
42.4463416401, 0.787903258143,
19.5356994122, 10.7470912996
};
D tb3plus_1[] = {
61.6900417092, 3.35058396417
};
D* tb3plus_c[] = { tb3plus_6, tb3plus_5, tb3plus_4, tb3plus_3, tb3plus_2, tb3plus_1 };

D dy3plus_s[] = { 6.0, 4.0, 3.0, 2.0, 0.8, 0.26 };
D dy3plus_e[] = {
0.00437255613562,
0.00774721945409,
0.00245879751175,
0.00395949614662,
0.00745755569081,
0.00850350470622
};
D dy3plus_6[] = {
-477.8475868, 0.570864998187,
264.439943035, 0.477308273737,
237.967167943, 0.684472250103,
18.4763340215, 2.93727422854,
13.0927860043, 13.6697926044,
6.84864062753, 0.0206237132168
};
D dy3plus_5[] = {
-198.443681247, 0.0400829216448,
192.431315835, 0.0365606644379,
27.7942859042, 0.155003403185,
26.5916446146, 2.16324605488,
14.582677726, 12.7424123981
};
D dy3plus_4[] = {
25.4181399281, 2.30670510197,
15.8212897892, 0.092951269167,
14.1415428083, 13.0271785132,
7.58306735718, 0.456643770207
};
D dy3plus_3[] = {
27.0331300535, 2.1342811208,
21.34823055, 0.142392427111,
14.5797326235, 12.7946398362
};
D dy3plus_2[] = {
43.0741220629, 0.777355225795,
19.8036515722, 10.2791329706
};
D dy3plus_1[] = {
62.6948340396, 3.27129690883
};
D* dy3plus_c[] = { dy3plus_6, dy3plus_5, dy3plus_4, dy3plus_3, dy3plus_2, dy3plus_1 };

D ho3plus_s[] = { 6.0, 4.0, 3.0, 2.0, 0.8, 0.26 };
D ho3plus_e[] = {
0.00440163886734,
0.00854485690461,
0.00219702090477,
0.00426445547329,
0.0070296239097,
0.00800260436241
};
D ho3plus_6[] = {
-2553.08534683, 0.551658577742,
1294.97725913, 0.508727933595,
1283.09752742, 0.596946187209,
18.8417355673, 2.88544564978,
13.2435710697, 13.2120987385,
6.89980379405, 0.0201423705444
};
D ho3plus_5[] = {
510.328813707, 0.0995782394439,
-503.061777734, 0.0954376094779,
27.1267439585, 2.01329402188,
15.4254202823, 11.8725474677,
14.1179955382, 0.0175807080672
};
D ho3plus_4[] = {
25.4045514958, 2.28938864609,
17.5862560342, 0.100494224804,
14.2574247269, 12.6463342919,
6.71566555138, 0.599629883989
};
D ho3plus_3[] = {
27.621698256, 2.065522808,
21.4026350354, 0.138161957363,
14.9282708847, 12.2428425568
};
D ho3plus_2[] = {
43.8953367352, 0.774031679705,
19.9869475266, 10.0211001305
};
D ho3plus_1[] = {
63.7072159943, 3.19633941795
};
D* ho3plus_c[] = { ho3plus_6, ho3plus_5, ho3plus_4, ho3plus_3, ho3plus_2, ho3plus_1 };

D er3plus_s[] = { 6.0, 4.0, 3.0, 2.0, 0.8, 0.26 };
D er3plus_e[] = {
0.00354184059667,
0.0086972992826,
0.00235320801605,
0.00443300485888,
0.00662563718794,
0.00754694080691
};
D er3plus_6[] = {
-250.023005689, 0.54539415383,
146.577484369, 0.423493621999,
130.069722903, 0.711589756629,
18.2641340176, 2.94192583627,
13.1907692008, 12.9045357461,
6.89601999521, 0.0194109340915
};
D er3plus_5[] = {
-349.395489414, 0.0716602851966,
222.511218397, 0.0589640892303,
148.538209966, 0.100940141539,
28.1318064285, 2.01438795338,
15.1643167832, 11.8223491566
};
D er3plus_4[] = {
25.2960170069, 2.26916223154,
18.2874777243, 0.101354557518,
14.3872252691, 12.2643105026,
6.9920847554, 0.706564189674
};
D er3plus_3[] = {
28.3539766056, 2.00554131219,
21.4365560995, 0.133957895999,
15.1599547663, 11.8296444209
};
D er3plus_2[] = {
44.7225345201, 0.770195286046,
20.1637335088, 9.76876219205
};
D er3plus_1[] = {
64.7186742601, 3.12201104995
};
D* er3plus_c[] = { er3plus_6, er3plus_5, er3plus_4, er3plus_3, er3plus_2, er3plus_1 };

D tm3plus_s[] = { 6.0, 4.0, 3.5, 2.0, 0.8, 0.28 };
D tm3plus_e[] = {
0.00367043653821,
0.00873747171134,
0.00956184531229,
0.0046379479416,
0.00624789258142,
0.00959578415879
};
D tm3plus_6[] = {
-497.32752555, 0.427376023724,
488.18627557, 0.407575646411,
38.8155483075, 0.932177011309,
16.621174772, 3.15238842535,
12.8850419988, 12.7462720602,
6.79691432405, 0.018219730229
};
D tm3plus_5[] = {
28.8655627663, 1.95214092867,
26.9074602914, 0.139179734167,
-20.9888506463, 0.0489240480183,
15.750962192, 0.0173064330665,
15.4122754712, 11.4262685526
};
D tm3plus_4[] = {
28.7199757748, 1.97396923147,
17.9124313885, 0.17623888894,
15.3172069674, 11.4789416192,
3.99997079966, 0.000161507318011
};
D tm3plus_3[] = {
29.0931456125, 1.94857193492,
21.477236619, 0.130091646441,
15.3781153873, 11.4503986749
};
D tm3plus_2[] = {
45.5780836656, 0.76679355773,
20.3119844472, 9.53912264655
};
D tm3plus_1[] = {
65.6625694314, 2.97711360836
};
D* tm3plus_c[] = { tm3plus_6, tm3plus_5, tm3plus_4, tm3plus_3, tm3plus_2, tm3plus_1 };

D yb2plus_s[] = { 6.0, 3.5, 3.0, 2.0, 0.8, 0.26 };
D yb2plus_e[] = {
0.00374819171872,
0.00928809730893,
0.00270340928118,
0.00694248711893,
0.00787848053918,
0.00846191150209
};
D yb2plus_6[] = {
-94.7208886557, 0.504926768027,
75.6338452663, 0.361397293806,
50.6059421246, 0.896031869301,
17.2713190145, 3.50210758829,
12.2464233483, 14.3845335852,
6.92887061638, 0.0182973468948
};
D yb2plus_5[] = {
-126.945936643, 0.0937980117404,
94.0319447068, 0.123024620516,
54.9444660667, 0.0623074075232,
30.2721542232, 1.97541889058,
15.6166647588, 12.3088920089
};
D yb2plus_4[] = {
19.4410820877, 0.101826035119,
17.961691455, 1.24972075936,
17.4009068568, 3.11751072486,
13.1516353015, 13.7985826878
};
D yb2plus_3[] = {
30.5148722543, 1.97853664676,
21.8562957721, 0.130872645515,
15.5486913676, 12.349268346
};
D yb2plus_2[] = {
47.3936893095, 0.79726066469,
20.4570830845, 10.2140248546
};
D yb2plus_1[] = {
67.6658438519, 3.16531333694
};
D* yb2plus_c[] = { yb2plus_6, yb2plus_5, yb2plus_4, yb2plus_3, yb2plus_2, yb2plus_1 };

D yb3plus_s[] = { 6.0, 4.0, 3.5, 2.5, 0.9, 0.28 };
D yb3plus_e[] = {
0.00321188321764,
0.00899120189278,
0.00953200543376,
0.00984903822349,
0.00972000248156,
0.00906789156445
};
D yb3plus_6[] = {
-99.3360135729, 0.520750597014,
70.3111970318, 0.355812288827,
58.9860120042, 0.828735560489,
17.2286997565, 3.08596915728,
12.9328774972, 12.4118964375,
6.85411261553, 0.0178765121706
};
D yb3plus_5[] = {
-47.7239606142, 0.0582267096113,
40.2119315447, 0.118934015135,
29.6376695671, 1.88967476312,
29.1488898682, 0.0296117332039,
15.6698878319, 11.0394706709
};
D yb3plus_4[] = {
29.5269654339, 1.91042033778,
17.9220834897, 0.168772758567,
15.5535789033, 11.1057003303,
3.94438748861, 0.000155742823257
};
D yb3plus_3[] = {
29.9884321253, 1.78949342328,
20.6783995071, 0.113622849384,
16.2645905546, 10.7227591525
};
D yb3plus_2[] = {
44.8452394211, 0.690607794122,
21.9948900546, 8.63719292268
};
D yb3plus_1[] = {
66.6746652908, 2.90996435146
};
D* yb3plus_c[] = { yb3plus_6, yb3plus_5, yb3plus_4, yb3plus_3, yb3plus_2, yb3plus_1 };

D lu3plus_s[] = { 6.0, 5.0, 3.5, 2.5, 0.9, 0.28 };
D lu3plus_e[] = {
0.00311739273008,
0.00939623808,
0.00810289265215,
0.00850885557535,
0.00920276844191,
0.00858536502693
};
D lu3plus_6[] = {
-56.4273434547, 0.584800281634,
53.1394436376, 0.914154031057,
36.241990046, 0.297187203789,
15.8217698503, 3.36115090558,
12.4292130845, 12.3575601704,
6.77431570604, 0.0169288025388
};
D lu3plus_5[] = {
54.3140051456, 0.242604193882,
-38.6161866233, 0.277395662957,
30.6558720952, 1.8217089208,
15.9194270891, 10.6901593399,
5.66906939489, 0.0107326962066
};
D lu3plus_4[] = {
30.2958383878, 1.85044751924,
17.6989936532, 0.16434337035,
15.7965451965, 10.749583903,
4.15268706022, 0.00289731133959
};
D lu3plus_3[] = {
30.566247454, 1.72054972473,
20.6307085033, 0.109449833278,
16.7227258911, 10.2446523661
};
D lu3plus_2[] = {
45.7041620012, 0.688149926452,
22.1405509444, 8.4492335079
};
D lu3plus_1[] = {
67.6858221787, 2.84530190574
};
D* lu3plus_c[] = { lu3plus_6, lu3plus_5, lu3plus_4, lu3plus_3, lu3plus_2, lu3plus_1 };

D hf4plus_s[] = { 6.0, 5.0, 3.5, 3.0, 0.9, 0.3 };
D hf4plus_e[] = {
0.00298085658601,
0.00859675550421,
0.00748570162699,
0.00977996585634,
0.00697027387205,
0.00865710248522
};
D hf4plus_6[] = {
-44.8740495897, 0.484120524731,
42.3407055328, 0.295625150748,
37.8310888201, 1.02745172506,
14.0249817643, 3.52221573292,
11.8543238941, 11.1692522205,
6.81334930617, 0.0165475292033
};
D hf4plus_5[] = {
56.8076335462, 0.248921907877,
-42.1484834077, 0.291548735461,
31.1729470032, 1.67425443743,
16.2357690795, 9.4318089549,
5.884624539, 0.0115279048778
};
D hf4plus_4[] = {
30.5231974684, 1.74481710008,
17.4429305528, 0.155594148476,
15.7906283853, 9.64132322818,
4.20506055206, 0.00554707507817
};
D hf4plus_3[] = {
30.7201637399, 1.59777014582,
20.2302169991, 0.100923480332,
16.9841918128, 9.09052304139
};
D hf4plus_2[] = {
45.7526060306, 0.660967810317,
22.1297563614, 7.69183882227
};
D hf4plus_1[] = {
67.6893184584, 2.58192519528
};
D* hf4plus_c[] = { hf4plus_6, hf4plus_5, hf4plus_4, hf4plus_3, hf4plus_2, hf4plus_1 };

D ta5plus_s[] = { 6.0, 5.0, 3.5, 3.0, 1.0, 0.32 };
D ta5plus_e[] = {
0.00227222802431,
0.00710075814632,
0.00587651822341,
0.0072962489278,
0.00909253807347,
0.00894233147838
};
D ta5plus_6[] = {
63.7100225092, 0.30128601157,
-61.0357809797, 0.400334919179,
33.3029927218, 1.05797311295,
12.8695181765, 3.28140220168,
12.2893853818, 9.812801807,
6.85479096549, 0.0162693966938
};
D ta5plus_5[] = {
63.2214527575, 0.239481679101,
-48.6529794624, 0.275980178808,
31.3383082653, 1.57790100579,
16.300563118, 8.51298924362,
5.75556356805, 0.0101910453026
};
D ta5plus_4[] = {
30.5520708022, 1.63125211699,
17.6729035287, 0.143746650308,
16.0245632543, 8.60833571657,
3.71689414968, 0.00100130639165
};
D ta5plus_3[] = {
30.781719362, 1.51469882462,
20.1383377554, 0.0969224095401,
17.0265106969, 8.21977892699
};
D ta5plus_2[] = {
44.2249184632, 0.579546253124,
23.638933493, 6.59902865191
};
D ta5plus_1[] = {
67.6887922329, 2.36318795006
};
D* ta5plus_c[] = { ta5plus_6, ta5plus_5, ta5plus_4, ta5plus_3, ta5plus_2, ta5plus_1 };

D w6plus_s[] = { 6.0, 6.0, 3.5, 3.0, 1.0, 0.35 };
D w6plus_e[] = {
0.00361008282555,
0.00623376835105,
0.00493318592694,
0.00477298600725,
0.00717834710023,
0.00990255574704
};
D w6plus_6[] = {
40.4483462819, 1.08152568877,
-26.9307989997, 0.541058412944,
26.5126781118, 0.239153650074,
14.3593829404, 4.71897869635,
6.97354055548, 10.9015547714,
6.64624872897, 0.0147920047075
};
D w6plus_5[] = {
38.935567426, 0.261352953753,
33.8694888903, 1.3798794531,
-28.6952174982, 0.377745184312,
17.0051690131, 7.54349971902,
6.84585636039, 0.0158235102231
};
D w6plus_4[] = {
30.8239991075, 1.56136799631,
16.3328064886, 0.146194442734,
15.7944493219, 7.95721115005,
5.03054364921, 0.0156972187007
};
D w6plus_3[] = {
30.6856900649, 1.42835476436,
20.0274731533, 0.0931048800363,
17.2376463897, 7.42294090702
};
D w6plus_2[] = {
44.337105452, 0.559595885123,
23.5542022436, 6.11692746581
};
D w6plus_1[] = {
67.6496643413, 2.15156692809
};
D* w6plus_c[] = { w6plus_6, w6plus_5, w6plus_4, w6plus_3, w6plus_2, w6plus_1 };

D os4plus_s[] = { 6.0, 4.0, 3.5, 2.0, 0.9, 0.28 };
D os4plus_e[] = {
0.00200061984452,
0.00912881407984,
0.00993911533948,
0.00714635587256,
0.00840718815537,
0.00855832663986
};
D os4plus_6[] = {
38.4844650704, 1.0668487248,
28.7716502205, 0.22892965526,
-25.3099617664, 0.452250492777,
14.4283481501, 5.04270853581,
8.88658362002, 14.4389936769,
6.72005979815, 0.0142684893839
};
D os4plus_5[] = {
41.1920663581, 0.120702279442,
-34.6153117077, 0.0854871859496,
32.7627642803, 1.5320698667,
17.21111464, 10.1325485164,
15.3499706726, 0.0342194478769
};
D os4plus_4[] = {
32.3844284295, 1.56116985855,
17.0590820269, 10.2057793962,
12.607875427, 0.197205693231,
9.85326716348, 0.0375945310985
};
D os4plus_3[] = {
32.827357723, 1.5755978486,
22.2355682076, 0.114382907912,
16.8475484565, 10.322089187
};
D os4plus_2[] = {
49.9759634714, 0.66337127814,
21.8556688999, 8.54924152988
};
D os4plus_1[] = {
71.6613435745, 2.69000258739
};
D* os4plus_c[] = { os4plus_6, os4plus_5, os4plus_4, os4plus_3, os4plus_2, os4plus_1 };

D ir3plus_s[] = { 6.0, 4.0, 3.5, 1.9, 0.8, 0.26 };
D ir3plus_e[] = {
0.00269816592358,
0.00956221018713,
0.00985127230081,
0.0093470408192,
0.00702514004745,
0.00819776361153
};
D ir3plus_6[] = {
35.8971910026, 1.12994919902,
35.17291668, 0.227042228463,
-27.0143480575, 0.358721839591,
15.9623926075, 6.20390095353,
7.31826231922, 18.5116045052,
6.64921867976, 0.0135128801219
};
D ir3plus_5[] = {
32.1976637579, 1.40004855926,
17.187797888, 8.59433193559,
16.3066406545, 0.140007195898,
5.21926943366, 0.0103548892571,
3.1098399732, 27.3156572738
};
D ir3plus_4[] = {
27.2811110998, 1.84213237946,
17.6959659199, 0.0699437738131,
17.0179694739, 11.7326166877,
11.8924048481, 0.626657524727
};
D ir3plus_3[] = {
32.7954108353, 1.62971614475,
23.6151363291, 0.129590233186,
17.4685777633, 11.5122837589
};
D ir3plus_2[] = {
52.992058873, 0.740185888343,
20.8480512028, 10.2444292115
};
D ir3plus_1[] = {
73.6418575945, 2.96313336431
};
D* ir3plus_c[] = { ir3plus_6, ir3plus_5, ir3plus_4, ir3plus_3, ir3plus_2, ir3plus_1 };

D ir4plus_s[] = { 6.0, 6.0, 4.0, 2.0, 0.9, 0.28 };
D ir4plus_e[] = {
0.00219636648808,
0.00948495722286,
0.00969579466474,
0.00758299122783,
0.00818947995119,
0.00863019168136
};
D ir4plus_6[] = {
106.345379268, 0.265493563021,
-98.847447371, 0.304755133947,
35.6891207635, 1.09939438261,
14.960697937, 5.55616063212,
8.02488254002, 15.1763069088,
6.81285253667, 0.0141762913895
};
D ir4plus_5[] = {
-106.186824541, 0.0762127870069,
98.5369254424, 0.0955873862268,
33.0913768627, 1.46696798091,
29.5179729712, 0.0371780376304,
17.9368962739, 10.0262042064
};
D ir4plus_4[] = {
32.955642492, 1.47618761995,
17.8861359504, 10.0498555179,
16.6935576788, 0.14914814421,
5.3622174022, 0.00824729245256
};
D ir4plus_3[] = {
32.9579326489, 1.5155946274,
22.3655430545, 0.113052302172,
17.5814131409, 10.1937055243
};
D ir4plus_2[] = {
50.6662691484, 0.654149363383,
22.1671386129, 8.62570925718
};
D ir4plus_1[] = {
72.654397622, 2.69719911037
};
D* ir4plus_c[] = { ir4plus_6, ir4plus_5, ir4plus_4, ir4plus_3, ir4plus_2, ir4plus_1 };

D pt2plus_s[] = { 6.0, 4.0, 3.5, 1.7, 0.8, 0.25 };
D pt2plus_e[] = {
0.00260615937505,
0.00845418314791,
0.00808777143087,
0.00996154627066,
0.00873040150089,
0.00899869133271
};
D pt2plus_6[] = {
35.8680809566, 1.11657522433,
32.6179759772, 0.210044261732,
-23.327462606, 0.339741850732,
17.1127991457, 6.70442146729,
7.28720278123, 21.6589419342,
6.42481827013, 0.0120227589803
};
D pt2plus_5[] = {
32.5369655785, 1.33319048107,
17.7807291348, 8.52196833995,
16.2831340182, 0.132810921197,
5.09436390131, 0.00985499039559,
4.32383913087, 28.0043035719
};
D pt2plus_4[] = {
25.112690007, 0.958916552887,
18.6602357283, 0.0727673766978,
16.6357438005, 3.0106182196,
15.4867389015, 14.2237460443
};
D pt2plus_3[] = {
31.090909998, 1.86175652884,
27.3636876796, 0.177980063979,
17.4093783468, 13.1325398271
};
D pt2plus_2[] = {
54.2727736964, 0.749579582149,
21.5198605559, 11.2209985443
};
D pt2plus_1[] = {
75.594652834, 3.21875714114
};
D* pt2plus_c[] = { pt2plus_6, pt2plus_5, pt2plus_4, pt2plus_3, pt2plus_2, pt2plus_1 };

D pt4plus_s[] = { 6.0, 6.0, 5.0, 2.5, 0.9, 0.28 };
D pt4plus_e[] = {
0.00180832926676,
0.00938563592615,
0.00996242017114,
0.00975794443049,
0.00780042999677,
0.00857254681958
};
D pt4plus_6[] = {
37.4602775347, 1.0214879713,
35.7018294832, 0.222045327333,
-29.8975654537, 0.362784294127,
14.6509830264, 5.17410928661,
9.43715098035, 14.1410669064,
6.62996108864, 0.0128781844249
};
D pt4plus_5[] = {
33.9411919345, 0.10876934851,
33.5241412395, 1.4019016024,
-31.583169395, 0.060798814957,
19.3952191805, 0.0281620214202,
18.6302614204, 9.95863525607
};
D pt4plus_4[] = {
33.4238080853, 1.40835832304,
18.5947017473, 9.97401323464,
17.1558299897, 0.138613966886,
4.7340572298, 0.00306415277676
};
D pt4plus_3[] = {
34.005306397, 1.36134820988,
20.9380988627, 0.0909612521999,
18.9470845932, 9.77483462217
};
D pt4plus_2[] = {
51.2295367318, 0.64217258232,
22.6092603001, 8.63227950139
};
D pt4plus_1[] = {
73.652906644, 2.69968836298
};
D* pt4plus_c[] = { pt4plus_6, pt4plus_5, pt4plus_4, pt4plus_3, pt4plus_2, pt4plus_1 };

D au1plus_s[] = { 6.0, 5.0, 3.5, 1.5, 0.7, 0.22 };
D au1plus_e[] = {
0.00276601080643,
0.00988742236882,
0.00960613148366,
0.00908291209018,
0.00676892984349,
0.00750441781247
};
D au1plus_6[] = {
37.0555607649, 1.08200125813,
23.3672365042, 0.18447429871,
18.4370800527, 7.11493519877,
-14.5824438488, 0.397819874609,
7.29368458115, 25.2320184691,
6.40451024654, 0.0116961650138
};
D au1plus_5[] = {
32.5334955604, 1.25645688355,
18.592522052, 8.16778368777,
16.8399347704, 0.125147703613,
5.64506570258, 28.9103026917,
4.37856638141, 0.0014229974795
};
D au1plus_4[] = {
31.1841411656, 1.08234993321,
19.2067378452, 0.0735437314703,
15.8532790313, 5.28499088027,
11.6743835106, 19.0392195605
};
D au1plus_3[] = {
33.7504631735, 0.262734307656,
27.6766362446, 2.42613280811,
16.4339890894, 15.5113349132
};
D au1plus_2[] = {
57.3016369439, 0.848203345528,
20.5062709032, 13.3592133434
};
D au1plus_1[] = {
77.6503983333, 3.62185161627
};
D* au1plus_c[] = { au1plus_6, au1plus_5, au1plus_4, au1plus_3, au1plus_2, au1plus_1 };

D au3plus_s[] = { 6.0, 5.0, 3.5, 2.0, 0.9, 0.26 };
D au3plus_e[] = {
0.00106971924514,
0.00990388033264,
0.00988101780489,
0.00983909895628,
0.00926188427996,
0.007782119049
};
D au3plus_6[] = {
37.326711126, 1.03880720382,
25.2709761369, 0.189786710145,
-17.6241353398, 0.38755722612,
16.7767924603, 6.17312423422,
7.82785569784, 17.3739490827,
6.40913807215, 0.0116500391636
};
D au3plus_5[] = {
32.4167029131, 1.25365050386,
18.6900111168, 7.98287835529,
16.8382925162, 0.12509194262,
4.37564260803, 0.00140608908372,
3.68715324125, 24.1897024698
};
D au3plus_4[] = {
31.4797485134, 1.09231761534,
19.241116786, 0.0737123199647,
15.1387423186, 5.39453270162,
10.115750511, 15.4855105942
};
D au3plus_3[] = {
33.1910464075, 1.46091330642,
23.2408805619, 0.117339832454,
19.4418534872, 10.7664573251
};
D au3plus_2[] = {
52.3770480653, 0.646108574167,
23.4236190459, 9.34379119164
};
D au3plus_1[] = {
75.6530769121, 2.95000541434
};
D* au3plus_c[] = { au3plus_6, au3plus_5, au3plus_4, au3plus_3, au3plus_2, au3plus_1 };

D hg1plus_s[] = { 6.0, 4.0, 3.5, 1.4, 0.7, 0.22 };
D hg1plus_e[] = {
0.0024030934694,
0.00490851360793,
0.0073768178236,
0.00821239807726,
0.00750249643745,
0.00802881103616
};
D hg1plus_6[] = {
38.4498342573, 1.02253452631,
21.7832830862, 0.171135566763,
19.5712332962, 7.04431004867,
-14.0814114868, 0.420414518272,
7.01265761862, 27.3511328963,
6.23851941138, 0.0105826047269
};
D hg1plus_5[] = {
33.1478417214, 1.19429104205,
20.2482933159, 8.28633272303,
16.9847634736, 0.111347911279,
4.79475389534, 36.0961394685,
3.85774085731, 0.00167734971689
};
D hg1plus_4[] = {
32.0809141241, 1.05713844295,
19.2188037732, 0.0713346560616,
17.8868940398, 5.90676872138,
9.74253481092, 22.0658020303
};
D hg1plus_3[] = {
38.1842719318, 0.317827705144,
26.0034681364, 3.0072633734,
14.6835928384, 17.2797866404
};
D hg1plus_2[] = {
58.3133376188, 0.852989856946,
20.4666583955, 13.6531775931
};
D hg1plus_1[] = {
78.6184306705, 3.64257071331
};
D* hg1plus_c[] = { hg1plus_6, hg1plus_5, hg1plus_4, hg1plus_3, hg1plus_2, hg1plus_1 };

D hg2plus_s[] = { 6.0, 4.0, 3.5, 1.7, 0.8, 0.26 };
D hg2plus_e[] = {
0.00142319178624,
0.0052007740308,
0.00646321012297,
0.00934748851706,
0.00753364010326,
0.00931885897228
};
D hg2plus_6[] = {
60.6613489286, 0.222097708312,
-52.5574298458, 0.282292393045,
36.9263485516, 1.00152608959,
17.9188899796, 6.3067267918,
8.37760181976, 19.0753619988,
6.65397976469, 0.0121759189079
};
D hg2plus_5[] = {
33.1577005596, 1.19129623128,
20.829072358, 8.43398710592,
16.9116336625, 0.111055950281,
3.89636530598, 0.00237046988352,
3.2453833416, 32.687252018
};
D hg2plus_4[] = {
30.5265514877, 1.01846642529,
19.0987047021, 0.0707482339013,
14.8722818509, 14.0948665564,
13.4217729929, 4.1702364111
};
D hg2plus_3[] = {
30.112436978, 1.77440063269,
28.6235543927, 0.184015028333,
19.1340014396, 12.1530773066
};
D hg2plus_2[] = {
54.9088510818, 0.710627204412,
22.9070566406, 10.7145158146
};
D hg2plus_1[] = {
77.5741964287, 3.12899594114
};
D* hg2plus_c[] = { hg2plus_6, hg2plus_5, hg2plus_4, hg2plus_3, hg2plus_2, hg2plus_1 };

D tl1plus_s[] = { 6.0, 4.0, 3.5, 1.4, 0.7, 0.22 };
D tl1plus_e[] = {
0.00278134366612,
0.00418064781599,
0.00527311556135,
0.00852498138853,
0.00808376136514,
0.00843783940885
};
D tl1plus_6[] = {
37.049076622, 1.00261961525,
22.1844663643, 0.162708636446,
20.0426466144, 6.82255414519,
-12.6993296142, 0.3686103657,
7.33311508547, 28.0172338491,
6.06332037958, 0.00945529865302
};
D tl1plus_5[] = {
33.1228034288, 1.13000029464,
20.3944058937, 7.65031797888,
16.2139401781, 0.108808009678,
5.83586404905, 33.3462430421,
4.4562202331, 0.00781655481719
};
D tl1plus_4[] = {
32.9525869906, 1.03084943284,
19.9538202222, 6.51250123244,
19.2005417232, 0.0689999454486,
7.86590774506, 26.951068647
};
D tl1plus_3[] = {
39.5327824616, 0.325027778987,
26.1602116133, 3.17915721832,
14.1766153818, 18.2496535544
};
D tl1plus_2[] = {
59.3180509198, 0.857332496559,
20.4434193498, 13.9847676945
};
D tl1plus_1[] = {
79.5936200788, 3.66804798489
};
D* tl1plus_c[] = { tl1plus_6, tl1plus_5, tl1plus_4, tl1plus_3, tl1plus_2, tl1plus_1 };

D tl3plus_s[] = { 6.0, 4.0, 3.5, 2.0, 0.9, 0.28 };
D tl3plus_e[] = {
0.0014136992188,
0.00443715523938,
0.00367643781213,
0.00951683979893,
0.00802334145934,
0.00965602287128
};
D tl3plus_6[] = {
88.0253728999, 0.220653823638,
-79.6848352717, 0.257764482322,
36.8196833593, 0.964594471507,
18.4150571839, 6.18447142281,
7.74248772629, 16.6980288418,
6.68398666729, 0.0119731203781
};
D tl3plus_5[] = {
33.1471655067, 1.11879884592,
21.5512537481, 7.84394624401,
17.0129163008, 0.10233892855,
3.49528990428, 0.00057555925546,
2.82651214189, 27.5993450224
};
D tl3plus_4[] = {
30.6292721086, 0.973992259013,
19.0067947713, 0.0680420180138,
16.5158368877, 11.7035224739,
11.7829947648, 3.72615375751
};
D tl3plus_3[] = {
32.8767121018, 1.35329459086,
23.672820948, 0.116584302403,
21.3285050038, 10.0576511227
};
D tl3plus_2[] = {
53.0271930299, 0.61356261876,
24.7960453817, 9.01425636424
};
D tl3plus_1[] = {
77.5946441516, 2.84550025923
};
D* tl3plus_c[] = { tl3plus_6, tl3plus_5, tl3plus_4, tl3plus_3, tl3plus_2, tl3plus_1 };

D pb2plus_s[] = { 6.0, 4.0, 3.5, 1.5, 0.8, 0.25 };
D pb2plus_e[] = {
0.0015239460537,
0.0046095113552,
0.00305076899057,
0.00866823853692,
0.00969459972582,
0.00959109249497
};
D pb2plus_6[] = {
37.5456340066, 0.93604907295,
23.5363868897, 0.160854042588,
20.2354144275, 6.29405398158,
-14.9029286137, 0.344152191863,
7.49092731905, 23.235233666,
6.07715674328, 0.00915118624314
};
D pb2plus_5[] = {
33.2963126598, 1.10051408028,
21.5094589197, 7.73744863946,
12.6191693049, 0.128603585158,
8.29018607319, 0.027442100502,
4.33021505199, 33.9193596142
};
D pb2plus_4[] = {
32.4804791406, 0.97323724826,
19.1088309878, 0.0664336958488,
19.0357596503, 5.64042819286,
9.33035743412, 20.2788596879
};
D pb2plus_3[] = {
37.2896234053, 0.28105223518,
26.7023992133, 2.61460665261,
15.8864097445, 14.8145978062
};
D pb2plus_2[] = {
57.0330206149, 0.72221178054,
22.7150345739, 11.309915074
};
D pb2plus_1[] = {
79.5422609741, 3.23016632158
};
D* pb2plus_c[] = { pb2plus_6, pb2plus_5, pb2plus_4, pb2plus_3, pb2plus_2, pb2plus_1 };

D pb4plus_s[] = { 6.0, 6.0, 6.0, 3.0, 1.0, 0.3 };
D pb4plus_e[] = {
0.00049689855836,
0.00850770686128,
0.00915172112883,
0.00872826430368,
0.0090945671057,
0.00975654718126
};
D pb4plus_6[] = {
37.1809769981, 0.916010497853,
36.4043749828, 0.185631663801,
-28.1823506347, 0.283328860686,
18.8882434393, 5.94288656053,
7.31557810687, 14.5466831085,
6.38926234513, 0.010377450197
};
D pb4plus_5[] = {
34.0874092789, 1.14647255676,
31.3543131386, 0.0913185328366,
-30.2818946174, 0.047677123988,
22.6171277543, 8.80253671129,
20.1263212932, 0.0232656450436
};
D pb4plus_4[] = {
33.9489117629, 1.15301483004,
22.5771646906, 8.81555165286,
16.6436187845, 0.11731940813,
4.73445670055, 0.00333655207908
};
D pb4plus_3[] = {
34.8331846576, 1.1060209705,
22.8862189868, 8.71472925204,
20.1777608782, 0.0737661783857
};
D pb4plus_2[] = {
51.4598269372, 0.540855604611,
26.363514935, 7.78902786259
};
D pb4plus_1[] = {
77.5973231135, 2.60324214235
};
D* pb4plus_c[] = { pb4plus_6, pb4plus_5, pb4plus_4, pb4plus_3, pb4plus_2, pb4plus_1 };

D bi3plus_s[] = { 6.0, 4.0, 3.5, 1.6, 0.8, 0.26 };
D bi3plus_e[] = {
0.0012663437695,
0.00509348087886,
0.00216700522068,
0.00879747973136,
0.00761926516665,
0.00868838314622
};
D bi3plus_6[] = {
263.437395195, 0.204352355346,
-253.792565355, 0.21395214266,
36.1511531573, 0.903397196575,
20.3995378056, 5.90496514958,
7.46310810364, 20.0207840965,
6.32724160138, 0.00975297135563
};
D bi3plus_5[] = {
33.0077674828, 0.992234721948,
20.4437113379, 6.29652641384,
17.0280878964, 0.0871149696349,
6.58721027623, 21.3557510902,
2.91622081351, 0.000701729475356
};
D bi3plus_4[] = {
32.7338777732, 0.940724565679,
19.0958757509, 0.064288373645,
19.061642572, 5.46186597294,
9.07425796719, 17.8875289963
};
D bi3plus_3[] = {
35.0542004082, 0.242310143259,
27.3321298501, 2.17647222118,
17.4940450737, 12.392977326
};
D bi3plus_2[] = {
56.8291514541, 0.689908571339,
22.9744863511, 10.2752202638
};
D bi3plus_1[] = {
79.5883250927, 2.98043074351
};
D* bi3plus_c[] = { bi3plus_6, bi3plus_5, bi3plus_4, bi3plus_3, bi3plus_2, bi3plus_1 };

D bi5plus_s[] = { 6.0, 6.0, 6.0, 3.5, 1.0, 0.3 };
D bi5plus_e[] = {
0.000130434810691,
0.00683404580466,
0.00930562096883,
0.00989154107963,
0.00695244265874,
0.00797858941245
};
D bi5plus_6[] = {
116.338599481, 0.207676011487,
-108.682016508, 0.234098289959,
37.4669668646, 0.86653627398,
19.4269096684, 5.67797486274,
6.90789690858, 12.8840363595,
6.53946736477, 0.0106115391332
};
D bi5plus_5[] = {
122.298692642, 0.190676657397,
-109.631417576, 0.205701606921,
35.3039603726, 1.02425577995,
23.5470265814, 7.81179243858,
6.38861941147, 0.00991781953744
};
D bi5plus_4[] = {
33.6126966271, 1.07103723778,
23.3065307823, 7.87607875444,
16.7210836073, 0.107311914803,
4.27156627508, 0.000925435783498
};
D bi5plus_3[] = {
34.5674536769, 1.02511231745,
23.6216854324, 7.79021987402,
19.715924811, 0.0675638289687
};
D bi5plus_2[] = {
51.160333216, 0.51490071939,
26.7038411091, 7.15034822706
};
D bi5plus_1[] = {
77.6693122509, 2.45362627404
};
D* bi5plus_c[] = { bi5plus_6, bi5plus_5, bi5plus_4, bi5plus_3, bi5plus_2, bi5plus_1 };

D ra2plus_s[] = { 6.0, 5.0, 4.0, 1.6, 0.7, 0.22 };
D ra2plus_e[] = {
0.00142348527457,
0.00944831084325,
0.00408926460078,
0.00973633713516,
0.00835628622226,
0.00939786025531
};
D ra2plus_6[] = {
98.6438180435, 0.172687716202,
-92.0002147409, 0.199509486275,
38.1920569655, 0.692599255465,
22.6401702942, 4.4309637378,
12.016654657, 24.5032504423,
6.47710270461, 0.00885575410111
};
D ra2plus_5[] = {
32.7702852492, 0.804362764899,
21.5851133259, 4.66745809616,
16.2361587983, 0.0791665008937,
11.8020687231, 24.6873993688,
3.57308192804, 2.2419672286e-05
};
D ra2plus_4[] = {
32.3861993483, 0.739364762005,
21.9592818636, 4.09251026414,
18.4658791028, 0.0519971474661,
13.1183093792, 22.6086369795
};
D ra2plus_3[] = {
40.9554332452, 0.264568045903,
29.6834036183, 2.80175516762,
15.2471305129, 20.210411606
};
D ra2plus_2[] = {
65.5030552047, 0.853367398918,
20.2613206918, 16.0411482771
};
D ra2plus_1[] = {
85.5204682365, 3.72786012237
};
D* ra2plus_c[] = { ra2plus_6, ra2plus_5, ra2plus_4, ra2plus_3, ra2plus_2, ra2plus_1 };

D ac3plus_s[] = { 6.0, 5.0, 4.0, 1.6, 0.7, 0.22 };
D ac3plus_e[] = {
0.000987742978507,
0.00887413903914,
0.00292036613897,
0.00751556617893,
0.00634405430904,
0.00754838491778
};
D ac3plus_6[] = {
37.6163101557, 0.654828979809,
33.0350117895, 0.127786069228,
-24.8165936977, 0.213916995561,
22.5086504393, 4.01945632611,
12.6820923715, 20.9597830115,
4.95248271097, 0.0021171248382
};
D ac3plus_5[] = {
32.7539996328, 0.764597543204,
21.4244079537, 4.33443125925,
15.9829516374, 0.0742457662461,
12.233251771, 21.3675481449,
3.58996470329, 0.00238547708502
};
D ac3plus_4[] = {
32.9574462773, 0.722692309287,
21.9975165002, 4.13097987945,
18.4883287169, 0.0505376351835,
12.5347445625, 21.0909282991
};
D ac3plus_3[] = {
40.8953270355, 0.255773095255,
29.4271298743, 2.64309053686,
15.5913126121, 17.9288598888
};
D ac3plus_2[] = {
65.3713973378, 0.81705849522,
20.4510735825, 14.6392336799
};
D ac3plus_1[] = {
85.6156134974, 3.50551593174
};
D* ac3plus_c[] = { ac3plus_6, ac3plus_5, ac3plus_4, ac3plus_3, ac3plus_2, ac3plus_1 };

D th4plus_s[] = { 6.0, 5.0, 4.0, 1.7, 0.8, 0.25 };
D th4plus_e[] = {
0.000631953507127,
0.00802396521421,
0.00215539632958,
0.00840124559214,
0.00906712173003,
0.0093941847222
};
D th4plus_6[] = {
156.851411939, 0.176022530952,
-155.256316987, 0.196059152179,
41.7932718492, 0.585631000326,
22.5994596411, 3.64918290651,
13.2927716451, 18.2809472563,
6.70294692066, 0.0090533670348
};
D th4plus_5[] = {
32.6370952367, 0.750627002212,
21.4316956716, 4.21096209329,
14.8077065102, 0.0823255979819,
12.0015353412, 19.7538962422,
5.14465226844, 0.00779640293056
};
D th4plus_4[] = {
33.0614795175, 0.698980390978,
21.9414906687, 3.96113066087,
18.4799306995, 0.0489654780106,
12.5359147682, 19.2045694587
};
D th4plus_3[] = {
39.4858377767, 0.231392856815,
29.8560810356, 2.32765344571,
16.5711060139, 15.5084627301
};
D th4plus_2[] = {
63.4014445288, 0.703594004063,
22.37528498, 12.1815920617
};
D th4plus_1[] = {
85.5235983952, 3.12757854106
};
D* th4plus_c[] = { th4plus_6, th4plus_5, th4plus_4, th4plus_3, th4plus_2, th4plus_1 };

D u3plus_s[] = { 6.0, 5.0, 4.0, 1.7, 0.8, 0.24 };
D u3plus_e[] = {
0.00157821859401,
0.00679566293815,
0.00220229527754,
0.00835181373618,
0.00958739117034,
0.00931982379841
};
D u3plus_6[] = {
38.2051426276, 0.586855624999,
33.7091350888, 0.119167424483,
-26.0893492641, 0.19381885229,
23.3004112085, 3.72958029538,
14.5914947661, 18.5183488409,
5.25184347435, 0.00308033335134
};
D u3plus_5[] = {
33.0333836535, 0.671868967027,
22.5121063964, 3.92238566042,
16.0801219377, 0.0635125734635,
14.2620794642, 18.7453544332,
3.08158100269, 0.000392894038425
};
D u3plus_4[] = {
33.6421264828, 0.653565794521,
22.9633193762, 3.9478586941,
18.3741214788, 0.0457228509243,
13.9972584993, 19.0857394821
};
D u3plus_3[] = {
41.1779007546, 0.232775175687,
29.7820546955, 2.41858338175,
17.940270102, 15.9015899217
};
D u3plus_2[] = {
64.608187935, 0.693524186217,
24.1398593975, 12.4684115981
};
D u3plus_1[] = {
88.5285466868, 3.34418046305
};
D* u3plus_c[] = { u3plus_6, u3plus_5, u3plus_4, u3plus_3, u3plus_2, u3plus_1 };

D u4plus_s[] = { 6.0, 5.0, 4.0, 1.8, 0.8, 0.26 };
D u4plus_e[] = {
0.00100662636543,
0.00701017774495,
0.00294860093587,
0.00984089011049,
0.00797735426567,
0.0099648727886
};
D u4plus_6[] = {
43.3907104795, 0.544053157899,
25.6784515368, 0.115164294999,
-24.2957228902, 0.252514713481,
22.9995637527, 3.48561567795,
14.6307736339, 16.7931986986,
5.57602683977, 0.0045535032694
};
D u4plus_5[] = {
32.897329091, 0.668994213205,
22.1508881853, 3.81295448857,
16.1317737246, 0.0629707873938,
13.8161230181, 17.4567926109,
2.99477011842, 3.57664564184e-06
};
D u4plus_4[] = {
33.1027589328, 0.645080838198,
22.0362712948, 3.62957822701,
18.3413466521, 0.0456892499384,
14.4955949889, 16.8087566294
};
D u4plus_3[] = {
39.2231683786, 0.212894072516,
30.1479769963, 2.13526874051,
18.5272164974, 14.1020940664
};
D u4plus_2[] = {
64.0830322306, 0.677602540659,
23.7136605538, 11.6940179495
};
D u4plus_1[] = {
87.4871309515, 3.05414022447
};
D* u4plus_c[] = { u4plus_6, u4plus_5, u4plus_4, u4plus_3, u4plus_2, u4plus_1 };

D u6plus_s[] = { 6.0, 5.0, 4.0, 1.8, 0.9, 0.26 };
D u6plus_e[] = {
0.000387063621785,
0.00698543545041,
0.0027031169969,
0.00745392096116,
0.00941952354112,
0.00763239017005
};
D u6plus_6[] = {
179.061396507, 0.416787426512,
-161.172723041, 0.365977765515,
24.7017039082, 0.123353683033,
22.7370345883, 3.07786541805,
14.3274593356, 14.4961915699,
6.33566598238, 0.00745077640061
};
D u6plus_5[] = {
32.417511395, 0.663054296959,
21.1986048801, 3.50305414929,
16.1195980929, 0.0628567999916,
13.2816501508, 15.1962100286,
2.98808952322, 1.44785350113e-06
};
D u6plus_4[] = {
32.9373667276, 0.64267121853,
21.8629533972, 3.52535246938,
18.3122423546, 0.0455005318281,
12.9166983508, 15.6621735414
};
D u6plus_3[] = {
38.1986397104, 0.204193831565,
30.1101931163, 1.97920722935,
17.6233515617, 12.5457420481
};
D u6plus_2[] = {
61.6654111428, 0.594578033824,
24.1166801138, 9.75414881825
};
D u6plus_1[] = {
85.6137579869, 2.77174263216
};
D* u6plus_c[] = { u6plus_6, u6plus_5, u6plus_4, u6plus_3, u6plus_2, u6plus_1 };

D np3plus_s[] = { 6.0, 5.0, 4.0, 1.7, 0.8, 0.25 };
D np3plus_e[] = {
0.00238479148467,
0.00652873613088,
0.00399109595098,
0.00778333204514,
0.00903010057117,
0.00987959412099
};
D np3plus_6[] = {
44.1666629627, 0.52909162429,
28.0697702386, 0.115828403887,
-26.9375471337, 0.23734370364,
23.7914510194, 3.5964535264,
15.3072590818, 17.579824052,
5.5655594756, 0.00418454640069
};
D np3plus_5[] = {
33.2555333421, 0.667717899368,
22.7821044938, 4.00121099069,
14.3469395788, 18.3292090001,
13.6671655743, 0.0743660336075,
5.92465168116, 0.0119194577691
};
D np3plus_4[] = {
33.6416231098, 0.627865707629,
23.108425694, 3.78312620706,
18.2955916583, 0.0440594467494,
14.9210536234, 17.8428914531
};
D np3plus_3[] = {
41.7331634004, 0.23071336099,
29.695598844, 2.41391943832,
18.4744283181, 15.3588500263
};
D np3plus_2[] = {
64.9381147417, 0.681246479338,
24.8205329948, 12.1320062503
};
D np3plus_1[] = {
89.4783048044, 3.25244614297
};
D* np3plus_c[] = { np3plus_6, np3plus_5, np3plus_4, np3plus_3, np3plus_2, np3plus_1 };

D np4plus_s[] = { 6.0, 5.0, 4.0, 1.8, 0.8, 0.26 };
D np4plus_e[] = {
0.00178676382502,
0.0071955984926,
0.00420476795028,
0.00908583695726,
0.0074971509509,
0.00956001219457
};
D np4plus_6[] = {
63.2081737116, 0.472395781281,
-42.5260843564, 0.30933043572,
23.6424636176, 0.112039480249,
23.4509557845, 3.37083897854,
15.3545222584, 15.9982952813,
5.84439739527, 0.00558697612809
};
D np4plus_5[] = {
32.7762091657, 0.682422065871,
22.5658702513, 4.0350547409,
13.3807575708, 17.6549080039,
13.3073439853, 0.0304561082795,
6.99155132225, 0.128251681922
};
D np4plus_4[] = {
33.4443098394, 0.624671613991,
22.5500740452, 3.63982935782,
18.2712910165, 0.0439605357759,
14.7150824092, 16.4159454473
};
D np4plus_3[] = {
39.8131109508, 0.211577649242,
29.9754400035, 2.13014868184,
19.1125682423, 13.6570361033
};
D np4plus_2[] = {
64.3959274173, 0.665071462773,
24.4091366005, 11.3933534164
};
D np4plus_1[] = {
88.5027809252, 3.03640063724
};
D* np4plus_c[] = { np4plus_6, np4plus_5, np4plus_4, np4plus_3, np4plus_2, np4plus_1 };

D np6plus_s[] = { 6.0, 5.0, 4.0, 1.9, 0.9, 0.28 };
D np6plus_e[] = {
0.00091974237421,
0.00754578674298,
0.00474148052296,
0.00954095397007,
0.00876844037826,
0.00981742810431
};
D np6plus_6[] = {
76.2929259377, 0.424780559736,
-75.3810736832, 0.271983046171,
41.0673273102, 0.147258372212,
22.9498594579, 2.99510347348,
15.1086722083, 13.8247808082,
6.94930529508, 0.00911809729505
};
D np6plus_5[] = {
32.6717728085, 0.633859763405,
21.4982024073, 3.41248957935,
16.3139770895, 0.0570356582002,
13.9920421995, 14.4922891773,
2.52584481876, 1.41597592493e-05
};
D np6plus_4[] = {
32.9122740333, 0.616067346095,
21.8488245796, 3.35745253565,
18.2096791284, 0.0437149821593,
14.0427981852, 14.5417817405
};
D np6plus_3[] = {
37.3510457467, 0.189211525567,
30.4492513302, 1.82190276866,
19.1112057825, 11.6932640928
};
D np6plus_2[] = {
61.9430069961, 0.582666804912,
24.8506232431, 9.54648056567
};
D np6plus_1[] = {
86.5328138992, 2.68362918059
};
D* np6plus_c[] = { np6plus_6, np6plus_5, np6plus_4, np6plus_3, np6plus_2, np6plus_1 };

D pu3plus_s[] = { 6.0, 5.0, 4.0, 1.8, 0.8, 0.25 };
D pu3plus_e[] = {
0.00311223671034,
0.00788966426956,
0.00562443882778,
0.00987052297366,
0.00852283107178,
0.00940515129206
};
D pu3plus_6[] = {
52.3230492941, 0.479595326057,
-34.062128198, 0.26077851528,
26.6789499071, 0.112693442509,
24.3442424683, 3.48973952657,
15.915024113, 16.7817099847,
5.76156241928, 0.00506229222439
};
D pu3plus_5[] = {
33.3409327616, 0.627728449775,
23.4256462218, 3.81962290474,
15.0832792287, 17.3690588552,
10.5611857893, 0.0263610043259,
8.56128269159, 0.0811301372133
};
D pu3plus_4[] = {
33.9857464599, 0.608797423754,
23.6806615954, 3.79568437427,
18.2336996492, 0.0424614742231,
15.0669835774, 17.3685502654
};
D pu3plus_3[] = {
40.9819969186, 0.214936348068,
30.1600852765, 2.24238422256,
19.7426435055, 14.3403905847
};
D pu3plus_2[] = {
65.2662411639, 0.669592782456,
25.5021713014, 11.7818762371
};
D pu3plus_1[] = {
90.4984258205, 3.2235109881
};
D* pu3plus_c[] = { pu3plus_6, pu3plus_5, pu3plus_4, pu3plus_3, pu3plus_2, pu3plus_1 };

D pu4plus_s[] = { 6.0, 5.0, 4.0, 1.8, 0.8, 0.26 };
D pu4plus_e[] = {
0.00232813550322,
0.0084298337102,
0.00592334397355,
0.00845496962266,
0.00704923903377,
0.00913948278738
};
D pu4plus_6[] = {
-86.18788099, 0.245921614432,
71.1356844814, 0.42486735578,
57.4410860874, 0.159267079299,
24.0056536651, 3.24721007366,
16.0863552943, 15.239367461,
7.48969691551, 0.0107285505651
};
D pu4plus_5[] = {
33.3430913016, 0.609755657489,
22.8656333777, 3.58447566348,
16.6578689337, 0.0508498861019,
15.2234445772, 15.7578656386,
1.89057750889, 0.000174971527385
};
D pu4plus_4[] = {
33.7038569135, 0.605292960327,
23.2765318467, 3.66236893422,
18.2450367204, 0.0425508071584,
14.7694609121, 16.1591806459
};
D pu4plus_3[] = {
40.4174963778, 0.210332153232,
29.8280634396, 2.13117512157,
19.6593545703, 13.2199487524
};
D pu4plus_2[] = {
64.7042046715, 0.653155005817,
25.1093619111, 11.0766205825
};
D pu4plus_1[] = {
89.5202261736, 3.01357969887
};
D* pu4plus_c[] = { pu4plus_6, pu4plus_5, pu4plus_4, pu4plus_3, pu4plus_2, pu4plus_1 };

D pu6plus_s[] = { 6.0, 5.0, 4.0, 1.9, 0.9, 0.28 };
D pu6plus_e[] = {
0.00175347573263,
0.00856271292386,
0.00597764534215,
0.00877855582832,
0.00816945514933,
0.00940789702557
};
D pu6plus_6[] = {
-199.149658166, 0.226618471818,
150.918103989, 0.183235215829,
89.6646881546, 0.385596308871,
23.3279362469, 2.91417166539,
15.8358517437, 13.2161011823,
7.38793340818, 0.010178463743
};
D pu6plus_5[] = {
32.9647924633, 0.604546018491,
21.9257531113, 3.33439879202,
16.6825119692, 0.0504061594261,
14.6091674009, 13.8946359557,
1.82345147206, 2.37070211605e-05
};
D pu6plus_4[] = {
33.3221486574, 0.600667795704,
22.437417622, 3.4180759252,
18.2191588603, 0.0424823314596,
14.0469875203, 14.3760618292
};
D pu6plus_3[] = {
38.0154714625, 0.188926943713,
30.2205358482, 1.8249301451,
19.6844849849, 11.3803228815
};
D pu6plus_2[] = {
62.2000103069, 0.570943218412,
25.6041826796, 9.31460234584
};
D pu6plus_1[] = {
87.5475161468, 2.66951392017
};
D* pu6plus_c[] = { pu6plus_6, pu6plus_5, pu6plus_4, pu6plus_3, pu6plus_2, pu6plus_1 };

static const char*
labels[] = {
"H",
"Hiso",
"He",
"Li",
"Be",
"B",
"C",
"N",
"O",
"F",
"Ne",
"Na",
"Mg",
"Al",
"Si",
"P",
"S",
"Cl",
"Ar",
"K",
"Ca",
"Sc",
"Ti",
"V",
"Cr",
"Mn",
"Fe",
"Co",
"Ni",
"Cu",
"Zn",
"Ga",
"Ge",
"As",
"Se",
"Br",
"Kr",
"Rb",
"Sr",
"Y",
"Zr",
"Nb",
"Mo",
"Tc",
"Ru",
"Rh",
"Pd",
"Ag",
"Cd",
"In",
"Sn",
"Sb",
"Te",
"I",
"Xe",
"Cs",
"Ba",
"La",
"Ce",
"Pr",
"Nd",
"Pm",
"Sm",
"Eu",
"Gd",
"Tb",
"Dy",
"Ho",
"Er",
"Tm",
"Yb",
"Lu",
"Hf",
"Ta",
"W",
"Re",
"Os",
"Ir",
"Pt",
"Au",
"Hg",
"Tl",
"Pb",
"Bi",
"Po",
"At",
"Rn",
"Fr",
"Ra",
"Ac",
"Th",
"Pa",
"U",
"Np",
"Pu",
"Am",
"Cm",
"Bk",
"Cf",
"H1-",
"Li1+",
"Be2+",
"Cval",
"O1-",
"O2-",
"F1-",
"Na1+",
"Mg2+",
"Al3+",
"Sival",
"Si4+",
"Cl1-",
"K1+",
"Ca2+",
"Sc3+",
"Ti2+",
"Ti3+",
"Ti4+",
"V2+",
"V3+",
"V5+",
"Cr2+",
"Cr3+",
"Mn2+",
"Mn3+",
"Mn4+",
"Fe2+",
"Fe3+",
"Co2+",
"Co3+",
"Ni2+",
"Ni3+",
"Cu1+",
"Cu2+",
"Zn2+",
"Ga3+",
"Ge4+",
"Br1-",
"Rb1+",
"Sr2+",
"Y3+",
"Zr4+",
"Nb3+",
"Nb5+",
"Mo3+",
"Mo5+",
"Mo6+",
"Ru3+",
"Ru4+",
"Rh3+",
"Rh4+",
"Pd2+",
"Pd4+",
"Ag1+",
"Ag2+",
"Cd2+",
"In3+",
"Sn2+",
"Sn4+",
"Sb3+",
"Sb5+",
"I1-",
"Cs1+",
"Ba2+",
"La3+",
"Ce3+",
"Ce4+",
"Pr3+",
"Pr4+",
"Nd3+",
"Pm3+",
"Sm3+",
"Eu2+",
"Eu3+",
"Gd3+",
"Tb3+",
"Dy3+",
"Ho3+",
"Er3+",
"Tm3+",
"Yb2+",
"Yb3+",
"Lu3+",
"Hf4+",
"Ta5+",
"W6+",
"Os4+",
"Ir3+",
"Ir4+",
"Pt2+",
"Pt4+",
"Au1+",
"Au3+",
"Hg1+",
"Hg2+",
"Tl1+",
"Tl3+",
"Pb2+",
"Pb4+",
"Bi3+",
"Bi5+",
"Ra2+",
"Ac3+",
"Th4+",
"U3+",
"U4+",
"U6+",
"Np3+",
"Np4+",
"Np6+",
"Pu3+",
"Pu4+",
"Pu6+"
};
static const cctbx::eltbx::xray_scattering::n_gaussian::raw::entry
table[] = {
h_sds_s, h_sds_e, h_sds_c,
h_hf_s, h_hf_e, h_hf_c,
he_s, he_e, he_c,
li_s, li_e, li_c,
be_s, be_e, be_c,
b_s, b_e, b_c,
c_s, c_e, c_c,
n_s, n_e, n_c,
o_s, o_e, o_c,
f_s, f_e, f_c,
ne_s, ne_e, ne_c,
na_s, na_e, na_c,
mg_s, mg_e, mg_c,
al_s, al_e, al_c,
si_s, si_e, si_c,
p_s, p_e, p_c,
s_s, s_e, s_c,
cl_s, cl_e, cl_c,
ar_s, ar_e, ar_c,
k_s, k_e, k_c,
ca_s, ca_e, ca_c,
sc_s, sc_e, sc_c,
ti_s, ti_e, ti_c,
v_s, v_e, v_c,
cr_s, cr_e, cr_c,
mn_s, mn_e, mn_c,
fe_s, fe_e, fe_c,
co_s, co_e, co_c,
ni_s, ni_e, ni_c,
cu_s, cu_e, cu_c,
zn_s, zn_e, zn_c,
ga_s, ga_e, ga_c,
ge_s, ge_e, ge_c,
as_s, as_e, as_c,
se_s, se_e, se_c,
br_s, br_e, br_c,
kr_s, kr_e, kr_c,
rb_s, rb_e, rb_c,
sr_s, sr_e, sr_c,
y_s, y_e, y_c,
zr_s, zr_e, zr_c,
nb_s, nb_e, nb_c,
mo_s, mo_e, mo_c,
tc_s, tc_e, tc_c,
ru_s, ru_e, ru_c,
rh_s, rh_e, rh_c,
pd_s, pd_e, pd_c,
ag_s, ag_e, ag_c,
cd_s, cd_e, cd_c,
in_s, in_e, in_c,
sn_s, sn_e, sn_c,
sb_s, sb_e, sb_c,
te_s, te_e, te_c,
i_s, i_e, i_c,
xe_s, xe_e, xe_c,
cs_s, cs_e, cs_c,
ba_s, ba_e, ba_c,
la_s, la_e, la_c,
ce_s, ce_e, ce_c,
pr_s, pr_e, pr_c,
nd_s, nd_e, nd_c,
pm_s, pm_e, pm_c,
sm_s, sm_e, sm_c,
eu_s, eu_e, eu_c,
gd_s, gd_e, gd_c,
tb_s, tb_e, tb_c,
dy_s, dy_e, dy_c,
ho_s, ho_e, ho_c,
er_s, er_e, er_c,
tm_s, tm_e, tm_c,
yb_s, yb_e, yb_c,
lu_s, lu_e, lu_c,
hf_s, hf_e, hf_c,
ta_s, ta_e, ta_c,
w_s, w_e, w_c,
re_s, re_e, re_c,
os_s, os_e, os_c,
ir_s, ir_e, ir_c,
pt_s, pt_e, pt_c,
au_s, au_e, au_c,
hg_s, hg_e, hg_c,
tl_s, tl_e, tl_c,
pb_s, pb_e, pb_c,
bi_s, bi_e, bi_c,
po_s, po_e, po_c,
at_s, at_e, at_c,
rn_s, rn_e, rn_c,
fr_s, fr_e, fr_c,
ra_s, ra_e, ra_c,
ac_s, ac_e, ac_c,
th_s, th_e, th_c,
pa_s, pa_e, pa_c,
u_s, u_e, u_c,
np_s, np_e, np_c,
pu_s, pu_e, pu_c,
am_s, am_e, am_c,
cm_s, cm_e, cm_c,
bk_s, bk_e, bk_c,
cf_s, cf_e, cf_c,
h1minus_s, h1minus_e, h1minus_c,
li1plus_s, li1plus_e, li1plus_c,
be2plus_s, be2plus_e, be2plus_c,
cval_s, cval_e, cval_c,
o1minus_s, o1minus_e, o1minus_c,
o2minus_s, o2minus_e, o2minus_c,
f1minus_s, f1minus_e, f1minus_c,
na1plus_s, na1plus_e, na1plus_c,
mg2plus_s, mg2plus_e, mg2plus_c,
al3plus_s, al3plus_e, al3plus_c,
sival_s, sival_e, sival_c,
si4plus_s, si4plus_e, si4plus_c,
cl1minus_s, cl1minus_e, cl1minus_c,
k1plus_s, k1plus_e, k1plus_c,
ca2plus_s, ca2plus_e, ca2plus_c,
sc3plus_s, sc3plus_e, sc3plus_c,
ti2plus_s, ti2plus_e, ti2plus_c,
ti3plus_s, ti3plus_e, ti3plus_c,
ti4plus_s, ti4plus_e, ti4plus_c,
v2plus_s, v2plus_e, v2plus_c,
v3plus_s, v3plus_e, v3plus_c,
v5plus_s, v5plus_e, v5plus_c,
cr2plus_s, cr2plus_e, cr2plus_c,
cr3plus_s, cr3plus_e, cr3plus_c,
mn2plus_s, mn2plus_e, mn2plus_c,
mn3plus_s, mn3plus_e, mn3plus_c,
mn4plus_s, mn4plus_e, mn4plus_c,
fe2plus_s, fe2plus_e, fe2plus_c,
fe3plus_s, fe3plus_e, fe3plus_c,
co2plus_s, co2plus_e, co2plus_c,
co3plus_s, co3plus_e, co3plus_c,
ni2plus_s, ni2plus_e, ni2plus_c,
ni3plus_s, ni3plus_e, ni3plus_c,
cu1plus_s, cu1plus_e, cu1plus_c,
cu2plus_s, cu2plus_e, cu2plus_c,
zn2plus_s, zn2plus_e, zn2plus_c,
ga3plus_s, ga3plus_e, ga3plus_c,
ge4plus_s, ge4plus_e, ge4plus_c,
br1minus_s, br1minus_e, br1minus_c,
rb1plus_s, rb1plus_e, rb1plus_c,
sr2plus_s, sr2plus_e, sr2plus_c,
y3plus_s, y3plus_e, y3plus_c,
zr4plus_s, zr4plus_e, zr4plus_c,
nb3plus_s, nb3plus_e, nb3plus_c,
nb5plus_s, nb5plus_e, nb5plus_c,
mo3plus_s, mo3plus_e, mo3plus_c,
mo5plus_s, mo5plus_e, mo5plus_c,
mo6plus_s, mo6plus_e, mo6plus_c,
ru3plus_s, ru3plus_e, ru3plus_c,
ru4plus_s, ru4plus_e, ru4plus_c,
rh3plus_s, rh3plus_e, rh3plus_c,
rh4plus_s, rh4plus_e, rh4plus_c,
pd2plus_s, pd2plus_e, pd2plus_c,
pd4plus_s, pd4plus_e, pd4plus_c,
ag1plus_s, ag1plus_e, ag1plus_c,
ag2plus_s, ag2plus_e, ag2plus_c,
cd2plus_s, cd2plus_e, cd2plus_c,
in3plus_s, in3plus_e, in3plus_c,
sn2plus_s, sn2plus_e, sn2plus_c,
sn4plus_s, sn4plus_e, sn4plus_c,
sb3plus_s, sb3plus_e, sb3plus_c,
sb5plus_s, sb5plus_e, sb5plus_c,
i1minus_s, i1minus_e, i1minus_c,
cs1plus_s, cs1plus_e, cs1plus_c,
ba2plus_s, ba2plus_e, ba2plus_c,
la3plus_s, la3plus_e, la3plus_c,
ce3plus_s, ce3plus_e, ce3plus_c,
ce4plus_s, ce4plus_e, ce4plus_c,
pr3plus_s, pr3plus_e, pr3plus_c,
pr4plus_s, pr4plus_e, pr4plus_c,
nd3plus_s, nd3plus_e, nd3plus_c,
pm3plus_s, pm3plus_e, pm3plus_c,
sm3plus_s, sm3plus_e, sm3plus_c,
eu2plus_s, eu2plus_e, eu2plus_c,
eu3plus_s, eu3plus_e, eu3plus_c,
gd3plus_s, gd3plus_e, gd3plus_c,
tb3plus_s, tb3plus_e, tb3plus_c,
dy3plus_s, dy3plus_e, dy3plus_c,
ho3plus_s, ho3plus_e, ho3plus_c,
er3plus_s, er3plus_e, er3plus_c,
tm3plus_s, tm3plus_e, tm3plus_c,
yb2plus_s, yb2plus_e, yb2plus_c,
yb3plus_s, yb3plus_e, yb3plus_c,
lu3plus_s, lu3plus_e, lu3plus_c,
hf4plus_s, hf4plus_e, hf4plus_c,
ta5plus_s, ta5plus_e, ta5plus_c,
w6plus_s, w6plus_e, w6plus_c,
os4plus_s, os4plus_e, os4plus_c,
ir3plus_s, ir3plus_e, ir3plus_c,
ir4plus_s, ir4plus_e, ir4plus_c,
pt2plus_s, pt2plus_e, pt2plus_c,
pt4plus_s, pt4plus_e, pt4plus_c,
au1plus_s, au1plus_e, au1plus_c,
au3plus_s, au3plus_e, au3plus_c,
hg1plus_s, hg1plus_e, hg1plus_c,
hg2plus_s, hg2plus_e, hg2plus_c,
tl1plus_s, tl1plus_e, tl1plus_c,
tl3plus_s, tl3plus_e, tl3plus_c,
pb2plus_s, pb2plus_e, pb2plus_c,
pb4plus_s, pb4plus_e, pb4plus_c,
bi3plus_s, bi3plus_e, bi3plus_c,
bi5plus_s, bi5plus_e, bi5plus_c,
ra2plus_s, ra2plus_e, ra2plus_c,
ac3plus_s, ac3plus_e, ac3plus_c,
th4plus_s, th4plus_e, th4plus_c,
u3plus_s, u3plus_e, u3plus_c,
u4plus_s, u4plus_e, u4plus_c,
u6plus_s, u6plus_e, u6plus_c,
np3plus_s, np3plus_e, np3plus_c,
np4plus_s, np4plus_e, np4plus_c,
np6plus_s, np6plus_e, np6plus_c,
pu3plus_s, pu3plus_e, pu3plus_c,
pu4plus_s, pu4plus_e, pu4plus_c,
pu6plus_s, pu6plus_e, pu6plus_c
};
} // namespace <anonymous>

namespace cctbx { namespace eltbx { namespace xray_scattering {
namespace n_gaussian { namespace raw {

  const char*
  get_tag() { return "2011_01_14_2211"; }

  const char**
  get_labels() { return labels; }

  unsigned int
  get_table_size() { return 213U; }

  const entry*
  get_table() { return table; }

}}}}} // namespace cctbx::eltbx::xray_scattering::n_gaussian::raw
