// Copyright 2019 Kevin Gibbons. All rights reserved.
// This code is governed by the BSD license found in the LICENSE file.

/*---
esid: sec-enumerate-object-properties
description: Property enumeration order for simple objects
features: [for-in-order]
includes: [compareArray.js]
---*/

var o = {
  p1: 'p1',
  p2: 'p2',
  p3: 'p3',
};

o.p4 = 'p4';

o[2] = '2';
o[0] = '0';
o[1] = '1';

delete o.p1;
delete o.p3;
o.p1 = 'p1';


var keys = [];
for (var key in o) {
  keys.push(key);
}

assert.compareArray(keys, ['0', '1', '2', 'p2', 'p4', 'p1']);

reportCompare(0, 0);
