/*
 * Decompiled with CFR 0.152.
 */
package rene.zirkel.graphics;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ImageObserver;
import java.io.FileOutputStream;
import java.io.PrintWriter;
import rene.gui.Global;
import rene.zirkel.ZirkelFrame;
import rene.zirkel.construction.Construction;
import rene.zirkel.graphics.MyGraphics;
import rene.zirkel.graphics.PdfFontMetrics;
import rene.zirkel.objects.ConstructionObject;
import rene.zirkel.objects.PointObject;

public class MyGraphicsPDF
extends MyGraphics {
    PrintWriter Out;
    StringBuffer buf;
    StringBuffer xref;
    StringBuffer stream;
    int nxref = 1;
    String prefix = "";
    final int Normal = 0;
    final int Thin = 1;
    final int Thick = 2;
    int Stroke = 0;
    private PdfFontMetrics FM = new PdfFontMetrics(10);
    boolean Bold;
    double W;
    double H;
    double LineWidth;
    Color OldColor = null;
    Color OldFillColor = null;
    public static char[] Translation = new char[]{'a', '\u03b1', 'A', '\u0391', 'b', '\u03b2', 'B', '\u0392', 'c', '\u03b3', 'C', '\u0393', 'd', '\u03b4', 'D', '\u0394', 'e', '\u03b5', 'E', '\u0395', 'f', '\u03d5', 'F', '\u03a6', 'g', '\u03b3', 'G', '\u0393', 'h', '\u03b7', 'H', '\u0397', 'i', '\u03b9', 'I', '\u0399', 'k', '\u03ba', 'K', '\u039a', 'l', '\u03bb', 'L', '\u039b', 'm', '\u03bc', 'M', '\u039c', 'n', '\u03bd', 'N', '\u039d', 'o', '\u03bf', 'O', '\u03a9', 'p', '\u03c0', 'P', '\u03a0', 'q', '\u03c7', 'Q', '\u03a7', 'r', '\u03c1', 'R', '\u03a1', 's', '\u03c3', 'S', '\u03a3', 't', '\u03c4', 'T', '\u03a4', 'u', '\u03c5', 'U', '\u03a5', 'v', '\u03c8', 'V', '\u03a8', 'w', '\u03c9', 'W', '\u03a9', 'x', '\u03be', 'X', '\u039e', 'y', '\u03c7', 'Y', '\u03a7', 'z', '\u03b6', 'Z', '\u0396'};
    int fsize;
    boolean flarge;
    boolean fbold;
    int ffactor = Global.getParameter("ffactor", 130);

    public MyGraphicsPDF(PrintWriter printWriter, double d2, double d3, double d4) {
        this.Out = printWriter;
        this.LineWidth = d4;
        this.W = d2;
        this.H = d3;
        this.buf = new StringBuffer();
        this.xref = new StringBuffer();
        this.appendxref(0, 65535, false);
        this.appendln("%PDF-1.4");
        this.newObject();
        this.appendln("<< /Type /Catalog");
        this.appendln("   /Outlines 2 0 R");
        this.appendln("   /Pages 3 0 R");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Outlines");
        this.appendln("   /Count 0");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Pages");
        this.appendln("   /Kids [4 0 R]");
        this.appendln("   /Count 1");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Page");
        this.appendln("   /Parent 3 0 R");
        this.appendln("   /MediaBox [0 0 " + d2 + " " + d3 + "]");
        this.appendln("   /Contents 5 0 R");
        this.appendln("   /Resources << /ProcSet 6 0 R");
        this.appendln("                 /Font << /F1 7 0 R");
        this.appendln("                          /F2 7 0 R \t\t\t\t\t\t\t\t/F3 7 0 R >>");
        this.appendln("              >>");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.stream = new StringBuffer();
    }

    public void close() {
        this.appendln("<< /Length " + this.stream.length() + " >>");
        this.prefix = "";
        this.appendln("stream");
        this.buf.append(this.stream.toString());
        this.appendln("endstream");
        this.endObject();
        this.newObject();
        this.appendln("[/PDF]");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Font");
        this.appendln("   /Subtype /Type1");
        this.appendln("   /Name /F1");
        this.appendln("   /BaseFont /Helvetica");
        this.appendln("   /Encoding /WinAnsiEncoding");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Font");
        this.appendln("   /Subtype /Type1");
        this.appendln("   /Name /F2");
        this.appendln("   /BaseFont /Symbol");
        this.appendln("   /Encoding /WinAnsiEncoding");
        this.appendln(">>");
        this.endObject();
        this.newObject();
        this.appendln("<< /Type /Font");
        this.appendln("   /Subtype /Type1");
        this.appendln("   /Name /F3");
        this.appendln("   /BaseFont /Helvetica-Bold");
        this.appendln("   /Encoding /WinAnsiEncoding");
        this.appendln(">>");
        this.endObject();
        this.appendln("");
        this.appendln("xref");
        int n = this.buf.length();
        this.appendln("0 " + this.nxref);
        this.buf.append(this.xref.toString());
        this.appendln("");
        this.appendln("trailer");
        this.appendln("<< /Size " + this.nxref);
        this.appendln("   /Root 1 0 R");
        this.appendln(">>");
        this.appendln("");
        this.appendln("startxref");
        this.appendln("" + n);
        this.appendln("");
        this.appendln("%%EOF");
        this.Out.write(this.buf.toString());
    }

    public void appendln(String string) {
        this.buf.append(this.prefix + string);
        this.buf.append('\r');
        this.buf.append('\n');
    }

    public void streamln(String string) {
        this.stream.append(this.prefix + string);
        this.stream.append('\r');
        this.stream.append('\n');
    }

    public void appendxref(int n, int n2, boolean bl) {
        this.xref.append(this.format(n, 10) + " " + this.format(n2, 5) + (bl ? " n" : " f"));
        this.xref.append('\r');
        this.xref.append('\n');
    }

    public String format(int n, int n2) {
        String string = "" + n;
        while (string.length() < n2) {
            string = "0" + string;
        }
        return string;
    }

    public void newObject() {
        int n = this.buf.length();
        this.appendln("");
        this.appendln(this.nxref + " " + 0 + " obj");
        this.appendxref(n, 0, true);
        ++this.nxref;
        this.prefix = "  ";
    }

    public void endObject() {
        this.prefix = "";
        this.appendln("endobj");
    }

    public double r(double d2) {
        return (double)Math.round(d2 * 100.0) / 100.0;
    }

    public double ry(double d2) {
        return (double)Math.round((this.H - d2) * 100.0) / 100.0;
    }

    public void setStroke(int n) {
        if (this.Stroke == n) {
            return;
        }
        this.Stroke = n;
        switch (this.Stroke) {
            case 0: {
                this.streamln(this.r(this.LineWidth) + " w");
                this.streamln("[] 0 d");
                break;
            }
            case 2: {
                this.streamln(this.r(3.0 * this.LineWidth) + " w");
                this.streamln("[] 0 d");
                break;
            }
            case 1: {
                this.streamln(this.LineWidth + " w");
                this.streamln("[" + this.r(3.0 * this.LineWidth) + " " + this.r(3.0 * this.LineWidth) + "] 0 d");
            }
        }
    }

    public void clearRect(int n, int n2, int n3, int n4, Color color) {
    }

    public void setColor(Color color) {
        if (this.OldColor != null && color.getRed() == this.OldColor.getRed() && color.getGreen() == this.OldColor.getGreen() && color.getBlue() == this.OldColor.getBlue()) {
            return;
        }
        this.streamln(this.r((double)color.getRed() / 255.0) + " " + this.r((double)color.getGreen() / 255.0) + " " + this.r((double)color.getBlue() / 255.0) + " rg");
        this.OldColor = color;
    }

    public void setColor(ConstructionObject constructionObject) {
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject.indicated()) {
            this.setColor(ZirkelFrame.IndicateColor);
        } else if (constructionObject.selected()) {
            this.setColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.getColorType() == 2) {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterLightColors[n]);
            } else {
                this.setColor(ZirkelFrame.LightColors[n]);
            }
        } else {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setColor(ZirkelFrame.BrighterColors[n]);
            } else {
                this.setColor(ZirkelFrame.Colors[n]);
            }
        }
        if (constructionObject.getColorType() == 2) {
            this.setStroke(1);
        } else if (constructionObject.getColorType() == 1) {
            this.setStroke(2);
        } else {
            this.setStroke(0);
        }
    }

    public void setFillColor(Color color) {
        if (this.OldFillColor != null && color.getRed() == this.OldFillColor.getRed() && color.getGreen() == this.OldFillColor.getGreen() && color.getBlue() == this.OldFillColor.getBlue()) {
            return;
        }
        this.streamln(this.r((double)color.getRed() / 255.0) + " " + this.r((double)color.getGreen() / 255.0) + " " + this.r((double)color.getBlue() / 255.0) + " rg");
        this.OldFillColor = color;
    }

    public void setFillColor(ConstructionObject constructionObject) {
        this.setStroke(0);
        if (constructionObject.isJobTarget()) {
            this.setColor(ZirkelFrame.TargetColor);
        } else if (constructionObject instanceof PointObject && constructionObject.indicated()) {
            this.setFillColor(ZirkelFrame.IndicateColor);
        } else if (constructionObject.getColorType() != 1) {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setFillColor(ZirkelFrame.BrighterLightColors[n]);
            } else {
                this.setFillColor(ZirkelFrame.LightColors[n]);
            }
        } else {
            int n = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setFillColor(ZirkelFrame.BrighterColors[n]);
            } else {
                this.setFillColor(ZirkelFrame.Colors[n]);
            }
        }
    }

    public void setLabelColor(ConstructionObject constructionObject) {
        if (constructionObject.labelSelected()) {
            this.setFillColor(ZirkelFrame.SelectColor);
        } else if (constructionObject.isFilled()) {
            int n = constructionObject.getColorType();
            constructionObject.setColorType(0);
            int n2 = constructionObject.getColorIndex();
            this.setFillColor(ZirkelFrame.Colors[n2]);
            constructionObject.setColorType(n);
        } else {
            int n = constructionObject.getColorType();
            constructionObject.setColorType(0);
            int n3 = constructionObject.getColorIndex();
            if (constructionObject.isHidden()) {
                this.setFillColor(ZirkelFrame.BrighterColors[n3]);
            } else {
                this.setFillColor(ZirkelFrame.Colors[n3]);
            }
            constructionObject.setColorType(n);
        }
    }

    public void drawRect(double d2, double d3, double d4, double d5) {
        this.streamln(this.r(d2) + " " + this.ry(d3 + d5) + " " + this.r(d4) + " " + this.r(d5) + " " + "re");
        this.streamln("S");
    }

    public void drawLine(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        this.streamln(this.r(d2) + " " + this.ry(d3) + " m");
        this.streamln(this.r(d4) + " " + this.ry(d5) + " l");
        this.streamln("S");
    }

    public void drawLine(double d2, double d3, double d4, double d5) {
        this.setStroke(0);
        this.streamln(this.r(d2) + " " + this.ry(d3) + " m");
        this.streamln(this.r(d4) + " " + this.ry(d5) + " l");
        this.streamln("S");
    }

    public void drawThickLine(double d2, double d3, double d4, double d5) {
        this.setStroke(2);
        this.streamln(this.r(d2) + " " + this.ry(d3) + " m");
        this.streamln(this.r(d4) + " " + this.ry(d5) + " l");
        this.streamln("S");
        this.setStroke(0);
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6) {
        double d7 = d4 / Math.cos(d6 / 3.0);
        this.streamln(this.r(d2 + Math.cos(d5 + d6 / 3.0) * d7) + " " + this.ry(d3 - Math.sin(d5 + d6 / 3.0) * d7) + " " + this.r(d2 + Math.cos(d5 + 2.0 * d6 / 3.0) * d7) + " " + this.ry(d3 - Math.sin(d5 + 2.0 * d6 / 3.0) * d7) + " " + this.r(d2 + Math.cos(d5 + d6) * d4) + " " + this.ry(d3 - Math.sin(d5 + d6) * d4) + " c");
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7) {
        this.setStroke(0);
        double d8 = d4 / 2.0;
        d2 += d8;
        d3 += d8;
        d6 = d6 / 180.0 * Math.PI;
        d7 = d7 / 180.0 * Math.PI;
        int n = (int)(d8 * d7 / 10.0);
        if (n < 4) {
            n = 4;
        }
        this.streamln(this.r(d2 + Math.cos(d6) * d8) + " " + this.ry(d3 - Math.sin(d6) * d8) + " m");
        for (int i = 0; i < n; ++i) {
            this.drawArc(d2, d3, d8, d6 + (double)i * d7 / (double)n, d7 / (double)n);
        }
        this.streamln("S");
    }

    public void drawArc(double d2, double d3, double d4, double d5, double d6, double d7, ConstructionObject constructionObject) {
        double d8 = d4 / 2.0;
        d2 += d8;
        d3 += d8;
        d6 = d6 / 180.0 * Math.PI;
        int n = (int)(d8 * (d7 = d7 / 180.0 * Math.PI) / 10.0);
        if (n < 4) {
            n = 4;
        }
        this.streamln(this.r(d2 + Math.cos(d6) * d8) + " " + this.ry(d3 + -Math.sin(d6) * d8) + " m");
        for (int i = 0; i < n; ++i) {
            this.drawArc(d2, d3, d8, d6 + (double)i * d7 / (double)n, d7 / (double)n);
        }
        this.streamln("S");
    }

    public void setFont(int n, boolean bl) {
        this.Bold = bl;
        this.FM = new PdfFontMetrics(n);
        this.streamln("/F1 " + n + " Tf");
    }

    public FontMetrics getFontMetrics() {
        if (this.FM == null) {
            this.FM = new PdfFontMetrics(20);
        }
        return this.FM;
    }

    public void drawString(String string, double d2, double d3) {
        if (string.length() == 1) {
            char c2 = string.charAt(0);
            for (int i = 0; i < Translation.length / 2; ++i) {
                if (Translation[2 * i + 1] != c2) continue;
                this.streamln("BT");
                this.streamln("/F2 " + this.FM.Size + " Tf");
                this.streamln(this.r(d2) + " " + this.ry(d3) + " Td");
                this.streamln("(" + Translation[2 * i] + ") Tj");
                this.streamln("ET");
                return;
            }
        }
        this.streamln("BT");
        if (this.Bold) {
            this.streamln("/F3 " + this.FM.Size + " Tf");
        } else {
            this.streamln("/F1 " + this.FM.Size + " Tf");
        }
        this.streamln(this.r(d2) + " " + this.ry(d3) + " Td");
        this.streamln("(" + string + ") Tj");
        this.streamln("ET");
    }

    public void drawOval(double d2, double d3, double d4, double d5) {
        this.drawArc(d2, d3, d4, d5, 0.0, 360.0);
    }

    public void drawOval(double d2, double d3, double d4, double d5, ConstructionObject constructionObject) {
        this.drawArc(d2, d3, d4, d5, 0.0, 360.0, constructionObject);
    }

    public void fillRect(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.setFillColor(constructionObject);
        if (bl) {
            this.setColor(constructionObject);
        }
        this.streamln(this.r(d2) + " " + this.ry(d3 + d5) + " " + this.r(d4) + " " + this.r(d5) + " " + "re");
        this.streamln(bl ? "b" : "f");
    }

    public void fillOval(double d2, double d3, double d4, double d5, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.fillArc(d2, d3, d4, d5, 0.0, 360.0, bl, bl2, true, constructionObject);
    }

    public void fillPolygon(double[] dArray, double[] dArray2, int n, boolean bl, boolean bl2, ConstructionObject constructionObject) {
        this.setFillColor(constructionObject);
        if (bl) {
            this.setColor(constructionObject);
        }
        this.streamln(this.r(dArray[0]) + " " + this.ry(dArray2[0]) + " m");
        for (int i = 1; i < n; ++i) {
            this.streamln(this.r(dArray[i]) + " " + this.ry(dArray2[i]) + " l");
        }
        this.streamln(bl ? "b*" : "f*");
    }

    public void fillArc(double d2, double d3, double d4, double d5, double d6, double d7, boolean bl, boolean bl2, boolean bl3, ConstructionObject constructionObject) {
        this.setFillColor(constructionObject);
        if (bl) {
            this.setColor(constructionObject);
        }
        double d8 = d4 / 2.0;
        d2 += d8;
        d3 += d8;
        d6 = d6 * Math.PI / 180.0;
        int n = (int)(d8 * (d7 = d7 * Math.PI / 180.0) / 10.0);
        if (n < 4) {
            n = 4;
        }
        this.streamln(this.r(d2 + Math.cos(d6) * d8) + " " + this.ry(d3 - Math.sin(d6) * d8) + " m");
        for (int i = 0; i < n; ++i) {
            this.drawArc(d2, d3, d8, d6 + (double)i * d7 / (double)n, d7 / (double)n);
        }
        if (bl3) {
            this.streamln(this.r(d2) + " " + this.ry(d3) + " l");
        }
        this.streamln(bl ? "b" : "f");
    }

    public void drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
    }

    public void drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
    }

    public static void main(String[] stringArray) {
        try {
            ConstructionObject constructionObject = new ConstructionObject(new Construction());
            PrintWriter printWriter = new PrintWriter(new FileOutputStream("test.pdf"));
            MyGraphicsPDF myGraphicsPDF = new MyGraphicsPDF(printWriter, 1000.0, 1000.0, 1.0);
            myGraphicsPDF.streamln("1 0 0 -1 0 1000 cm");
            myGraphicsPDF.drawRect(300.0, 300.0, 400.0, 400.0);
            for (int i = 0; i < 180; ++i) {
                double d2 = (double)i / 180.0 * Math.PI;
                double d3 = (double)(i + 1) / 180.0 * Math.PI;
                myGraphicsPDF.drawLine(500.0 + Math.cos(d2) * 200.0, 500.0 + Math.sin(d2) * 200.0, 500.0 + Math.cos(d2) * 200.0, 500.0 + Math.sin(d2) * 200.0);
            }
            myGraphicsPDF.setColor(Color.red);
            myGraphicsPDF.drawArc(-300.0, -300.0, 1000.0, 1000.0, 0.0, 360.0);
            myGraphicsPDF.close();
            printWriter.close();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void setDefaultFont(int n, boolean bl, boolean bl2) {
        this.fsize = n;
        this.flarge = bl;
        this.fbold = bl2;
        this.ffactor = Global.getParameter("ffactor", 130);
        this.setFont(bl, bl2);
    }

    public void setFont(boolean bl, boolean bl2) {
        int n = this.fsize;
        if (bl) {
            n = n * this.ffactor / 100;
        }
        if (this.flarge) {
            n = n * this.ffactor / 100;
        }
        this.setFont(n, bl2 || this.fbold);
    }

    public void drawImage(Image image, double d2, double d3, double d4, double d5, double d6, double d7, ImageObserver imageObserver) {
    }

    public Graphics getGraphics() {
        return null;
    }

    public int stringWidth(String string) {
        return this.getFontMetrics().stringWidth(string);
    }

    public int stringHeight(String string) {
        return this.getFontMetrics().getHeight();
    }

    public int drawStringExtended(String string, double d2, double d3) {
        this.drawString(string, d2, d3 + (double)this.getFontMetrics().getAscent());
        return this.getFontMetrics().getHeight();
    }

    public int stringAscent(String string) {
        return this.getFontMetrics().getAscent();
    }
}

