// GENERATED FILE - DO NOT EDIT.
// Generated by gen_vk_format_table.py using data from vk_format_map.json
//
// Copyright 2020 The ANGLE Project Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.
//
// vk_format_table_autogen.cpp:
//   Queries for full Vulkan format information based on GL format.

#include "libANGLE/renderer/vulkan/vk_format_utils.h"

#include "image_util/loadimage.h"

using namespace angle;

namespace rx
{
namespace vk
{

void Format::initialize(Renderer *renderer, const angle::Format &angleFormat)
{
    switch (angleFormat.id)
    {
        case angle::FormatID::A16_FLOAT:
            mIntendedGLFormat              = GL_ALPHA16F_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16_FLOAT;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::A1R5G5B5_UNORM:
            mIntendedGLFormat              = GL_A1RGB5_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::A1R5G5B5_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::A1R5G5B5_UNORM;
            mVkBufferFormatIsPacked        = true;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::A2R10G10B10_SINT_VERTEX:
            mIntendedGLFormat              = GL_INT_10_10_10_2_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyW2XYZ10ToXYZWFloatVertexData<true, false, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::A2R10G10B10_SNORM_VERTEX:
            mIntendedGLFormat              = GL_A2_RGB10_SNORM_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyW2XYZ10ToXYZWFloatVertexData<true, true, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::A2R10G10B10_SSCALED_VERTEX:
            mIntendedGLFormat              = GL_A2_RGB10_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyW2XYZ10ToXYZWFloatVertexData<true, false, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::A2R10G10B10_UINT_VERTEX:
            mIntendedGLFormat              = GL_UNSIGNED_INT_10_10_10_2_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyW2XYZ10ToXYZWFloatVertexData<false, false, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::A2R10G10B10_UNORM_VERTEX:
            mIntendedGLFormat              = GL_A2_RGB10_UNORM_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyW2XYZ10ToXYZWFloatVertexData<false, true, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::A2R10G10B10_USCALED_VERTEX:
            mIntendedGLFormat              = GL_A2_RGB10_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyW2XYZ10ToXYZWFloatVertexData<false, false, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::A32_FLOAT:
            mIntendedGLFormat              = GL_ALPHA32F_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32_FLOAT;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::A8_UNORM:
            mIntendedGLFormat              = GL_ALPHA8_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::ASTC_10x10_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x10_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x10_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_10x10_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x10_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_10x10_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x10_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_10x10_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x5_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x5_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_10x5_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x5_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_10x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x5_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_10x5_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x6_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x6_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_10x6_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x6_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_10x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x6_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_10x6_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x8_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_10x8_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x8_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_10x8_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_10x8_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_10x8_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_10x8_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_10x8_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_12x10_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x10_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_12x10_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_12x10_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_12x10_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_12x10_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_12x10_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_12x10_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_12x12_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_12x12_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_12x12_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_12x12_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_12x12_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_12x12_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_12x12_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_12x12_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_3x3x3_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_3x3x3_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x3x3_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x3x3_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x4_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_4x4_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_4x4_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_4x4_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_4x4_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_4x4_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_4x4_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_4x4_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_4x4x3_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x4x3_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x4x4_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_4x4x4_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x4_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x4_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_5x4_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_5x4_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_5x4_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_5x4_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_5x4_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_5x4_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_5x4x4_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x4x4_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x5_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_5x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_5x5_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_5x5_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_5x5_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_5x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_5x5_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_5x5_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_5x5x4_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x5x4_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x5x5_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_5x5x5_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x5_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_6x5_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_6x5_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_6x5_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_6x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_6x5_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_6x5_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_6x5x5_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x5x5_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x6_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_6x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_6x6_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_6x6_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_6x6_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_6x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_6x6_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_6x6_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_6x6x5_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x6x5_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x6x6_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_6x6x6_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ASTC_8x5_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x5_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_8x5_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x5_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_8x5_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x5_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_8x5_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x6_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x6_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_8x6_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x6_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_8x6_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x6_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_8x6_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x8_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ASTC_8x8_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x8_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_8x8_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ASTC_8x8_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA_ASTC_8x8_KHR;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ASTC_8x8_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ASTC_8x8_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::B10G10R10A2_UNORM:
            mIntendedGLFormat              = GL_BGR10_A2_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::B10G10R10A2_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::B10G10R10A2_UNORM;
            mVkBufferFormatIsPacked        = true;
            mVertexLoadFunction            = CopyNativeVertexData<GLuint, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::B4G4R4A4_UNORM:
            mIntendedGLFormat              = GL_BGRA4_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::B4G4R4A4_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::B4G4R4A4_UNORM;
            mVkBufferFormatIsPacked        = true;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::B5G5R5A1_UNORM:
            mIntendedGLFormat              = GL_BGR5_A1_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::B5G5R5A1_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::B5G5R5A1_UNORM;
            mVkBufferFormatIsPacked        = true;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::B5G6R5_UNORM:
            mIntendedGLFormat              = GL_BGR565_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::B5G6R5_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::B5G6R5_UNORM;
            mVkBufferFormatIsPacked        = true;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::B8G8R8A8_TYPELESS:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::B8G8R8A8_TYPELESS_SRGB:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::B8G8R8A8_UNORM:
            mIntendedGLFormat              = GL_BGRA8_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::B8G8R8A8_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::B8G8R8A8_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::B8G8R8A8_UNORM_SRGB:
            mIntendedGLFormat              = GL_BGRA8_SRGB_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::B8G8R8A8_UNORM_SRGB;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::B8G8R8A8_UNORM_SRGB;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::B8G8R8X8_UNORM:
            mIntendedGLFormat              = GL_BGRX8_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::B8G8R8A8_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::NONE;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::B8G8R8X8_UNORM_SRGB:
            mIntendedGLFormat              = GL_BGRX8_SRGB_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::B8G8R8A8_UNORM_SRGB;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::NONE;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::BC1_RGBA_UNORM_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_RGBA_S3TC_DXT1_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC1_RGBA_UNORM_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC1_RGBA_UNORM_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC1_RGB_UNORM_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_RGB_S3TC_DXT1_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC1_RGB_UNORM_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC1_RGB_UNORM_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC1_RGB_UNORM_SRGB_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_SRGB_S3TC_DXT1_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC1_RGB_UNORM_SRGB_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC1_RGB_UNORM_SRGB_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC2_RGBA_UNORM_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_RGBA_S3TC_DXT3_ANGLE;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC2_RGBA_UNORM_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC2_RGBA_UNORM_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC3_RGBA_UNORM_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_RGBA_S3TC_DXT5_ANGLE;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC3_RGBA_UNORM_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC3_RGBA_UNORM_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC4_RED_SNORM_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_SIGNED_RED_RGTC1_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC4_RED_SNORM_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC4_RED_SNORM_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC4_RED_UNORM_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_RED_RGTC1_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC4_RED_UNORM_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC4_RED_UNORM_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC5_RG_SNORM_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC5_RG_SNORM_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC5_RG_SNORM_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC5_RG_UNORM_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_RED_GREEN_RGTC2_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC5_RG_UNORM_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC5_RG_UNORM_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC6H_RGB_SFLOAT_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_RGB_BPTC_SIGNED_FLOAT_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC6H_RGB_SFLOAT_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC6H_RGB_SFLOAT_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC6H_RGB_UFLOAT_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_RGB_BPTC_UNSIGNED_FLOAT_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC6H_RGB_UFLOAT_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC6H_RGB_UFLOAT_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC7_RGBA_UNORM_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_RGBA_BPTC_UNORM_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC7_RGBA_UNORM_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC7_RGBA_UNORM_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::BC7_RGBA_UNORM_SRGB_BLOCK:
            mIntendedGLFormat              = GL_COMPRESSED_SRGB_ALPHA_BPTC_UNORM_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::BC7_RGBA_UNORM_SRGB_BLOCK;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::BC7_RGBA_UNORM_SRGB_BLOCK;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::D16_UNORM:
            mIntendedGLFormat              = GL_DEPTH_COMPONENT16;
            mActualSampleOnlyImageFormatID = angle::FormatID::D16_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::D16_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::D24_UNORM_S8_UINT:
            mIntendedGLFormat = GL_DEPTH24_STENCIL8;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::D24_UNORM_S8_UINT, nullptr},
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::D24_UNORM_S8_UINT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::D24_UNORM_X8_UINT:
            mIntendedGLFormat = GL_DEPTH_COMPONENT24;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::D24_UNORM_X8_UINT, nullptr},
                    {angle::FormatID::D24_UNORM_S8_UINT, nullptr},
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::D24_UNORM_X8_UINT;
            mVkBufferFormatIsPacked       = true;
            mVertexLoadFunction           = CopyNativeVertexData<GLuint, 1, 1, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::D32_FLOAT:
            mIntendedGLFormat              = GL_DEPTH_COMPONENT32F;
            mActualSampleOnlyImageFormatID = angle::FormatID::D32_FLOAT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::D32_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLfloat, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::D32_FLOAT_S8X24_UINT:
            mIntendedGLFormat = GL_DEPTH32F_STENCIL8;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, nullptr},
                    {angle::FormatID::D24_UNORM_S8_UINT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::D32_FLOAT_S8X24_UINT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLfloat, 3, 3, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::D32_UNORM:
            mIntendedGLFormat = GL_DEPTH_COMPONENT32_OES;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::D24_UNORM_X8_UINT, nullptr},
                    {angle::FormatID::D24_UNORM_S8_UINT, nullptr},
                    {angle::FormatID::D32_FLOAT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::NONE;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::EAC_R11G11_SNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SIGNED_RG11_EAC;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::EAC_R11G11_SNORM_BLOCK, nullptr},
                    {angle::FormatID::R16G16_SNORM, nullptr},
                    {angle::FormatID::R16G16_FLOAT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::EAC_R11G11_SNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EAC_R11G11_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RG11_EAC;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::EAC_R11G11_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R16G16_UNORM, nullptr},
                    {angle::FormatID::R16G16_FLOAT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::EAC_R11G11_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EAC_R11_SNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SIGNED_R11_EAC;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::EAC_R11_SNORM_BLOCK, nullptr},
                    {angle::FormatID::R16_SNORM, nullptr},
                    {angle::FormatID::R16_FLOAT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::EAC_R11_SNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EAC_R11_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_R11_EAC;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::EAC_R11_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R16_UNORM, nullptr},
                    {angle::FormatID::R16_FLOAT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::EAC_R11_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC1_LOSSY_DECODE_R8G8B8_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::ETC1_R8G8B8_UNORM_BLOCK:
            mIntendedGLFormat = GL_ETC1_RGB8_OES;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM,
                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::NONE;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_PUNCHTHROUGH_ALPHA1_ETC2;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB,
                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGB8_PUNCHTHROUGH_ALPHA1_ETC2;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM,
                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ALPHA8_ETC2_EAC;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGBA8_ETC2_EAC;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_SRGB8_ETC2;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB,
                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLbyte, 3, 3, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK:
            mIntendedGLFormat = GL_COMPRESSED_RGB8_ETC2;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM,
                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLubyte, 3, 3, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::EXTERNAL0:
            mIntendedGLFormat              = GL_NONE;
            mActualSampleOnlyImageFormatID = angle::FormatID::EXTERNAL0;
            mActualRenderableImageFormatID = angle::FormatID::EXTERNAL0;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::EXTERNAL0;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::EXTERNAL1:
            mIntendedGLFormat              = GL_NONE;
            mActualSampleOnlyImageFormatID = angle::FormatID::EXTERNAL1;
            mActualRenderableImageFormatID = angle::FormatID::EXTERNAL1;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::EXTERNAL1;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::EXTERNAL2:
            mIntendedGLFormat              = GL_NONE;
            mActualSampleOnlyImageFormatID = angle::FormatID::EXTERNAL2;
            mActualRenderableImageFormatID = angle::FormatID::EXTERNAL2;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::EXTERNAL2;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::EXTERNAL3:
            mIntendedGLFormat              = GL_NONE;
            mActualSampleOnlyImageFormatID = angle::FormatID::EXTERNAL3;
            mActualRenderableImageFormatID = angle::FormatID::EXTERNAL3;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::EXTERNAL3;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::EXTERNAL4:
            mIntendedGLFormat              = GL_NONE;
            mActualSampleOnlyImageFormatID = angle::FormatID::EXTERNAL4;
            mActualRenderableImageFormatID = angle::FormatID::EXTERNAL4;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::EXTERNAL4;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::EXTERNAL5:
            mIntendedGLFormat              = GL_NONE;
            mActualSampleOnlyImageFormatID = angle::FormatID::EXTERNAL5;
            mActualRenderableImageFormatID = angle::FormatID::EXTERNAL5;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::EXTERNAL5;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::EXTERNAL6:
            mIntendedGLFormat              = GL_NONE;
            mActualSampleOnlyImageFormatID = angle::FormatID::EXTERNAL6;
            mActualRenderableImageFormatID = angle::FormatID::EXTERNAL6;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::EXTERNAL6;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::EXTERNAL7:
            mIntendedGLFormat              = GL_NONE;
            mActualSampleOnlyImageFormatID = angle::FormatID::EXTERNAL7;
            mActualRenderableImageFormatID = angle::FormatID::EXTERNAL7;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::EXTERNAL7;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::G8_B8R8_2PLANE_420_UNORM:
            mIntendedGLFormat              = GL_G8_B8R8_2PLANE_420_UNORM_ANGLE;
            mActualSampleOnlyImageFormatID = angle::FormatID::G8_B8R8_2PLANE_420_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::G8_B8R8_2PLANE_420_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 3, 3, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::G8_B8_R8_3PLANE_420_UNORM:
            mIntendedGLFormat              = GL_G8_B8_R8_3PLANE_420_UNORM_ANGLE;
            mActualSampleOnlyImageFormatID = angle::FormatID::G8_B8_R8_3PLANE_420_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::G8_B8_R8_3PLANE_420_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 3, 3, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::L16A16_FLOAT:
            mIntendedGLFormat              = GL_LUMINANCE_ALPHA16F_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16_FLOAT;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::L16_FLOAT:
            mIntendedGLFormat              = GL_LUMINANCE16F_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16_FLOAT;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::L32A32_FLOAT:
            mIntendedGLFormat              = GL_LUMINANCE_ALPHA32F_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32G32_FLOAT;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::L32_FLOAT:
            mIntendedGLFormat              = GL_LUMINANCE32F_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32_FLOAT;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::L4A4_UNORM:
            mIntendedGLFormat              = GL_LUMINANCE4_ALPHA4_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::L8A8_UNORM:
            mIntendedGLFormat              = GL_LUMINANCE8_ALPHA8_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::L8_UNORM:
            mIntendedGLFormat              = GL_LUMINANCE8_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::NONE:
            mIntendedGLFormat              = GL_NONE;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::NONE;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::PALETTE4_R4G4B4A4_UNORM:
            mIntendedGLFormat              = GL_PALETTE4_RGBA4_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PALETTE4_R5G5B5A1_UNORM:
            mIntendedGLFormat              = GL_PALETTE4_RGB5_A1_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PALETTE4_R5G6B5_UNORM:
            mIntendedGLFormat              = GL_PALETTE4_R5_G6_B5_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PALETTE4_R8G8B8A8_UNORM:
            mIntendedGLFormat              = GL_PALETTE4_RGBA8_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PALETTE4_R8G8B8_UNORM:
            mIntendedGLFormat              = GL_PALETTE4_RGB8_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PALETTE8_R4G4B4A4_UNORM:
            mIntendedGLFormat              = GL_PALETTE8_RGBA4_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PALETTE8_R5G5B5A1_UNORM:
            mIntendedGLFormat              = GL_PALETTE8_RGB5_A1_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PALETTE8_R5G6B5_UNORM:
            mIntendedGLFormat              = GL_PALETTE8_R5_G6_B5_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PALETTE8_R8G8B8A8_UNORM:
            mIntendedGLFormat              = GL_PALETTE8_RGBA8_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PALETTE8_R8G8B8_UNORM:
            mIntendedGLFormat              = GL_PALETTE8_RGB8_OES;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;

            break;

        case angle::FormatID::PVRTC1_RGBA_2BPP_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::PVRTC1_RGBA_2BPP_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::PVRTC1_RGBA_4BPP_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::PVRTC1_RGBA_4BPP_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::PVRTC1_RGB_2BPP_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::PVRTC1_RGB_2BPP_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::PVRTC1_RGB_4BPP_UNORM_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::PVRTC1_RGB_4BPP_UNORM_SRGB_BLOCK:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::R10G10B10A2_SINT:
            mIntendedGLFormat              = GL_RGB10_A2_SINT_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R10G10B10A2_SINT;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R10G10B10A2_SINT, true, CopyNativeVertexData<GLuint, 1, 1, 0>,
                     false},
                    {angle::FormatID::R16G16B16A16_SINT, false,
                     CopyXYZ10W2ToXYZWFloatVertexData<true, false, false, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R10G10B10A2_SNORM:
            mIntendedGLFormat              = GL_RGB10_A2_SNORM_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R10G10B10A2_SNORM;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R10G10B10A2_SNORM, true,
                     CopyNativeVertexData<GLuint, 1, 1, 0>, false},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyXYZ10W2ToXYZWFloatVertexData<true, true, true, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R10G10B10A2_SSCALED:
            mIntendedGLFormat              = GL_RGB10_A2_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R10G10B10A2_SSCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R10G10B10A2_SSCALED, true,
                     CopyNativeVertexData<GLuint, 1, 1, 0>, false},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyXYZ10W2ToXYZWFloatVertexData<true, false, true, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R10G10B10A2_UINT:
            mIntendedGLFormat              = GL_RGB10_A2UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R10G10B10A2_UINT;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R10G10B10A2_UINT, true, CopyNativeVertexData<GLuint, 1, 1, 0>,
                     false},
                    {angle::FormatID::R16G16B16A16_UINT, false,
                     CopyXYZ10W2ToXYZWFloatVertexData<false, false, false, false>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R10G10B10A2_UNORM:
            mIntendedGLFormat              = GL_RGB10_A2;
            mActualSampleOnlyImageFormatID = angle::FormatID::R10G10B10A2_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R10G10B10A2_UNORM;
            mVkBufferFormatIsPacked        = true;
            mVertexLoadFunction            = CopyNativeVertexData<GLuint, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R10G10B10A2_USCALED:
            mIntendedGLFormat              = GL_RGB10_A2_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R10G10B10A2_USCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R10G10B10A2_USCALED, true,
                     CopyNativeVertexData<GLuint, 1, 1, 0>, false},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyXYZ10W2ToXYZWFloatVertexData<false, false, true, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R10G10B10X2_UNORM:
            mIntendedGLFormat              = GL_RGB10_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R10G10B10A2_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::NONE;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::R11G11B10_FLOAT:
            mIntendedGLFormat              = GL_R11F_G11F_B10F;
            mActualSampleOnlyImageFormatID = angle::FormatID::R11G11B10_FLOAT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R11G11B10_FLOAT;
            mVkBufferFormatIsPacked        = true;
            mVertexLoadFunction            = CopyNativeVertexData<GLuint, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16B16A16_FLOAT:
            mIntendedGLFormat              = GL_RGBA16F;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16B16A16_FLOAT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLhalf, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16B16A16_SINT:
            mIntendedGLFormat              = GL_RGBA16I;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16B16A16_SINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_SINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLshort, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16B16A16_SNORM:
            mIntendedGLFormat              = GL_RGBA16_SNORM_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16B16A16_SNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_SNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLshort, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16B16A16_SSCALED:
            mIntendedGLFormat              = GL_RGBA16_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16B16A16_SSCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16A16_SSCALED, false,
                     CopyNativeVertexData<GLshort, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 4, 4, false, false>, true},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 4, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R16G16B16A16_UINT:
            mIntendedGLFormat              = GL_RGBA16UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16B16A16_UINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_UINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16B16A16_UNORM:
            mIntendedGLFormat              = GL_RGBA16_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16B16A16_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16B16A16_USCALED:
            mIntendedGLFormat              = GL_RGBA16_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16B16A16_USCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16A16_USCALED, false,
                     CopyNativeVertexData<GLushort, 4, 4, 0>, false},
                    {angle::FormatID::R32G32B32A32_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 4, 4, false, false>, true},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 4, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R16G16B16_FLOAT:
            mIntendedGLFormat = GL_RGB16F;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_FLOAT, nullptr},
                    {angle::FormatID::R16G16B16A16_FLOAT,
                     Initialize4ComponentData<GLhalf, 0x0000, 0x0000, 0x0000, gl::Float16One>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_FLOAT, false, CopyNativeVertexData<GLhalf, 3, 3, 0>,
                     false},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyNativeVertexData<GLhalf, 3, 4, gl::Float16One>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R16G16B16_SINT:
            mIntendedGLFormat = GL_RGB16I;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_SINT, nullptr},
                    {angle::FormatID::R16G16B16A16_SINT,
                     Initialize4ComponentData<GLshort, 0x0000, 0x0000, 0x0000, 0x0001>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_SINT, false, CopyNativeVertexData<GLshort, 3, 3, 0>,
                     false},
                    {angle::FormatID::R16G16B16A16_SINT, false,
                     CopyNativeVertexData<GLshort, 3, 4, 1>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R16G16B16_SNORM:
            mIntendedGLFormat = GL_RGB16_SNORM_EXT;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_SNORM, nullptr},
                    {angle::FormatID::R16G16B16A16_SNORM,
                     Initialize4ComponentData<GLushort, 0x0000, 0x0000, 0x0000, 0x7FFF>},
                    {angle::FormatID::R32G32B32_FLOAT, nullptr},
                    {angle::FormatID::R32G32B32A32_FLOAT,
                     Initialize4ComponentData<GLfloat, 0x00000000, 0x00000000, 0x00000000,
                                              gl::Float32One>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_SNORM, false,
                     CopyNativeVertexData<GLshort, 3, 3, 0>, false},
                    {angle::FormatID::R16G16B16A16_SNORM, false,
                     CopyNativeVertexData<GLshort, 3, 4, std::numeric_limits<GLshort>::max()>,
                     true},
                    {angle::FormatID::R32G32B32_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 3, 3, true, false>, true},
                    {angle::FormatID::R16G16B16_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 3, 3, true, true>, true},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 3, 4, true, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 3);
            }
            break;

        case angle::FormatID::R16G16B16_SSCALED:
            mIntendedGLFormat              = GL_RGB16_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16B16_SSCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_SSCALED, false,
                     CopyNativeVertexData<GLshort, 3, 3, 0>, false},
                    {angle::FormatID::R16G16B16A16_SSCALED, false,
                     CopyNativeVertexData<GLshort, 3, 4, 1>, true},
                    {angle::FormatID::R32G32B32_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 3, 3, false, false>, true},
                    {angle::FormatID::R16G16B16_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 3, 3, false, true>, true},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 3, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 3);
            }
            break;

        case angle::FormatID::R16G16B16_UINT:
            mIntendedGLFormat = GL_RGB16UI;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_UINT, nullptr},
                    {angle::FormatID::R16G16B16A16_UINT,
                     Initialize4ComponentData<GLushort, 0x0000, 0x0000, 0x0000, 0x0001>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_UINT, false,
                     CopyNativeVertexData<GLushort, 3, 3, 0>, false},
                    {angle::FormatID::R16G16B16A16_UINT, false,
                     CopyNativeVertexData<GLushort, 3, 4, 1>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R16G16B16_UNORM:
            mIntendedGLFormat = GL_RGB16_EXT;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_UNORM, nullptr},
                    {angle::FormatID::R16G16B16A16_UNORM,
                     Initialize4ComponentData<GLushort, 0x0000, 0x0000, 0x0000, 0xFFFF>},
                    {angle::FormatID::R32G32B32_FLOAT, nullptr},
                    {angle::FormatID::R32G32B32A32_FLOAT,
                     Initialize4ComponentData<GLfloat, 0x00000000, 0x00000000, 0x00000000,
                                              gl::Float32One>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_UNORM, false,
                     CopyNativeVertexData<GLushort, 3, 3, 0>, false},
                    {angle::FormatID::R16G16B16A16_UNORM, false,
                     CopyNativeVertexData<GLushort, 3, 4, std::numeric_limits<GLushort>::max()>,
                     true},
                    {angle::FormatID::R32G32B32_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 3, 3, true, false>, true},
                    {angle::FormatID::R16G16B16_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 3, 3, true, true>, true},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 3, 4, true, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 3);
            }
            break;

        case angle::FormatID::R16G16B16_USCALED:
            mIntendedGLFormat              = GL_RGB16_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16B16_USCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16B16_USCALED, false,
                     CopyNativeVertexData<GLushort, 3, 3, 0>, false},
                    {angle::FormatID::R16G16B16A16_USCALED, false,
                     CopyNativeVertexData<GLushort, 3, 4, 1>, true},
                    {angle::FormatID::R32G32B32_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 3, 3, false, false>, true},
                    {angle::FormatID::R16G16B16_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 3, 3, false, true>, true},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 3, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 3);
            }
            break;

        case angle::FormatID::R16G16_FLOAT:
            mIntendedGLFormat              = GL_RG16F;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16_FLOAT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLhalf, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16_SINT:
            mIntendedGLFormat              = GL_RG16I;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16_SINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16_SINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLshort, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16_SNORM:
            mIntendedGLFormat              = GL_RG16_SNORM_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16_SNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16_SNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLshort, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16_SSCALED:
            mIntendedGLFormat              = GL_RG16_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16_SSCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16_SSCALED, false, CopyNativeVertexData<GLshort, 2, 2, 0>,
                     false},
                    {angle::FormatID::R16G16B16_SSCALED, false,
                     CopyNativeVertexData<GLshort, 2, 3, 0>, true},
                    {angle::FormatID::R32G32_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 2, 2, false, false>, true},
                    {angle::FormatID::R16G16_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 2, 2, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 3);
            }
            break;

        case angle::FormatID::R16G16_UINT:
            mIntendedGLFormat              = GL_RG16UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16_UINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16_UINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16_UNORM:
            mIntendedGLFormat              = GL_RG16_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16G16_USCALED:
            mIntendedGLFormat              = GL_RG16_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16G16_USCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16G16_USCALED, false,
                     CopyNativeVertexData<GLushort, 2, 2, 0>, false},
                    {angle::FormatID::R16G16B16_USCALED, false,
                     CopyNativeVertexData<GLushort, 2, 3, 0>, true},
                    {angle::FormatID::R32G32_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 2, 2, false, false>, true},
                    {angle::FormatID::R16G16_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 2, 2, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 3);
            }
            break;

        case angle::FormatID::R16_FLOAT:
            mIntendedGLFormat              = GL_R16F;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16_FLOAT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLhalf, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16_SINT:
            mIntendedGLFormat              = GL_R16I;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16_SINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16_SINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLshort, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16_SNORM:
            mIntendedGLFormat              = GL_R16_SNORM_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16_SNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16_SNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLshort, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16_SSCALED:
            mIntendedGLFormat              = GL_R16_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16_SSCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16_SSCALED, false, CopyNativeVertexData<GLshort, 1, 1, 0>,
                     false},
                    {angle::FormatID::R32_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 1, 1, false, false>, true},
                    {angle::FormatID::R16_FLOAT, false,
                     CopyToFloatVertexData<GLshort, 1, 1, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R16_UINT:
            mIntendedGLFormat              = GL_R16UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16_UINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16_UINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16_UNORM:
            mIntendedGLFormat              = GL_R16_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R16_USCALED:
            mIntendedGLFormat              = GL_R16_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R16_USCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R16_USCALED, false, CopyNativeVertexData<GLushort, 1, 1, 0>,
                     false},
                    {angle::FormatID::R32_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 1, 1, false, false>, true},
                    {angle::FormatID::R16_FLOAT, false,
                     CopyToFloatVertexData<GLushort, 1, 1, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R32G32B32A32_FIXED:
            mIntendedGLFormat = GL_RGBA32_FIXED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = Copy32FixedTo32FVertexData<4, 4>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_FLOAT:
            mIntendedGLFormat              = GL_RGBA32F;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32G32B32A32_FLOAT;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32B32A32_FLOAT, false,
                     CopyNativeVertexData<GLfloat, 4, 4, 0>, false},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLfloat, 4, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 1);
            }
            break;

        case angle::FormatID::R32G32B32A32_SINT:
            mIntendedGLFormat              = GL_RGBA32I;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32G32B32A32_SINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R32G32B32A32_SINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLint, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R32G32B32A32_SNORM:
            mIntendedGLFormat = GL_RGBA32_SNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 4, 4, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_SSCALED:
            mIntendedGLFormat = GL_RGBA32_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 4, 4, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_UINT:
            mIntendedGLFormat              = GL_RGBA32UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32G32B32A32_UINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R32G32B32A32_UINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLuint, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R32G32B32A32_UNORM:
            mIntendedGLFormat = GL_RGBA32_UNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 4, 4, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32A32_USCALED:
            mIntendedGLFormat = GL_RGBA32_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32A32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 4, 4, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_FIXED:
            mIntendedGLFormat = GL_RGB32_FIXED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = Copy32FixedTo32FVertexData<3, 3>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_FLOAT:
            mIntendedGLFormat = GL_RGB32F;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32B32_FLOAT, nullptr},
                    {angle::FormatID::R32G32B32A32_FLOAT,
                     Initialize4ComponentData<GLfloat, 0x00000000, 0x00000000, 0x00000000,
                                              gl::Float32One>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32B32_FLOAT, false,
                     CopyNativeVertexData<GLfloat, 3, 3, 0>, false},
                    {angle::FormatID::R16G16B16_FLOAT, false,
                     CopyToFloatVertexData<GLfloat, 3, 3, false, true>, true},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLfloat, 3, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 1);
            }
            break;

        case angle::FormatID::R32G32B32_SINT:
            mIntendedGLFormat = GL_RGB32I;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32B32_SINT, nullptr},
                    {angle::FormatID::R32G32B32A32_SINT,
                     Initialize4ComponentData<GLint, 0x00000000, 0x00000000, 0x00000000,
                                              0x00000001>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::R32G32B32_SINT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLint, 3, 3, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32_SNORM:
            mIntendedGLFormat = GL_RGB32_SNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 3, 3, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_SSCALED:
            mIntendedGLFormat = GL_RGB32_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 3, 3, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_UINT:
            mIntendedGLFormat = GL_RGB32UI;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32B32_UINT, nullptr},
                    {angle::FormatID::R32G32B32A32_UINT,
                     Initialize4ComponentData<GLuint, 0x00000000, 0x00000000, 0x00000000,
                                              0x00000001>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::R32G32B32_UINT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLuint, 3, 3, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R32G32B32_UNORM:
            mIntendedGLFormat = GL_RGB32_UNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 3, 3, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32B32_USCALED:
            mIntendedGLFormat = GL_RGB32_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32B32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 3, 3, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_FIXED:
            mIntendedGLFormat = GL_RG32_FIXED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = Copy32FixedTo32FVertexData<2, 2>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_FLOAT:
            mIntendedGLFormat              = GL_RG32F;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32G32_FLOAT;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32G32_FLOAT, false, CopyNativeVertexData<GLfloat, 2, 2, 0>,
                     false},
                    {angle::FormatID::R16G16_FLOAT, false,
                     CopyToFloatVertexData<GLfloat, 2, 2, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 1);
            }
            break;

        case angle::FormatID::R32G32_SINT:
            mIntendedGLFormat              = GL_RG32I;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32G32_SINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R32G32_SINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLint, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R32G32_SNORM:
            mIntendedGLFormat = GL_RG32_SNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 2, 2, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_SSCALED:
            mIntendedGLFormat = GL_RG32_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 2, 2, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_UINT:
            mIntendedGLFormat              = GL_RG32UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32G32_UINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R32G32_UINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLuint, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R32G32_UNORM:
            mIntendedGLFormat = GL_RG32_UNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 2, 2, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32G32_USCALED:
            mIntendedGLFormat = GL_RG32_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32G32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 2, 2, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_FIXED:
            mIntendedGLFormat = GL_R32_FIXED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = Copy32FixedTo32FVertexData<1, 1>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_FLOAT:
            mIntendedGLFormat              = GL_R32F;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32_FLOAT;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R32_FLOAT, false, CopyNativeVertexData<GLfloat, 1, 1, 0>,
                     false},
                    {angle::FormatID::R16_FLOAT, false,
                     CopyToFloatVertexData<GLfloat, 1, 1, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 1);
            }
            break;

        case angle::FormatID::R32_SINT:
            mIntendedGLFormat              = GL_R32I;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32_SINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R32_SINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLint, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R32_SNORM:
            mIntendedGLFormat = GL_R32_SNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 1, 1, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_SSCALED:
            mIntendedGLFormat = GL_R32_SSCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLint, 1, 1, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_UINT:
            mIntendedGLFormat              = GL_R32UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R32_UINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R32_UINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLuint, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R32_UNORM:
            mIntendedGLFormat = GL_R32_UNORM_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 1, 1, true, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R32_USCALED:
            mIntendedGLFormat = GL_R32_USCALED_ANGLEX;

            mActualBufferFormatID         = angle::FormatID::R32_FLOAT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyToFloatVertexData<GLuint, 1, 1, false, false>;
            mVertexLoadRequiresConversion = true;
            break;

        case angle::FormatID::R4G4B4A4_UNORM:
            mIntendedGLFormat = GL_RGBA4;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R4G4B4A4_UNORM, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::R4G4B4A4_UNORM;
            mVkBufferFormatIsPacked       = true;
            mVertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R5G5B5A1_UNORM:
            mIntendedGLFormat = GL_RGB5_A1;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R5G5B5A1_UNORM, nullptr},
                    {angle::FormatID::A1R5G5B5_UNORM, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::R5G5B5A1_UNORM;
            mVkBufferFormatIsPacked       = true;
            mVertexLoadFunction           = CopyNativeVertexData<GLushort, 1, 1, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R5G6B5_UNORM:
            mIntendedGLFormat              = GL_RGB565;
            mActualSampleOnlyImageFormatID = angle::FormatID::R5G6B5_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R5G6B5_UNORM;
            mVkBufferFormatIsPacked        = true;
            mVertexLoadFunction            = CopyNativeVertexData<GLushort, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8B8A8_SINT:
            mIntendedGLFormat              = GL_RGBA8I;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_SINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8B8A8_SINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8B8A8_SNORM:
            mIntendedGLFormat              = GL_RGBA8_SNORM;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_SNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8B8A8_SNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8B8A8_SSCALED:
            mIntendedGLFormat              = GL_RGBA8_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_SSCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8A8_SSCALED, false,
                     CopyNativeVertexData<GLbyte, 4, 4, 0>, false},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLbyte, 4, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R8G8B8A8_TYPELESS:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::R8G8B8A8_TYPELESS_SRGB:
            // This format is not implemented in Vulkan.
            break;

        case angle::FormatID::R8G8B8A8_UINT:
            mIntendedGLFormat              = GL_RGBA8UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8B8A8_UINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8B8A8_UNORM:
            mIntendedGLFormat              = GL_RGBA8;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8B8A8_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8B8A8_UNORM_SRGB:
            mIntendedGLFormat              = GL_SRGB8_ALPHA8;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM_SRGB;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8B8A8_UNORM_SRGB;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 4, 4, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8B8A8_USCALED:
            mIntendedGLFormat              = GL_RGBA8_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_USCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8A8_USCALED, false,
                     CopyNativeVertexData<GLubyte, 4, 4, 0>, false},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLubyte, 4, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R8G8B8X8_UNORM:
            mIntendedGLFormat              = GL_RGBX8_ANGLE;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::NONE;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::R8G8B8X8_UNORM_SRGB:
            mIntendedGLFormat              = GL_RGBX8_SRGB_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8A8_UNORM_SRGB;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::NONE;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = nullptr;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::R8G8B8_SINT:
            mIntendedGLFormat = GL_RGB8I;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SINT, nullptr},
                    {angle::FormatID::R8G8B8A8_SINT,
                     Initialize4ComponentData<GLbyte, 0x00, 0x00, 0x00, 0x01>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SINT, false, CopyNativeVertexData<GLbyte, 3, 3, 0>,
                     false},
                    {angle::FormatID::R8G8B8A8_SINT, false, CopyNativeVertexData<GLbyte, 3, 4, 1>,
                     true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R8G8B8_SNORM:
            mIntendedGLFormat = GL_RGB8_SNORM;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SNORM, nullptr},
                    {angle::FormatID::R8G8B8A8_SNORM,
                     Initialize4ComponentData<GLbyte, 0x00, 0x00, 0x00, 0x7F>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SNORM, false, CopyNativeVertexData<GLbyte, 3, 3, 0>,
                     false},
                    {angle::FormatID::R8G8B8A8_SNORM, false,
                     CopyNativeVertexData<GLbyte, 3, 4, std::numeric_limits<GLbyte>::max()>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R8G8B8_SSCALED:
            mIntendedGLFormat              = GL_RGB8_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8_SSCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_SSCALED, false, CopyNativeVertexData<GLbyte, 3, 3, 0>,
                     false},
                    {angle::FormatID::R8G8B8A8_SSCALED, false,
                     CopyNativeVertexData<GLbyte, 3, 4, 1>, true},
                    {angle::FormatID::R16G16B16_FLOAT, false,
                     CopyToFloatVertexData<GLbyte, 3, 3, false, true>, true},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLbyte, 3, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 4);
            }
            break;

        case angle::FormatID::R8G8B8_UINT:
            mIntendedGLFormat = GL_RGB8UI;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_UINT, nullptr},
                    {angle::FormatID::R8G8B8A8_UINT,
                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0x01>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_UINT, false, CopyNativeVertexData<GLubyte, 3, 3, 0>,
                     false},
                    {angle::FormatID::R8G8B8A8_UINT, false, CopyNativeVertexData<GLubyte, 3, 4, 1>,
                     true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R8G8B8_UNORM:
            mIntendedGLFormat = GL_RGB8;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_UNORM, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM,
                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_UNORM, false, CopyNativeVertexData<GLubyte, 3, 3, 0>,
                     false},
                    {angle::FormatID::R8G8B8A8_UNORM, false,
                     CopyNativeVertexData<GLubyte, 3, 4, std::numeric_limits<GLubyte>::max()>,
                     true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R8G8B8_UNORM_SRGB:
            mIntendedGLFormat = GL_SRGB8;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_UNORM_SRGB, nullptr},
                    {angle::FormatID::R8G8B8A8_UNORM_SRGB,
                     Initialize4ComponentData<GLubyte, 0x00, 0x00, 0x00, 0xFF>}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::R8G8B8_UNORM_SRGB;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = CopyNativeVertexData<GLubyte, 3, 3, 0>;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::R8G8B8_USCALED:
            mIntendedGLFormat              = GL_RGB8_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8B8_USCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8B8_USCALED, false, CopyNativeVertexData<GLubyte, 3, 3, 0>,
                     false},
                    {angle::FormatID::R8G8B8A8_USCALED, false,
                     CopyNativeVertexData<GLubyte, 3, 4, 1>, true},
                    {angle::FormatID::R16G16B16_FLOAT, false,
                     CopyToFloatVertexData<GLubyte, 3, 3, false, true>, true},
                    {angle::FormatID::R16G16B16A16_FLOAT, false,
                     CopyToFloatVertexData<GLubyte, 3, 4, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 4);
            }
            break;

        case angle::FormatID::R8G8_SINT:
            mIntendedGLFormat              = GL_RG8I;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8_SINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8_SINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8_SNORM:
            mIntendedGLFormat              = GL_RG8_SNORM;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8_SNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8_SNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8_SSCALED:
            mIntendedGLFormat              = GL_RG8_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8_SSCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8_SSCALED, false, CopyNativeVertexData<GLbyte, 2, 2, 0>,
                     false},
                    {angle::FormatID::R8G8B8_SSCALED, false, CopyNativeVertexData<GLbyte, 2, 3, 0>,
                     true},
                    {angle::FormatID::R16G16_FLOAT, false,
                     CopyToFloatVertexData<GLbyte, 2, 2, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 3);
            }
            break;

        case angle::FormatID::R8G8_UINT:
            mIntendedGLFormat              = GL_RG8UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8_UINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8_UINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8_UNORM:
            mIntendedGLFormat              = GL_RG8;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8_UNORM_SRGB:
            mIntendedGLFormat              = GL_SRG8_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8_UNORM_SRGB;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8G8_UNORM_SRGB;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 2, 2, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8G8_USCALED:
            mIntendedGLFormat              = GL_RG8_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8G8_USCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8G8_USCALED, false, CopyNativeVertexData<GLubyte, 2, 2, 0>,
                     false},
                    {angle::FormatID::R8G8B8_USCALED, false, CopyNativeVertexData<GLubyte, 2, 3, 0>,
                     true},
                    {angle::FormatID::R16G16_FLOAT, false,
                     CopyToFloatVertexData<GLubyte, 2, 2, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 3);
            }
            break;

        case angle::FormatID::R8_SINT:
            mIntendedGLFormat              = GL_R8I;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8_SINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8_SINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8_SNORM:
            mIntendedGLFormat              = GL_R8_SNORM;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8_SNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8_SNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLbyte, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8_SSCALED:
            mIntendedGLFormat              = GL_R8_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8_SSCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8_SSCALED, false, CopyNativeVertexData<GLbyte, 1, 1, 0>,
                     false},
                    {angle::FormatID::R16_FLOAT, false,
                     CopyToFloatVertexData<GLbyte, 1, 1, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R8_UINT:
            mIntendedGLFormat              = GL_R8UI;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8_UINT;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8_UINT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8_UNORM:
            mIntendedGLFormat              = GL_R8;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8_UNORM;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8_UNORM;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8_UNORM_SRGB:
            mIntendedGLFormat              = GL_SR8_EXT;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8_UNORM_SRGB;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R8_UNORM_SRGB;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyNativeVertexData<GLubyte, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::R8_USCALED:
            mIntendedGLFormat              = GL_R8_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::R8_USCALED;
            mImageInitializerFunction      = nullptr;
            {
                static constexpr BufferFormatInitInfo kInfo[] = {
                    {angle::FormatID::R8_USCALED, false, CopyNativeVertexData<GLubyte, 1, 1, 0>,
                     false},
                    {angle::FormatID::R16_FLOAT, false,
                     CopyToFloatVertexData<GLubyte, 1, 1, false, true>, true}};
                initBufferFallback(renderer, kInfo, ArraySize(kInfo), 2);
            }
            break;

        case angle::FormatID::R9G9B9E5_SHAREDEXP:
            mIntendedGLFormat              = GL_RGB9_E5;
            mActualSampleOnlyImageFormatID = angle::FormatID::R9G9B9E5_SHAREDEXP;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R9G9B9E5_SHAREDEXP;
            mVkBufferFormatIsPacked        = true;
            mVertexLoadFunction            = CopyNativeVertexData<GLuint, 1, 1, 0>;
            mVertexLoadRequiresConversion  = false;
            break;

        case angle::FormatID::S8_UINT:
            mIntendedGLFormat = GL_STENCIL_INDEX8;
            {
                static constexpr ImageFormatInitInfo kInfo[] = {
                    {angle::FormatID::S8_UINT, nullptr},
                    {angle::FormatID::D24_UNORM_S8_UINT, nullptr},
                    {angle::FormatID::D32_FLOAT_S8X24_UINT, nullptr}};
                initImageFallback(renderer, kInfo, ArraySize(kInfo));
            }
            mActualBufferFormatID         = angle::FormatID::S8_UINT;
            mVkBufferFormatIsPacked       = false;
            mVertexLoadFunction           = nullptr;
            mVertexLoadRequiresConversion = false;
            break;

        case angle::FormatID::X2R10G10B10_SINT_VERTEX:
            mIntendedGLFormat              = GL_X2_RGB10_SINT_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyXYZ10ToXYZWFloatVertexData<true, false, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::X2R10G10B10_SNORM_VERTEX:
            mIntendedGLFormat              = GL_X2_RGB10_SNORM_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyXYZ10ToXYZWFloatVertexData<true, true, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::X2R10G10B10_SSCALED_VERTEX:
            mIntendedGLFormat              = GL_X2_RGB10_SSCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyXYZ10ToXYZWFloatVertexData<true, false, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::X2R10G10B10_UINT_VERTEX:
            mIntendedGLFormat              = GL_X2_RGB10_UINT_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyXYZ10ToXYZWFloatVertexData<false, false, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::X2R10G10B10_UNORM_VERTEX:
            mIntendedGLFormat              = GL_X2_RGB10_UNORM_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyXYZ10ToXYZWFloatVertexData<false, true, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        case angle::FormatID::X2R10G10B10_USCALED_VERTEX:
            mIntendedGLFormat              = GL_X2_RGB10_USCALED_ANGLEX;
            mActualSampleOnlyImageFormatID = angle::FormatID::NONE;
            mImageInitializerFunction      = nullptr;
            mActualBufferFormatID          = angle::FormatID::R16G16B16A16_FLOAT;
            mVkBufferFormatIsPacked        = false;
            mVertexLoadFunction            = CopyXYZ10ToXYZWFloatVertexData<false, false, true>;
            mVertexLoadRequiresConversion  = true;
            break;

        default:
            UNREACHABLE();
            break;
    }
}

VkFormat GetVkFormatFromFormatID(const Renderer *renderer, angle::FormatID formatID)
{
    static constexpr angle::FormatMap<VkFormat> kMap = {
        {angle::FormatID::A1R5G5B5_UNORM, VK_FORMAT_A1R5G5B5_UNORM_PACK16},
        {angle::FormatID::ASTC_10x10_SRGB_BLOCK, VK_FORMAT_ASTC_10x10_SRGB_BLOCK},
        {angle::FormatID::ASTC_10x10_UNORM_BLOCK, VK_FORMAT_ASTC_10x10_UNORM_BLOCK},
        {angle::FormatID::ASTC_10x5_SRGB_BLOCK, VK_FORMAT_ASTC_10x5_SRGB_BLOCK},
        {angle::FormatID::ASTC_10x5_UNORM_BLOCK, VK_FORMAT_ASTC_10x5_UNORM_BLOCK},
        {angle::FormatID::ASTC_10x6_SRGB_BLOCK, VK_FORMAT_ASTC_10x6_SRGB_BLOCK},
        {angle::FormatID::ASTC_10x6_UNORM_BLOCK, VK_FORMAT_ASTC_10x6_UNORM_BLOCK},
        {angle::FormatID::ASTC_10x8_SRGB_BLOCK, VK_FORMAT_ASTC_10x8_SRGB_BLOCK},
        {angle::FormatID::ASTC_10x8_UNORM_BLOCK, VK_FORMAT_ASTC_10x8_UNORM_BLOCK},
        {angle::FormatID::ASTC_12x10_SRGB_BLOCK, VK_FORMAT_ASTC_12x10_SRGB_BLOCK},
        {angle::FormatID::ASTC_12x10_UNORM_BLOCK, VK_FORMAT_ASTC_12x10_UNORM_BLOCK},
        {angle::FormatID::ASTC_12x12_SRGB_BLOCK, VK_FORMAT_ASTC_12x12_SRGB_BLOCK},
        {angle::FormatID::ASTC_12x12_UNORM_BLOCK, VK_FORMAT_ASTC_12x12_UNORM_BLOCK},
        {angle::FormatID::ASTC_4x4_SRGB_BLOCK, VK_FORMAT_ASTC_4x4_SRGB_BLOCK},
        {angle::FormatID::ASTC_4x4_UNORM_BLOCK, VK_FORMAT_ASTC_4x4_UNORM_BLOCK},
        {angle::FormatID::ASTC_5x4_SRGB_BLOCK, VK_FORMAT_ASTC_5x4_SRGB_BLOCK},
        {angle::FormatID::ASTC_5x4_UNORM_BLOCK, VK_FORMAT_ASTC_5x4_UNORM_BLOCK},
        {angle::FormatID::ASTC_5x5_SRGB_BLOCK, VK_FORMAT_ASTC_5x5_SRGB_BLOCK},
        {angle::FormatID::ASTC_5x5_UNORM_BLOCK, VK_FORMAT_ASTC_5x5_UNORM_BLOCK},
        {angle::FormatID::ASTC_6x5_SRGB_BLOCK, VK_FORMAT_ASTC_6x5_SRGB_BLOCK},
        {angle::FormatID::ASTC_6x5_UNORM_BLOCK, VK_FORMAT_ASTC_6x5_UNORM_BLOCK},
        {angle::FormatID::ASTC_6x6_SRGB_BLOCK, VK_FORMAT_ASTC_6x6_SRGB_BLOCK},
        {angle::FormatID::ASTC_6x6_UNORM_BLOCK, VK_FORMAT_ASTC_6x6_UNORM_BLOCK},
        {angle::FormatID::ASTC_8x5_SRGB_BLOCK, VK_FORMAT_ASTC_8x5_SRGB_BLOCK},
        {angle::FormatID::ASTC_8x5_UNORM_BLOCK, VK_FORMAT_ASTC_8x5_UNORM_BLOCK},
        {angle::FormatID::ASTC_8x6_SRGB_BLOCK, VK_FORMAT_ASTC_8x6_SRGB_BLOCK},
        {angle::FormatID::ASTC_8x6_UNORM_BLOCK, VK_FORMAT_ASTC_8x6_UNORM_BLOCK},
        {angle::FormatID::ASTC_8x8_SRGB_BLOCK, VK_FORMAT_ASTC_8x8_SRGB_BLOCK},
        {angle::FormatID::ASTC_8x8_UNORM_BLOCK, VK_FORMAT_ASTC_8x8_UNORM_BLOCK},
        {angle::FormatID::B10G10R10A2_UNORM, VK_FORMAT_A2R10G10B10_UNORM_PACK32},
        {angle::FormatID::B4G4R4A4_UNORM, VK_FORMAT_B4G4R4A4_UNORM_PACK16},
        {angle::FormatID::B5G5R5A1_UNORM, VK_FORMAT_B5G5R5A1_UNORM_PACK16},
        {angle::FormatID::B5G6R5_UNORM, VK_FORMAT_B5G6R5_UNORM_PACK16},
        {angle::FormatID::B8G8R8A8_UNORM, VK_FORMAT_B8G8R8A8_UNORM},
        {angle::FormatID::B8G8R8A8_UNORM_SRGB, VK_FORMAT_B8G8R8A8_SRGB},
        {angle::FormatID::BC1_RGBA_UNORM_BLOCK, VK_FORMAT_BC1_RGBA_UNORM_BLOCK},
        {angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK, VK_FORMAT_BC1_RGBA_SRGB_BLOCK},
        {angle::FormatID::BC1_RGB_UNORM_BLOCK, VK_FORMAT_BC1_RGB_UNORM_BLOCK},
        {angle::FormatID::BC1_RGB_UNORM_SRGB_BLOCK, VK_FORMAT_BC1_RGB_SRGB_BLOCK},
        {angle::FormatID::BC2_RGBA_UNORM_BLOCK, VK_FORMAT_BC2_UNORM_BLOCK},
        {angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK, VK_FORMAT_BC2_SRGB_BLOCK},
        {angle::FormatID::BC3_RGBA_UNORM_BLOCK, VK_FORMAT_BC3_UNORM_BLOCK},
        {angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK, VK_FORMAT_BC3_SRGB_BLOCK},
        {angle::FormatID::BC4_RED_SNORM_BLOCK, VK_FORMAT_BC4_SNORM_BLOCK},
        {angle::FormatID::BC4_RED_UNORM_BLOCK, VK_FORMAT_BC4_UNORM_BLOCK},
        {angle::FormatID::BC5_RG_SNORM_BLOCK, VK_FORMAT_BC5_SNORM_BLOCK},
        {angle::FormatID::BC5_RG_UNORM_BLOCK, VK_FORMAT_BC5_UNORM_BLOCK},
        {angle::FormatID::BC6H_RGB_SFLOAT_BLOCK, VK_FORMAT_BC6H_SFLOAT_BLOCK},
        {angle::FormatID::BC6H_RGB_UFLOAT_BLOCK, VK_FORMAT_BC6H_UFLOAT_BLOCK},
        {angle::FormatID::BC7_RGBA_UNORM_BLOCK, VK_FORMAT_BC7_UNORM_BLOCK},
        {angle::FormatID::BC7_RGBA_UNORM_SRGB_BLOCK, VK_FORMAT_BC7_SRGB_BLOCK},
        {angle::FormatID::D16_UNORM, VK_FORMAT_D16_UNORM},
        {angle::FormatID::D24_UNORM_S8_UINT, VK_FORMAT_D24_UNORM_S8_UINT},
        {angle::FormatID::D24_UNORM_X8_UINT, VK_FORMAT_X8_D24_UNORM_PACK32},
        {angle::FormatID::D32_FLOAT, VK_FORMAT_D32_SFLOAT},
        {angle::FormatID::D32_FLOAT_S8X24_UINT, VK_FORMAT_D32_SFLOAT_S8_UINT},
        {angle::FormatID::EAC_R11G11_SNORM_BLOCK, VK_FORMAT_EAC_R11G11_SNORM_BLOCK},
        {angle::FormatID::EAC_R11G11_UNORM_BLOCK, VK_FORMAT_EAC_R11G11_UNORM_BLOCK},
        {angle::FormatID::EAC_R11_SNORM_BLOCK, VK_FORMAT_EAC_R11_SNORM_BLOCK},
        {angle::FormatID::EAC_R11_UNORM_BLOCK, VK_FORMAT_EAC_R11_UNORM_BLOCK},
        {angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK, VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK},
        {angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK, VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK},
        {angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK, VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK},
        {angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK, VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK},
        {angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK, VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK},
        {angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK, VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK},
        {angle::FormatID::EXTERNAL0, VK_FORMAT_UNDEFINED},
        {angle::FormatID::EXTERNAL1, VK_FORMAT_UNDEFINED},
        {angle::FormatID::EXTERNAL2, VK_FORMAT_UNDEFINED},
        {angle::FormatID::EXTERNAL3, VK_FORMAT_UNDEFINED},
        {angle::FormatID::EXTERNAL4, VK_FORMAT_UNDEFINED},
        {angle::FormatID::EXTERNAL5, VK_FORMAT_UNDEFINED},
        {angle::FormatID::EXTERNAL6, VK_FORMAT_UNDEFINED},
        {angle::FormatID::EXTERNAL7, VK_FORMAT_UNDEFINED},
        {angle::FormatID::G8_B8R8_2PLANE_420_UNORM, VK_FORMAT_G8_B8R8_2PLANE_420_UNORM},
        {angle::FormatID::G8_B8_R8_3PLANE_420_UNORM, VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM},
        {angle::FormatID::NONE, VK_FORMAT_UNDEFINED},
        {angle::FormatID::R10G10B10A2_SINT, VK_FORMAT_A2B10G10R10_SINT_PACK32},
        {angle::FormatID::R10G10B10A2_SNORM, VK_FORMAT_A2B10G10R10_SNORM_PACK32},
        {angle::FormatID::R10G10B10A2_SSCALED, VK_FORMAT_A2B10G10R10_SSCALED_PACK32},
        {angle::FormatID::R10G10B10A2_UINT, VK_FORMAT_A2B10G10R10_UINT_PACK32},
        {angle::FormatID::R10G10B10A2_UNORM, VK_FORMAT_A2B10G10R10_UNORM_PACK32},
        {angle::FormatID::R10G10B10A2_USCALED, VK_FORMAT_A2B10G10R10_USCALED_PACK32},
        {angle::FormatID::R11G11B10_FLOAT, VK_FORMAT_B10G11R11_UFLOAT_PACK32},
        {angle::FormatID::R16G16B16A16_FLOAT, VK_FORMAT_R16G16B16A16_SFLOAT},
        {angle::FormatID::R16G16B16A16_SINT, VK_FORMAT_R16G16B16A16_SINT},
        {angle::FormatID::R16G16B16A16_SNORM, VK_FORMAT_R16G16B16A16_SNORM},
        {angle::FormatID::R16G16B16A16_SSCALED, VK_FORMAT_R16G16B16A16_SSCALED},
        {angle::FormatID::R16G16B16A16_UINT, VK_FORMAT_R16G16B16A16_UINT},
        {angle::FormatID::R16G16B16A16_UNORM, VK_FORMAT_R16G16B16A16_UNORM},
        {angle::FormatID::R16G16B16A16_USCALED, VK_FORMAT_R16G16B16A16_USCALED},
        {angle::FormatID::R16G16B16_FLOAT, VK_FORMAT_R16G16B16_SFLOAT},
        {angle::FormatID::R16G16B16_SINT, VK_FORMAT_R16G16B16_SINT},
        {angle::FormatID::R16G16B16_SNORM, VK_FORMAT_R16G16B16_SNORM},
        {angle::FormatID::R16G16B16_SSCALED, VK_FORMAT_R16G16B16_SSCALED},
        {angle::FormatID::R16G16B16_UINT, VK_FORMAT_R16G16B16_UINT},
        {angle::FormatID::R16G16B16_UNORM, VK_FORMAT_R16G16B16_UNORM},
        {angle::FormatID::R16G16B16_USCALED, VK_FORMAT_R16G16B16_USCALED},
        {angle::FormatID::R16G16_FLOAT, VK_FORMAT_R16G16_SFLOAT},
        {angle::FormatID::R16G16_SINT, VK_FORMAT_R16G16_SINT},
        {angle::FormatID::R16G16_SNORM, VK_FORMAT_R16G16_SNORM},
        {angle::FormatID::R16G16_SSCALED, VK_FORMAT_R16G16_SSCALED},
        {angle::FormatID::R16G16_UINT, VK_FORMAT_R16G16_UINT},
        {angle::FormatID::R16G16_UNORM, VK_FORMAT_R16G16_UNORM},
        {angle::FormatID::R16G16_USCALED, VK_FORMAT_R16G16_USCALED},
        {angle::FormatID::R16_FLOAT, VK_FORMAT_R16_SFLOAT},
        {angle::FormatID::R16_SINT, VK_FORMAT_R16_SINT},
        {angle::FormatID::R16_SNORM, VK_FORMAT_R16_SNORM},
        {angle::FormatID::R16_SSCALED, VK_FORMAT_R16_SSCALED},
        {angle::FormatID::R16_UINT, VK_FORMAT_R16_UINT},
        {angle::FormatID::R16_UNORM, VK_FORMAT_R16_UNORM},
        {angle::FormatID::R16_USCALED, VK_FORMAT_R16_USCALED},
        {angle::FormatID::R32G32B32A32_FLOAT, VK_FORMAT_R32G32B32A32_SFLOAT},
        {angle::FormatID::R32G32B32A32_SINT, VK_FORMAT_R32G32B32A32_SINT},
        {angle::FormatID::R32G32B32A32_UINT, VK_FORMAT_R32G32B32A32_UINT},
        {angle::FormatID::R32G32B32_FLOAT, VK_FORMAT_R32G32B32_SFLOAT},
        {angle::FormatID::R32G32B32_SINT, VK_FORMAT_R32G32B32_SINT},
        {angle::FormatID::R32G32B32_UINT, VK_FORMAT_R32G32B32_UINT},
        {angle::FormatID::R32G32_FLOAT, VK_FORMAT_R32G32_SFLOAT},
        {angle::FormatID::R32G32_SINT, VK_FORMAT_R32G32_SINT},
        {angle::FormatID::R32G32_UINT, VK_FORMAT_R32G32_UINT},
        {angle::FormatID::R32_FLOAT, VK_FORMAT_R32_SFLOAT},
        {angle::FormatID::R32_SINT, VK_FORMAT_R32_SINT},
        {angle::FormatID::R32_UINT, VK_FORMAT_R32_UINT},
        {angle::FormatID::R4G4B4A4_UNORM, VK_FORMAT_R4G4B4A4_UNORM_PACK16},
        {angle::FormatID::R5G5B5A1_UNORM, VK_FORMAT_R5G5B5A1_UNORM_PACK16},
        {angle::FormatID::R5G6B5_UNORM, VK_FORMAT_R5G6B5_UNORM_PACK16},
        {angle::FormatID::R8G8B8A8_SINT, VK_FORMAT_R8G8B8A8_SINT},
        {angle::FormatID::R8G8B8A8_SNORM, VK_FORMAT_R8G8B8A8_SNORM},
        {angle::FormatID::R8G8B8A8_SSCALED, VK_FORMAT_R8G8B8A8_SSCALED},
        {angle::FormatID::R8G8B8A8_UINT, VK_FORMAT_R8G8B8A8_UINT},
        {angle::FormatID::R8G8B8A8_UNORM, VK_FORMAT_R8G8B8A8_UNORM},
        {angle::FormatID::R8G8B8A8_UNORM_SRGB, VK_FORMAT_R8G8B8A8_SRGB},
        {angle::FormatID::R8G8B8A8_USCALED, VK_FORMAT_R8G8B8A8_USCALED},
        {angle::FormatID::R8G8B8_SINT, VK_FORMAT_R8G8B8_SINT},
        {angle::FormatID::R8G8B8_SNORM, VK_FORMAT_R8G8B8_SNORM},
        {angle::FormatID::R8G8B8_SSCALED, VK_FORMAT_R8G8B8_SSCALED},
        {angle::FormatID::R8G8B8_UINT, VK_FORMAT_R8G8B8_UINT},
        {angle::FormatID::R8G8B8_UNORM, VK_FORMAT_R8G8B8_UNORM},
        {angle::FormatID::R8G8B8_UNORM_SRGB, VK_FORMAT_R8G8B8_SRGB},
        {angle::FormatID::R8G8B8_USCALED, VK_FORMAT_R8G8B8_USCALED},
        {angle::FormatID::R8G8_SINT, VK_FORMAT_R8G8_SINT},
        {angle::FormatID::R8G8_SNORM, VK_FORMAT_R8G8_SNORM},
        {angle::FormatID::R8G8_SSCALED, VK_FORMAT_R8G8_SSCALED},
        {angle::FormatID::R8G8_UINT, VK_FORMAT_R8G8_UINT},
        {angle::FormatID::R8G8_UNORM, VK_FORMAT_R8G8_UNORM},
        {angle::FormatID::R8G8_UNORM_SRGB, VK_FORMAT_R8G8_SRGB},
        {angle::FormatID::R8G8_USCALED, VK_FORMAT_R8G8_USCALED},
        {angle::FormatID::R8_SINT, VK_FORMAT_R8_SINT},
        {angle::FormatID::R8_SNORM, VK_FORMAT_R8_SNORM},
        {angle::FormatID::R8_SSCALED, VK_FORMAT_R8_SSCALED},
        {angle::FormatID::R8_UINT, VK_FORMAT_R8_UINT},
        {angle::FormatID::R8_UNORM, VK_FORMAT_R8_UNORM},
        {angle::FormatID::R8_UNORM_SRGB, VK_FORMAT_R8_SRGB},
        {angle::FormatID::R8_USCALED, VK_FORMAT_R8_USCALED},
        {angle::FormatID::R9G9B9E5_SHAREDEXP, VK_FORMAT_E5B9G9R9_UFLOAT_PACK32},
        {angle::FormatID::S8_UINT, VK_FORMAT_S8_UINT}};

    return AdjustASTCFormatForHDR(renderer, kMap[formatID]);
}

angle::FormatID GetFormatIDFromVkFormat(VkFormat vkFormat)
{
    switch (vkFormat)
    {
        case VK_FORMAT_A1R5G5B5_UNORM_PACK16:
            return angle::FormatID::A1R5G5B5_UNORM;
        case VK_FORMAT_ASTC_10x10_SRGB_BLOCK:
            return angle::FormatID::ASTC_10x10_SRGB_BLOCK;
        case VK_FORMAT_ASTC_10x10_UNORM_BLOCK:
            return angle::FormatID::ASTC_10x10_UNORM_BLOCK;
        case VK_FORMAT_ASTC_10x5_SRGB_BLOCK:
            return angle::FormatID::ASTC_10x5_SRGB_BLOCK;
        case VK_FORMAT_ASTC_10x5_UNORM_BLOCK:
            return angle::FormatID::ASTC_10x5_UNORM_BLOCK;
        case VK_FORMAT_ASTC_10x6_SRGB_BLOCK:
            return angle::FormatID::ASTC_10x6_SRGB_BLOCK;
        case VK_FORMAT_ASTC_10x6_UNORM_BLOCK:
            return angle::FormatID::ASTC_10x6_UNORM_BLOCK;
        case VK_FORMAT_ASTC_10x8_SRGB_BLOCK:
            return angle::FormatID::ASTC_10x8_SRGB_BLOCK;
        case VK_FORMAT_ASTC_10x8_UNORM_BLOCK:
            return angle::FormatID::ASTC_10x8_UNORM_BLOCK;
        case VK_FORMAT_ASTC_12x10_SRGB_BLOCK:
            return angle::FormatID::ASTC_12x10_SRGB_BLOCK;
        case VK_FORMAT_ASTC_12x10_UNORM_BLOCK:
            return angle::FormatID::ASTC_12x10_UNORM_BLOCK;
        case VK_FORMAT_ASTC_12x12_SRGB_BLOCK:
            return angle::FormatID::ASTC_12x12_SRGB_BLOCK;
        case VK_FORMAT_ASTC_12x12_UNORM_BLOCK:
            return angle::FormatID::ASTC_12x12_UNORM_BLOCK;
        case VK_FORMAT_ASTC_4x4_SRGB_BLOCK:
            return angle::FormatID::ASTC_4x4_SRGB_BLOCK;
        case VK_FORMAT_ASTC_4x4_UNORM_BLOCK:
            return angle::FormatID::ASTC_4x4_UNORM_BLOCK;
        case VK_FORMAT_ASTC_5x4_SRGB_BLOCK:
            return angle::FormatID::ASTC_5x4_SRGB_BLOCK;
        case VK_FORMAT_ASTC_5x4_UNORM_BLOCK:
            return angle::FormatID::ASTC_5x4_UNORM_BLOCK;
        case VK_FORMAT_ASTC_5x5_SRGB_BLOCK:
            return angle::FormatID::ASTC_5x5_SRGB_BLOCK;
        case VK_FORMAT_ASTC_5x5_UNORM_BLOCK:
            return angle::FormatID::ASTC_5x5_UNORM_BLOCK;
        case VK_FORMAT_ASTC_6x5_SRGB_BLOCK:
            return angle::FormatID::ASTC_6x5_SRGB_BLOCK;
        case VK_FORMAT_ASTC_6x5_UNORM_BLOCK:
            return angle::FormatID::ASTC_6x5_UNORM_BLOCK;
        case VK_FORMAT_ASTC_6x6_SRGB_BLOCK:
            return angle::FormatID::ASTC_6x6_SRGB_BLOCK;
        case VK_FORMAT_ASTC_6x6_UNORM_BLOCK:
            return angle::FormatID::ASTC_6x6_UNORM_BLOCK;
        case VK_FORMAT_ASTC_8x5_SRGB_BLOCK:
            return angle::FormatID::ASTC_8x5_SRGB_BLOCK;
        case VK_FORMAT_ASTC_8x5_UNORM_BLOCK:
            return angle::FormatID::ASTC_8x5_UNORM_BLOCK;
        case VK_FORMAT_ASTC_8x6_SRGB_BLOCK:
            return angle::FormatID::ASTC_8x6_SRGB_BLOCK;
        case VK_FORMAT_ASTC_8x6_UNORM_BLOCK:
            return angle::FormatID::ASTC_8x6_UNORM_BLOCK;
        case VK_FORMAT_ASTC_8x8_SRGB_BLOCK:
            return angle::FormatID::ASTC_8x8_SRGB_BLOCK;
        case VK_FORMAT_ASTC_8x8_UNORM_BLOCK:
            return angle::FormatID::ASTC_8x8_UNORM_BLOCK;
        case VK_FORMAT_A2R10G10B10_UNORM_PACK32:
            return angle::FormatID::B10G10R10A2_UNORM;
        case VK_FORMAT_B4G4R4A4_UNORM_PACK16:
            return angle::FormatID::B4G4R4A4_UNORM;
        case VK_FORMAT_B5G5R5A1_UNORM_PACK16:
            return angle::FormatID::B5G5R5A1_UNORM;
        case VK_FORMAT_B5G6R5_UNORM_PACK16:
            return angle::FormatID::B5G6R5_UNORM;
        case VK_FORMAT_B8G8R8A8_UNORM:
            return angle::FormatID::B8G8R8A8_UNORM;
        case VK_FORMAT_B8G8R8A8_SRGB:
            return angle::FormatID::B8G8R8A8_UNORM_SRGB;
        case VK_FORMAT_BC1_RGBA_UNORM_BLOCK:
            return angle::FormatID::BC1_RGBA_UNORM_BLOCK;
        case VK_FORMAT_BC1_RGBA_SRGB_BLOCK:
            return angle::FormatID::BC1_RGBA_UNORM_SRGB_BLOCK;
        case VK_FORMAT_BC1_RGB_UNORM_BLOCK:
            return angle::FormatID::BC1_RGB_UNORM_BLOCK;
        case VK_FORMAT_BC1_RGB_SRGB_BLOCK:
            return angle::FormatID::BC1_RGB_UNORM_SRGB_BLOCK;
        case VK_FORMAT_BC2_UNORM_BLOCK:
            return angle::FormatID::BC2_RGBA_UNORM_BLOCK;
        case VK_FORMAT_BC2_SRGB_BLOCK:
            return angle::FormatID::BC2_RGBA_UNORM_SRGB_BLOCK;
        case VK_FORMAT_BC3_UNORM_BLOCK:
            return angle::FormatID::BC3_RGBA_UNORM_BLOCK;
        case VK_FORMAT_BC3_SRGB_BLOCK:
            return angle::FormatID::BC3_RGBA_UNORM_SRGB_BLOCK;
        case VK_FORMAT_BC4_SNORM_BLOCK:
            return angle::FormatID::BC4_RED_SNORM_BLOCK;
        case VK_FORMAT_BC4_UNORM_BLOCK:
            return angle::FormatID::BC4_RED_UNORM_BLOCK;
        case VK_FORMAT_BC5_SNORM_BLOCK:
            return angle::FormatID::BC5_RG_SNORM_BLOCK;
        case VK_FORMAT_BC5_UNORM_BLOCK:
            return angle::FormatID::BC5_RG_UNORM_BLOCK;
        case VK_FORMAT_BC6H_SFLOAT_BLOCK:
            return angle::FormatID::BC6H_RGB_SFLOAT_BLOCK;
        case VK_FORMAT_BC6H_UFLOAT_BLOCK:
            return angle::FormatID::BC6H_RGB_UFLOAT_BLOCK;
        case VK_FORMAT_BC7_UNORM_BLOCK:
            return angle::FormatID::BC7_RGBA_UNORM_BLOCK;
        case VK_FORMAT_BC7_SRGB_BLOCK:
            return angle::FormatID::BC7_RGBA_UNORM_SRGB_BLOCK;
        case VK_FORMAT_D16_UNORM:
            return angle::FormatID::D16_UNORM;
        case VK_FORMAT_D24_UNORM_S8_UINT:
            return angle::FormatID::D24_UNORM_S8_UINT;
        case VK_FORMAT_X8_D24_UNORM_PACK32:
            return angle::FormatID::D24_UNORM_X8_UINT;
        case VK_FORMAT_D32_SFLOAT:
            return angle::FormatID::D32_FLOAT;
        case VK_FORMAT_D32_SFLOAT_S8_UINT:
            return angle::FormatID::D32_FLOAT_S8X24_UINT;
        case VK_FORMAT_EAC_R11G11_SNORM_BLOCK:
            return angle::FormatID::EAC_R11G11_SNORM_BLOCK;
        case VK_FORMAT_EAC_R11G11_UNORM_BLOCK:
            return angle::FormatID::EAC_R11G11_UNORM_BLOCK;
        case VK_FORMAT_EAC_R11_SNORM_BLOCK:
            return angle::FormatID::EAC_R11_SNORM_BLOCK;
        case VK_FORMAT_EAC_R11_UNORM_BLOCK:
            return angle::FormatID::EAC_R11_UNORM_BLOCK;
        case VK_FORMAT_ETC2_R8G8B8A1_SRGB_BLOCK:
            return angle::FormatID::ETC2_R8G8B8A1_SRGB_BLOCK;
        case VK_FORMAT_ETC2_R8G8B8A1_UNORM_BLOCK:
            return angle::FormatID::ETC2_R8G8B8A1_UNORM_BLOCK;
        case VK_FORMAT_ETC2_R8G8B8A8_SRGB_BLOCK:
            return angle::FormatID::ETC2_R8G8B8A8_SRGB_BLOCK;
        case VK_FORMAT_ETC2_R8G8B8A8_UNORM_BLOCK:
            return angle::FormatID::ETC2_R8G8B8A8_UNORM_BLOCK;
        case VK_FORMAT_ETC2_R8G8B8_SRGB_BLOCK:
            return angle::FormatID::ETC2_R8G8B8_SRGB_BLOCK;
        case VK_FORMAT_ETC2_R8G8B8_UNORM_BLOCK:
            return angle::FormatID::ETC2_R8G8B8_UNORM_BLOCK;
        case VK_FORMAT_G8_B8R8_2PLANE_420_UNORM:
            return angle::FormatID::G8_B8R8_2PLANE_420_UNORM;
        case VK_FORMAT_G8_B8_R8_3PLANE_420_UNORM:
            return angle::FormatID::G8_B8_R8_3PLANE_420_UNORM;
        case VK_FORMAT_UNDEFINED:
            return angle::FormatID::NONE;
        case VK_FORMAT_A2B10G10R10_SINT_PACK32:
            return angle::FormatID::R10G10B10A2_SINT;
        case VK_FORMAT_A2B10G10R10_SNORM_PACK32:
            return angle::FormatID::R10G10B10A2_SNORM;
        case VK_FORMAT_A2B10G10R10_SSCALED_PACK32:
            return angle::FormatID::R10G10B10A2_SSCALED;
        case VK_FORMAT_A2B10G10R10_UINT_PACK32:
            return angle::FormatID::R10G10B10A2_UINT;
        case VK_FORMAT_A2B10G10R10_UNORM_PACK32:
            return angle::FormatID::R10G10B10A2_UNORM;
        case VK_FORMAT_A2B10G10R10_USCALED_PACK32:
            return angle::FormatID::R10G10B10A2_USCALED;
        case VK_FORMAT_B10G11R11_UFLOAT_PACK32:
            return angle::FormatID::R11G11B10_FLOAT;
        case VK_FORMAT_R16G16B16A16_SFLOAT:
            return angle::FormatID::R16G16B16A16_FLOAT;
        case VK_FORMAT_R16G16B16A16_SINT:
            return angle::FormatID::R16G16B16A16_SINT;
        case VK_FORMAT_R16G16B16A16_SNORM:
            return angle::FormatID::R16G16B16A16_SNORM;
        case VK_FORMAT_R16G16B16A16_SSCALED:
            return angle::FormatID::R16G16B16A16_SSCALED;
        case VK_FORMAT_R16G16B16A16_UINT:
            return angle::FormatID::R16G16B16A16_UINT;
        case VK_FORMAT_R16G16B16A16_UNORM:
            return angle::FormatID::R16G16B16A16_UNORM;
        case VK_FORMAT_R16G16B16A16_USCALED:
            return angle::FormatID::R16G16B16A16_USCALED;
        case VK_FORMAT_R16G16B16_SFLOAT:
            return angle::FormatID::R16G16B16_FLOAT;
        case VK_FORMAT_R16G16B16_SINT:
            return angle::FormatID::R16G16B16_SINT;
        case VK_FORMAT_R16G16B16_SNORM:
            return angle::FormatID::R16G16B16_SNORM;
        case VK_FORMAT_R16G16B16_SSCALED:
            return angle::FormatID::R16G16B16_SSCALED;
        case VK_FORMAT_R16G16B16_UINT:
            return angle::FormatID::R16G16B16_UINT;
        case VK_FORMAT_R16G16B16_UNORM:
            return angle::FormatID::R16G16B16_UNORM;
        case VK_FORMAT_R16G16B16_USCALED:
            return angle::FormatID::R16G16B16_USCALED;
        case VK_FORMAT_R16G16_SFLOAT:
            return angle::FormatID::R16G16_FLOAT;
        case VK_FORMAT_R16G16_SINT:
            return angle::FormatID::R16G16_SINT;
        case VK_FORMAT_R16G16_SNORM:
            return angle::FormatID::R16G16_SNORM;
        case VK_FORMAT_R16G16_SSCALED:
            return angle::FormatID::R16G16_SSCALED;
        case VK_FORMAT_R16G16_UINT:
            return angle::FormatID::R16G16_UINT;
        case VK_FORMAT_R16G16_UNORM:
            return angle::FormatID::R16G16_UNORM;
        case VK_FORMAT_R16G16_USCALED:
            return angle::FormatID::R16G16_USCALED;
        case VK_FORMAT_R16_SFLOAT:
            return angle::FormatID::R16_FLOAT;
        case VK_FORMAT_R16_SINT:
            return angle::FormatID::R16_SINT;
        case VK_FORMAT_R16_SNORM:
            return angle::FormatID::R16_SNORM;
        case VK_FORMAT_R16_SSCALED:
            return angle::FormatID::R16_SSCALED;
        case VK_FORMAT_R16_UINT:
            return angle::FormatID::R16_UINT;
        case VK_FORMAT_R16_UNORM:
            return angle::FormatID::R16_UNORM;
        case VK_FORMAT_R16_USCALED:
            return angle::FormatID::R16_USCALED;
        case VK_FORMAT_R32G32B32A32_SFLOAT:
            return angle::FormatID::R32G32B32A32_FLOAT;
        case VK_FORMAT_R32G32B32A32_SINT:
            return angle::FormatID::R32G32B32A32_SINT;
        case VK_FORMAT_R32G32B32A32_UINT:
            return angle::FormatID::R32G32B32A32_UINT;
        case VK_FORMAT_R32G32B32_SFLOAT:
            return angle::FormatID::R32G32B32_FLOAT;
        case VK_FORMAT_R32G32B32_SINT:
            return angle::FormatID::R32G32B32_SINT;
        case VK_FORMAT_R32G32B32_UINT:
            return angle::FormatID::R32G32B32_UINT;
        case VK_FORMAT_R32G32_SFLOAT:
            return angle::FormatID::R32G32_FLOAT;
        case VK_FORMAT_R32G32_SINT:
            return angle::FormatID::R32G32_SINT;
        case VK_FORMAT_R32G32_UINT:
            return angle::FormatID::R32G32_UINT;
        case VK_FORMAT_R32_SFLOAT:
            return angle::FormatID::R32_FLOAT;
        case VK_FORMAT_R32_SINT:
            return angle::FormatID::R32_SINT;
        case VK_FORMAT_R32_UINT:
            return angle::FormatID::R32_UINT;
        case VK_FORMAT_R4G4B4A4_UNORM_PACK16:
            return angle::FormatID::R4G4B4A4_UNORM;
        case VK_FORMAT_R5G5B5A1_UNORM_PACK16:
            return angle::FormatID::R5G5B5A1_UNORM;
        case VK_FORMAT_R5G6B5_UNORM_PACK16:
            return angle::FormatID::R5G6B5_UNORM;
        case VK_FORMAT_R8G8B8A8_SINT:
            return angle::FormatID::R8G8B8A8_SINT;
        case VK_FORMAT_R8G8B8A8_SNORM:
            return angle::FormatID::R8G8B8A8_SNORM;
        case VK_FORMAT_R8G8B8A8_SSCALED:
            return angle::FormatID::R8G8B8A8_SSCALED;
        case VK_FORMAT_R8G8B8A8_UINT:
            return angle::FormatID::R8G8B8A8_UINT;
        case VK_FORMAT_R8G8B8A8_UNORM:
            return angle::FormatID::R8G8B8A8_UNORM;
        case VK_FORMAT_R8G8B8A8_SRGB:
            return angle::FormatID::R8G8B8A8_UNORM_SRGB;
        case VK_FORMAT_R8G8B8A8_USCALED:
            return angle::FormatID::R8G8B8A8_USCALED;
        case VK_FORMAT_R8G8B8_SINT:
            return angle::FormatID::R8G8B8_SINT;
        case VK_FORMAT_R8G8B8_SNORM:
            return angle::FormatID::R8G8B8_SNORM;
        case VK_FORMAT_R8G8B8_SSCALED:
            return angle::FormatID::R8G8B8_SSCALED;
        case VK_FORMAT_R8G8B8_UINT:
            return angle::FormatID::R8G8B8_UINT;
        case VK_FORMAT_R8G8B8_UNORM:
            return angle::FormatID::R8G8B8_UNORM;
        case VK_FORMAT_R8G8B8_SRGB:
            return angle::FormatID::R8G8B8_UNORM_SRGB;
        case VK_FORMAT_R8G8B8_USCALED:
            return angle::FormatID::R8G8B8_USCALED;
        case VK_FORMAT_R8G8_SINT:
            return angle::FormatID::R8G8_SINT;
        case VK_FORMAT_R8G8_SNORM:
            return angle::FormatID::R8G8_SNORM;
        case VK_FORMAT_R8G8_SSCALED:
            return angle::FormatID::R8G8_SSCALED;
        case VK_FORMAT_R8G8_UINT:
            return angle::FormatID::R8G8_UINT;
        case VK_FORMAT_R8G8_UNORM:
            return angle::FormatID::R8G8_UNORM;
        case VK_FORMAT_R8G8_SRGB:
            return angle::FormatID::R8G8_UNORM_SRGB;
        case VK_FORMAT_R8G8_USCALED:
            return angle::FormatID::R8G8_USCALED;
        case VK_FORMAT_R8_SINT:
            return angle::FormatID::R8_SINT;
        case VK_FORMAT_R8_SNORM:
            return angle::FormatID::R8_SNORM;
        case VK_FORMAT_R8_SSCALED:
            return angle::FormatID::R8_SSCALED;
        case VK_FORMAT_R8_UINT:
            return angle::FormatID::R8_UINT;
        case VK_FORMAT_R8_UNORM:
            return angle::FormatID::R8_UNORM;
        case VK_FORMAT_R8_SRGB:
            return angle::FormatID::R8_UNORM_SRGB;
        case VK_FORMAT_R8_USCALED:
            return angle::FormatID::R8_USCALED;
        case VK_FORMAT_E5B9G9R9_UFLOAT_PACK32:
            return angle::FormatID::R9G9B9E5_SHAREDEXP;
        case VK_FORMAT_S8_UINT:
            return angle::FormatID::S8_UINT;

        default:
            UNREACHABLE();
            return angle::FormatID::NONE;
    }
}
}  // namespace vk
}  // namespace rx
