/*
 * Decompiled with CFR 0.152.
 */
package cds.healpix.common.sphgeom;

import cds.healpix.Healpix;
import cds.healpix.common.math.Math;
import cds.healpix.common.sphgeom.Cone;
import cds.healpix.common.sphgeom.Vect3D;
import java.util.Random;

public class CooXYZ {
    private final double lon;
    private final double lat;
    private final double x;
    private final double y;
    private final double z;
    private static final double R_MAX = Healpix.SMALLER_EDGE2OPEDGE_DIST[0];
    private static volatile Random r;

    public CooXYZ(double lonRad, double latRad) {
        double cosDec = Math.cos(latRad);
        this.x = cosDec * Math.cos(lonRad);
        this.y = cosDec * Math.sin(lonRad);
        this.z = Math.sin(latRad);
        if (Math.abs(latRad) > 1.5707963267948966 || lonRad < 0.0 || lonRad >= java.lang.Math.PI * 2) {
            double tmp = Math.atan2(this.y, this.x);
            this.lon = tmp < 0.0 ? java.lang.Math.PI * 2 + tmp : tmp;
            this.lat = Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y));
        } else {
            this.lon = lonRad;
            this.lat = latRad;
        }
    }

    public CooXYZ(double x, double y, double z) {
        this.x = x;
        this.y = y;
        this.z = z;
        double tmp = Math.atan2(this.y, this.x);
        this.lon = tmp < 0.0 ? java.lang.Math.PI * 2 + tmp : tmp;
        this.lat = Math.atan2(this.z, Math.sqrt(this.x * this.x + this.y * this.y));
    }

    public CooXYZ(Vect3D v) {
        this(v.x(), v.y(), v.z());
    }

    public static CooXYZ toEquaCooXYZ(CooXYZ pos) {
        return new CooXYZ(pos.lon(), pos.lat());
    }

    public final double lon() {
        return this.lon;
    }

    public final double lat() {
        return this.lat;
    }

    public final double x() {
        return this.x;
    }

    public final double y() {
        return this.y;
    }

    public final double z() {
        return this.z;
    }

    public static CooXYZ normalizedSum(CooXYZ ... vects) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (CooXYZ v : vects) {
            x += v.x;
            y += v.y;
            z += v.z;
        }
        double norm = Math.sqrt(x * x + y * y + z * z);
        return new CooXYZ(x / norm, y / norm, z / norm);
    }

    public static Vect3D crossProd(CooXYZ v1, CooXYZ v2) {
        return new Vect3D(v1.y * v2.z - v1.z * v2.y, v1.z * v2.x - v1.x * v2.z, v1.x * v2.y - v1.y * v2.x);
    }

    public double scalarProd(Vect3D v) {
        return this.x * v.x() + this.y * v.y() + this.z * v.z();
    }

    public double scalarProd(CooXYZ v) {
        return this.x * v.x + this.y * v.y + this.z * v.z;
    }

    public static final double havDist(CooXYZ c1, CooXYZ c2) {
        double d = Math.sin(0.5 * (c2.lat() - c1.lat()));
        double a = Math.sin(0.5 * (c2.lon() - c1.lon()));
        double h3 = d * d + a * a * Math.cos(c2.lat()) * Math.cos(c1.lat());
        return 2.0 * Math.asin(Math.sqrt(h3));
    }

    public static final double spheDist(CooXYZ c1, CooXYZ c2) {
        return 2.0 * Math.asin(0.5 * CooXYZ.euclDist(c1, c2));
    }

    public static final double euclDist(CooXYZ c1, CooXYZ c2) {
        double d = 0.0;
        double tmp = c2.x() - c1.x();
        d += tmp * tmp;
        tmp = c2.y() - c1.y();
        d += tmp * tmp;
        tmp = c2.z() - c1.z();
        return Math.sqrt(d += tmp * tmp);
    }

    public String toString() {
        return "lon: " + this.lon + "; lat: " + this.lat + "; " + this.x + "," + this.y + "," + this.z;
    }

    public static Cone boundingCone(CooXYZ ... p) {
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (CooXYZ coo : p) {
            x += coo.x;
            y += coo.y;
            z += coo.z;
        }
        double norm = java.lang.Math.sqrt((x /= (double)p.length) * x + (y /= (double)p.length) * y + (z /= (double)p.length) * z);
        CooXYZ center = new CooXYZ(x / norm, y / norm, z / norm);
        double dmax = 0.0;
        CooXYZ furthest = null;
        for (CooXYZ coo : p) {
            double d = CooXYZ.euclDist(center, coo);
            if (!(d > dmax)) continue;
            dmax = d;
            furthest = coo;
        }
        return new Cone(center, CooXYZ.spheDist(center, furthest));
    }

    public static Cone mec(CooXYZ a, CooXYZ b) {
        double r = 0.5 * CooXYZ.spheDist(a, b);
        return new Cone(CooXYZ.arcCenter(a, b), r);
    }

    public static Cone mec(CooXYZ a, CooXYZ b, CooXYZ c) {
        Cone cone;
        boolean only2points;
        boolean bl;
        CooXYZ centerPos;
        double dc;
        double da = CooXYZ.spheDist(b, c);
        double db = CooXYZ.spheDist(a, c);
        double r = dc = CooXYZ.spheDist(a, b);
        if (da > db && da > dc) {
            CooXYZ cooXYZ;
            double d;
            r = 0.5 * da;
            centerPos = CooXYZ.arcCenter(b, c, r);
            bl = d >= CooXYZ.spheDist(cooXYZ, a);
        } else if (db > dc) {
            CooXYZ cooXYZ;
            double d;
            r = 0.5 * db;
            centerPos = CooXYZ.arcCenter(a, c, r);
            bl = d >= CooXYZ.spheDist(cooXYZ, b);
        } else {
            CooXYZ cooXYZ;
            double d;
            r = 0.5 * dc;
            centerPos = CooXYZ.arcCenter(a, b, r);
            bl = only2points = d >= CooXYZ.spheDist(cooXYZ, c);
        }
        if (only2points) {
            cone = new Cone(centerPos, r);
        } else {
            r = CooXYZ.circumRadiusSphe(da, db, dc);
            Cone cone2 = new Cone(CooXYZ.circumCenter(a, b, c, r), r);
            cone = cone2;
        }
        return cone;
    }

    public static Cone mec(CooXYZ ... p) {
        Cone cone = null;
        switch (p.length) {
            case 0: {
                break;
            }
            case 1: {
                cone = new Cone(p[0], 0.0);
                break;
            }
            case 2: {
                double r = 0.5 * CooXYZ.spheDist(p[0], p[1]);
                cone = new Cone(CooXYZ.arcCenter(p[0], p[1]), r);
                break;
            }
            case 3: {
                CooXYZ ctmp;
                CooXYZ a = p[0];
                CooXYZ b = p[1];
                CooXYZ c = p[2];
                double da = CooXYZ.spheDist(b, c);
                double db = CooXYZ.spheDist(a, c);
                double dc = CooXYZ.spheDist(a, b);
                if (da > db && da > dc) {
                    ctmp = a;
                    double dtmp = da;
                    a = c;
                    da = dc;
                    c = ctmp;
                    dc = dtmp;
                } else if (db > dc) {
                    ctmp = b;
                    double dtmp = db;
                    b = c;
                    db = dc;
                    c = ctmp;
                    dc = dtmp;
                }
                double r = 0.5 * dc;
                CooXYZ centerPos = CooXYZ.arcCenter(a, b, r);
                if (CooXYZ.spheDist(c, centerPos) <= r) {
                    cone = new Cone(centerPos, r);
                    break;
                }
                r = CooXYZ.circumRadiusSphe(da, db, dc);
                cone = new Cone(CooXYZ.circumCenter(a, b, c, r), r);
                break;
            }
            default: {
                cone = CooXYZ.minSphericalCircle((CooXYZ[])p.clone());
            }
        }
        return cone;
    }

    public static final double circumRadiusSphe(double a, double b, double c) {
        double sinas2 = Math.sin(0.5 * a);
        double sinbs2 = Math.sin(0.5 * b);
        double sincs2 = Math.sin(0.5 * c);
        double n = sinas2 * sinbs2 * sincs2;
        double d = (sinas2 + sinbs2 + sincs2) * (sinas2 + sinbs2 - sincs2) * (sinas2 - sinbs2 + sincs2) * (sinbs2 + sincs2 - sinas2);
        return Math.asin(Math.sqrt(4.0 * n * n / d));
    }

    public static final double circumRadiusSphe(CooXYZ a, CooXYZ b, CooXYZ c) {
        double da = CooXYZ.spheDist(b, c);
        double db = CooXYZ.spheDist(a, c);
        double dc = CooXYZ.spheDist(a, b);
        return CooXYZ.circumRadiusSphe(da, db, dc);
    }

    public static final CooXYZ circumCenter(CooXYZ a, CooXYZ b, CooXYZ c) {
        return CooXYZ.circumCenter(a, b, c, CooXYZ.circumRadiusSphe(a, b, c));
    }

    public static final CooXYZ circumCenter(CooXYZ a, CooXYZ b, CooXYZ c, double r) {
        double e = 1.0 - 0.5 * r * r;
        double d = a.x() * (b.y() * c.z() - c.y() * b.z()) - b.x() * (a.y() * c.z() - c.y() * a.z()) + c.x() * (a.y() * b.z() - b.y() * a.z());
        double x = b.y() * c.z() - c.y() * b.z() - (a.y() * c.z() - c.y() * a.z()) + (a.y() * b.z() - b.y() * a.z());
        double y = a.x() * (c.z() - b.z()) - b.x() * (c.z() - a.z()) + c.x() * (b.z() - a.z());
        double z = a.x() * (b.y() - c.y()) - b.x() * (a.y() - c.y()) + c.x() * (a.y() - b.y());
        return new CooXYZ(e * x / d, e * y / d, e * z / d);
    }

    public static final CooXYZ arcCenter(CooXYZ a, CooXYZ b) {
        return CooXYZ.arcCenter(a, b, 0.5 * CooXYZ.spheDist(a, b));
    }

    public static final CooXYZ arcCenter(CooXYZ a, CooXYZ b, double r) {
        double e = 1.0 - 0.5 * r * r;
        double e3 = 0.0;
        double x13 = a.y() * b.z() - a.z() * b.y();
        double x23 = a.z() * b.x() - a.x() * b.z();
        double x33 = a.x() * b.y() - a.y() * b.x();
        double d = a.x() * (b.y() * x33 - x23 * b.z()) - b.x() * (a.y() * x33 - x23 * a.z()) + x13 * (a.y() * b.z() - b.y() * a.z());
        double x = e * (b.y() * x33 - x23 * b.z()) - e * (a.y() * x33 - x23 * a.z()) + 0.0 * (a.y() * b.z() - b.y() * a.z());
        double y = a.x() * (e * x33 - 0.0 * b.z()) - b.x() * (e * x33 - 0.0 * a.z()) + x13 * (e * b.z() - e * a.z());
        double z = a.x() * (b.y() * 0.0 - x23 * e) - b.x() * (a.y() * 0.0 - x23 * e) + x13 * (a.y() * e - b.y() * e);
        return new CooXYZ(x / d, y / d, z / d);
    }

    private static Cone minSphericalCircle(CooXYZ[] p) {
        CooXYZ.shuffle(p, 0, p.length);
        double r = 0.5 * CooXYZ.spheDist(p[0], p[1]);
        if (r > R_MAX) {
            return null;
        }
        Cone c = new Cone(CooXYZ.arcCenter(p[0], p[1]), r);
        for (int i = 2; i < p.length; ++i) {
            if (c.contains(p[i])) continue;
            CooXYZ.shuffle(p, 0, i);
            r = 0.5 * CooXYZ.spheDist(p[0], p[i]);
            if (r > R_MAX) {
                return null;
            }
            c = new Cone(CooXYZ.arcCenter(p[0], p[i]), r);
            for (int j = 1; j < i; ++j) {
                if (c.contains(p[j])) continue;
                CooXYZ.shuffle(p, 0, j);
                r = 0.5 * CooXYZ.spheDist(p[j], p[i]);
                if (r > R_MAX) {
                    return null;
                }
                c = new Cone(CooXYZ.arcCenter(p[j], p[i]), r);
                for (int k = 0; k < j; ++k) {
                    if (c.contains(p[k]) || !((r = (c = CooXYZ.mec(p[k], p[j], p[i])).radiusRad()) > R_MAX)) continue;
                    return null;
                }
            }
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private static final void shuffle(Object[] a, int from, int to) {
        Random rnd = r;
        if (rnd == null) {
            Class<CooXYZ> clazz = CooXYZ.class;
            // MONITORENTER : cds.healpix.common.sphgeom.CooXYZ.class
            r = rnd = new Random();
            // MONITOREXIT : clazz
        }
        int i = to - from;
        while (i > 1) {
            CooXYZ.swap(a, rnd.nextInt(i + from), --i + from);
        }
    }

    private static void swap(Object[] a, int i, int j) {
        Object tmp = a[i];
        a[i] = a[j];
        a[j] = tmp;
    }
}

