package net.crystallography.helpers.cdk;

import org.junit.Test;
import org.openscience.cdk.Crystal;
import org.openscience.cdk.interfaces.ICrystal;
import org.openscience.cdk.silent.Atom;
import org.openscience.cdk.silent.AtomContainer;

import javax.vecmath.Point3d;
import javax.vecmath.Vector3d;

import static net.crystallography.helpers.cdk.OrthogonaliseAtomCoordinates.computeOrthogonalCoordinates;
import static org.junit.Assert.*;

public class OrthogonaliseAtomCoordinatesTest {

    private static final double[][] coordinates =
            new double[][] {
                    new double[] { 0.3, 0.2, 0.1 },
                    new double[] { 0.2, 0.4, 0.1 },
                    new double[] { 0.0, 0.2, 0.5 },
            };

    @Test
    public void computeOrthogonalCoordinatesTest() throws Exception {
        ICrystal crystal = new Crystal();
        crystal.setA(new Vector3d(1,2,3));
        crystal.setB(new Vector3d(3,4,3));
        crystal.setC(new Vector3d(2,1,1));

        AtomContainer ac = new AtomContainer();
        for( int i = 0; i < coordinates.length; i++ ) {
            Atom a = new Atom("C");
            a.setFractionalPoint3d(new Point3d(coordinates[i]));
            ac.addAtom(a);
        }
        crystal.add(new AtomContainer(ac));

        computeOrthogonalCoordinates(crystal);

        Point3d xyz = crystal.getAtom(0).getPoint3d();
        assertEquals(1.1, xyz.x, 1E-10);
        assertEquals(1.5, xyz.y, 1E-10);
        assertEquals(1.6, xyz.z, 1E-10);

        xyz = crystal.getAtom(1).getPoint3d();
        assertEquals(1.6, xyz.x, 1E-10);
        assertEquals(2.1, xyz.y, 1E-10);
        assertEquals(1.9, xyz.z, 1E-10);

        xyz = crystal.getAtom(2).getPoint3d();
        assertEquals(1.6, xyz.x, 1E-10);
        assertEquals(1.3, xyz.y, 1E-10);
        assertEquals(1.1, xyz.z, 1E-10);
    }

}