# Sensors

Sensor objects provide information about the SimpliSafe™ sensors to which they relate.

Like their {meth}`System <simplipy.system.System>` cousins, two types of objects can be
returned:

- {meth}`SensorV2 <simplipy.sensor.v2.SensorV2>`: an object to view V2 (classic)
  SimpliSafe™ sensors
- {meth}`SensorV3 <simplipy.sensor.v3.SensorV3>`: an object to view V3 (new, released in
  2018\) SimpliSafe™ sensors

Once again, `simplipy` provides a common interface to
these objects; however, there are some properties that are either (a) specific
to one version or (b) return a different meaning based on the version. These
differences are outlined below.

## Core Properties

All `Sensor` objects come with a standard set of properties

```python
for serial, sensor in system.sensors.items():
    # Return the sensor's name:
    sensor.name
    # >>> Kitchen Window

    # Return the sensor's serial number through the index:
    serial
    # >>> 1234ABCD

    # ...or through the property:
    sensor.serial
    # >>> 1234ABCD

    # Return the sensor's type:
    sensor.type
    # >>> simplipy.DeviceTypes.GLASS_BREAK

    # Return whether the sensor is in an error state:
    sensor.error
    # >>> False

    # Return whether the sensor has a low battery:
    sensor.low_battery
    # >>> False

    # Return whether the sensor has been triggered
    # (open/closed, etc.):
    sensor.triggered
    # >>> False
```

## V2 Properties

```python
# Return the sensor's data as a currently
# non-understood integer:
sensor.data
# >>> 0

# Return the sensor's settings as a currently
# non-understood integer:
sensor.settings
# >>> 1
```

## V3 Properties

```python
# Return whether the sensor is offline:
sensor.offline
# >>> False

# Return a settings dictionary for the sensor:
sensor.settings
# >>> {"instantTrigger": False, "away2": 1, "away": 1, ...}

# For temperature sensors, return the current temperature:
sensor.temperature
# >>> 67
```

## Updating the Sensor

To retrieve the sensor's latest state/properties/etc., simply:

```python
await sensor.async_update(cached=True)
```
