/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 */

#ifndef STATICDATA_H
#define STATICDATA_H

const char *locationDirNotVisited_EN[] = {
	"Lab", "Path", "Outside", "Pothole", "Palace Hallway",
	"Door", "Secret Passage", "Doorway", "Doorway", "DUMMY",
	"Path", "Shop", "Shop", "Shop", "Shop",
	"Path", "Malevolated Countryside", "Malevolated Countryside", "Entrance", "Entrance",
	"Path", "Path", "Central Zanydu", "Lower Zanydu", "Wacme Entrance",
	"Upper Zanydu", "Entrance", "Entrance", "Path", "Path",
	"Path", "Seedy's", "Entrance", "Entrance", "Path",
	"DUMMY", "DUMMY", "Dungeon", "Hallway", "Air Vent",
	"Upstairs", "Doorway", "Doorway", "Downstairs", "Rec Room",
	"Doorway", "Secret Passageway", "Upstairs", "Upstairs", "Up",
	"Doorway", "Upstairs", "Doorway", "Doorway", "Doorway",
	"Swamp", "Forest", "Meadow", "Farmland", "Main Street",
	"Costume Shop", "Shuttle Station", "Central Zanydu", "Upper North-Southeast Zanydu", "Lower South-Northwest Zanydu",
	"Way-Outback", "High Road", "Frank's Lab", "Cryo-Crypt", "Fantasyworld",
	"Vulture Falls", "Vulture Falls", "Vincent van Gogh's Studio", "Fearworld", "Attic",
	"Unorthodontist's Office", "Bedroom", "The Malevolands", "Inhuman Robots, Inc.", "Inhuman Robots, Inc. Workshop",
	"The End of the World", "Castle Ramparts", "Castle Top", "Kitchen", "Living Room",
	"Bedroom", "Laboratory", "Storage Center First Floor", "Storage Center Second Floor", "Storage Center Third Floor",
	"King Hugh's Palace", "Trophy Room", "Hallway", "Hallway", "Throne Room",
	"Office", "Balcony", "Lighthouse", "Bedroom", "Hall of Reflection",
	"Seedy's", "Barn", "WACME", "Lab"
};

const char *locationDirNotVisited_FR[] = {
	"Labo", "Chemin", "Ext\351rieur", "Trou", "Hall du Palais",
	"Porte", "Passage Secret", "Porte", "Porte", "DUMMY",
	"Chemin", "Boutique", "Boutique", "Boutique", "Boutique",
	"Chemin", "Champ perfidifi\351", "Champ perfidifi\351", "Entr\351e", "Entr\351e",
	"Chemin", "Chemin", "Zanydu-Centre", "Bas de Zanydu", "Entr\351e des 3 Belges",
	"Hauts de Zanydu", "Entr\351e", "Entr\351e", "Chemin", "Chemin",
	"Chemin", "Bouling", "Entr\351e", "Entr\351e", "Chemin",
	"DUMMY", "DUMMY", "Donjon", "Hall", "Conduit d'a\351ration",
	"Etage sup\351rieur", "Porte", "Porte", "Etage inf\351rieur", "Salle de jeux",
	"Porte", "Passage Secret", "Etage sup\351rieur", "Etage sup\351rieur", "Vers le haut",
	"Porte", "Etage sup\351rieur", "Porte", "Porte", "Porte",
	"Mar\351cage", "For\352t", "Prairie", "Champ", "Rue Principale",
	"Boutique de costumes", "Gare Navette", "Zanydu-Centre", "Hauts de Zanydu Sud-Est du Nord", "Bas de Zanydu Nord-Ouest du Sud",
	"Lointain lointain", "High Road", "Labo de Frank", "Cryo-Crypt", "Fantasyworld",
	"Vulture Falls", "Vulture Falls", "Vincent van Gogh's Studio", "Fearworld", "Grenier",
	"Unorthodontist's Office", "Chambre", "Perfidia", "Robots Inhumains SARL", "Robots Inhumains SARL. Atelier",
	"La Fin du Monde", "Remparts du ch\342teau", "Castle Top", "Cuisine", "Salon",
	"Chambre", "Laboratoire", "Storage Center First Floor", "Storage Center Second Floor", "Storage Center Third Floor",
	"Ch\342teau de Hilarius 1er", "Salle des Troph\351es", "Hall", "Hall", "Salle du Tr\364ne",
	"Bureau", "Balcon", "Lighthouse", "Chambre", "Hall of Reflection",
	"Bouling", "Grange", "LES 3 BELGES", "Labo"
};

const char *locationDirNotVisited_DE[] = {
	"Labor", "Weg", "Drau\337en", "Schlagloch", "Palastflur",
	"T\374r", "Geheimgang", "T\374r", "T\374r", "DUMMY",
	"Weg", "Laden", "Laden", "Laden", "Laden",
	"Weg", "\334belierte Landschaft", "\334belierte Landschaft", "Eingang", "Eingang",
	"Weg", "Weg", "Mittel-Trickreich", "Nieder-Trickreich", "Eingang der Fa. Wacme",
	"Ober-Trickreich", "Eingang", "Eingang", "Weg", "Weg",
	"Weg", "Seedys", "Eingang", "Eingang", "Weg",
	"DUMMY", "DUMMY", "Kerker", "Flur", "Luftschacht",
	"Nach oben", "T\374r", "T\374r", "Nach unten", "Ruheraum",
	"T\374r", "Geheimgang", "Nach oben", "Nach oben", "Rauf",
	"T\374r", "Nach oben", "T\374r", "T\374r", "T\374r",
	"Sumpf", "Wald", "Wiese", "Ackerland", "Hauptstra\337e",
	"Kost\374mverleih", "Bahnhaltestelle", "Mittel-Trickreich", "Ober-Nord-S\374dost-Trickreich", "Unteres S\374d-Nordwest-Trickreich",
	"Weite W\374ste Wildnis", "Hochstra\337e", "Franks Labor", "K\344lteschlafkammer", "Phantasiawelt",
	"Geierf\344lle", "Geierf\344lle", "Vincent van Goghs Studio", "Angstwelt", "Dachboden",
	"Praxis des Unorthodontisten", "Schlafzimmer", "Das \334beland", "Unmenschliche Roboter AG", "Unmenschliche Roboter AG - Werkstatt",
	"Das Ende der Welt", "Schlo\337w\344lle", "Oberer Teil des Schlosses", "K\374che", "Wohnzimmer",
	"Schlafzimmer", "Labor", "Lager 1. Stock", "Lager 2. Stock", "Lager 3. Stock",
	"K\366nig Nicks Palast", "Pokalsaal", "Flur", "Flur", "Thronsaal",
	"B\374ro", "Balkon", "Leuchtturm", "Schlafzimmer", "Saal der Reflektion",
	"Seedys", "Scheune", "WACME", "Labor"
};

const char *locationDirNotVisited_RU[] = {
	"YBB", "Nelf", "Ds[jl", "Hsndbyf", "Dtcnb,.km",
	"D[jl", "Nfqysq ghj[jl", "Ghj[jl", "Ghj[jl", "VFRTN",
	"Nelf", "Ijg", "Ijg", "Ijg", "Ijg",
	"Nelf", "Bcrjdthrfyyfz ptvkz", "Bcrjdthrfyyfz ptvkz", "D[jl", "D[jl",
	"Nelf", "Nelf", "Wtynh", "Yb;yzz pjyf", "Gfhflysq d[jl",
	"Dth[yzz pjyf", "D[jl", "D[jl", "Nelf", "Nelf",
	"Nelf", "D[jl", "D[jl", "D[jl", "Nelf",
	"VFRTN", "VFRTN", "Gjldfk", "Rjhbljh", "Kfp",
	"Ddth[", "Ghj[jl", "Ghj[jl", "Dybp", "Buhjdfz",
	"Ghj[jl", "Nfqysq ghj[jl", "Ddth[", "Ddth[", "!",
	"Ghj[jl", "Ddth[", "Ghj[jl", "Ghj[jl", "Ghj[jl",
	"Njgm", "Ktc", "Keu", "Athvf", "Ghjcgtrn",
	"Jlt;lf", "Cnfywbz", "Wtynh", "Dth[ybq Ctdthj-.uj-djcnjr", "Yb;ybq >uj-ctdthj-pfgfl",
	"Jrhfbyf", "Ljhjuf", "Kf,jhfnjhbz", "Crktg", "Vbh Afynfpbq",
	"Cnthdjgfl", "Cnthdjgfl", "Cnelbz Dbyctynf dfy Ujuf", "Rjivfhbz", "Fnnbr",
	"Rf,bytn Ytjhnjljrcf", "Cgfkmyz", "Pkjdtybz", "FJPN +Ytuevfyjbl+", "Vfcnthcrfz FJPN +Ytuevfyjbl+",
	"Rhfq cdtnf", "Rhtgjcnyjq dfk", "<fiyz", "Re[yz", "Ujcnbyfz",
	"Cgfkmyz", "Rf,bytn", "Gthdsq 'nf; [hfybkbof", "Dnjhjq 'nf; [hfybkbof", "Nhtnbq 'nf; [hfybkbof",
	"Ldjhtw rjhjkz {m.", "Veptq", "Rjhbljh", "Rjhbljh", "Nhjyysq pfk",
	"Jabc", "<fkrjy", "Vfzr", "Cgfkmyz", "Rjvyfnf hfplevbq",
	"D[jl", "{ktd", "VJHLS", "YBB"
};

const char *locationDirNotVisited_SP[] = {
	"Laboratorio", "Camino", "Exterior", "Bache", "Vest\355bulo del Palacio",
	"Puerta", "Pasaje secreto", "Salida", "Salida", "Cosa extra\361a",
	"Camino", "Tienda", "Tienda", "Tienda", "Tienda",
	"Camino", "Paisaje malificado", "Paisaje malificado", "Entrada", "Entrada",
	"Camino", "Camino", "Centro de Loquilandia", "Loquilandia de Abajo", "Entrada a Wacme",
	"Loquilandia de arriba", "Entrada", "Entrada", "Camino", "Camino",
	"Camino", "Sady's", "Entrada", "Entrada", "Camino",
	"OBJETO EXTRA\321O", "OBJETO EXTRA\321O", "Mazmorra", "Vest\355bulo", "Conducto de la ventilaci\363n",
	"Planta alta", "Salida", "Salida", "Planta baja", "Sala de entretenimiento",
	"Salida", "Pasadizo secreto", "Planta alta", "Planta alta", "Arriba",
	"Salida", "Planta alta", "Salida", "Salida", "Salida",
	"Ci\351naga", "Bosque", "Pradera", "Tierras", "Calle principal",
	"Tienda de disfraces", "Estaci\363n del telecabina", "Centro de Loquilandia", "Norsudeste de Loquilandia de Arriba", "Surnoroeste de Loquilandia de Abajo",
	"Camino del interior", "Camino Real ", "Laboratorio de Frankestain", "Crio-Cripta", "Fantasilandia",
	"Salto del buitre", "Salto del buitre", "Estudio de Vincent van Gogh ", "Miedilandia", "Atico",
	"Despacho del Desortodoncista", "Dormitorio", "Malevolandia", "Robots Inhumanos, S.L.", "Robots Inhumanos, S.L. Taller",
	"El fin del mundo", "Murallas del castillo", "Parte alta del castillo", "Cocina", "Sala de estar",
	"Dormitorio", "Laboratorio", "Centro de almacenamiento del primer piso", "Centro de almacenamiento del segundo piso", "Centro de almacenamiento del tercer piso",
	"Palacio del Rey Hugo", "Sala de trofeos", "Vest\355bulo", "Vest\355bulo", "Sal\363n del trono",
	"Oficina", "Balc\363n", "Faro", "Dormitorio", "Sala de reflexi\363n",
	"Sady's", "Establo", "Wacme", "Laboratorio"
};

const char *locationDirNotVisited_HE[] = {
	"\xEE\xF2\xE1\xE3\xE4", "\xE3\xF8\xEA", "\xE4\xE7\xE5\xF6\xE4", "\xE1\xE5\xF8", "\xE4\xE9\xEB\xEC \xE4\xE0\xF8\xEE\xE5\xEF",
	"\xE3\xEC\xFA", "\xEE\xF2\xE1\xF8 \xF1\xFA\xF8\xE9\xED", "\xF4\xFA\xE7", "\xF4\xFA\xE7", "\xF1\xFA\xED",
	"\xE3\xF8\xEA", "\xE7\xF0\xE5\xFA", "\xE7\xF0\xE5\xFA", "\xE7\xF0\xE5\xFA", "\xE7\xF0\xE5\xFA",
	"\xE3\xF8\xEA", "\xEB\xF4\xF8 \xEE\xE5\xE6\xE3", "\xEB\xF4\xF8 \xEE\xE5\xE6\xE3", "\xEB\xF0\xE9\xF1\xE4", "\xEB\xF0\xE9\xF1\xE4",
	"\xE3\xF8\xEA", "\xE3\xF8\xEA", "\xEE\xF8\xEB\xE6 \xE6\xF0\xE9\xE3\xE5", "\xE6\xF0\xE9\xE3\xE5 \xFA\xE7\xFA\xE9\xFA", "\xE4\xEB\xF0\xE9\xF1\xE4 \xEC\xEB\xE5\xFA\xE5\xFA\xE9",
	"\xE6\xF0\xE9\xE3\xE5 \xF2\xE9\xEC\xE9\xFA", "\xEB\xF0\xE9\xF1\xE4", "\xEB\xF0\xE9\xF1\xE4", "\xE3\xF8\xEA", "\xE3\xF8\xEA",
	"\xE3\xF8\xEA", "\xF1\xE9\xE3\xE9", "\xEB\xF0\xE9\xF1\xE4", "\xEB\xF0\xE9\xF1\xE4", "\xE3\xF8\xEA",
	"\xF1\xFA\xED", "\xF1\xFA\xED", "\xF6\xE9\xF0\xE5\xF7", "\xE8\xF8\xF7\xEC\xE9\xEF", "\xFA\xF2\xEC\xFA \xE0\xE5\xE5\xF8\xE5\xF8",
	"\xEE\xF2\xEC\xE4 \xE4\xEE\xE3\xF8\xE2\xE5\xFA", "\xF4\xFA\xE7", "\xF4\xFA\xE7", "\xEE\xE5\xF8\xE3 \xE4\xEE\xE3\xF8\xE2\xE5\xFA", "\xE7\xE3\xF8 \xEE\xF9\xE7\xF7\xE9\xED",
	"\xF4\xFA\xE7", "\xEE\xF2\xE1\xF8 \xF1\xFA\xF8\xE9\xED", "\xEE\xF2\xEC\xE4 \xE4\xEE\xE3\xF8\xE2\xE5\xFA", "\xEE\xF2\xEC\xE4 \xE4\xEE\xE3\xF8\xE2\xE5\xFA", "\xEC\xEE\xF2\xEC\xE4",
	"\xF4\xFA\xE7", "\xEC\xEE\xF2\xEC\xE4", "\xF4\xFA\xE7", "\xF4\xFA\xE7", "\xF4\xFA\xE7",
	"\xE1\xE9\xF6\xE4", "\xE9\xF2\xF8", "\xE0\xE7\xE5", "\xE7\xE5\xE5\xE4", "\xF8\xE7\xE5\xE1 \xF8\xE0\xF9\xE9",
	"\xE7\xF0\xE5\xFA \xFA\xE7\xF4\xE5\xF9\xE5\xFA", "\xFA\xE7\xF0\xFA \xEE\xF2\xE1\xE5\xF8\xFA", "\xEE\xF8\xEB\xE6 \xE6\xF0\xE9\xE3\xE5", "\xF6\xF4\xE5\xEF-\xE3\xF8\xE5\xED-\xEE\xE6\xF8\xE7 \xE6\xF0\xE9\xE3\xE5 \xF2\xE9\xEC\xE9\xFA", "\xE3\xF8\xE5\xED-\xF6\xF4\xE5\xEF-\xEE\xF2\xF8\xE1 \xE6\xF0\xE9\xE3\xE5 \xFA\xE7\xFA\xE9\xFA",
	"\xEE\xEE\xF9-\xF0\xE9\xE3\xE7", "\xE3\xF8\xEA \xEE\xE4\xE9\xF8\xE4", "\xE4\xEE\xF2\xE1\xE3\xE4 \xF9\xEC \xF4\xF8\xF0\xF7", "\xE1\xE5\xF8-\xEB\xF4\xE5\xF8", "\xF2\xE5\xEC\xED \xE4\xF4\xF0\xE8\xE6\xE9\xE4",
	"\xEE\xF4\xEC\xE9 \xF0\xF9\xF8\xE9\xED", "\xEE\xF4\xEC\xE9 \xF0\xF9\xF8\xE9\xED", "\xE4\xF1\xE8\xE5\xE3\xE9\xE5 \xF9\xEC \xE5\xE9\xF0\xF1\xF0\xE8 \xE5\xE0\xEF \xE2\xE5\xEA", "\xF2\xE5\xEC\xED \xE4\xF4\xE7\xE3", "\xF2\xEC\xE9\xE9\xFA \xE4\xE2\xE2",
	"\xEE\xF9\xF8\xE3\xE5 \xF9\xEC \xEE\xF7\xE4\xE4 \xE4\xF9\xE9\xF0\xE9\xE9\xED", "\xE7\xE3\xF8 \xF9\xE9\xF0\xE4", "\xE6\xE3\xE5\xF0\xE9\xE4", "\xF8\xE5\xE1\xE5\xE8\xE9\xED \xE0\xEC-\xE0\xF0\xE5\xF9\xE9\xE9\xED \xE1\xF2\"\xEE", "\xE4\xF1\xE3\xF0\xE4 \xF9\xEC \xF8\xE5\xE1\xE5\xE8\xE9\xED \xE0\xEC-\xE0\xF0\xE5\xF9\xE9\xE9\xED \xE1\xF2\"\xEE",
	"\xF1\xE5\xF3 \xE4\xF2\xE5\xEC\xED", "\xE1\xE9\xF6\xE5\xF8\xE9 \xE4\xE8\xE9\xF8\xE4", "\xE2\xE2 \xE4\xE8\xE9\xF8\xE4", "\xEE\xE8\xE1\xE7", "\xF1\xEC\xE5\xEF",
	"\xE7\xE3\xF8 \xF9\xE9\xF0\xE4", "\xEE\xF2\xE1\xE3\xE4", "\xEE\xE7\xF1\xEF \xF7\xE5\xEE\xE4 \xF8\xE0\xF9\xE5\xF0\xE4", "\xEE\xE7\xF1\xEF \xF7\xE5\xEE\xE4 \xF9\xF0\xE9\xE4", "\xEE\xE7\xF1\xEF \xF7\xE5\xEE\xE4 \xF9\xEC\xE9\xF9\xE9\xFA",
	"\xE0\xF8\xEE\xE5\xEF \xE4\xEE\xEC\xEA \xF6\xE5\xEE\xE9", "\xE7\xE3\xF8 \xE4\xF4\xF8\xF1\xE9\xED", "\xE8\xF8\xF7\xEC\xE9\xEF", "\xE8\xF8\xF7\xEC\xE9\xEF", "\xE7\xE3\xF8 \xE4\xEB\xF1",
	"\xEE\xF9\xF8\xE3", "\xEE\xF8\xF4\xF1\xFA", "\xEE\xE2\xE3\xEC\xE5\xF8", "\xE7\xE3\xF8 \xF9\xE9\xF0\xE4", "\xE4\xE9\xEB\xEC \xE4\xE4\xF9\xFA\xF7\xF4\xE5\xFA",
	"\xF1\xE9\xE3\xE9", "\xE0\xF1\xED", "\xEB\xE5\xFA\xE5\xFA\xE9", "\xEE\xF2\xE1\xE3\xE4"
};

const char *locationDirVisited_EN[] = {
	"Lab", "Meadow", "King Hugh's Palace", "Pothole", "Palace Hallway",
	"Bedroom", "Cellar", "Trophy Room", "Laboratory", "DUMMY",
	"Town Center", "Bakery", "Costume Shop", "Tavern", "Arcade",
	"Countryside", "Malevolated Countryside", "Malevolated Countryside", "Entrance", "Entrance",
	"Forest", "Shuttle Station", "Central Zanydu", "Lower Zanydu", "Wacme Entrance",
	"Upper Zanydu", "Entrance", "Entrance", "Way-Outback", "Wolf Den",
	"The Malevolands", "Seedy's", "Robot Maker", "Prison", "The End of the World",
	"DUMMY", "DUMMY", "Dungeon", "Climatron Room", "Air Vent",
	"First Floor Landing", "Kitchen", "Padded Cell", "Second Floor Landing", "Wrecked Room",
	"Knight Hall", "Surveillance Room", "Armory", "Third Floor Landing", "Bathroom",
	"Study", "Stairwell", "Fourth Floor Landing", "Ms. Fortune's Lair", "Nefarious's Headquarters",
	"Swamp", "Forest", "Meadow", "Farmland", "Main Street",
	"Costume Shop", "Shuttle Station", "Inner-Central Middlemost Zanydu", "Upper North-Southeast Zanydu", "Lower South-Northwest Zanydu",
	"Way-Outback", "High Road", "Frank's Lab", "Cryo-Crypt", "Fantasyworld",
	"Vulture Falls", "Vulture Falls", "Vincent van Gogh's Studio", "Fearworld", "Attic",
	"Unorthodontist's Office", "Bedroom", "The Malevolands", "Inhuman Robots, Inc.", "Inhuman Robots, Inc. Workshop",
	"The End of the World", "Castle Ramparts", "Castle Top", "Kitchen", "Living Room",
	"Bedroom", "Laboratory", "Storage Center First Floor", "Storage Center Second Floor", "Storage Center Third Floor",
	"King Hugh's Palace", "Trophy Room", "Hallway", "Hallway", "Throne Room",
	"Office", "Balcony", "Lighthouse", "Bedroom", "Hall of Reflection",
	"Seedy's", "Barn", "WACME", "Lab"
};

const char *locationDirVisited_FR[] = {
	"Labo", "Prairie", "Palais de Hilarius 1er", "Trou", "Hall du Palais",
	"Chambre", "Cave", "Salle des Troph\351es", "Laboratoire", "DUMMY",
	"Centre ville", "Boulangerie", "Boutique de costumes", "Taverne", "Salle d'arcade",
	"Champ", "Champ perfidifi\351", "Champ perfidifi\351", "Etable", "Etable",
	"For\352t", "Terminus Navette", "Zanydu-Centre", "Bas-Zanydu", "Entr\351e des 3 Belges",
	"Hauts de Zanydu", "Entr\351e", "Entr\351e", "Lointain lointain", "Tani\350re des loups",
	"Perfidia", "Bouling", "Faiseur de Robots", "Prison", "Le bout du monde",
	"DUMMY", "DUMMY", "Donjon", "Salle du Climatron", "Conduit d'a\351ration",
	"Palier 1er \351tage", "Cuisine", "Cellule capiton\351e", "Palier 2\350me \351tage", "Salle de jeux",
	"Hall du Chevalier", "Salle de surveillance", "Armurerie", "Palier 3\350me \351tage", "Salle de bains",
	"Bureau", "Escalier", "Palier 4\350me \351tage", "Antre de Miss Fortune", "Quartiers g\351n\351raux de N\351farius",
	"Mar\351cage", "For\352t", "Prairie", "Champ", "Rue principale",
	"Boutique de costumes", "Gare Navette", "Centre du coeur de Zanydu", "Haut-Zanydu Sud-Est du North", "Bas-Zanydu Nord-Ouest du Sud",
	"Lointain lointain", "High Road", "Labo de Frank", "Cryo-Crypt", "Fantasyworld",
	"Vulture Falls", "Vulture Falls", "Vincent van Gogh's Studio", "Fearworld", "Grenier",
	"Unorthodontist's Office", "Chambre", "Perfidia", "Robots Inhumains SARL.", "Robots Inhumains SARL. Atelier",
	"La Fin du Monde", "Remparts du Ch\342teau", "Castle Top", "Cuisine", "Salon",
	"Chambre", "Laboratoire", "Storage Center First Floor", "Storage Center Second Floor", "Storage Center Third Floor",
	"Palais d'Hilarius 1er", "Salle des Troph\351es", "Hall", "Hall", "Salle du Tr\364ne",
	"Bureau", "Balcon", "Lighthouse", "Chambre", "Hall of Reflection",
	"Bouling", "Grange", "LES 3 BELGES", "Labo"
};

const char *locationDirVisited_DE[] = {
	"Labor", "Wiese", "K\366nig Nicks Palast", "Schlagloch", "Palastflur",
	"Schlafzimmer", "Keller", "Pokalsaal", "Laboratorium", "DUMMY",
	"Stadtmitte", "B\344ckerei", "Kost\374mverleih", "Kneipe", "Spielhalle",
	"Landschaft", "\334belierte Landschaft", "\334belierte Landschaft", "Eingang", "Eingang",
	"Wald", "Bahnhaltestelle", "Mittel-Trickreich", "Nieder-Trickreich", "Eingang der Fa. Wacme",
	"Ober-Trickreich", "Eingang", "Eingang", "Weite W\374ste Wildnis", "Wolfsh\366hle",
	"Das \334beland", "Seedys", "Roboterschmied", "Gef\344ngnis", "Das Ende der Welt",
	"DUMMY", "DUMMY", "Verlies", "Klimatron-Zimmer", "Luftschacht",
	"Treppenabsatz 1. Stock", "K\374che", "Gummizelle", "Treppenabsatz 2. Stock", "Demoliertes Zimmer",
	"Rittersaal", "\334berwachungsraum", "Waffenkammer", "Treppenabsatz 3. Stock", "Badezimmer",
	"Arbeitszimmer", "Treppenhaus", "Treppenabsatz 4. Stock", "Zimmer von Miss Gunst", "Hauptquartier von Widerlus",
	"Sumpf", "Wald", "Wiese", "Ackerland", "Hauptstra\337e",
	"Kost\374mverleih", "Bahnhaltestelle", "Zentrum des Inneren Mittel-Trickreichs", "Ober-Nord-S\374dost-Trickreich", "Unteres S\374d-Nordwest-Trickreich",
	"Weite W\374ste Wildnis", "Hochstra\337e", "Franks Labor", "K\344lteschlafkammer", "Phantasiawelt",
	"Geierf\344lle", "Geierf\344lle", "Vincent van Goghs Studio", "Angstwelt", "Dachboden",
	"Praxis des Unorthodontisten", "Schlafzimmer", "Das \334beland", "Unmenschliche Roboter AG", "Unmenschliche Roboter AG - Werkstatt",
	"Das Ende der Welt", "Schlo\337w\344lle", "Oberer Teil des Schlosses", "K\374che", "Wohnzimmer",
	"Schlafzimmer", "Labor", "Lager 1. Stock", "Lager 2. Stock", "Lager 3. Stock",
	"K\366nig Nicks Palast", "Pokalsaal", "Flur", "Flur", "Thronsaal",
	"B\374ro", "Balkon", "Leuchtturm", "Schlafzimmer", "Saal der Reflektion",
	"Seedys", "Scheune", "WACME", "Labor"
};

const char *locationDirVisited_RU[] = {
	"YBB", "Keu", "Ldjhtw rjhjkf {m.", "Hsndbyf", "Dtcnb,.km",
	"Cgfkmyz", "Gjuht,", "Veptq", "Rf,bytn", "VFRTN",
	"Wtynh", "{kt,", "Jlt;lf", "Rf,fr", "Buhs",
	"Lthtdyz", "Bcrjdthrfyyfz ptvkz", "Bcrjdthrfyyfz ptvkz", "D[jl", "D[jl",
	"Ktc", "Cnfywbz", "Wtynh", "Yb;yzz pjyf", "Gfhflysq d[jl",
	"Dth[yzz pjyf", "D[jl", "D[jl", "Jrhfbyf", "Kjujdj",
	"Pkjdtybz", "D[jl", "Hj,jn", "N.hmvf", "Rhfq cdtnf",
	"VFRTN", "VFRTN", "Gjldfk", "Rkbvfnhjyyfz", "Kfp",
	"Gkjoflrf 1-uj 'nf;f", "Re[yz", "Rfvthf", "Gkjoflrf 2-uj 'nf;f", "Fynbrdfhbfn",
	"Hswfhcrfz", "Rjvyfnf j[hfys", "Jhe;bt", "Gkjoflrf 3-uj 'nf;f", "Dfyyfz",
	"Jabc", "Rjkjltw", "Gkjoflrf 4-uj 'nf;f", "Yjhf vbcc Ajhneys", "Inf,-rdfhnbhf Ytafhbecf",
	"Njgm", "Ktc", "Keu", "Athvf", "Ghjcgtrn",
	"Jlt;lf", "Cnfywbz", "Chtlyzz pjyf dyenhtyytuj wtynhf", "Yb;ybq Ctdthj-.uj-djcnjr", "Yb;ybq >uj-ctdthj-pfgfl",
	"Jrhfbyf", "Ljhjuf", "Kf,jhfnjhbz", "Crktg", "Vbh Afynfpbq",
	"Cnthdjgfl", "Cnthdjgfl", "Cnelbz Dbyctynf dfy Ujuf", "Rjivfhbz", "Fnnbr",
	"Rf,bytn Ytjhnjljrcf", "Cgfkmyz", "Pkjdtybz", "FJPN +Ytuevfyjbl+", "Vfcnthcrfz FJPN +Ytuevfyjbl+",
	"Rhfq cdtnf", "Rhtgjcnyjq dfk", "<fiyz", "Re[yz", "Ujcnbyfz",
	"Cgfkmyz", "Rf,bytn", "Gthdsq 'nf; [hfybkbof", "Dnjhjq 'nf; [hfybkbof", "Nhtnbq 'nf; [hfybkbof",
	"Ldjhtw rjhjkz {m.", "Veptq", "Rjhbljh", "Rjhbljh", "Nhjyysq pfk",
	"Jabc", "<fkrjy", "Vfzr", "Cgfkmyz", "Rjvyfnf hfplevbq",
	"D[jl", "{ktd", "VJHLS", "YBB"
};

const char *locationDirVisited_SP[] = {
	"Laboratorio", "Pradera", "Palacio del Rey Hugo", "Bache", "Vest\355bulo del  palacio",
	"Dormitorio", "S\363tano", "Sala de trofeos", "Laboratorio", "Mu\361eco",
	"Centro ciudad", "Panader\355a", "Tienda de disfraces", "Taberna", "Sal\363n de juegos recreativos",
	"Paisaje", "Paisaje malificado", "Paisaje malificado", "Entrada", "Entrada",
	"Bosque", "Estaci\363n del telecabina", "Centro de Loquilandia", "Loquilandia de Abajo", "Entrada a Wacme",
	"Loquilandia de Arriba", "Entrada", "Entrada", "Camino del interior", "Guarida de lobos",
	"Malevolandia", "Sady's", "Fabricante de robots", "Prisi\363n", "El fin del mundo",
	"Cosa extra\361a", "Cosa extra\361a", "Mazmorra", "Sala del Climatr\363n", "Conducto de ventilaci\363n",
	"Descansillo del primer piso", "Cocina", "Jaula de locos", "Descansillo del segundo piso", "Cuarto destrozado",
	"Sala del caballero", "Sala de vigilancia", "Sala de blasones", "Descansillo del tercer piso", "Cuarto de ba\361o",
	"Estudio", "Escalera", "Descansillo del cuarto piso", "Guarida de Lady Infortunata", "Dependencias de Nefastus",
	"Ci\351naga", "Bosque", "Pradera", "Tierras", "Calle principal",
	"Tienda de disfraces", "Estaci\363n del telecabina", "Casi medio centro de Loquilandia", "Norsudeste de Loquilandia de Arriba", "Surnoroeste de Loquilandia de Abajo",
	"Camino del interior", "Camino Real", "Laboratorio de Frankestain", "Crio-Cripta", "Fantasilandia",
	"Salto del buitre", "Salto del buitre", "Estudio de Vincent van Gogh ", "Miedilandia", "Atico",
	"Despacho del Desortodoncista", "Dormitorio", "Malevolandia", "Robots Inhumanos, S.L.", "Robots Inhumanos, S.L. Taller",
	"El fin del mundo", "Murallas del castillo", "Parte alta del castillo", "Cocina", "Sala de estar",
	"Dormitorio", "Laboratorio", "Centro de almacenamiento del primer piso", "Centro de almacenamiento del segundo piso", "Centro de almacenamiento del tercer piso",
	"Palacio del Rey Hugo", "Sala de trofeos", "Vest\355bulo", "Vest\355bulo", "Sal\363n del trono",
	"Oficina", "Balc\363n", "Faro", "Dormitorio", "Sala de reflexi\363n",
	"Sady's", "Establo", "Wacme", "Laboratorio "
};


const char *locationDirVisited_HE[] = {
	"\xEE\xF2\xE1\xE3\xE4", "\xE0\xE7\xE5", "\xE0\xF8\xEE\xE5\xEF \xE4\xEE\xEC\xEA \xF6\xE5\xEE\xE9", "\xE1\xE5\xF8", "\xE4\xE9\xEB\xEC \xE4\xE0\xF8\xEE\xE5\xEF",
	"\xE7\xE3\xF8 \xF9\xE9\xF0\xE4", "\xEE\xF8\xFA\xF3", "\xE7\xE3\xF8 \xE4\xF4\xF8\xF1\xE9\xED", "\xEE\xF2\xE1\xE3\xE4", "\xF1\xFA\xED",
	"\xEE\xF8\xEB\xE6 \xE4\xF2\xE9\xE9\xF8\xE4", "\xEE\xE0\xF4\xE9\xE9\xE4", "\xE7\xF0\xE5\xFA \xFA\xE7\xF4\xE5\xF9\xE5\xFA", "\xEE\xF1\xE1\xE0\xE4", "\xEE\xF9\xE7\xF7\xE9\xE4",
	"\xEB\xF4\xF8", "\xEB\xF4\xF8 \xEE\xE5\xE6\xE3", "\xEB\xF4\xF8 \xEE\xE5\xE6\xE3", "\xEB\xF0\xE9\xF1\xE4", "\xEB\xF0\xE9\xF1\xE4",
	"\xE9\xF2\xF8", "\xFA\xE7\xF0\xFA \xEE\xF2\xE1\xE5\xF8\xFA", "\xEE\xF8\xEB\xE6 \xE6\xF0\xE9\xE3\xE5", "\xE6\xF0\xE9\xE3\xE5 \xFA\xE7\xFA\xE9\xFA", "\xEB\xF0\xE9\xF1\xE4 \xEC\xEB\xE5\xFA\xE5\xFA\xE9",
	"\xE6\xF0\xE9\xE3\xE5 \xF2\xE9\xEC\xE9\xFA", "\xEB\xF0\xE9\xF1\xE4", "\xEB\xF0\xE9\xF1\xE4", "\xEE\xEE\xF9-\xF0\xE9\xE3\xE7", "\xE2\xE5\xE1 \xE6\xE0\xE1\xE9\xED",
	"\xE6\xE3\xE5\xF0\xE9\xE4", "\xF1\xE9\xE3\xE9", "\xE9\xF6\xF8\xEF \xF8\xE5\xE1\xE5\xE8\xE9\xED", "\xE1\xE9\xFA \xF1\xE5\xE4\xF8", "\xF1\xE5\xF3 \xE4\xF2\xE5\xEC\xED",
	"\xF1\xFA\xED", "\xF1\xFA\xED", "\xF6\xE9\xF0\xE5\xF7", "\xE7\xE3\xF8 \xE4\xEE\xE7\xEE\xEE\xE4", "\xFA\xF2\xEC\xFA \xE0\xE5\xE5\xF8\xE5\xF8",
	"\xEE\xE9\xF9\xE5\xF8\xFA \xF7\xE5\xEE\xE4 \xF8\xE0\xF9\xE5\xF0\xE4", "\xEE\xE8\xE1\xE7", "\xFA\xE0 \xEE\xF8\xE5\xF4\xE3", "\xEE\xE9\xF9\xE5\xF8\xFA \xF7\xE5\xEE\xE4 \xF9\xF0\xE9\xE4", "\xE7\xE3\xF8 \xE4\xF8\xE5\xF1",
	"\xE4\xE9\xEB\xEC \xE4\xE0\xE1\xE9\xF8\xE9\xED", "\xE7\xE3\xF8 \xEE\xF2\xF7\xE1", "\xF0\xF9\xF7\xE9\xE4", "\xEE\xE9\xF9\xE5\xF8\xFA \xF7\xE5\xEE\xE4 \xF9\xEC\xE9\xF9\xE9\xFA", "\xE7\xE3\xF8 \xF8\xE7\xF6\xE4",
	"\xE7\xE3\xF8 \xF2\xE1\xE5\xE3\xE4", "\xE2\xF8\xED \xEE\xE3\xF8\xE2\xE5\xFA", "\xEE\xE9\xF9\xE5\xF8\xFA \xF7\xE5\xEE\xE4 \xF8\xE1\xE9\xF2\xE9\xFA", "\xEE\xE0\xE5\xF8\xFA\xE4 \xF9\xEC \xE0\xEE\xE0 \xF0\xE7\xE5\xF1\xE4", "\xE4\xEE\xF4\xF7\xE3\xE4 \xF9\xEC \xE1\xEC\xE9\xF2\xEC",
	"\xE1\xE9\xF6\xE4", "\xE9\xF2\xF8", "\xE0\xE7\xE5", "\xE7\xE5\xE5\xE4", "\xF8\xE7\xE5\xE1 \xF8\xE0\xF9\xE9",
	"\xE7\xF0\xE5\xFA \xFA\xE7\xF4\xE5\xF9\xE5\xFA", "\xFA\xE7\xF0\xFA \xEE\xF2\xE1\xE5\xF8\xFA", "\xEE\xF8\xEB\xE6-\xF4\xF0\xE9\xED-\xEE\xEE\xF9-\xE1\xE0\xEE\xF6\xF2 \xE6\xF0\xE9\xE3\xE5", "\xF6\xF4\xE5\xEF-\xE3\xF8\xE5\xED-\xEE\xE6\xF8\xE7 \xE6\xF0\xE9\xE3\xE5 \xF2\xE9\xEC\xE9\xFA", "\xE3\xF8\xE5\xED-\xF6\xF4\xE5\xEF-\xEE\xF2\xF8\xE1 \xE6\xF0\xE9\xE3\xE5 \xFA\xE7\xFA\xE9\xFA",
	"\xEE\xEE\xF9-\xF0\xE9\xE3\xE7", "\xE3\xF8\xEA \xEE\xE4\xE9\xF8\xE4", "\xE4\xEE\xF2\xE1\xE3\xE4 \xF9\xEC \xF4\xF8\xF0\xF7", "\xE1\xE5\xF8 \xEB\xF4\xE5\xF8", "\xF2\xE5\xEC\xED \xE4\xF4\xF0\xE8\xE6\xE9\xE4",
	"\xEE\xF4\xEC\xE9 \xF0\xF9\xF8\xE9\xED", "\xEE\xF4\xEC\xE9 \xF0\xF9\xF8\xE9\xED", "\xE4\xF1\xE8\xE5\xE3\xE9\xE5 \xF9\xEC \xE5\xE9\xF0\xF1\xF0\xE8 \xE5\xE0\xEF \xE2\xE5\xEA", "\xF2\xE5\xEC\xED \xE4\xF4\xE7\xE3", "\xF2\xEC\xE9\xE9\xFA \xE4\xE2\xE2",
	"\xEE\xF9\xF8\xE3\xE5 \xF9\xEC \xEE\xF7\xE4\xE4 \xE4\xF9\xE9\xF0\xE9\xE9\xED", "\xE7\xE3\xF8 \xF9\xE9\xF0\xE4", "\xE6\xE3\xE5\xF0\xE9\xE4", "\xF8\xE5\xE1\xE5\xE8\xE9\xED \xE0\xEC-\xE0\xF0\xE5\xF9\xE9\xE9\xED \xE1\xF2\"\xEE", "\xE4\xF1\xE3\xF0\xE4 \xF9\xEC \xF8\xE5\xE1\xE5\xE8\xE9\xED \xE0\xEC-\xE0\xF0\xE5\xF9\xE9\xE9\xED \xE1\xF2\"\xEE",
	"\xF1\xE5\xF3 \xE4\xF2\xE5\xEC\xED", "\xE1\xE9\xF6\xE5\xF8\xE9 \xE4\xE8\xE9\xF8\xE4", "\xE2\xE2 \xE4\xE8\xE9\xF8\xE4", "\xEE\xE8\xE1\xE7", "\xF1\xEC\xE5\xEF",
	"\xE7\xE3\xF8 \xF9\xE9\xF0\xE4", "\xEE\xF2\xE1\xE3\xE4", "\xEE\xE7\xF1\xEF \xF7\xE5\xEE\xE4 \xF8\xE0\xF9\xE5\xF0\xE4", "\xEE\xE7\xF1\xEF \xF7\xE5\xEE\xE4 \xF9\xF0\xE9\xE4", "\xEE\xE7\xF1\xEF \xF7\xE5\xEE\xE4 \xF9\xEC\xE9\xF9\xE9\xFA",
	"\xE0\xF8\xEE\xE5\xEF \xE4\xEE\xEC\xEA \xF6\xE5\xEE\xE9", "\xE7\xE3\xF8 \xE4\xF4\xF8\xF1\xE9\xED", "\xE8\xF8\xF7\xEC\xE9\xEF", "\xE8\xF8\xF7\xEC\xE9\xEF", "\xE7\xE3\xF8 \xE4\xEB\xF1",
	"\xEE\xF9\xF8\xE3", "\xEE\xF8\xF4\xF1\xFA", "\xEE\xE2\xE3\xEC\xE5\xF8", "\xE7\xE3\xF8 \xF9\xE9\xF0\xE4", "\xE4\xE9\xEB\xEC \xE4\xE4\xF9\xFA\xF7\xF4\xE5\xFA",
	"\xF1\xE9\xE3\xE9", "\xE0\xF1\xED", "\xEB\xE5\xFA\xE5\xFA\xE9", "\xEE\xF2\xE1\xE3\xE4"
};


const char *specialInfoLine_EN[] = { "Exit not defined", "Bottomless Bag", "Flux Wildly", "Drew Blanc" };
const char *specialInfoLine_FR[] = { "Exit not defined", "Inventaire", "Flux Radieux", "Marc Blanc" };
const char *specialInfoLine_DE[] = { "Exit not defined", "Bodenloser Beutel", "Flux W. Wild", "Mal Block" };
const char *specialInfoLine_RU[] = { "Exit not defined", "   Fdjcmrf    ", "  :bdxbr   ", "Lhe <k'yr " };
const char *specialInfoLine_SP[] = { "Exit not defined", "Saco sin fondo", "Flux Tarambana", "Andr\351s Truido" };
const char *specialInfoLine_HE[] = { "\xE9\xF6\xE9\xE0\xE4 \xEC\xE0 \xEE\xE5\xE2\xE3\xF8\xFA", "\xF9\xF7 \xEC\xEC\xE0 \xFA\xE7\xFA\xE9\xFA", "\xF4\xEC\xE0\xF7\xF1 \xE5\xE5\xE9\xEC\xE3\xEC\xE9", "\xE3\xF8\xE5 \xE1\xEC\xE0\xF0\xF7" };

// Those are not yet in the DAT file. They'll be added as soon as they are really used.
const char *miscTexts_EN[] = {
	"Are you sure you want to exit? (Y/N)",
	"Please insert Disc One",
	"Please insert Disc Two",
	"File %s is missing. Press a key."
};

const char *miscTexts_FR[] = {
	"Etes-vous s\373r(e) de vouloir quitter ? (O/N)",
	"Ins\351rez le CD 1",
	"Ins\351rez le CD 2",
	"Le fichier %s est manquant. Appuyez sur une touche."
};

const char *miscTexts_DE[] = {
	"Aufh\366ren? Sind Sie sicher? (J/N)",
	"Bitte CD 1 einlegen",
	"Bitte CD 2 einlegen",
	"Datei %s fehlt. Beliebige Taste dr\374cken."
};

const char *miscTexts_RU[] = {
	"Are you sure you want to exit? (Y/N)",
	"Please insert Disc One",
	"Please insert Disc Two",
	"File %s is missing. Press a key."
};

const char *miscTexts_SP[] = {
	"\277Est\341s seguro de que quieres salir? (S/N)",
	"Por favor, inserta el disco 1",
	"Por favor, inserta el disco 2",
	"El  archivo %s no aparece. Pulsa una tecla."
};

const char *miscTexts_HE[] = {
	"\xE4\xE0\xED \xE0\xFA\xED \xE1\xE8\xE5\xE7\xE9\xED \xF9\xE1\xF8\xF6\xE5\xE5\xF0\xEB\xED \xEC\xF6\xE0\xFA? (\xEB/\xEC)",
	"\xF0\xE0 \xEC\xE4\xEB\xF0\xE9\xF1 \xE0\xFA \xFA\xF7\xEC\xE9\xE8\xE5\xF8 \xEE\xF1\xF4\xF8 \xE0\xE7\xFA",
	"\xF0\xE0 \xEC\xE4\xEB\xF0\xE9\xF1 \xE0\xFA \xFA\xF7\xEC\xE9\xE8\xE5\xF8 \xEE\xF1\xF4\xF8 \xF9\xFA\xE9\xE9\xED",
	"\xE4\xF7\xE5\xE1\xF5 %s \xE7\xF1\xF8. \xF0\xE0 \xEC\xEC\xE7\xE5\xF5 \xF2\xEC \xEE\xF7\xF9 \xEB\xEC\xF9\xE4\xE5."
};

const char *endingLine_EN = "Congratulations!!! Hope you enjoyed playing ToonStruck!!";
const char *endingLine_FR = "F\202licitations ! Nous esp\202rons que vous avez aim\202 ToonStruck !";
const char *endingLine_DE = "Herzlichen Gl\201ckwunsch! Wir hoffen, Toonstruck hat Ihnen Spa\341 gemacht!";
const char *endingLine_RU = "Congratulations!!! Hope you enjoyed playing ToonStruck!!";
const char *endingLine_SP = "\255\255Enhorabuena!! \255\255Esperamos que te diviertas jugando a ToonStruck!!";
const char *endingLine_HE = "\xEE\xE6\xEC \xE8\xE5\xE1!!! \xEE\xF7\xE5\xE5\xE9\xED \xF9\xF0\xE4\xF0\xE9\xFA\xED \xEC\xF9\xE7\xF7 \xE1\xF6\xE9\xE9\xF8\xE5\xF8\xE9!!";

const char *exitLine_EN = "Hope you enjoyed playing ToonStruck!!";
const char *exitLine_FR = "Nous esp\202rons que vous avez aim\202 jouer \205 ToonStruck !";
const char *exitLine_DE = "Wir hoffen, Toonstruck hat Ihnen Spa\341 gemacht!";
const char *exitLine_RU = "Hope you enjoyed playing ToonStruck!!";
const char* exitLine_SP = "\255\255Esperamos que te diviertas jugando a ToonStruck!!";
const char *exitLine_HE = "\xEE\xF7\xE5\xE5\xE9\xED \xF9\xF0\xE4\xF0\xE9\xFA\xED \xEC\xF9\xE7\xF7 \xE1\xF6\xE9\xE9\xF8\xE5\xF8\xE9!!";

#endif
