(define (integer-sqrt square)
  (letrec
    ((sqrt2 (lambda (x last)
       (cond ((= last x)
               x)
             ((= last (+ 1 x))
               (if (> (* x x) square) (- x 1) x))
             (else
               (sqrt2 (quotient
                         (+ x (quotient square x))
                         2)
                      x))))))
    (if (negative? square)
        (error "integer-sqrt: negative argument" square)
        (sqrt2 square 0))))

(if (not (= (integer-sqrt (expt 3 3210))
    6020240278348296952024210735588056965545988660215374912039661779722278668115433924751214197781291006573158332201150797927655411646011843834110202700546900289345892839697719102865436925905446491521722342836937250752358303431057729782419841961026106652172507978189628068679446663027011565353921431609457039884157053173407821753708873627229236368642034066297519054201325848229505217825863201466375984013249671121899907356169497194823315274693932054738024051305451237747433491441664039289014923895031445113001374835440215491733893518385379402575570882432326216342324658839812894247747797056025361698228030453095159603210153275790532329633913622965500622337525350766229226229428901837411529052743262952237229078413537385499273875834310410315980539890312923276547485536243))
    (error "integer-sqrt failed"))
