# 2022-11-08 Triage Log

A relatively noisy week (most of those have been dropped below, and comments
left on GitHub), but otherwise a quiet one in terms of performance changes,
with essentially no significant changes occuring.

Triage done by **@simulacrum**.
Revision range: [822f8c22f540b12f296d844ad5bf39aaa47bfeb4..57d3c58ed6e0faf89a62411f96c000ffc9fd3937](https://perf.rust-lang.org/?start=822f8c22f540b12f296d844ad5bf39aaa47bfeb4&end=57d3c58ed6e0faf89a62411f96c000ffc9fd3937&absolute=false&stat=instructions%3Au)

**Summary**:

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.2%  | [0.2%, 1.8%]   | 13    |
| Regressions ❌ <br /> (secondary)  | 1.2%  | [0.2%, 2.1%]   | 47    |
| Improvements ✅ <br /> (primary)   | -1.5% | [-4.0%, -0.2%] | 21    |
| Improvements ✅ <br /> (secondary) | -1.8% | [-3.9%, -0.3%] | 61    |
| All ❌✅ (primary)                 | -0.4% | [-4.0%, 1.8%]  | 34    |


2 Regressions, 2 Improvements, 3 Mixed; 3 of them in rollups
39 artifact comparisons made in total

#### Regressions

Rollup of 6 pull requests [#103998](https://github.com/rust-lang/rust/pull/103998) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=5b3e9090757da9a95b22f589fe39b6a4b5455b96&end=452cf4f7109f58433ac38be7d3da527408571054&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 2.5%  | [0.3%, 3.9%]   | 6     |
| Regressions ❌ <br /> (secondary)  | 1.4%  | [0.4%, 3.5%]   | 43    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -1.3% | [-1.5%, -1.0%] | 2     |
| All ❌✅ (primary)                 | 2.5%  | [0.3%, 3.9%]   | 6     |

Appears to be a genuine regression. Mostly limited to smaller benchmarks, so
most likely just a slight increase in the minimum work rustc does. Suspected to
be due to the changes in sysroot detection; have enqueued a build to try and
find out.

std: sync "Dependencies of the `backtrace` crate" with `backtrace` [#103934](https://github.com/rust-lang/rust/pull/103934) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=d69c33ad4c65e42a7a2d018a5c2ee1c7dbd0fc15&end=73c9eaf21454b718e7c549984d9eb6e1f75e995c&stat=instructions:u)

| (instructions:u)                   | mean | range        | count |
|:----------------------------------:|:----:|:------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4% | [0.9%, 1.8%] | 10    |
| Regressions ❌ <br /> (secondary)  | 1.5% | [0.3%, 3.3%] | 47    |
| Improvements ✅ <br /> (primary)   | -    | -            | 0     |
| Improvements ✅ <br /> (secondary) | -    | -            | 0     |
| All ❌✅ (primary)                 | 1.4% | [0.9%, 1.8%] | 10    |

Some of this may be noise, but it's also possible that the newer dependencies
are doing slightly different things causing some regressions -- it's possible
we're computing backtraces somewhere, and even modulo that, the changes to the
standard library may cause different inlining decisions, etc.

#### Improvements

Make rustdoc Item::visibility computed on-demand [#103690](https://github.com/rust-lang/rust/pull/103690) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=822f8c22f540b12f296d844ad5bf39aaa47bfeb4&end=c0a76127283bc963b085f54a1b275a8e281e81e6&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.8% | [-1.7%, -0.4%] | 11    |
| Improvements ✅ <br /> (secondary) | -1.6% | [-2.7%, -0.6%] | 23    |
| All ❌✅ (primary)                 | -0.8% | [-1.7%, -0.4%] | 11    |


Rollup of 7 pull requests [#103962](https://github.com/rust-lang/rust/pull/103962) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=47c008e440e59d793c2883f7dd712481dc965045&end=6330c27ae24ec1556cf2b97eeac333dc23391686&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | -     | -              | 0     |
| Improvements ✅ <br /> (primary)   | -0.2% | [-0.3%, -0.2%] | 6     |
| Improvements ✅ <br /> (secondary) | -0.4% | [-0.4%, -0.3%] | 4     |
| All ❌✅ (primary)                 | -0.2% | [-0.3%, -0.2%] | 6     |


#### Mixed

Revert "ci: Bring back ninja for dist builders" [#103846](https://github.com/rust-lang/rust/pull/103846) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=edf0182213a9e30982eb34f3925ddc4cf5ed3471&end=5b1304a03bbefe618cf16d6f4b3c41f4bd8e390a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | -     | -              | 0     |
| Regressions ❌ <br /> (secondary)  | 2.5%  | [2.5%, 2.5%]   | 1     |
| Improvements ✅ <br /> (primary)   | -1.7% | [-7.4%, -0.2%] | 19    |
| Improvements ✅ <br /> (secondary) | -2.0% | [-6.6%, -0.2%] | 71    |
| All ❌✅ (primary)                 | -1.7% | [-7.4%, -0.2%] | 19    |

This change was reverted precisely due to the performance regression it introduced, so this is no surprise.

Rollup of 5 pull requests [#104017](https://github.com/rust-lang/rust/pull/104017) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=6b8d9dd0a09851b3e4f400ddd1303857945be25d&end=371100b1fb811e604f7451eff3b06960587fe1af&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.4%  | [1.4%, 1.4%]   | 1     |
| Regressions ❌ <br /> (secondary)  | 0.5%  | [0.3%, 0.8%]   | 2     |
| Improvements ✅ <br /> (primary)   | -1.0% | [-3.2%, -0.3%] | 13    |
| Improvements ✅ <br /> (secondary) | -2.3% | [-3.1%, -0.6%] | 19    |
| All ❌✅ (primary)                 | -0.9% | [-3.2%, 1.4%]  | 14    |

Minor regressions in two secondary benchmarks and in libc don't seem to warrant
further investigation, especially given the general improvement across the
board.

Some tracing and comment cleanups [#103975](https://github.com/rust-lang/rust/pull/103975) [(Comparison Link)](https://perf.rust-lang.org/compare.html?start=e6fead46dc21ba017f7c1a5130ff3d31535acb16&end=a4ab2e064306c2c3e5b1d2efe1d5c0e1a6e0346a&stat=instructions:u)

| (instructions:u)                   | mean  | range          | count |
|:----------------------------------:|:-----:|:--------------:|:-----:|
| Regressions ❌ <br /> (primary)    | 1.0%  | [0.2%, 1.5%]   | 3     |
| Regressions ❌ <br /> (secondary)  | 1.9%  | [0.3%, 4.2%]   | 13    |
| Improvements ✅ <br /> (primary)   | -     | -              | 0     |
| Improvements ✅ <br /> (secondary) | -0.6% | [-0.6%, -0.6%] | 3     |
| All ❌✅ (primary)                 | 1.0%  | [0.2%, 1.5%]   | 3     |

Most of the regressions are probably noise, so this change is likely actually an improvement or neutral.
