use crate::utils::{FileUpdater, update_text_region_fn};
use chrono::offset::Utc;
use std::fmt::Write;

pub fn update_nightly() {
    let date = Utc::now().format("%Y-%m-%d").to_string();
    let toolchain_update = &mut update_text_region_fn(
        "# begin autogenerated nightly\n",
        "# end autogenerated nightly",
        |dst| {
            writeln!(dst, "channel = \"nightly-{date}\"").unwrap();
        },
    );
    let readme_update = &mut update_text_region_fn(
        "<!-- begin autogenerated nightly -->\n",
        "<!-- end autogenerated nightly -->",
        |dst| {
            writeln!(dst, "```\nnightly-{date}\n```").unwrap();
        },
    );

    let mut updater = FileUpdater::default();
    updater.update_file("rust-toolchain.toml", toolchain_update);
    updater.update_file("clippy_utils/README.md", readme_update);
}
