// This file was generated by gir (https://github.com/gtk-rs/gir)
// from gir-files (https://github.com/gtk-rs/gir-files)
// DO NOT EDIT

use crate::{Object, Relation, RelationType};
use glib::{prelude::*, translate::*};
use std::fmt;

glib::wrapper! {
    #[doc(alias = "AtkRelationSet")]
    pub struct RelationSet(Object<ffi::AtkRelationSet, ffi::AtkRelationSetClass>);

    match fn {
        type_ => || ffi::atk_relation_set_get_type(),
    }
}

impl RelationSet {
    pub const NONE: Option<&'static RelationSet> = None;

    #[doc(alias = "atk_relation_set_new")]
    pub fn new() -> RelationSet {
        assert_initialized_main_thread!();
        unsafe { from_glib_full(ffi::atk_relation_set_new()) }
    }
}

impl Default for RelationSet {
    fn default() -> Self {
        Self::new()
    }
}

mod sealed {
    pub trait Sealed {}
    impl<T: super::IsA<super::RelationSet>> Sealed for T {}
}

pub trait RelationSetExt: IsA<RelationSet> + sealed::Sealed + 'static {
    #[doc(alias = "atk_relation_set_add")]
    fn add(&self, relation: &impl IsA<Relation>) {
        unsafe {
            ffi::atk_relation_set_add(
                self.as_ref().to_glib_none().0,
                relation.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "atk_relation_set_add_relation_by_type")]
    fn add_relation_by_type(&self, relationship: RelationType, target: &impl IsA<Object>) {
        unsafe {
            ffi::atk_relation_set_add_relation_by_type(
                self.as_ref().to_glib_none().0,
                relationship.into_glib(),
                target.as_ref().to_glib_none().0,
            );
        }
    }

    #[doc(alias = "atk_relation_set_contains")]
    fn contains(&self, relationship: RelationType) -> bool {
        unsafe {
            from_glib(ffi::atk_relation_set_contains(
                self.as_ref().to_glib_none().0,
                relationship.into_glib(),
            ))
        }
    }

    #[doc(alias = "atk_relation_set_contains_target")]
    fn contains_target(&self, relationship: RelationType, target: &impl IsA<Object>) -> bool {
        unsafe {
            from_glib(ffi::atk_relation_set_contains_target(
                self.as_ref().to_glib_none().0,
                relationship.into_glib(),
                target.as_ref().to_glib_none().0,
            ))
        }
    }

    #[doc(alias = "atk_relation_set_get_n_relations")]
    #[doc(alias = "get_n_relations")]
    fn n_relations(&self) -> i32 {
        unsafe { ffi::atk_relation_set_get_n_relations(self.as_ref().to_glib_none().0) }
    }

    #[doc(alias = "atk_relation_set_get_relation")]
    #[doc(alias = "get_relation")]
    fn relation(&self, i: i32) -> Option<Relation> {
        unsafe {
            from_glib_none(ffi::atk_relation_set_get_relation(
                self.as_ref().to_glib_none().0,
                i,
            ))
        }
    }

    #[doc(alias = "atk_relation_set_get_relation_by_type")]
    #[doc(alias = "get_relation_by_type")]
    fn relation_by_type(&self, relationship: RelationType) -> Option<Relation> {
        unsafe {
            from_glib_none(ffi::atk_relation_set_get_relation_by_type(
                self.as_ref().to_glib_none().0,
                relationship.into_glib(),
            ))
        }
    }

    #[doc(alias = "atk_relation_set_remove")]
    fn remove(&self, relation: &impl IsA<Relation>) {
        unsafe {
            ffi::atk_relation_set_remove(
                self.as_ref().to_glib_none().0,
                relation.as_ref().to_glib_none().0,
            );
        }
    }
}

impl<O: IsA<RelationSet>> RelationSetExt for O {}

impl fmt::Display for RelationSet {
    fn fmt(&self, f: &mut fmt::Formatter) -> fmt::Result {
        f.write_str("RelationSet")
    }
}
