#! /usr/bin/env perl

# Test package that computes default database settings:

use strict;
use warnings;
use utf8;
use Data::Dumper;

use lib 'lib';
use Database::View;
use DBIx::MyParsePP;

binmode( STDOUT, "utf8" );

$Data::Dumper::Sortkeys = 1;
$Data::Dumper::Indent   = 1;

my @tests = (
    'create view experiment_view as select SolsaID, result, esu from sample join experiment on sample.id = sample_id',
    'create view experiment_view as select sample.SolsaID, result, esu from sample join experiment on sample.id = sample_id',
    'create view experiment_view as select SolsaID from experiment',
    'create view `experiment_view` as select `SolsaID` from `experiment`',
    'create view `experiment_view` as select `SolsaID`, `OtherID` from `experiment`',
    'create view experiment_view as select measurement_date as mdate from experiment',
    'create view experiment_view as select measurement_date as mdate, esu as uncertainty from experiment',
    'create view experiment_view as select measurement_date as mdate, id, esu as uncertainty from experiment',
    'create view sub_test (a, b) as select a, b from test',
    'create view sub_test (a, b) as select c, d from test',
    'create view sub_test as select * from A join B on A.id = B.id join C on A.id = C.id',
    'create view sub_test as select * from A join B using (common_field)',
    'create view sub_test as select * from A join B using (common_field_1, common_field_2)',
    'create view sub_test as select * from A join B using (common_to_A_and_B) join C using (common_to_B_and_C)',
    'create view test as select A.* from A',
    'create view test as select A.*, B.* from A join B using (common_field)',
    'CREATE VIEW `xrf` AS ' .
        'select `sample`.`SolsaID` AS `SolsaID`,' .
        '`experiment_xrf`.`measurement_date` AS `measurement_date`,' .
        '`experiment_xrf`.`analytical_conditions` AS `analytical_conditions`,' .
        '`experiment_xrf`.`loi_content` AS `loi_content`,' .
        '`xrf_content`.`component` AS `component`,' .
        '`xrf_content`.`value` AS `value` ' .
        'from ((`sample` join `experiment_xrf` on((`sample`.`id` = `experiment_xrf`.`sample_id`))) ' .
        'join `xrf_content` on((`experiment_xrf`.`id` = `xrf_content`.`experiment_id`)))',
    'CREATE VIEW `xrf` AS ' .
        'select `sample`.`SolsaID` AS `SolsaID`,' .
        '`experiment_xrf`.`measurement_date` AS `mdate`,' .
        '`experiment_xrf`.`analytical_conditions` AS `conditions`,' .
        '`experiment_xrf`.`loi_content` AS `loi_content`,' .
        '`xrf_content`.`component` AS `component`,' .
        '`xrf_content`.`value` AS `value` ' .
        'from ((`sample` join `experiment_xrf` on((`sample`.`id` = `experiment_xrf`.`sample_id`))) ' .
        'join `xrf_content` on((`experiment_xrf`.`id` = `xrf_content`.`experiment_id`)))',
    'CREATE ALGORITHM=UNDEFINED DEFINER=`root`@`localhost` SQL SECURITY DEFINER ' .
        'VIEW `homepage` AS '.
        '(select `s1`.`id` AS `id`,`s1`.`SolsaID` AS `SolsaID`,`s1`.`name` AS `Rock_name`,' .
        '`origin`.`location` AS `Origin_country`,' .
        '`origin`.`mine` AS `Origin_site_mine`' .
        ',`s1`.`specimen_type` AS `Form`,' .
        'group_concat(`s2`.`SolsaID` separator \';\') AS `Related_SolsaID` ' .
        'from ((((`sample` `s1` left join `related_samples` on((`s1`.`id` = `related_samples`.`sample_id1`))) ' .
        'left join `sample` `s2` on((`s2`.`id` = `related_samples`.`sample_id2`))) ' .
        'left join `natural_sample` on((`natural_sample`.`sample_id` = `s1`.`id`))) ' .
        'left join `origin` on((`natural_sample`.`origin_id` = `origin`.`id`))) group by `s1`.`id`)',
    'CREATE  OR REPLACE VIEW `soil_grain_description` AS ' .
        'SELECT ' .
         '`id`, '.
         '`uuid`, '.
         '`revision_id`, '.
         '`grain_mineral_composition_id`, '.
         '`grain_size_id`, '.
         '`grain_form_id`, '.
         '`grain_angularity_id`, '.
         '`grain_arrangement_id`, '.
         '`grain_colour_lightness`, '.
         '`grain_colour_chroma`, '.
         '`grain_colour_hue`, '.
         '`soil_structure_description_id` '.
        'FROM `lithology_grain_description` '.
        'WHERE `soil_structure_description_id` IS NOT NULL',
    'create view experiment_view as select S.SolsaID, S.result, esu from sample as S join experiment on S.id = sample_id',
    'create view experiment_view as select S.SolsaID, S.result, esu from sample S join experiment on S.id = sample_id',
);

my $parser = DBIx::MyParsePP->new();
for (@tests) {
    print "$_\n";
    my $parse_tree = $parser->parse( $_ )->root()->shrink();
    eval {
        my %tables = Database::View::get_view_tables( $parse_tree );
        print Dumper( {
                        columns => [ Database::View::get_view_columns( $parse_tree ) ],
                        tables  => [ sort values %tables ],
                        joins   => [ Database::View::get_joins( $parse_tree ) ]
                      } );
    };
    if( $@ ) {
        print "FAILED: $@";
    }
}
