// SPDX-License-Identifier: BSD-3-Clause
//
// Copyright 2022 Raritan Inc. All rights reserved.
//
// This file was generated by IdlC from SensorHub.idl.

using System;
using System.Linq;
using LightJson;
using Com.Raritan.Idl;
using Com.Raritan.JsonRpc;
using Com.Raritan.Util;

#pragma warning disable 0108, 0219, 0414, 1591

namespace Com.Raritan.Idl.peripheral {
  public class SensorHub : ObjectProxy {

    static public readonly new TypeInfo typeInfo = new TypeInfo("peripheral.SensorHub:1.0.0", null);

    public SensorHub(Agent agent, string rid, TypeInfo ti) : base(agent, rid, ti) {}
    public SensorHub(Agent agent, string rid) : this(agent, rid, typeInfo) {}

    public static new SensorHub StaticCast(ObjectProxy proxy) {
      return proxy == null ? null : new SensorHub(proxy.Agent, proxy.Rid, proxy.StaticTypeInfo);
    }

    public enum UpstreamType {
      BUILTIN,
      ENV_HUB,
      REMOTE_HUB,
    }

    public class HubPortInfo : ICloneable {
      public object Clone() {
        HubPortInfo copy = new HubPortInfo();
        copy.hubPort = this.hubPort;
        copy.fuse = this.fuse;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["hubPort"] = this.hubPort;
        json["fuse"] = this.fuse != null ? this.fuse.Encode() : JsonValue.Null;
        return json;
      }

      public static HubPortInfo Decode(LightJson.JsonObject json, Agent agent) {
        HubPortInfo inst = new HubPortInfo();
        inst.hubPort = (string)json["hubPort"];
        inst.fuse = Com.Raritan.Idl.portsmodel.PortFuse.StaticCast(ObjectProxy.Decode(json["fuse"], agent));
        return inst;
      }

      public string hubPort = "";
      public Com.Raritan.Idl.portsmodel.PortFuse fuse = null;
    }

    public class DeviceInfo : ICloneable {
      public object Clone() {
        DeviceInfo copy = new DeviceInfo();
        copy.serial = this.serial;
        copy.model = this.model;
        copy.upstreamType = this.upstreamType;
        copy.position = this.position;
        copy.protocolVersion = this.protocolVersion;
        copy.bootVersion = this.bootVersion;
        copy.appVersion = this.appVersion;
        copy.hubPortInfos = this.hubPortInfos;
        return copy;
      }

      public LightJson.JsonObject Encode() {
        LightJson.JsonObject json = new LightJson.JsonObject();
        json["serial"] = this.serial;
        json["model"] = this.model;
        json["upstreamType"] = (int)this.upstreamType;
        json["position"] = this.position.Encode();
        json["protocolVersion"] = this.protocolVersion;
        json["bootVersion"] = this.bootVersion;
        json["appVersion"] = this.appVersion;
        json["hubPortInfos"] = new JsonArray(this.hubPortInfos.Select(
          _value => (JsonValue)(_value.Encode())));
        return json;
      }

      public static DeviceInfo Decode(LightJson.JsonObject json, Agent agent) {
        DeviceInfo inst = new DeviceInfo();
        inst.serial = (string)json["serial"];
        inst.model = (string)json["model"];
        inst.upstreamType = (Com.Raritan.Idl.peripheral.SensorHub.UpstreamType)(int)json["upstreamType"];
        inst.position = Com.Raritan.Idl.peripheral.PosElement_2_0_0.Decode(json["position"], agent);
        inst.protocolVersion = (int)json["protocolVersion"];
        inst.bootVersion = (int)json["bootVersion"];
        inst.appVersion = (int)json["appVersion"];
        inst.hubPortInfos = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.SensorHub.HubPortInfo>(json["hubPortInfos"].AsJsonArray.Select(
          _value => Com.Raritan.Idl.peripheral.SensorHub.HubPortInfo.Decode(_value, agent)));
        return inst;
      }

      public string serial = "";
      public string model = "";
      public Com.Raritan.Idl.peripheral.SensorHub.UpstreamType upstreamType = Com.Raritan.Idl.peripheral.SensorHub.UpstreamType.BUILTIN;
      public Com.Raritan.Idl.peripheral.PosElement_2_0_0 position = new Com.Raritan.Idl.peripheral.PosElement_2_0_0();
      public int protocolVersion = 0;
      public int bootVersion = 0;
      public int appVersion = 0;
      public System.Collections.Generic.IEnumerable<Com.Raritan.Idl.peripheral.SensorHub.HubPortInfo> hubPortInfos = new System.Collections.Generic.List<Com.Raritan.Idl.peripheral.SensorHub.HubPortInfo>();
    }

    public class GetDeviceInfoResult {
      public Com.Raritan.Idl.peripheral.SensorHub.DeviceInfo _ret_;
    }

    public GetDeviceInfoResult getDeviceInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getDeviceInfo", _parameters);
      var _ret = new GetDeviceInfoResult();
      _ret._ret_ = Com.Raritan.Idl.peripheral.SensorHub.DeviceInfo.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getDeviceInfo(AsyncRpcResponse<GetDeviceInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getDeviceInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getDeviceInfo(AsyncRpcResponse<GetDeviceInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getDeviceInfo", _parameters,
        _result => {
          try {
            var _ret = new GetDeviceInfoResult();
            _ret._ret_ = Com.Raritan.Idl.peripheral.SensorHub.DeviceInfo.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

    public class GetPackageInfoResult {
      public Com.Raritan.Idl.peripheral.PackageInfo_3_0_0 _ret_;
    }

    public GetPackageInfoResult getPackageInfo() {
      JsonObject _parameters = null;
      var _result = RpcCall("getPackageInfo", _parameters);
      var _ret = new GetPackageInfoResult();
      _ret._ret_ = Com.Raritan.Idl.peripheral.PackageInfo_3_0_0.Decode(_result["_ret_"], agent);
      return _ret;
    }

    public AsyncRequest getPackageInfo(AsyncRpcResponse<GetPackageInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail) {
      return getPackageInfo(rsp, fail, RpcCtrl.Default);
    }

    public AsyncRequest getPackageInfo(AsyncRpcResponse<GetPackageInfoResult>.SuccessHandler rsp, AsyncRpcResponse.FailureHandler fail, RpcCtrl rpcCtrl) {
      JsonObject _parameters = null;
      return RpcCall("getPackageInfo", _parameters,
        _result => {
          try {
            var _ret = new GetPackageInfoResult();
            _ret._ret_ = Com.Raritan.Idl.peripheral.PackageInfo_3_0_0.Decode(_result["_ret_"], agent);
            rsp(_ret);
          } catch (Exception e) {
            if (fail != null) fail(e);
          }
        }, fail, rpcCtrl);
    }

  }
}
