% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\docType{import}
\name{set-if-null}
\alias{set-if-null}
\alias{\%||\%}
\alias{\%iff\%}
\title{Set a default value depending on if an object is \code{NULL}}
\usage{
x \%iff\% y
}
\arguments{
\item{x}{An object to test}

\item{y}{A default value}
}
\value{
For \code{\%||\%}: \code{y} if \code{x} is \code{NULL} otherwise
\code{x}

For \code{\%iff\%}: \code{y} if \code{x} is \strong{not}
\code{NULL}; otherwise \code{x}
}
\examples{
1 \%||\% 2
NULL \%||\% 2

1 \%iff\% 2
NULL \%iff\% 2

}
\concept{utils}
\keyword{internal}
\description{
These objects are imported from other packages. Follow the links
below to see their documentation.

\describe{
  \item{rlang}{\code{\link[rlang:op-null-default]{\%||\%}}}
}}

