% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/label-log.R
\name{label_log}
\alias{label_log}
\title{Label numbers in log format (10^3, 10^6, etc)}
\usage{
label_log(base = 10, digits = 3)
}
\arguments{
\item{base}{Base of logarithm to use}

\item{digits}{Number of significant digits to show for the exponent. Argument
is passed on to \code{\link[base:format]{base::format()}}.}
}
\value{
All \code{label_()} functions return a "labelling" function, i.e. a function that
takes a vector \code{x} and returns a character vector of \code{length(x)} giving a
label for each input value.

Labelling functions are designed to be used with the \code{labels} argument of
ggplot2 scales. The examples demonstrate their use with x scales, but
they work similarly for all scales, including those that generate legends
rather than axes.
}
\description{
\code{label_log()} displays numbers as base^exponent, using superscript formatting.
}
\examples{
demo_log10(c(1, 1e5), labels = label_log())
demo_log10(c(1, 1e5), breaks = breaks_log(base = 2), labels = label_log(base = 2))
}
\seealso{
\code{\link[=breaks_log]{breaks_log()}} for the related breaks algorithm.

Other labels for log scales: 
\code{\link{label_bytes}()},
\code{\link{label_number_si}()},
\code{\link{label_scientific}()}
}
\concept{labels for log scales}
