% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stubs.R
\name{navigateToFile}
\alias{navigateToFile}
\title{Navigate to file}
\usage{
navigateToFile(
  file = character(0),
  line = -1L,
  column = -1L,
  moveCursor = TRUE
)
}
\arguments{
\item{file}{The file to be opened.}

\item{line}{The line number where the cursor should be placed. When \code{-1L}
(the default), the cursor will not be moved.}

\item{column}{The column number where the cursour should be placed. When
\code{-1L} (the default), the cursor will not be moved.}

\item{moveCursor}{Boolean; should the cursor be moved to the requested
(\code{line}, \code{column}) position? Set this to \code{FALSE} to preserve the existing
cursor position in the document.}
}
\description{
Open a file in RStudio, optionally at a specified location.
}
\details{
The \code{navigateToFile} opens a file in RStudio. If the file is already
open, its tab or window is activated.

Once the file is open, the cursor is moved to the specified location. If the
\code{file} argument is empty (the default), then the file is the file
currently in view if one exists. If the \code{line} and \code{column}
arguments are both equal to \code{-1L} (the default), then the cursor
position in the document that is opened will be preserved. Alternatively,
\code{moveCursor} can be set to \code{FALSE} to preserve the cursor position.

Note that if your intent is to navigate to a particular function within a
file, you can also cause RStudio to navigate there by invoking
\code{\link[utils]{View}} on the function, which has the advantage of
falling back on deparsing if the file is not available.
}
\note{
The \code{navigateToFile} function was added in version 0.99.719 of
RStudio.
}
