% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chunk.R
\name{chunk-callbacks}
\alias{chunk-callbacks}
\alias{registerChunkCallback}
\alias{unregisterChunkCallback}
\title{Register and Unregister a Chunk Callback}
\usage{
registerChunkCallback(callback)

unregisterChunkCallback(id = NULL)
}
\arguments{
\item{callback}{A callback function. See \strong{Chunk Callbacks} for more details.}

\item{id}{A unique identifier.}
}
\value{
For \code{registerChunkCallback()}, a unique identifier. That identifier
can be passed to \code{unreigsterChunkCallback()} to de-register a
previously-registered callback.
}
\description{
Register a callback function to be executed after a chunk within an R
Markdown document is run.
}
\section{Chunk Callbacks}{


The \code{callback} argument should be a function accepting two parameters:
\itemize{
\item \code{chunkName}: The chunk label,
\item \code{chunkCode}: The code within the chunk.
}

The function should return an \R list of HTML outputs, to be displayed after
that chunk has been executed.
}

