% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pandoc.R
\name{pandoc_available}
\alias{pandoc_available}
\alias{pandoc_version}
\title{Check pandoc availability and version}
\usage{
pandoc_available(version = NULL, error = FALSE)

pandoc_version()
}
\arguments{
\item{version}{Required version of pandoc}

\item{error}{Whether to signal an error if pandoc with the required version
is not found}
}
\value{
\code{pandoc_available} returns a logical indicating whether the
  required version of pandoc is available. \code{pandoc_version} returns a
  \code{\link[base]{numeric_version}} with the version of pandoc found.
}
\description{
Determine whether pandoc is currently available on the system (optionally
checking for a specific version or greater). Determine the specific version
of pandoc available.
}
\details{
The system environment variable \samp{PATH} as well as the version of pandoc
shipped with RStudio (its location is set via the environment variable
\samp{RSTUDIO_PANDOC} by RStudio products like the RStudio IDE, RStudio
Server, Shiny Server, and RStudio Connect, etc) are scanned for pandoc and
the highest version available is used. Please do not modify the environment
variable \samp{RSTUDIO_PANDOC} unless you know what it means.
}
\examples{
\dontrun{
library(rmarkdown)

if (pandoc_available())
  cat("pandoc", as.character(pandoc_version()), "is available!\n")

if (pandoc_available("1.12.3"))
  cat("required version of pandoc is available!\n")
}
}
