% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{read.dtas}
\alias{read.dtas}
\title{Read frames from Stata dtas files}
\usage{
read.dtas(path, select.frames = NULL, read.dta13.options = NULL)
}
\arguments{
\item{path}{path to .dtas file}

\item{select.frames}{character vector}

\item{read.dta13.options}{list of parameters used in  \code{\link[readstata13]{read.dta13}}. The list must have the following structure: \code{list(framename = list(param = value))}}
}
\value{
Returns a named list of data.frames.
}
\description{
Stata 18 introduced framesets (file extension `.dtas`) that contain zipped `dta`
files. This helper functions imports those files and returns a list of data.frames.
}
\examples{

path <- system.file("extdata", "myproject2.dtas", package="readstata13")

# read all frames in myproject2.dtas
read.dtas(path)

# read selected frames
read.dtas(path, select.frames = c("persons", "counties"))

# read only frame counties
read.dtas(path, select.frames = c("counties"))

# read frames with different arguments
read.dtas(path, 
          read.dta13.options = list(counties = list(select.cols = "median_income"),
                                     persons = list(select.cols = "income")))

}
