% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprec-rerun.R
\name{rerun}
\alias{rerun}
\title{Re-run expressions multiple times}
\usage{
rerun(.n, ...)
}
\arguments{
\item{.n}{Number of times to run expressions}

\item{...}{Expressions to re-run.}
}
\value{
A list of length \code{.n}. Each element of \code{...} will be
re-run once for each \code{.n}.

There is one special case: if there's a single unnamed input, the second
level list will be dropped. In this case, \code{rerun(n, x)} behaves like
\code{replicate(n, x, simplify = FALSE)}.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}

This function was deprecated in purrr 1.0.0 because we believe that NSE
functions are not a  good fit for purrr. Also, \code{rerun(n, x)} can just as
easily be expressed as \verb{map(1:n, \\(i) x)}

\code{rerun()} is a convenient way of generating sample data. It works similarly to
\code{\link{replicate}(..., simplify = FALSE)}.
}
\examples{
# old
5 |> rerun(rnorm(5)) |> str()
# new
1:5 |> map(\(i) rnorm(5)) |> str()

# old
5 |>
  rerun(x = rnorm(5), y = rnorm(5)) |>
  map_dbl(\(l) cor(l$x, l$y))
# new
1:5 |>
  map(\(i) list(x = rnorm(5), y = rnorm(5))) |>
  map_dbl(\(l) cor(l$x, l$y))
}
\keyword{internal}
