% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.draws_array}
\alias{print.draws_array}
\title{Print \code{draws_array} objects}
\usage{
\method{print}{draws_array}(
  x,
  digits = 2,
  max_iterations = getOption("posterior.max_iterations", 5),
  max_chains = getOption("posterior.max_chains", 8),
  max_variables = getOption("posterior.max_variables", 4),
  reserved = FALSE,
  ...
)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{digits}{(nonnegative integer) The minimum number of significant digits
to print. If \code{NULL}, defaults to \code{getOption("posterior.digits", 2)}.}

\item{max_iterations}{(positive integer) The maximum number of iterations to
print. Can be controlled globally via the \code{"posterior.max_iterations"}
\link[base:options]{option}.}

\item{max_chains}{(positive integer) The maximum number of chains to print.
Can be controlled globally via the \code{"posterior.max_chains"}
\link[base:options]{option}.}

\item{max_variables}{(positive integer) The maximum number of variables to
print. Can be controlled globally via the \code{"posterior.max_variables"}
\link[base:options]{option}.}

\item{reserved}{(logical) Should reserved variables be included in the
output? Defaults to \code{FALSE}. See \code{\link{reserved_variables}} for an overview of
currently reserved variable names.}

\item{...}{Further arguments passed to the underlying \code{\link[=print]{print()}} methods.}
}
\value{
A \code{draws} object of the same class as \code{x}.
}
\description{
Pretty printing for \code{\link{draws_array}} objects.
}
\examples{
x <- as_draws_array(example_draws())
print(x)

}
