% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/neighborNet.R
\name{neighborNet}
\alias{neighborNet}
\title{Computes a neighborNet from a distance matrix}
\usage{
neighborNet(x, ord = NULL)
}
\arguments{
\item{x}{a distance matrix.}

\item{ord}{a circular ordering.}
}
\value{
\code{neighborNet} returns an object of class networx.
}
\description{
Computes a neighborNet, i.e. an object of class \code{networx} from a
distance matrix.
}
\details{
\code{neighborNet} is still experimental. The cyclic ordering sometimes
differ from the SplitsTree implementation, the \emph{ord} argument can be
used to enforce a certain circular ordering.
}
\examples{

data(yeast)
dm <- dist.ml(yeast)
nnet <- neighborNet(dm)
plot(nnet, "2D")

}
\references{
Bryant, D. & Moulton, V. (2004) Neighbor-Net: An Agglomerative
Method for the Construction of Phylogenetic Networks. \emph{Molecular
Biology and Evolution}, 2004, \bold{21}, 255-265
}
\seealso{
\code{\link{splitsNetwork}}, \code{\link{consensusNet}},
\code{\link{plot.networx}}, \code{\link{lento}},
\code{\link{cophenetic.networx}}, \code{\link{distanceHadamard}}
}
\author{
Klaus Schliep \email{klaus.schliep@gmail.com}
}
\keyword{hplot}
