% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cifreg.R
\name{FG_AugmentCifstrata}
\alias{FG_AugmentCifstrata}
\alias{strataC}
\alias{simul.cifs}
\alias{setup.cif}
\alias{drop.strata}
\title{Augmentation for Fine-Gray model based on stratified NPMLE Cif (Aalen-Johansen)}
\usage{
FG_AugmentCifstrata(
  formula,
  data = data,
  E = NULL,
  cause = NULL,
  cens.code = 0,
  km = TRUE,
  case.weights = NULL,
  weights = NULL,
  offset = NULL,
  ...
)
}
\arguments{
\item{formula}{formula with 'Event', strata model for CIF given by strata, and strataC specifies censoring strata}

\item{data}{data frame}

\item{E}{from FG-model}

\item{cause}{of interest}

\item{cens.code}{code of censoring}

\item{km}{to use Kaplan-Meier}

\item{case.weights}{weights for FG score equations (that follow dN_1)}

\item{weights}{weights for FG score equations}

\item{offset}{offsets for FG   model}

\item{...}{Additional arguments to lower level funtions}
}
\description{
Computes  the augmentation term for each individual as well as the sum
\deqn{
A(\beta) = \int H(t,X,\beta) \frac{F_2^*(t,s)}{S^*(t,s)} \frac{1}{G_c(t)} dM_c
}
with
\deqn{
H(t,X,\beta) = \int_t^\infty (X - E(\beta,t) ) G_c(t) d\Lambda_1^*i(t,s)
}
using a KM for \deqn{G_c(t)} and a working model for cumulative baseline
related to \deqn{F_1^*(t,s)} and \deqn{s} is strata,
\deqn{S^*(t,s) = 1 - F_1^*(t,s) - F_2^*(t,s)}, and
\deqn{E(\beta^p,t)} is given. Assumes that no strata for baseline of ine-Gay model that is augmented.
}
\details{
After a couple of iterations we end up with a solution of
\deqn{
\int (X - E(\beta) ) Y_1(t) w(t) dM_1 + A(\beta)
}
the augmented FG-score.

Standard errors computed under assumption of correct \deqn{G_c} model.
}
\examples{
set.seed(100)
rho1 <- 0.2; rho2 <- 10
n <- 400
beta=c(0.0,-0.1,-0.5,0.3)
dats <- simul.cifs(n,rho1,rho2,beta,rc=0.2)
dtable(dats,~status)
dsort(dats) <- ~time
fg <- cifreg(Event(time,status)~Z1+Z2,data=dats,cause=1,propodds=NULL)
summary(fg)

fgaugS <- FG_AugmentCifstrata(Event(time,status)~Z1+Z2+strata(Z1,Z2),data=dats,cause=1,E=fg$E)
summary(fgaugS)
fgaugS2 <- FG_AugmentCifstrata(Event(time,status)~Z1+Z2+strata(Z1,Z2),data=dats,cause=1,E=fgaugS$E)
summary(fgaugS2)

}
\author{
Thomas Scheike
}
