% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reformulas.R
\name{splitForm}
\alias{splitForm}
\alias{noSpecials}
\title{Split formula containing special random effect terms}
\usage{
splitForm(
  formula,
  defaultTerm = "us",
  allowFixedOnly = TRUE,
  allowNoSpecials = TRUE,
  debug = FALSE
)

noSpecials(term, delete = TRUE, debug = FALSE)
}
\arguments{
\item{formula}{a formula containing special random effect terms}

\item{defaultTerm}{default type for non-special RE terms}

\item{allowFixedOnly}{(logical) are formulas with no RE terms OK?}

\item{allowNoSpecials}{(logical) are formulas with only standard RE terms OK?}

\item{debug}{debugging mode (print stuff)?}

\item{term}{language object}
}
\value{
a list containing elements \code{fixedFormula};
\code{reTrmFormulas} list of \code{x | g} formulas for each term;
\code{reTrmAddArgs} list of function+additional arguments, i.e. \code{list()} (non-special), \code{foo()} (no additional arguments), \code{foo(addArgs)} (additional arguments); \code{reTrmClasses} (vector of special functions/classes, as character)
}
\description{
Parse a formula into fixed formula and random effect terms,
treating 'special' terms (of the form foo(x|g[,m])) appropriately
}
\details{
Taken from Steve Walker's lme4ord,
ultimately from the flexLambda branch of lme4
<https://github.com/stevencarlislewalker/lme4ord/blob/master/R/formulaParsing.R>.  Mostly for internal use.
}
\examples{
splitForm(~x+y)                     ## no specials or RE
splitForm(~x+y+(f|g))               ## no specials
splitForm(~x+y+diag(f|g))           ## one special
splitForm(~x+y+(diag(f|g)))         ## 'hidden' special
splitForm(~x+y+(f|g)+cs(1|g))       ## combination
splitForm(~x+y+(1|f/g))             ## 'slash'; term
splitForm(~x+y+(1|f/g/h))             ## 'slash'; term
splitForm(~x+y+(1|(f/g)/h))             ## 'slash'; term
splitForm(~x+y+(f|g)+cs(1|g)+cs(a|b,stuff))  ## complex special
splitForm(~(((x+y))))               ## lots of parentheses
splitForm(~1+rr(f|g,n=2))

noSpecials(y~1+us(1|f))
noSpecials(y~1+us(1|f),delete=FALSE)
noSpecials(y~us(1|f))
noSpecials(y~us(1|f), delete=FALSE)
noSpecials(y~us(1|f), debug=TRUE)
noSpecials(y~us+1)  ## should *not* delete unless head of a function
noSpecials(~us+1)   ## should work on a one-sided formula!
}
\author{
Steve Walker
}
\keyword{internal}
