% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/repository.R
\name{in_repository}
\alias{in_repository}
\title{Determine if a directory is in a git repository}
\usage{
in_repository(path = ".")
}
\arguments{
\item{path}{The path to the directory.}
}
\value{
TRUE if directory is in a git repository else FALSE
}
\description{
The lookup start from path and walk across parent directories if
nothing has been found.
}
\examples{
\dontrun{
## Initialize a temporary repository
path <- tempfile(pattern="git2r-")
dir.create(path)
repo <- init(path)

## Create a user
config(repo, user.name = "Alice", user.email = "alice@example.org")

## Check if path is in a git repository
in_repository(path)

## Check if working directory is in a git repository
setwd(path)
in_repository()
}
}
