% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R, R/methods_row.R
\name{colCummins,dgCMatrix-method}
\alias{colCummins,dgCMatrix-method}
\alias{rowCummins,dgCMatrix-method}
\title{Calculates the cumulative minima for each row (column) of a matrix-like
object}
\usage{
\S4method{colCummins}{dgCMatrix}(x, rows = NULL, cols = NULL, useNames = NA)

\S4method{rowCummins}{dgCMatrix}(x, rows = NULL, cols = NULL, useNames = NA)
}
\arguments{
\item{x}{An NxK matrix-like object.}

\item{rows}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{cols}{A \code{\link{vector}} indicating the subset of rows
(and/or columns) to operate over. If \code{\link{NULL}}, no subsetting is
done.}

\item{useNames}{If \code{\link{NA}}, the default behavior of the function about naming support is remained. If \code{\link{FALSE}}, no naming support is done. Else if \code{\link{TRUE}}, names attributes of result are set.}
}
\value{
Returns a \code{\link{numeric}} \code{\link{matrix}}with the same
dimensions as \code{x}.
}
\description{
Calculates the cumulative minima for each row (column) of a matrix-like
object.
}
\details{
The S4 methods for \code{x} of type \code{\link{matrix}},
\code{\link{array}}, or \code{\link{numeric}} call
\code{matrixStats::rowCummins}
/ \code{matrixStats::colCummins}.
}
\examples{
mat <- matrix(rnorm(15), nrow = 5, ncol = 3)
  mat[2, 1] <- NA
  mat[3, 3] <- Inf
  mat[4, 1] <- 0
  
  print(mat)
  
  rowCummins(mat)
  colCummins(mat)
}
\seealso{
\itemize{
\item \code{matrixStats::\link[matrixStats:rowCumsums]{rowCummins}()} and
\code{matrixStats::\link[matrixStats:rowCumsums]{colCummins}()} which are
used when the input is a \code{matrix} or \code{numeric} vector.
\item For single minimum estimates, see \code{\link[MatrixGenerics]{rowMins}()}.
\item \code{base::\link{cummin}()}.
}
}
