% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_lesion_segregation.R
\name{plot_lesion_segregation}
\alias{plot_lesion_segregation}
\title{Plot the strands of variants to show lesion segregation}
\usage{
plot_lesion_segregation(
  vcf,
  per_chrom = FALSE,
  sample_name = NA,
  min_muts_mean = 10,
  chromosomes = NA,
  subsample = NA
)
}
\arguments{
\item{vcf}{GRanges or RGrangesList object.}

\item{per_chrom}{Boolean. Determines whether to create a separate plot per chromosome.}

\item{sample_name}{Name of the sample. Is used as the title of the plot.
Not very useful if you have more than one sample.}

\item{min_muts_mean}{Integer. The minimum of mutations, required for the mean strand 
of a chromosome to be calculated.}

\item{chromosomes}{Character vector. Determines chromosomes to be used and their order.}

\item{subsample}{Double between 0 and 1. Subsamples the amount of mutations to create
a plot with less dots. Such a plot is easier to modify in a vector program like illustrator.
(default: NA)}
}
\value{
ggplot2 object
}
\description{
The strands of variants in a GRanges object is plotted.
This way the presence of any lesion segregation is visualized.
The function can plot either a single or multiple samples.
Per chromosome, the ratio of the mutations on the chromosomal strands is
visualised by a line. The position of this line is calculated as the mean of
the "+" and "-" strand, where "+" equals 1 and "-" equals 0. In other words:
this line lies between the two strands if the mutations are equally
distributed between them, and approaches a strand if the majority of
mutations on a chromosome lie on that strand.
}
\examples{

## See the 'read_vcfs_as_granges()' example for how we obtained the
## following data:
grl <- readRDS(system.file("states/read_vcfs_as_granges_output.rds",
  package = "MutationalPatterns"
))

## Plot lesion segregation
plot_lesion_segregation(grl[1:3])

## Select a single GRanges object to plot.
gr <- grl[[1]]

## Plot lesion segregation for a single sample. 
## Also add a title to the plot.
plot_lesion_segregation(gr, sample_name = "Colon1")

## Plot lesion segregation per chromosome.
## We here store the results in a list.
figure_l = plot_lesion_segregation(gr, per_chrom = TRUE, sample_name = "Colon1")

## Plot specific chromosomes in a user specified order
plot_lesion_segregation(grl[1:3], chromosomes = c(2,3))

## Subsample the mutations, so less points are plotted.
plot_lesion_segregation(grl[1:3], subsample = 0.2)

}
\seealso{
\code{\link{calculate_lesion_segregation}}

Other Lesion_segregation: 
\code{\link{calculate_lesion_segregation}()}
}
\concept{Lesion_segregation}
