# pylint: disable=line-too-long,useless-suppression,too-many-lines
# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) Python Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
# pylint: disable=useless-super-delegation

import datetime
from typing import Any, Dict, List, Literal, Mapping, Optional, TYPE_CHECKING, Union, overload

from .._utils.model_base import Model as _Model, rest_discriminator, rest_field
from ._enums import SummaryType

if TYPE_CHECKING:
    from .. import models as _models


class BinaryHardeningFeatures(_Model):
    """Binary hardening features.

    :ivar no_execute: Flag indicating the binary's stack is set to NX (no-execute).
    :vartype no_execute: bool
    :ivar position_independent_executable: Flag indicating the binary was compiled to be a position
     independent executable.
    :vartype position_independent_executable: bool
    :ivar relocation_read_only: Flag indicating the binary has enabled relocation read-only
     protections.
    :vartype relocation_read_only: bool
    :ivar canary: Flag indicating if the binary was compiled with stack canaries enabled.
    :vartype canary: bool
    :ivar stripped: Flag indicating if debug symbols have been stripped from the binary.
    :vartype stripped: bool
    """

    no_execute: Optional[bool] = rest_field(
        name="noExecute", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag indicating the binary's stack is set to NX (no-execute)."""
    position_independent_executable: Optional[bool] = rest_field(
        name="positionIndependentExecutable", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag indicating the binary was compiled to be a position independent executable."""
    relocation_read_only: Optional[bool] = rest_field(
        name="relocationReadOnly", visibility=["read", "create", "update", "delete", "query"]
    )
    """Flag indicating the binary has enabled relocation read-only protections."""
    canary: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Flag indicating if the binary was compiled with stack canaries enabled."""
    stripped: Optional[bool] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Flag indicating if debug symbols have been stripped from the binary."""

    @overload
    def __init__(
        self,
        *,
        no_execute: Optional[bool] = None,
        position_independent_executable: Optional[bool] = None,
        relocation_read_only: Optional[bool] = None,
        canary: Optional[bool] = None,
        stripped: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Resource(_Model):
    """Common fields that are returned in the response for all Azure Resource Manager resources.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    """

    id: Optional[str] = rest_field(visibility=["read"])
    """Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}."""
    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the resource."""
    type: Optional[str] = rest_field(visibility=["read"])
    """The type of the resource. E.g. \"Microsoft.Compute/virtualMachines\" or
     \"Microsoft.Storage/storageAccounts\"."""
    system_data: Optional["_models.SystemData"] = rest_field(name="systemData", visibility=["read"])
    """Azure Resource Manager metadata containing createdBy and modifiedBy information."""


class ProxyResource(Resource):
    """The resource model definition for a Azure Resource Manager proxy resource. It will not have
    tags and a location.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    """


class BinaryHardeningResource(ProxyResource):
    """The object representing a firmware analysis binary hardening result resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.BinaryHardeningResult
    """

    properties: Optional["_models.BinaryHardeningResult"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "binary_hardening_id",
        "security_hardening_features",
        "executable_architecture",
        "file_path",
        "executable_class",
        "runpath",
        "rpath",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.BinaryHardeningResult"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class BinaryHardeningResult(_Model):
    """Binary hardening of a firmware.

    :ivar binary_hardening_id: ID for the binary hardening result.
    :vartype binary_hardening_id: str
    :ivar security_hardening_features: The security hardening features of the binary.
    :vartype security_hardening_features:
     ~azure.mgmt.iotfirmwaredefense.models.BinaryHardeningFeatures
    :ivar executable_architecture: The architecture of the binary being reported on.
    :vartype executable_architecture: str
    :ivar file_path: The path to the binary in the firmware.
    :vartype file_path: str
    :ivar executable_class: The executable class to indicate 32 or 64 bit. Known values are: "x86"
     and "x64".
    :vartype executable_class: str or ~azure.mgmt.iotfirmwaredefense.models.ExecutableClass
    :ivar runpath: The runpath property of the uploaded binary, which is a method of specifying
     additional paths to load objects at runtime.
    :vartype runpath: str
    :ivar rpath: The rpath property of the uploaded binary, which is a deprecated method of
     specifying additional paths to load objects at runtime.
    :vartype rpath: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    binary_hardening_id: Optional[str] = rest_field(
        name="binaryHardeningId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID for the binary hardening result."""
    security_hardening_features: Optional["_models.BinaryHardeningFeatures"] = rest_field(
        name="securityHardeningFeatures", visibility=["read", "create", "update", "delete", "query"]
    )
    """The security hardening features of the binary."""
    executable_architecture: Optional[str] = rest_field(
        name="executableArchitecture", visibility=["read", "create", "update", "delete", "query"]
    )
    """The architecture of the binary being reported on."""
    file_path: Optional[str] = rest_field(name="filePath", visibility=["read", "create", "update", "delete", "query"])
    """The path to the binary in the firmware."""
    executable_class: Optional[Union[str, "_models.ExecutableClass"]] = rest_field(
        name="executableClass", visibility=["read", "create", "update", "delete", "query"]
    )
    """The executable class to indicate 32 or 64 bit. Known values are: \"x86\" and \"x64\"."""
    runpath: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The runpath property of the uploaded binary, which is a method of specifying additional paths
     to load objects at runtime."""
    rpath: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The rpath property of the uploaded binary, which is a deprecated method of specifying
     additional paths to load objects at runtime."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""

    @overload
    def __init__(
        self,
        *,
        binary_hardening_id: Optional[str] = None,
        security_hardening_features: Optional["_models.BinaryHardeningFeatures"] = None,
        executable_architecture: Optional[str] = None,
        file_path: Optional[str] = None,
        executable_class: Optional[Union[str, "_models.ExecutableClass"]] = None,
        runpath: Optional[str] = None,
        rpath: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SummaryResourceProperties(_Model):
    """Properties of an analysis summary.

    You probably want to use the sub-classes and not this class directly. Known sub-classes are:
    BinaryHardeningSummaryResource, CveSummary, CryptoCertificateSummaryResource,
    CryptoKeySummaryResource, FirmwareSummary

    :ivar summary_type: The type of summary. Required. Known values are: "Firmware",
     "CommonVulnerabilitiesAndExposures", "BinaryHardening", "CryptoCertificate", and "CryptoKey".
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.SummaryType
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    __mapping__: Dict[str, _Model] = {}
    summary_type: str = rest_discriminator(
        name="summaryType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of summary. Required. Known values are: \"Firmware\",
     \"CommonVulnerabilitiesAndExposures\", \"BinaryHardening\", \"CryptoCertificate\", and
     \"CryptoKey\"."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""

    @overload
    def __init__(
        self,
        *,
        summary_type: str,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class BinaryHardeningSummaryResource(SummaryResourceProperties, discriminator="BinaryHardening"):
    """Properties for a binary hardening analysis summary.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    :ivar total_files: Total number of binaries that were analyzed.
    :vartype total_files: int
    :ivar not_executable_stack_count: Total number of analyzed files that were found to have a
     nonexecutable stack.
    :vartype not_executable_stack_count: int
    :ivar position_independent_executable_count: Total number of analyzed files that were compiled
     to be a position independent executable.
    :vartype position_independent_executable_count: int
    :ivar relocation_read_only_count: Total number of analyzed files that have enabled relocation
     read-only protections.
    :vartype relocation_read_only_count: int
    :ivar stack_canary_count: Total number of analyzed files that have stack canaries enabled.
    :vartype stack_canary_count: int
    :ivar stripped_binary_count: Total number of analyzed files that have debug symbols stripped.
    :vartype stripped_binary_count: int
    :ivar summary_type: Describes the type of summary object. Required. The summary contains
     information about the binary hardening analysis results
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.BINARY_HARDENING
    """

    total_files: Optional[int] = rest_field(
        name="totalFiles", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of binaries that were analyzed."""
    not_executable_stack_count: Optional[int] = rest_field(
        name="notExecutableStackCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of analyzed files that were found to have a nonexecutable stack."""
    position_independent_executable_count: Optional[int] = rest_field(
        name="positionIndependentExecutableCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of analyzed files that were compiled to be a position independent executable."""
    relocation_read_only_count: Optional[int] = rest_field(
        name="relocationReadOnlyCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of analyzed files that have enabled relocation read-only protections."""
    stack_canary_count: Optional[int] = rest_field(
        name="stackCanaryCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of analyzed files that have stack canaries enabled."""
    stripped_binary_count: Optional[int] = rest_field(
        name="strippedBinaryCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of analyzed files that have debug symbols stripped."""
    summary_type: Literal[SummaryType.BINARY_HARDENING] = rest_discriminator(name="summaryType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Describes the type of summary object. Required. The summary contains information about the
     binary hardening analysis results"""

    @overload
    def __init__(
        self,
        *,
        total_files: Optional[int] = None,
        not_executable_stack_count: Optional[int] = None,
        position_independent_executable_count: Optional[int] = None,
        relocation_read_only_count: Optional[int] = None,
        stack_canary_count: Optional[int] = None,
        stripped_binary_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, summary_type=SummaryType.BINARY_HARDENING, **kwargs)


class CryptoCertificate(_Model):
    """Crypto certificate properties.

    :ivar crypto_cert_id: ID for the certificate result.
    :vartype crypto_cert_id: str
    :ivar certificate_name: Name of the certificate.
    :vartype certificate_name: str
    :ivar subject: Subject information of the certificate.
    :vartype subject: ~azure.mgmt.iotfirmwaredefense.models.CryptoCertificateEntity
    :ivar issuer: Issuer information of the certificate.
    :vartype issuer: ~azure.mgmt.iotfirmwaredefense.models.CryptoCertificateEntity
    :ivar issued_date: Issue date for the certificate.
    :vartype issued_date: ~datetime.datetime
    :ivar expiration_date: Expiration date for the certificate.
    :vartype expiration_date: ~datetime.datetime
    :ivar certificate_role: Role of the certificate (Root CA, etc).
    :vartype certificate_role: str
    :ivar signature_algorithm: The signature algorithm used in the certificate.
    :vartype signature_algorithm: str
    :ivar certificate_key_size: Size of the certificate's key in bits.
    :vartype certificate_key_size: int
    :ivar certificate_key_algorithm: Key algorithm used in the certificate.
    :vartype certificate_key_algorithm: str
    :ivar encoding: Encoding used for the certificate.
    :vartype encoding: str
    :ivar serial_number: Serial number of the certificate.
    :vartype serial_number: str
    :ivar fingerprint: Fingerprint of the certificate.
    :vartype fingerprint: str
    :ivar certificate_usage: List of functions the certificate can fulfill.
    :vartype certificate_usage: list[str or ~azure.mgmt.iotfirmwaredefense.models.CertificateUsage]
    :ivar file_paths: List of files where this certificate was found.
    :vartype file_paths: list[str]
    :ivar paired_key: A matching paired private key.
    :vartype paired_key: ~azure.mgmt.iotfirmwaredefense.models.PairedKey
    :ivar is_expired: Indicates if the certificate is expired.
    :vartype is_expired: bool
    :ivar is_self_signed: Indicates if the certificate is self-signed.
    :vartype is_self_signed: bool
    :ivar is_weak_signature: Indicates the signature algorithm used is insecure according to NIST
     guidance.
    :vartype is_weak_signature: bool
    :ivar is_short_key_size: Indicates the certificate's key size is considered too small to be
     secure for the key algorithm according to NIST guidance.
    :vartype is_short_key_size: bool
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    crypto_cert_id: Optional[str] = rest_field(
        name="cryptoCertId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID for the certificate result."""
    certificate_name: Optional[str] = rest_field(
        name="certificateName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the certificate."""
    subject: Optional["_models.CryptoCertificateEntity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Subject information of the certificate."""
    issuer: Optional["_models.CryptoCertificateEntity"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Issuer information of the certificate."""
    issued_date: Optional[datetime.datetime] = rest_field(
        name="issuedDate", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Issue date for the certificate."""
    expiration_date: Optional[datetime.datetime] = rest_field(
        name="expirationDate", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """Expiration date for the certificate."""
    certificate_role: Optional[str] = rest_field(
        name="certificateRole", visibility=["read", "create", "update", "delete", "query"]
    )
    """Role of the certificate (Root CA, etc)."""
    signature_algorithm: Optional[str] = rest_field(
        name="signatureAlgorithm", visibility=["read", "create", "update", "delete", "query"]
    )
    """The signature algorithm used in the certificate."""
    certificate_key_size: Optional[int] = rest_field(
        name="certificateKeySize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Size of the certificate's key in bits."""
    certificate_key_algorithm: Optional[str] = rest_field(
        name="certificateKeyAlgorithm", visibility=["read", "create", "update", "delete", "query"]
    )
    """Key algorithm used in the certificate."""
    encoding: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Encoding used for the certificate."""
    serial_number: Optional[str] = rest_field(
        name="serialNumber", visibility=["read", "create", "update", "delete", "query"]
    )
    """Serial number of the certificate."""
    fingerprint: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Fingerprint of the certificate."""
    certificate_usage: Optional[List[Union[str, "_models.CertificateUsage"]]] = rest_field(
        name="certificateUsage", visibility=["read", "create", "update", "delete", "query"]
    )
    """List of functions the certificate can fulfill."""
    file_paths: Optional[List[str]] = rest_field(name="filePaths", visibility=["read"])
    """List of files where this certificate was found."""
    paired_key: Optional["_models.PairedKey"] = rest_field(
        name="pairedKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A matching paired private key."""
    is_expired: Optional[bool] = rest_field(
        name="isExpired", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the certificate is expired."""
    is_self_signed: Optional[bool] = rest_field(
        name="isSelfSigned", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates if the certificate is self-signed."""
    is_weak_signature: Optional[bool] = rest_field(
        name="isWeakSignature", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the signature algorithm used is insecure according to NIST guidance."""
    is_short_key_size: Optional[bool] = rest_field(
        name="isShortKeySize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the certificate's key size is considered too small to be secure for the key algorithm
     according to NIST guidance."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""

    @overload
    def __init__(
        self,
        *,
        crypto_cert_id: Optional[str] = None,
        certificate_name: Optional[str] = None,
        subject: Optional["_models.CryptoCertificateEntity"] = None,
        issuer: Optional["_models.CryptoCertificateEntity"] = None,
        issued_date: Optional[datetime.datetime] = None,
        expiration_date: Optional[datetime.datetime] = None,
        certificate_role: Optional[str] = None,
        signature_algorithm: Optional[str] = None,
        certificate_key_size: Optional[int] = None,
        certificate_key_algorithm: Optional[str] = None,
        encoding: Optional[str] = None,
        serial_number: Optional[str] = None,
        fingerprint: Optional[str] = None,
        certificate_usage: Optional[List[Union[str, "_models.CertificateUsage"]]] = None,
        paired_key: Optional["_models.PairedKey"] = None,
        is_expired: Optional[bool] = None,
        is_self_signed: Optional[bool] = None,
        is_weak_signature: Optional[bool] = None,
        is_short_key_size: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CryptoCertificateEntity(_Model):
    """Information on an entity (distinguished name) in a cryptographic certificate.

    :ivar common_name: Common name of the certificate entity.
    :vartype common_name: str
    :ivar organization: Organization of the certificate entity.
    :vartype organization: str
    :ivar organizational_unit: The organizational unit of the certificate entity.
    :vartype organizational_unit: str
    :ivar state: Geographical state or province of the certificate entity.
    :vartype state: str
    :ivar country: Country code of the certificate entity.
    :vartype country: str
    """

    common_name: Optional[str] = rest_field(
        name="commonName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Common name of the certificate entity."""
    organization: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Organization of the certificate entity."""
    organizational_unit: Optional[str] = rest_field(
        name="organizationalUnit", visibility=["read", "create", "update", "delete", "query"]
    )
    """The organizational unit of the certificate entity."""
    state: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Geographical state or province of the certificate entity."""
    country: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Country code of the certificate entity."""

    @overload
    def __init__(
        self,
        *,
        common_name: Optional[str] = None,
        organization: Optional[str] = None,
        organizational_unit: Optional[str] = None,
        state: Optional[str] = None,
        country: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CryptoCertificateResource(ProxyResource):
    """The object representing a firmware analysis crypto certificate resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.CryptoCertificate
    """

    properties: Optional["_models.CryptoCertificate"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "crypto_cert_id",
        "certificate_name",
        "subject",
        "issuer",
        "issued_date",
        "expiration_date",
        "certificate_role",
        "signature_algorithm",
        "certificate_key_size",
        "certificate_key_algorithm",
        "encoding",
        "serial_number",
        "fingerprint",
        "certificate_usage",
        "file_paths",
        "paired_key",
        "is_expired",
        "is_self_signed",
        "is_weak_signature",
        "is_short_key_size",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.CryptoCertificate"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class CryptoCertificateSummaryResource(SummaryResourceProperties, discriminator="CryptoCertificate"):
    """Properties for cryptographic certificate summary.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    :ivar total_certificate_count: Total number of certificates found.
    :vartype total_certificate_count: int
    :ivar paired_key_count: Total number of paired private keys found for the certificates.
    :vartype paired_key_count: int
    :ivar expired_certificate_count: Total number of expired certificates found.
    :vartype expired_certificate_count: int
    :ivar expiring_soon_certificate_count: Total number of nearly expired certificates found.
    :vartype expiring_soon_certificate_count: int
    :ivar weak_signature_count: Total number of certificates found using a weak signature
     algorithm.
    :vartype weak_signature_count: int
    :ivar self_signed_certificate_count: Total number of certificates found that are self-signed.
    :vartype self_signed_certificate_count: int
    :ivar short_key_size_count: Total number of certificates found that have an insecure key size
     for the key algorithm.
    :vartype short_key_size_count: int
    :ivar summary_type: Describes the type of summary. Required. The summary contains information
     about the cryptographic certificate analysis results
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.CRYPTO_CERTIFICATE
    """

    total_certificate_count: Optional[int] = rest_field(
        name="totalCertificateCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of certificates found."""
    paired_key_count: Optional[int] = rest_field(
        name="pairedKeyCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of paired private keys found for the certificates."""
    expired_certificate_count: Optional[int] = rest_field(
        name="expiredCertificateCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of expired certificates found."""
    expiring_soon_certificate_count: Optional[int] = rest_field(
        name="expiringSoonCertificateCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of nearly expired certificates found."""
    weak_signature_count: Optional[int] = rest_field(
        name="weakSignatureCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of certificates found using a weak signature algorithm."""
    self_signed_certificate_count: Optional[int] = rest_field(
        name="selfSignedCertificateCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of certificates found that are self-signed."""
    short_key_size_count: Optional[int] = rest_field(
        name="shortKeySizeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of certificates found that have an insecure key size for the key algorithm."""
    summary_type: Literal[SummaryType.CRYPTO_CERTIFICATE] = rest_discriminator(name="summaryType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Describes the type of summary. Required. The summary contains information about the
     cryptographic certificate analysis results"""

    @overload
    def __init__(
        self,
        *,
        total_certificate_count: Optional[int] = None,
        paired_key_count: Optional[int] = None,
        expired_certificate_count: Optional[int] = None,
        expiring_soon_certificate_count: Optional[int] = None,
        weak_signature_count: Optional[int] = None,
        self_signed_certificate_count: Optional[int] = None,
        short_key_size_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, summary_type=SummaryType.CRYPTO_CERTIFICATE, **kwargs)


class CryptoKey(_Model):
    """Crypto key properties.

    :ivar crypto_key_id: ID for the key result.
    :vartype crypto_key_id: str
    :ivar key_type: Type of the key (public or private). Known values are: "Public" and "Private".
    :vartype key_type: str or ~azure.mgmt.iotfirmwaredefense.models.CryptoKeyType
    :ivar crypto_key_size: Size of the key in bits.
    :vartype crypto_key_size: int
    :ivar key_algorithm: Key algorithm name.
    :vartype key_algorithm: str
    :ivar usage: Functions the key can fulfill.
    :vartype usage: list[str]
    :ivar file_paths: List of files where this key was found.
    :vartype file_paths: list[str]
    :ivar paired_key: A matching paired key or certificate.
    :vartype paired_key: ~azure.mgmt.iotfirmwaredefense.models.PairedKey
    :ivar is_short_key_size: Indicates the key size is considered too small to be secure for the
     algorithm according to NIST guidance.
    :vartype is_short_key_size: bool
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    crypto_key_id: Optional[str] = rest_field(
        name="cryptoKeyId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID for the key result."""
    key_type: Optional[Union[str, "_models.CryptoKeyType"]] = rest_field(
        name="keyType", visibility=["read", "create", "update", "delete", "query"]
    )
    """Type of the key (public or private). Known values are: \"Public\" and \"Private\"."""
    crypto_key_size: Optional[int] = rest_field(
        name="cryptoKeySize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Size of the key in bits."""
    key_algorithm: Optional[str] = rest_field(
        name="keyAlgorithm", visibility=["read", "create", "update", "delete", "query"]
    )
    """Key algorithm name."""
    usage: Optional[List[str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Functions the key can fulfill."""
    file_paths: Optional[List[str]] = rest_field(name="filePaths", visibility=["read"])
    """List of files where this key was found."""
    paired_key: Optional["_models.PairedKey"] = rest_field(
        name="pairedKey", visibility=["read", "create", "update", "delete", "query"]
    )
    """A matching paired key or certificate."""
    is_short_key_size: Optional[bool] = rest_field(
        name="isShortKeySize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Indicates the key size is considered too small to be secure for the algorithm according to NIST
     guidance."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""

    @overload
    def __init__(
        self,
        *,
        crypto_key_id: Optional[str] = None,
        key_type: Optional[Union[str, "_models.CryptoKeyType"]] = None,
        crypto_key_size: Optional[int] = None,
        key_algorithm: Optional[str] = None,
        usage: Optional[List[str]] = None,
        paired_key: Optional["_models.PairedKey"] = None,
        is_short_key_size: Optional[bool] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CryptoKeyResource(ProxyResource):
    """The object representing a firmware analysis crypto key resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.CryptoKey
    """

    properties: Optional["_models.CryptoKey"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "crypto_key_id",
        "key_type",
        "crypto_key_size",
        "key_algorithm",
        "usage",
        "file_paths",
        "paired_key",
        "is_short_key_size",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.CryptoKey"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class CryptoKeySummaryResource(SummaryResourceProperties, discriminator="CryptoKey"):
    """Properties for cryptographic key summary.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    :ivar total_key_count: Total number of cryptographic keys found.
    :vartype total_key_count: int
    :ivar public_key_count: Total number of (non-certificate) public keys found.
    :vartype public_key_count: int
    :ivar private_key_count: Total number of private keys found.
    :vartype private_key_count: int
    :ivar paired_key_count: Total number of keys found that have a matching paired key or
     certificate.
    :vartype paired_key_count: int
    :ivar short_key_size_count: Total number of keys found that have an insecure key size for the
     algorithm.
    :vartype short_key_size_count: int
    :ivar summary_type: Describes the type of summary. Required. The summary contains information
     about the cryptographic key analysis results
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.CRYPTO_KEY
    """

    total_key_count: Optional[int] = rest_field(
        name="totalKeyCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of cryptographic keys found."""
    public_key_count: Optional[int] = rest_field(
        name="publicKeyCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of (non-certificate) public keys found."""
    private_key_count: Optional[int] = rest_field(
        name="privateKeyCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of private keys found."""
    paired_key_count: Optional[int] = rest_field(
        name="pairedKeyCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of keys found that have a matching paired key or certificate."""
    short_key_size_count: Optional[int] = rest_field(
        name="shortKeySizeCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total number of keys found that have an insecure key size for the algorithm."""
    summary_type: Literal[SummaryType.CRYPTO_KEY] = rest_discriminator(name="summaryType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Describes the type of summary. Required. The summary contains information about the
     cryptographic key analysis results"""

    @overload
    def __init__(
        self,
        *,
        total_key_count: Optional[int] = None,
        public_key_count: Optional[int] = None,
        private_key_count: Optional[int] = None,
        paired_key_count: Optional[int] = None,
        short_key_size_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, summary_type=SummaryType.CRYPTO_KEY, **kwargs)


class CveLink(_Model):
    """Properties of a reference link for a CVE.

    :ivar href: The destination of the reference link.
    :vartype href: str
    :ivar label: The label of the reference link.
    :vartype label: str
    """

    href: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The destination of the reference link."""
    label: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The label of the reference link."""

    @overload
    def __init__(
        self,
        *,
        href: Optional[str] = None,
        label: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CveResource(ProxyResource):
    """The object representing a firmware analysis CVE result resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.CveResult
    """

    properties: Optional["_models.CveResult"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "cve_id",
        "component_id",
        "component_name",
        "component_version",
        "severity",
        "cve_name",
        "effective_cvss_score",
        "effective_cvss_version",
        "cvss_scores",
        "links",
        "description",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.CveResult"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class CveResult(_Model):
    """Details of a CVE detected in firmware.

    :ivar cve_id: ID of the CVE result.
    :vartype cve_id: str
    :ivar component_id: ID of the affected SBOM component.
    :vartype component_id: str
    :ivar component_name: Name of the affected SBOM component.
    :vartype component_name: str
    :ivar component_version: Version of the affected SBOM component.
    :vartype component_version: str
    :ivar severity: Severity of the CVE.
    :vartype severity: str
    :ivar cve_name: Name of the CVE.
    :vartype cve_name: str
    :ivar effective_cvss_score: The most recent CVSS score of the CVE.
    :vartype effective_cvss_score: float
    :ivar effective_cvss_version: The version of the effectiveCvssScore property.
    :vartype effective_cvss_version: int
    :ivar cvss_scores: All known CVSS scores for the CVE.
    :vartype cvss_scores: list[~azure.mgmt.iotfirmwaredefense.models.CvssScore]
    :ivar links: The list of reference links for the CVE.
    :vartype links: list[~azure.mgmt.iotfirmwaredefense.models.CveLink]
    :ivar description: The CVE description.
    :vartype description: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    cve_id: Optional[str] = rest_field(name="cveId", visibility=["read", "create", "update", "delete", "query"])
    """ID of the CVE result."""
    component_id: Optional[str] = rest_field(
        name="componentId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID of the affected SBOM component."""
    component_name: Optional[str] = rest_field(
        name="componentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name of the affected SBOM component."""
    component_version: Optional[str] = rest_field(
        name="componentVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """Version of the affected SBOM component."""
    severity: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Severity of the CVE."""
    cve_name: Optional[str] = rest_field(name="cveName", visibility=["read", "create", "update", "delete", "query"])
    """Name of the CVE."""
    effective_cvss_score: Optional[float] = rest_field(
        name="effectiveCvssScore", visibility=["read", "create", "update", "delete", "query"]
    )
    """The most recent CVSS score of the CVE."""
    effective_cvss_version: Optional[int] = rest_field(
        name="effectiveCvssVersion", visibility=["read", "create", "update", "delete", "query"]
    )
    """The version of the effectiveCvssScore property."""
    cvss_scores: Optional[List["_models.CvssScore"]] = rest_field(
        name="cvssScores", visibility=["read", "create", "update", "delete", "query"]
    )
    """All known CVSS scores for the CVE."""
    links: Optional[List["_models.CveLink"]] = rest_field(visibility=["read"])
    """The list of reference links for the CVE."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The CVE description."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""

    @overload
    def __init__(
        self,
        *,
        cve_id: Optional[str] = None,
        component_id: Optional[str] = None,
        component_name: Optional[str] = None,
        component_version: Optional[str] = None,
        severity: Optional[str] = None,
        cve_name: Optional[str] = None,
        effective_cvss_score: Optional[float] = None,
        effective_cvss_version: Optional[int] = None,
        cvss_scores: Optional[List["_models.CvssScore"]] = None,
        description: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class CveSummary(SummaryResourceProperties, discriminator="CommonVulnerabilitiesAndExposures"):
    """Properties for a CVE analysis summary.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    :ivar critical_cve_count: The total number of critical severity CVEs detected.
    :vartype critical_cve_count: int
    :ivar high_cve_count: The total number of high severity CVEs detected.
    :vartype high_cve_count: int
    :ivar medium_cve_count: The total number of medium severity CVEs detected.
    :vartype medium_cve_count: int
    :ivar low_cve_count: The total number of low severity CVEs detected.
    :vartype low_cve_count: int
    :ivar unknown_cve_count: The total number of unknown severity CVEs detected.
    :vartype unknown_cve_count: int
    :ivar summary_type: Describes the type of summary object. Required. The summary contains
     information about the Common Vulnerabilities and Exposures analysis results
    :vartype summary_type: str or
     ~azure.mgmt.iotfirmwaredefense.models.COMMON_VULNERABILITIES_AND_EXPOSURES
    """

    critical_cve_count: Optional[int] = rest_field(
        name="criticalCveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total number of critical severity CVEs detected."""
    high_cve_count: Optional[int] = rest_field(
        name="highCveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total number of high severity CVEs detected."""
    medium_cve_count: Optional[int] = rest_field(
        name="mediumCveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total number of medium severity CVEs detected."""
    low_cve_count: Optional[int] = rest_field(
        name="lowCveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total number of low severity CVEs detected."""
    unknown_cve_count: Optional[int] = rest_field(
        name="unknownCveCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """The total number of unknown severity CVEs detected."""
    summary_type: Literal[SummaryType.COMMON_VULNERABILITIES_AND_EXPOSURES] = rest_discriminator(name="summaryType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Describes the type of summary object. Required. The summary contains information about the
     Common Vulnerabilities and Exposures analysis results"""

    @overload
    def __init__(
        self,
        *,
        critical_cve_count: Optional[int] = None,
        high_cve_count: Optional[int] = None,
        medium_cve_count: Optional[int] = None,
        low_cve_count: Optional[int] = None,
        unknown_cve_count: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, summary_type=SummaryType.COMMON_VULNERABILITIES_AND_EXPOSURES, **kwargs)


class CvssScore(_Model):
    """Common Vulnerability Scoring System values.

    :ivar version: The version of the Common Vulnerability Scoring System (CVSS). Required.
    :vartype version: int
    :ivar score: The score of the CVE according to the CVSS specified.
    :vartype score: float
    """

    version: int = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The version of the Common Vulnerability Scoring System (CVSS). Required."""
    score: Optional[float] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The score of the CVE according to the CVSS specified."""

    @overload
    def __init__(
        self,
        *,
        version: int,
        score: Optional[float] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class ErrorAdditionalInfo(_Model):
    """The resource management error additional info.

    :ivar type: The additional info type.
    :vartype type: str
    :ivar info: The additional info.
    :vartype info: any
    """

    type: Optional[str] = rest_field(visibility=["read"])
    """The additional info type."""
    info: Optional[Any] = rest_field(visibility=["read"])
    """The additional info."""


class ErrorDetail(_Model):
    """The error detail.

    :ivar code: The error code.
    :vartype code: str
    :ivar message: The error message.
    :vartype message: str
    :ivar target: The error target.
    :vartype target: str
    :ivar details: The error details.
    :vartype details: list[~azure.mgmt.iotfirmwaredefense.models.ErrorDetail]
    :ivar additional_info: The error additional info.
    :vartype additional_info: list[~azure.mgmt.iotfirmwaredefense.models.ErrorAdditionalInfo]
    """

    code: Optional[str] = rest_field(visibility=["read"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read"])
    """The error message."""
    target: Optional[str] = rest_field(visibility=["read"])
    """The error target."""
    details: Optional[List["_models.ErrorDetail"]] = rest_field(visibility=["read"])
    """The error details."""
    additional_info: Optional[List["_models.ErrorAdditionalInfo"]] = rest_field(
        name="additionalInfo", visibility=["read"]
    )
    """The error additional info."""


class ErrorResponse(_Model):
    """Common error response for all Azure Resource Manager APIs to return error details for failed
    operations.

    :ivar error: The error object.
    :vartype error: ~azure.mgmt.iotfirmwaredefense.models.ErrorDetail
    """

    error: Optional["_models.ErrorDetail"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error object."""

    @overload
    def __init__(
        self,
        *,
        error: Optional["_models.ErrorDetail"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Firmware(ProxyResource):
    """Firmware definition.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.FirmwareProperties
    """

    properties: Optional["_models.FirmwareProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "file_name",
        "vendor",
        "model",
        "version",
        "description",
        "file_size",
        "status",
        "status_messages",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.FirmwareProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class FirmwareProperties(_Model):
    """Firmware properties.

    :ivar file_name: File name for a firmware that user uploaded.
    :vartype file_name: str
    :ivar vendor: Firmware vendor.
    :vartype vendor: str
    :ivar model: Firmware model.
    :vartype model: str
    :ivar version: Firmware version.
    :vartype version: str
    :ivar description: User-specified description of the firmware.
    :vartype description: str
    :ivar file_size: File size of the uploaded firmware image.
    :vartype file_size: int
    :ivar status: The status of firmware scan. Known values are: "Pending", "Extracting",
     "Analyzing", "Ready", and "Error".
    :vartype status: str or ~azure.mgmt.iotfirmwaredefense.models.Status
    :ivar status_messages: A list of errors or other messages generated during firmware analysis.
    :vartype status_messages: list[~azure.mgmt.iotfirmwaredefense.models.StatusMessage]
    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    file_name: Optional[str] = rest_field(name="fileName", visibility=["read", "create", "update", "delete", "query"])
    """File name for a firmware that user uploaded."""
    vendor: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Firmware vendor."""
    model: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Firmware model."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Firmware version."""
    description: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User-specified description of the firmware."""
    file_size: Optional[int] = rest_field(name="fileSize", visibility=["read", "create", "update", "delete", "query"])
    """File size of the uploaded firmware image."""
    status: Optional[Union[str, "_models.Status"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The status of firmware scan. Known values are: \"Pending\", \"Extracting\", \"Analyzing\",
     \"Ready\", and \"Error\"."""
    status_messages: Optional[List["_models.StatusMessage"]] = rest_field(
        name="statusMessages", visibility=["read", "create", "update", "delete", "query"]
    )
    """A list of errors or other messages generated during firmware analysis."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""

    @overload
    def __init__(
        self,
        *,
        file_name: Optional[str] = None,
        vendor: Optional[str] = None,
        model: Optional[str] = None,
        version: Optional[str] = None,
        description: Optional[str] = None,
        file_size: Optional[int] = None,
        status: Optional[Union[str, "_models.Status"]] = None,
        status_messages: Optional[List["_models.StatusMessage"]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class FirmwareSummary(SummaryResourceProperties, discriminator="Firmware"):
    """Properties for high level summary of firmware analysis results.

    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    :ivar extracted_size: Total extracted size of the firmware in bytes.
    :vartype extracted_size: int
    :ivar file_size: Firmware file size in bytes.
    :vartype file_size: int
    :ivar extracted_file_count: Extracted file count.
    :vartype extracted_file_count: int
    :ivar component_count: Components count.
    :vartype component_count: int
    :ivar binary_count: Binary count.
    :vartype binary_count: int
    :ivar analysis_time_seconds: Time used for analysis.
    :vartype analysis_time_seconds: int
    :ivar root_file_systems: The number of root file systems found.
    :vartype root_file_systems: int
    :ivar summary_type: Describes the type of summary. Required. The summary contains information
     about the submitted firmware
    :vartype summary_type: str or ~azure.mgmt.iotfirmwaredefense.models.FIRMWARE
    """

    extracted_size: Optional[int] = rest_field(
        name="extractedSize", visibility=["read", "create", "update", "delete", "query"]
    )
    """Total extracted size of the firmware in bytes."""
    file_size: Optional[int] = rest_field(name="fileSize", visibility=["read", "create", "update", "delete", "query"])
    """Firmware file size in bytes."""
    extracted_file_count: Optional[int] = rest_field(
        name="extractedFileCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Extracted file count."""
    component_count: Optional[int] = rest_field(
        name="componentCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Components count."""
    binary_count: Optional[int] = rest_field(
        name="binaryCount", visibility=["read", "create", "update", "delete", "query"]
    )
    """Binary count."""
    analysis_time_seconds: Optional[int] = rest_field(
        name="analysisTimeSeconds", visibility=["read", "create", "update", "delete", "query"]
    )
    """Time used for analysis."""
    root_file_systems: Optional[int] = rest_field(
        name="rootFileSystems", visibility=["read", "create", "update", "delete", "query"]
    )
    """The number of root file systems found."""
    summary_type: Literal[SummaryType.FIRMWARE] = rest_discriminator(name="summaryType", visibility=["read", "create", "update", "delete", "query"])  # type: ignore
    """Describes the type of summary. Required. The summary contains information about the submitted
     firmware"""

    @overload
    def __init__(
        self,
        *,
        extracted_size: Optional[int] = None,
        file_size: Optional[int] = None,
        extracted_file_count: Optional[int] = None,
        component_count: Optional[int] = None,
        binary_count: Optional[int] = None,
        analysis_time_seconds: Optional[int] = None,
        root_file_systems: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, summary_type=SummaryType.FIRMWARE, **kwargs)


class FirmwareUpdateDefinition(_Model):
    """Firmware definition.

    :ivar properties: The editable properties of a firmware.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.FirmwareProperties
    """

    properties: Optional["_models.FirmwareProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The editable properties of a firmware."""

    __flattened_items = [
        "file_name",
        "vendor",
        "model",
        "version",
        "description",
        "file_size",
        "status",
        "status_messages",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.FirmwareProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class GenerateUploadUrlRequest(_Model):
    """Properties for generating an upload URL.

    :ivar firmware_id: A unique ID for the firmware to be uploaded.
    :vartype firmware_id: str
    """

    firmware_id: Optional[str] = rest_field(
        name="firmwareId", visibility=["read", "create", "update", "delete", "query"]
    )
    """A unique ID for the firmware to be uploaded."""

    @overload
    def __init__(
        self,
        *,
        firmware_id: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class Operation(_Model):
    """Details of a REST API operation, returned from the Resource Provider Operations API.

    :ivar name: The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     "Microsoft.Compute/virtualMachines/write", "Microsoft.Compute/virtualMachines/capture/action".
    :vartype name: str
    :ivar is_data_action: Whether the operation applies to data-plane. This is "true" for
     data-plane operations and "false" for Azure Resource Manager/control-plane operations.
    :vartype is_data_action: bool
    :ivar display: Localized display information for this particular operation.
    :vartype display: ~azure.mgmt.iotfirmwaredefense.models.OperationDisplay
    :ivar origin: The intended executor of the operation; as in Resource Based Access Control
     (RBAC) and audit logs UX. Default value is "user,system". Known values are: "user", "system",
     and "user,system".
    :vartype origin: str or ~azure.mgmt.iotfirmwaredefense.models.Origin
    :ivar action_type: Extensible enum. Indicates the action type. "Internal" refers to actions
     that are for internal only APIs. "Internal"
    :vartype action_type: str or ~azure.mgmt.iotfirmwaredefense.models.ActionType
    """

    name: Optional[str] = rest_field(visibility=["read"])
    """The name of the operation, as per Resource-Based Access Control (RBAC). Examples:
     \"Microsoft.Compute/virtualMachines/write\",
     \"Microsoft.Compute/virtualMachines/capture/action\"."""
    is_data_action: Optional[bool] = rest_field(name="isDataAction", visibility=["read"])
    """Whether the operation applies to data-plane. This is \"true\" for data-plane operations and
     \"false\" for Azure Resource Manager/control-plane operations."""
    display: Optional["_models.OperationDisplay"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """Localized display information for this particular operation."""
    origin: Optional[Union[str, "_models.Origin"]] = rest_field(visibility=["read"])
    """The intended executor of the operation; as in Resource Based Access Control (RBAC) and audit
     logs UX. Default value is \"user,system\". Known values are: \"user\", \"system\", and
     \"user,system\"."""
    action_type: Optional[Union[str, "_models.ActionType"]] = rest_field(name="actionType", visibility=["read"])
    """Extensible enum. Indicates the action type. \"Internal\" refers to actions that are for
     internal only APIs. \"Internal\""""

    @overload
    def __init__(
        self,
        *,
        display: Optional["_models.OperationDisplay"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class OperationDisplay(_Model):
    """Localized display information for and operation.

    :ivar provider: The localized friendly form of the resource provider name, e.g. "Microsoft
     Monitoring Insights" or "Microsoft Compute".
    :vartype provider: str
    :ivar resource: The localized friendly name of the resource type related to this operation.
     E.g. "Virtual Machines" or "Job Schedule Collections".
    :vartype resource: str
    :ivar operation: The concise, localized friendly name for the operation; suitable for
     dropdowns. E.g. "Create or Update Virtual Machine", "Restart Virtual Machine".
    :vartype operation: str
    :ivar description: The short, localized friendly description of the operation; suitable for
     tool tips and detailed views.
    :vartype description: str
    """

    provider: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly form of the resource provider name, e.g. \"Microsoft Monitoring
     Insights\" or \"Microsoft Compute\"."""
    resource: Optional[str] = rest_field(visibility=["read"])
    """The localized friendly name of the resource type related to this operation. E.g. \"Virtual
     Machines\" or \"Job Schedule Collections\"."""
    operation: Optional[str] = rest_field(visibility=["read"])
    """The concise, localized friendly name for the operation; suitable for dropdowns. E.g. \"Create
     or Update Virtual Machine\", \"Restart Virtual Machine\"."""
    description: Optional[str] = rest_field(visibility=["read"])
    """The short, localized friendly description of the operation; suitable for tool tips and detailed
     views."""


class PairedKey(_Model):
    """Details of a matching paired key or certificate.

    :ivar paired_key_id: ID of the paired key or certificate.
    :vartype paired_key_id: str
    :ivar type: The type indicating whether the paired object is a key or certificate.
    :vartype type: str
    """

    paired_key_id: Optional[str] = rest_field(
        name="pairedKeyId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID of the paired key or certificate."""
    type: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The type indicating whether the paired object is a key or certificate."""

    @overload
    def __init__(
        self,
        *,
        paired_key_id: Optional[str] = None,
        type: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PasswordHash(_Model):
    """Password hash properties.

    :ivar password_hash_id: ID for password hash.
    :vartype password_hash_id: str
    :ivar file_path: File path of the password hash.
    :vartype file_path: str
    :ivar salt: Salt of the password hash.
    :vartype salt: str
    :ivar hash: Hash of the password.
    :vartype hash: str
    :ivar context: Context of password hash.
    :vartype context: str
    :ivar username: User name of password hash.
    :vartype username: str
    :ivar algorithm: Algorithm of the password hash.
    :vartype algorithm: str
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    password_hash_id: Optional[str] = rest_field(
        name="passwordHashId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID for password hash."""
    file_path: Optional[str] = rest_field(name="filePath", visibility=["read", "create", "update", "delete", "query"])
    """File path of the password hash."""
    salt: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Salt of the password hash."""
    hash: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Hash of the password."""
    context: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Context of password hash."""
    username: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """User name of password hash."""
    algorithm: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Algorithm of the password hash."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""

    @overload
    def __init__(
        self,
        *,
        password_hash_id: Optional[str] = None,
        file_path: Optional[str] = None,
        salt: Optional[str] = None,
        hash: Optional[str] = None,
        context: Optional[str] = None,
        username: Optional[str] = None,
        algorithm: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class PasswordHashResource(ProxyResource):
    """The object representing a firmware analysis password hash result resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.PasswordHash
    """

    properties: Optional["_models.PasswordHash"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = [
        "password_hash_id",
        "file_path",
        "salt",
        "hash",
        "context",
        "username",
        "algorithm",
        "provisioning_state",
    ]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.PasswordHash"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class SbomComponent(_Model):
    """SBOM component of a firmware.

    :ivar component_id: ID for the component.
    :vartype component_id: str
    :ivar component_name: Name for the component.
    :vartype component_name: str
    :ivar version: Version for the component.
    :vartype version: str
    :ivar license: License for the component.
    :vartype license: str
    :ivar file_paths: File paths related to the component. Note, relatedFiles should be used
     instead of this property.
    :vartype file_paths: list[str]
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    component_id: Optional[str] = rest_field(
        name="componentId", visibility=["read", "create", "update", "delete", "query"]
    )
    """ID for the component."""
    component_name: Optional[str] = rest_field(
        name="componentName", visibility=["read", "create", "update", "delete", "query"]
    )
    """Name for the component."""
    version: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Version for the component."""
    license: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """License for the component."""
    file_paths: Optional[List[str]] = rest_field(
        name="filePaths", visibility=["read", "create", "update", "delete", "query"]
    )
    """File paths related to the component. Note, relatedFiles should be used instead of this
     property."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""

    @overload
    def __init__(
        self,
        *,
        component_id: Optional[str] = None,
        component_name: Optional[str] = None,
        version: Optional[str] = None,
        license: Optional[str] = None,
        file_paths: Optional[List[str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SbomComponentResource(ProxyResource):
    """The object representing a firmware analysis SBOM component result resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.SbomComponent
    """

    properties: Optional["_models.SbomComponent"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["component_id", "component_name", "version", "license", "file_paths", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SbomComponent"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class Sku(_Model):
    """The resource model definition representing SKU.

    :ivar name: The name of the SKU. Ex - P3. It is typically a letter+number code. Required.
    :vartype name: str
    :ivar tier: This field is required to be implemented by the Resource Provider if the service
     has more than one tier, but is not required on a PUT. Known values are: "Free", "Basic",
     "Standard", and "Premium".
    :vartype tier: str or ~azure.mgmt.iotfirmwaredefense.models.SkuTier
    :ivar size: The SKU size. When the name field is the combination of tier and some other value,
     this would be the standalone code.
    :vartype size: str
    :ivar family: If the service has different generations of hardware, for the same SKU, then that
     can be captured here.
    :vartype family: str
    :ivar capacity: If the SKU supports scale out/in then the capacity integer should be included.
     If scale out/in is not possible for the resource this may be omitted.
    :vartype capacity: int
    """

    name: str = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The name of the SKU. Ex - P3. It is typically a letter+number code. Required."""
    tier: Optional[Union[str, "_models.SkuTier"]] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """This field is required to be implemented by the Resource Provider if the service has more than
     one tier, but is not required on a PUT. Known values are: \"Free\", \"Basic\", \"Standard\",
     and \"Premium\"."""
    size: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU size. When the name field is the combination of tier and some other value, this would
     be the standalone code."""
    family: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If the service has different generations of hardware, for the same SKU, then that can be
     captured here."""
    capacity: Optional[int] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """If the SKU supports scale out/in then the capacity integer should be included. If scale out/in
     is not possible for the resource this may be omitted."""

    @overload
    def __init__(
        self,
        *,
        name: str,
        tier: Optional[Union[str, "_models.SkuTier"]] = None,
        size: Optional[str] = None,
        family: Optional[str] = None,
        capacity: Optional[int] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class StatusMessage(_Model):
    """Error and status message.

    :ivar error_code: The error code.
    :vartype error_code: int
    :ivar message: The error or status message.
    :vartype message: str
    """

    error_code: Optional[int] = rest_field(name="errorCode", visibility=["read", "create", "update", "delete", "query"])
    """The error code."""
    message: Optional[str] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The error or status message."""

    @overload
    def __init__(
        self,
        *,
        error_code: Optional[int] = None,
        message: Optional[str] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SummaryResource(ProxyResource):
    """The object representing a firmware analysis summary resource.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.SummaryResourceProperties
    """

    properties: Optional["_models.SummaryResourceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.SummaryResourceProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class SystemData(_Model):
    """Metadata pertaining to creation and last modification of the resource.

    :ivar created_by: The identity that created the resource.
    :vartype created_by: str
    :ivar created_by_type: The type of identity that created the resource. Known values are:
     "User", "Application", "ManagedIdentity", and "Key".
    :vartype created_by_type: str or ~azure.mgmt.iotfirmwaredefense.models.CreatedByType
    :ivar created_at: The timestamp of resource creation (UTC).
    :vartype created_at: ~datetime.datetime
    :ivar last_modified_by: The identity that last modified the resource.
    :vartype last_modified_by: str
    :ivar last_modified_by_type: The type of identity that last modified the resource. Known values
     are: "User", "Application", "ManagedIdentity", and "Key".
    :vartype last_modified_by_type: str or ~azure.mgmt.iotfirmwaredefense.models.CreatedByType
    :ivar last_modified_at: The timestamp of resource last modification (UTC).
    :vartype last_modified_at: ~datetime.datetime
    """

    created_by: Optional[str] = rest_field(name="createdBy", visibility=["read", "create", "update", "delete", "query"])
    """The identity that created the resource."""
    created_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="createdByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that created the resource. Known values are: \"User\", \"Application\",
     \"ManagedIdentity\", and \"Key\"."""
    created_at: Optional[datetime.datetime] = rest_field(
        name="createdAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource creation (UTC)."""
    last_modified_by: Optional[str] = rest_field(
        name="lastModifiedBy", visibility=["read", "create", "update", "delete", "query"]
    )
    """The identity that last modified the resource."""
    last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = rest_field(
        name="lastModifiedByType", visibility=["read", "create", "update", "delete", "query"]
    )
    """The type of identity that last modified the resource. Known values are: \"User\",
     \"Application\", \"ManagedIdentity\", and \"Key\"."""
    last_modified_at: Optional[datetime.datetime] = rest_field(
        name="lastModifiedAt", visibility=["read", "create", "update", "delete", "query"], format="rfc3339"
    )
    """The timestamp of resource last modification (UTC)."""

    @overload
    def __init__(
        self,
        *,
        created_by: Optional[str] = None,
        created_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        created_at: Optional[datetime.datetime] = None,
        last_modified_by: Optional[str] = None,
        last_modified_by_type: Optional[Union[str, "_models.CreatedByType"]] = None,
        last_modified_at: Optional[datetime.datetime] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class TrackedResource(Resource):
    """The resource model definition for an Azure Resource Manager tracked top level resource which
    has 'tags' and a 'location'.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    """

    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""
    location: str = rest_field(visibility=["read", "create"])
    """The geo-location where the resource lives. Required."""

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)


class UrlToken(_Model):
    """Url data for creating or accessing a blob file.

    :ivar url: SAS URL for creating or accessing a blob file.
    :vartype url: str
    """

    url: Optional[str] = rest_field(visibility=["read"])
    """SAS URL for creating or accessing a blob file."""


class UsageMetric(ProxyResource):
    """The object representing how many firmwares the user has uploaded to the workspace.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.UsageMetricProperties
    """

    properties: Optional["_models.UsageMetricProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""

    __flattened_items = ["monthly_firmware_upload_count", "total_firmware_count", "provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        properties: Optional["_models.UsageMetricProperties"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class UsageMetricProperties(_Model):
    """Properties of a workspaces usage metrics.

    :ivar monthly_firmware_upload_count: The number of firmware analysis jobs that have been
     submitted in the current month. Required.
    :vartype monthly_firmware_upload_count: int
    :ivar total_firmware_count: The total number of firmwares that are in the workspace. Required.
    :vartype total_firmware_count: int
    :ivar provisioning_state: The status of the last operation. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    monthly_firmware_upload_count: int = rest_field(name="monthlyFirmwareUploadCount", visibility=["read"])
    """The number of firmware analysis jobs that have been submitted in the current month. Required."""
    total_firmware_count: int = rest_field(name="totalFirmwareCount", visibility=["read"])
    """The total number of firmwares that are in the workspace. Required."""
    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """The status of the last operation. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""


class Workspace(TrackedResource):
    """Firmware analysis workspace.

    :ivar id: Fully qualified resource ID for the resource. Ex -
     /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/{resourceProviderNamespace}/{resourceType}/{resourceName}.
    :vartype id: str
    :ivar name: The name of the resource.
    :vartype name: str
    :ivar type: The type of the resource. E.g. "Microsoft.Compute/virtualMachines" or
     "Microsoft.Storage/storageAccounts".
    :vartype type: str
    :ivar system_data: Azure Resource Manager metadata containing createdBy and modifiedBy
     information.
    :vartype system_data: ~azure.mgmt.iotfirmwaredefense.models.SystemData
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    :ivar location: The geo-location where the resource lives. Required.
    :vartype location: str
    :ivar properties: The resource-specific properties for this resource.
    :vartype properties: ~azure.mgmt.iotfirmwaredefense.models.WorkspaceProperties
    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.iotfirmwaredefense.models.Sku
    """

    properties: Optional["_models.WorkspaceProperties"] = rest_field(
        visibility=["read", "create", "update", "delete", "query"]
    )
    """The resource-specific properties for this resource."""
    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU (Stock Keeping Unit) assigned to this resource."""

    __flattened_items = ["provisioning_state"]

    @overload
    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["_models.WorkspaceProperties"] = None,
        sku: Optional["_models.Sku"] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        _flattened_input = {k: kwargs.pop(k) for k in kwargs.keys() & self.__flattened_items}
        super().__init__(*args, **kwargs)
        for k, v in _flattened_input.items():
            setattr(self, k, v)

    def __getattr__(self, name: str) -> Any:
        if name in self.__flattened_items:
            if self.properties is None:
                return None
            return getattr(self.properties, name)
        raise AttributeError(f"'{self.__class__.__name__}' object has no attribute '{name}'")

    def __setattr__(self, key: str, value: Any) -> None:
        if key in self.__flattened_items:
            if self.properties is None:
                self.properties = self._attr_to_rest_field["properties"]._class_type()
            setattr(self.properties, key, value)
        else:
            super().__setattr__(key, value)


class WorkspaceProperties(_Model):
    """Workspace properties.

    :ivar provisioning_state: Provisioning state of the resource. Known values are: "Succeeded",
     "Failed", "Canceled", "Pending", "Extracting", and "Analyzing".
    :vartype provisioning_state: str or ~azure.mgmt.iotfirmwaredefense.models.ProvisioningState
    """

    provisioning_state: Optional[Union[str, "_models.ProvisioningState"]] = rest_field(
        name="provisioningState", visibility=["read"]
    )
    """Provisioning state of the resource. Known values are: \"Succeeded\", \"Failed\", \"Canceled\",
     \"Pending\", \"Extracting\", and \"Analyzing\"."""


class WorkspaceUpdate(_Model):
    """The type used for update operations of the Workspace.

    :ivar sku: The SKU (Stock Keeping Unit) assigned to this resource.
    :vartype sku: ~azure.mgmt.iotfirmwaredefense.models.Sku
    :ivar tags: Resource tags.
    :vartype tags: dict[str, str]
    """

    sku: Optional["_models.Sku"] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """The SKU (Stock Keeping Unit) assigned to this resource."""
    tags: Optional[Dict[str, str]] = rest_field(visibility=["read", "create", "update", "delete", "query"])
    """Resource tags."""

    @overload
    def __init__(
        self,
        *,
        sku: Optional["_models.Sku"] = None,
        tags: Optional[Dict[str, str]] = None,
    ) -> None: ...

    @overload
    def __init__(self, mapping: Mapping[str, Any]) -> None:
        """
        :param mapping: raw JSON to initialize the model.
        :type mapping: Mapping[str, Any]
        """

    def __init__(self, *args: Any, **kwargs: Any) -> None:
        super().__init__(*args, **kwargs)
