#
# Class to execute "vmms-manage 'db_sync'"
#
# ==Parameters
#
# [*db_sync_timeout*]
#   (Optional) Timeout for the execution of the db_sync
#   Defaults to 300
#
class vmms::db::sync(
  $db_sync_timeout = 300,
) {

  include vmms::deps
  include vmms::params

  exec { 'vmms-db-sync':
    command     => $::vmms::params::db_sync_command,
    path        => '/usr/bin',
    user        => $::vmms::params::user,
    logoutput   => on_failure,
    refreshonly => true,
    try_sleep   => 5,
    tries       => 10,
    timeout     => $db_sync_timeout,
    subscribe   => [
      Anchor['vmms::install::end'],
      Anchor['vmms::config::end'],
      Anchor['vmms::dbsync::begin']
    ],
    notify      => Anchor['vmms::dbsync::end'],
    tag         => 'openstack-db',
  }
}
